// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 5>, 203> hypergeometric_1F2 = {{
      { SC_(-4.9536584472656250000000000000000000000000e+02), SC_(-4.6568273925781250000000000000000000000000e+02), SC_(2.7491040039062500000000000000000000000000e+02), SC_(4.7700195312500000000000000000000000000000e+02), SC_(6.2953633625840198330241832636073870213647e+00) }, 
      { SC_(-4.8809802246093750000000000000000000000000e+02), SC_(2.2695471191406250000000000000000000000000e+02), SC_(-1.6287738037109375000000000000000000000000e+02), SC_(-1.1143020629882812500000000000000000000000e+02), SC_(2.2954168492018348021567539085069725582696e-01) }, 
      { SC_(-4.5697619628906250000000000000000000000000e+02), SC_(4.0843359375000000000000000000000000000000e+02), SC_(-3.3101000976562500000000000000000000000000e+02), SC_(3.0913720703125000000000000000000000000000e+02), SC_(2.8406789544837496409837534677181916029002e+00) }, 
      { SC_(-4.2414575195312500000000000000000000000000e+02), SC_(-9.5791503906250000000000000000000000000000e+01), SC_(-4.4604992675781250000000000000000000000000e+02), SC_(-1.4723760986328125000000000000000000000000e+02), SC_(4.3621387519835661716303050453655954333981e+00) }, 
      { SC_(-4.2182446289062500000000000000000000000000e+02), SC_(3.5445092773437500000000000000000000000000e+02), SC_(-5.7321716308593750000000000000000000000000e+01), SC_(1.0423150634765625000000000000000000000000e+02), SC_(8.9770347887034762646255416767297731004656e+00) }, 
      { SC_(-4.1556420898437500000000000000000000000000e+02), SC_(-1.5376660156250000000000000000000000000000e+02), SC_(-1.0021734619140625000000000000000000000000e+02), SC_(3.5587512207031250000000000000000000000000e+02), SC_(4.0952594655659526604226152771672138770580e+07) }, 
      { SC_(-4.0354553222656250000000000000000000000000e+02), SC_(-2.7658007812500000000000000000000000000000e+02), SC_(-3.6802673339843750000000000000000000000000e+02), SC_(-9.6985168457031250000000000000000000000000e+00), SC_(1.0392018562107877165208393046336826121615e+00) }, 
      { SC_(-4.0286828613281250000000000000000000000000e+02), SC_(4.9406848144531250000000000000000000000000e+02), SC_(3.2345776367187500000000000000000000000000e+02), SC_(3.2190319824218750000000000000000000000000e+02), SC_(4.4308313520337312066670250774889362476371e-01) }, 
      { SC_(-3.9334729003906250000000000000000000000000e+02), SC_(-1.4558105468750000000000000000000000000000e+00), SC_(4.6189807128906250000000000000000000000000e+02), SC_(4.7992565917968750000000000000000000000000e+02), SC_(1.1195384661700382236382001507705022784189e+03) }, 
      { SC_(-3.8100231933593750000000000000000000000000e+02), SC_(-4.3967193603515625000000000000000000000000e+01), SC_(-1.6359252929687500000000000000000000000000e+00), SC_(2.7391711425781250000000000000000000000000e+02), SC_(-1.2900365105767572521165387360306912062493e+52) }, 
      { SC_(-3.7301318359375000000000000000000000000000e+02), SC_(4.6886779785156250000000000000000000000000e+02), SC_(4.1337585449218750000000000000000000000000e+02), SC_(-2.7896594238281250000000000000000000000000e+02), SC_(1.7088983160726331161548448241078207728564e+00) }, 
      { SC_(-3.5446105957031250000000000000000000000000e+02), SC_(-2.1732672119140625000000000000000000000000e+02), SC_(-3.6393151855468750000000000000000000000000e+02), SC_(3.0211145019531250000000000000000000000000e+02), SC_(2.5928803317535669685163913495588679602266e-01) }, 
      { SC_(-3.5070605468750000000000000000000000000000e+02), SC_(-2.6984399414062500000000000000000000000000e+02), SC_(-2.4249176025390625000000000000000000000000e+02), SC_(3.0973449707031250000000000000000000000000e+02), SC_(1.9142889445713712115260413093057932942367e-01) }, 
      { SC_(-3.4762207031250000000000000000000000000000e+02), SC_(3.1900329589843750000000000000000000000000e+00), SC_(3.2581701660156250000000000000000000000000e+02), SC_(-3.7525817871093750000000000000000000000000e+01), SC_(1.1480130815171587388506615460208536579504e+03) }, 
      { SC_(-3.4238696289062500000000000000000000000000e+02), SC_(2.2583898925781250000000000000000000000000e+02), SC_(4.7059277343750000000000000000000000000000e+02), SC_(4.8110961914062500000000000000000000000000e+02), SC_(2.0983327605520708176806967283659011097557e-01) }, 
      { SC_(-3.3781774902343750000000000000000000000000e+02), SC_(4.2749279785156250000000000000000000000000e+02), SC_(2.9428454589843750000000000000000000000000e+02), SC_(-6.3882446289062500000000000000000000000000e+01), SC_(1.1869817799931480728760769672044110585667e+00) }, 
      { SC_(-3.3435131835937500000000000000000000000000e+02), SC_(-3.8045288085937500000000000000000000000000e+02), SC_(1.0198193359375000000000000000000000000000e+02), SC_(-2.8043212890625000000000000000000000000000e+01), SC_(7.8509068293092183850912864620461919495373e-01) }, 
      { SC_(-3.1815307617187500000000000000000000000000e+02), SC_(4.8236047363281250000000000000000000000000e+02), SC_(-2.3619708251953125000000000000000000000000e+02), SC_(-4.0464489746093750000000000000000000000000e+02), SC_(3.2284305619312206575036028397068097398837e-01) }, 
      { SC_(-3.1609228515625000000000000000000000000000e+02), SC_(4.7709960937500000000000000000000000000000e+00), SC_(-2.6004748535156250000000000000000000000000e+02), SC_(3.2260498046875000000000000000000000000000e+02), SC_(2.0681843344609826233997194529693269163853e+12) }, 
      { SC_(-3.1312744140625000000000000000000000000000e+02), SC_(-9.1268829345703125000000000000000000000000e+01), SC_(-1.0235595703125000000000000000000000000000e+01), SC_(-4.2010833740234375000000000000000000000000e+01), SC_(-1.1434801258896651208704659123724449421769e+05) }, 
      { SC_(-3.0340478515625000000000000000000000000000e+02), SC_(3.4846777343750000000000000000000000000000e+02), SC_(-2.4891619873046875000000000000000000000000e+02), SC_(4.5501757812500000000000000000000000000000e+02), SC_(4.8984161004382169077893149986653301379522e+00) }, 
      { SC_(-2.7102307128906250000000000000000000000000e+02), SC_(5.4985351562500000000000000000000000000000e+00), SC_(4.1333728027343750000000000000000000000000e+02), SC_(5.8268798828125000000000000000000000000000e+01), SC_(2.3772578658335831769915649816518556238736e-03) }, 
      { SC_(-2.6522009277343750000000000000000000000000e+02), SC_(5.2881164550781250000000000000000000000000e+01), SC_(-1.4684143066406250000000000000000000000000e+02), SC_(-4.4684753417968750000000000000000000000000e+02), SC_(8.4892537677592787989991483572127549572789e-09) }, 
      { SC_(-2.6008386230468750000000000000000000000000e+02), SC_(-4.5952893066406250000000000000000000000000e+02), SC_(-3.7668115234375000000000000000000000000000e+02), SC_(-2.4704406738281250000000000000000000000000e+02), SC_(1.4495627712429950621933072560877302044965e+00) }, 
      { SC_(-2.5830871582031250000000000000000000000000e+02), SC_(-2.2724700927734375000000000000000000000000e+02), SC_(-9.6087860107421875000000000000000000000000e+01), SC_(-7.5580139160156250000000000000000000000000e+00), SC_(1.0935759282076007044751382503570393444482e+00) }, 
      { SC_(-2.4012957763671875000000000000000000000000e+02), SC_(-4.5494055175781250000000000000000000000000e+02), SC_(3.0006848144531250000000000000000000000000e+02), SC_(1.6011944580078125000000000000000000000000e+02), SC_(1.3250416124772042353426751277966619703625e+00) }, 
      { SC_(-2.3702874755859375000000000000000000000000e+02), SC_(-1.5978033447265625000000000000000000000000e+02), SC_(1.5407910156250000000000000000000000000000e+02), SC_(2.9841979980468750000000000000000000000000e+01), SC_(1.3326049952467952598653371651232863684134e+00) }, 
      { SC_(-2.2397491455078125000000000000000000000000e+02), SC_(2.0577423095703125000000000000000000000000e+02), SC_(1.7970269775390625000000000000000000000000e+02), SC_(-4.9718164062500000000000000000000000000000e+02), SC_(1.9056234941228406055930919346670994692304e+01) }, 
      { SC_(-2.2307702636718750000000000000000000000000e+02), SC_(3.7242883300781250000000000000000000000000e+02), SC_(-4.5382861328125000000000000000000000000000e+02), SC_(-3.5088610839843750000000000000000000000000e+02), SC_(6.2898720554615802418327146735741736394814e-01) }, 
      { SC_(-2.2150177001953125000000000000000000000000e+02), SC_(-3.1161804199218750000000000000000000000000e+02), SC_(4.6881469726562500000000000000000000000000e+01), SC_(4.9288122558593750000000000000000000000000e+02), SC_(1.0487435494209809074694724050956547440689e+03) }, 
      { SC_(-1.8878497314453125000000000000000000000000e+02), SC_(3.6267810058593750000000000000000000000000e+02), SC_(2.8533142089843750000000000000000000000000e+01), SC_(1.2036004638671875000000000000000000000000e+02), SC_(9.9383072015492347795086661518016762849065e-02) }, 
      { SC_(-1.6228057861328125000000000000000000000000e+02), SC_(3.8772607421875000000000000000000000000000e+02), SC_(4.0005383300781250000000000000000000000000e+02), SC_(-1.5616046142578125000000000000000000000000e+02), SC_(1.1773064181329539807646132943923713860725e+00) }, 
      { SC_(-1.4904760742187500000000000000000000000000e+02), SC_(-3.0044885253906250000000000000000000000000e+02), SC_(1.3249511718750000000000000000000000000000e+01), SC_(-3.6199865722656250000000000000000000000000e+02), SC_(-2.4029573460782352192606632604885723921759e-06) }, 
      { SC_(-1.4834051513671875000000000000000000000000e+02), SC_(-4.3240466308593750000000000000000000000000e+02), SC_(3.3082861328125000000000000000000000000000e+02), SC_(2.9359753417968750000000000000000000000000e+02), SC_(1.3554151740644619074420270217185158298084e+00) }, 
      { SC_(-1.3151544189453125000000000000000000000000e+02), SC_(-1.5607025146484375000000000000000000000000e+02), SC_(1.2561859130859375000000000000000000000000e+02), SC_(3.1576904296875000000000000000000000000000e+02), SC_(8.1520938504033295486071048439136075568494e+00) }, 
      { SC_(-1.3075323486328125000000000000000000000000e+02), SC_(-4.6673144531250000000000000000000000000000e+02), SC_(-3.8879724121093750000000000000000000000000e+02), SC_(-3.3712792968750000000000000000000000000000e+02), SC_(1.2748509702084167484662551181100799157721e+00) }, 
      { SC_(-1.1955416870117187500000000000000000000000e+02), SC_(-2.9193200683593750000000000000000000000000e+02), SC_(6.7821594238281250000000000000000000000000e+01), SC_(2.7371459960937500000000000000000000000000e+01), SC_(1.1794084458977569869956360625369446312629e+00) }, 
      { SC_(-9.8191986083984375000000000000000000000000e+01), SC_(-1.1766705322265625000000000000000000000000e+02), SC_(-4.2403332519531250000000000000000000000000e+02), SC_(2.6242126464843750000000000000000000000000e+02), SC_(5.9669343007090826088072192231073904673194e-01) }, 
      { SC_(-8.2732940673828125000000000000000000000000e+01), SC_(4.8172314453125000000000000000000000000000e+02), SC_(-4.5034558105468750000000000000000000000000e+02), SC_(3.2345532226562500000000000000000000000000e+02), SC_(1.1311809199747059032676993957739437928526e+00) }, 
      { SC_(-7.8238739013671875000000000000000000000000e+01), SC_(-3.8753552246093750000000000000000000000000e+02), SC_(4.1573547363281250000000000000000000000000e+02), SC_(1.3976336669921875000000000000000000000000e+02), SC_(1.0701965862482266358967694037812895100740e+00) }, 
      { SC_(-6.8586181640625000000000000000000000000000e+01), SC_(2.4994097900390625000000000000000000000000e+02), SC_(4.1064758300781250000000000000000000000000e+02), SC_(-3.6700402832031250000000000000000000000000e+02), SC_(1.2771356300389206196314378574550847037874e+00) }, 
      { SC_(-6.1255645751953125000000000000000000000000e+01), SC_(-3.7410339355468750000000000000000000000000e+02), SC_(-1.1844155883789062500000000000000000000000e+02), SC_(-2.8979101562500000000000000000000000000000e+02), SC_(1.4921182330716139350597725372333505935146e+00) }, 
      { SC_(-5.4413787841796875000000000000000000000000e+01), SC_(-1.2431091308593750000000000000000000000000e+01), SC_(1.4631298828125000000000000000000000000000e+02), SC_(2.9397497558593750000000000000000000000000e+02), SC_(-2.5278953264648316431087258570812681778992e+04) }, 
      { SC_(-5.3216247558593750000000000000000000000000e+01), SC_(2.5578985595703125000000000000000000000000e+02), SC_(-1.9365051269531250000000000000000000000000e+02), SC_(-3.9193811035156250000000000000000000000000e+02), SC_(6.5531594455879472422876799045220598756408e-01) }, 
      { SC_(-4.9458404541015625000000000000000000000000e+01), SC_(2.2049340820312500000000000000000000000000e+02), SC_(-4.1617871093750000000000000000000000000000e+02), SC_(4.1257751464843750000000000000000000000000e+02), SC_(1.2483438748421501457339905802753720720856e+00) }, 
      { SC_(-1.3208374023437500000000000000000000000000e+01), SC_(4.1056494140625000000000000000000000000000e+02), SC_(-6.4141418457031250000000000000000000000000e+01), SC_(-1.1382293701171875000000000000000000000000e+01), SC_(9.9430625587774773590881102535071325517011e-01) }, 
      { SC_(-9.1358947753906250000000000000000000000000e+00), SC_(-2.5215240478515625000000000000000000000000e+02), SC_(-1.0747375488281250000000000000000000000000e+01), SC_(4.4056091308593750000000000000000000000000e+01), SC_(8.6184774616504107537101040944344063025663e-01) }, 
      { SC_(-1.9523921012878417968750000000000000000000e+00), SC_(9.0781879425048828125000000000000000000000e-01), SC_(-6.5150952339172363281250000000000000000000e-01), SC_(-2.2286041259765625000000000000000000000000e+01), SC_(-1.1829184327297930459732091586947349183430e+03) }, 
      { SC_(-1.6965827941894531250000000000000000000000e+00), SC_(-3.8316595554351806640625000000000000000000e-01), SC_(-1.7841997146606445312500000000000000000000e+00), SC_(-2.9447517395019531250000000000000000000000e+01), SC_(3.0932019607617689720770559134107540658859e+02) }, 
      { SC_(-1.6114730834960937500000000000000000000000e+00), SC_(1.9762740135192871093750000000000000000000e+00), SC_(1.2938313484191894531250000000000000000000e+00), SC_(6.4380645751953125000000000000000000000000e+01), SC_(4.5751763441190395082568811070936983485471e+02) }, 
      { SC_(-1.5240092277526855468750000000000000000000e+00), SC_(-1.7586874961853027343750000000000000000000e-01), SC_(-6.5437555313110351562500000000000000000000e-03), SC_(5.4783432006835937500000000000000000000000e+01), SC_(8.7593445866548644784554153716920135220292e+07) }, 
      { SC_(-1.4920530319213867187500000000000000000000e+00), SC_(1.8754711151123046875000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+00), SC_(-5.5793197631835937500000000000000000000000e+01), SC_(5.9574323300473903736296340992008016775853e+01) }, 
      { SC_(-1.4028239250183105468750000000000000000000e+00), SC_(-1.0793757438659667968750000000000000000000e+00), SC_(-9.6996712684631347656250000000000000000000e-01), SC_(6.1946899414062500000000000000000000000000e+01), SC_(-3.0454988293761419029095887681263402220572e+09) }, 
      { SC_(-1.3695478439331054687500000000000000000000e+00), SC_(9.0335583686828613281250000000000000000000e-01), SC_(1.8823709487915039062500000000000000000000e+00), SC_(9.6221923828125000000000000000000000000000e+01), SC_(1.5993919919071500351168916827210844991695e+04) }, 
      { SC_(-1.3512711524963378906250000000000000000000e+00), SC_(1.7099714279174804687500000000000000000000e+00), SC_(1.1771378517150878906250000000000000000000e+00), SC_(-1.2776489257812500000000000000000000000000e+01), SC_(1.2240014879399043423175568994561403840721e+01) }, 
      { SC_(-1.2525095939636230468750000000000000000000e+00), SC_(-3.6507534980773925781250000000000000000000e-01), SC_(-4.0942430496215820312500000000000000000000e-02), SC_(-8.4021682739257812500000000000000000000000e+00), SC_(1.4097716434932852029816897270885530598483e+03) }, 
      { SC_(-1.2136192321777343750000000000000000000000e+00), SC_(1.3938708305358886718750000000000000000000e+00), SC_(-9.9566459655761718750000000000000000000000e-01), SC_(9.1003509521484375000000000000000000000000e+01), SC_(-2.1412398725284440675823281404424652677267e+08) }, 
      { SC_(-8.9589977264404296875000000000000000000000e-01), SC_(8.2309699058532714843750000000000000000000e-01), SC_(7.1881079673767089843750000000000000000000e-01), SC_(-9.9436309814453125000000000000000000000000e+01), SC_(1.0948867089361139355200808120640760155402e+02) }, 
      { SC_(-8.9230823516845703125000000000000000000000e-01), SC_(1.4897150993347167968750000000000000000000e+00), SC_(-1.8153147697448730468750000000000000000000e+00), SC_(-7.0177215576171875000000000000000000000000e+01), SC_(-7.6674988422858550132775055090660067781617e+00) }, 
      { SC_(-8.8600707054138183593750000000000000000000e-01), SC_(-1.2464723587036132812500000000000000000000e+00), SC_(1.8752598762512207031250000000000000000000e-01), SC_(9.8576263427734375000000000000000000000000e+01), SC_(-1.0770215401622412837922799995284943227872e+09) }, 
      { SC_(-5.9336209297180175781250000000000000000000e-01), SC_(-1.7296185493469238281250000000000000000000e+00), SC_(1.3233141899108886718750000000000000000000e+00), SC_(5.8719512939453125000000000000000000000000e+01), SC_(-1.1009498459690405526674569312679275410682e+06) }, 
      { SC_(-4.7821664810180664062500000000000000000000e-01), SC_(-1.1677279472351074218750000000000000000000e+00), SC_(2.7128648757934570312500000000000000000000e-01), SC_(5.4742965698242187500000000000000000000000e+00), SC_(-1.9266906856217955276585238741895455418904e+02) }, 
      { SC_(-3.1295490264892578125000000000000000000000e-01), SC_(-1.5501422882080078125000000000000000000000e+00), SC_(1.6629419326782226562500000000000000000000e+00), SC_(2.7952667236328125000000000000000000000000e+01), SC_(-3.5021530400436195089164439908334907557730e+03) }, 
      { SC_(-2.4502253532409667968750000000000000000000e-01), SC_(-1.4964137077331542968750000000000000000000e+00), SC_(-4.7376620769500732421875000000000000000000e-01), SC_(-5.7958190917968750000000000000000000000000e+01), SC_(8.8772058948223989853147952305320917042946e+01) }, 
      { SC_(-2.1765518188476562500000000000000000000000e-01), SC_(-4.9724340438842773437500000000000000000000e-02), SC_(5.8525204658508300781250000000000000000000e-01), SC_(5.8794998168945312500000000000000000000000e+01), SC_(4.5921366203604249788225130841098163284568e+06) }, 
      { SC_(-9.7619613370625302195549011230468750000000e-07), SC_(4.5390936520561808720231056213378906250000e-07), SC_(-3.2575474051554920151829719543457031250000e-07), SC_(-4.4572086334228515625000000000000000000000e+00), SC_(2.0390856319903787480402625064753476893836e+06) }, 
      { SC_(-8.4829139268549624830484390258789062500000e-07), SC_(-1.9158295572196948342025279998779296875000e-07), SC_(-8.9209993348049465566873550415039062500000e-07), SC_(-5.8895034790039062500000000000000000000000e+00), SC_(-3.7050701918386056547771125250197701019540e+06) }, 
      { SC_(-8.0573659033689182251691818237304687500000e-07), SC_(9.8813688964582979679107666015625000000000e-07), SC_(6.4691562329244334250688552856445312500000e-07), SC_(1.2876132965087890625000000000000000000000e+01), SC_(-8.3298943510672174570318656500757462377147e+08) }, 
      { SC_(-7.6200467447051778435707092285156250000000e-07), SC_(-8.7934381554077845066785812377929687500000e-08), SC_(-3.2719071896281093358993530273437500000000e-09), SC_(1.0956684112548828125000000000000000000000e+01), SC_(-9.5861706646135309243107091950306113675211e+11) }, 
      { SC_(-7.4602644417609553784132003784179687500000e-07), SC_(9.3773542175767943263053894042968750000000e-07), SC_(8.2675160228973254561424255371093750000000e-07), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-3.2480681746796721650950875355518067773457e+05) }, 
      { SC_(-7.0141209107532631605863571166992187500000e-07), SC_(-5.3968801694281864911317825317382812500000e-07), SC_(-4.8498350224690511822700500488281250000000e-07), SC_(1.2389381408691406250000000000000000000000e+01), SC_(-1.5276873193825676575054334716098034939573e+09) }, 
      { SC_(-6.8477379500109236687421798706054687500000e-07), SC_(4.5167791995481820777058601379394531250000e-07), SC_(9.4118558990885503590106964111328125000000e-07), SC_(1.9244384765625000000000000000000000000000e+01), SC_(-5.8766461812921984449513547456744185037625e+09) }, 
      { SC_(-6.7563541961135342717170715332031250000000e-07), SC_(8.5498572843789588660001754760742187500000e-07), SC_(5.8856903706328012049198150634765625000000e-07), SC_(-2.5552978515625000000000000000000000000000e+00), SC_(5.6344407174277391731457778331764112027764e+05) }, 
      { SC_(-6.2625485952594317495822906494140625000000e-07), SC_(-1.8253768985232454724609851837158203125000e-07), SC_(-2.0471247808018233627080917358398437500000e-08), SC_(-1.6804332733154296875000000000000000000000e+00), SC_(1.0272970389489382601204444664366227074609e+08) }, 
      { SC_(-6.0680963542836252599954605102539062500000e-07), SC_(6.9693555815319996327161788940429687500000e-07), SC_(-4.9783238864620216190814971923828125000000e-07), SC_(1.8200698852539062500000000000000000000000e+01), SC_(4.9368357357713658461736812608373135802872e+09) }, 
      { SC_(-4.4794990117225097492337226867675781250000e-07), SC_(4.1154851260216673836112022399902343750000e-07), SC_(3.5940536236012121662497520446777343750000e-07), SC_(-1.9887268066406250000000000000000000000000e+01), SC_(3.4313447988255817246239442092899209507143e+06) }, 
      { SC_(-4.4615410388360032811760902404785156250000e-07), SC_(7.4485751611064188182353973388671875000000e-07), SC_(-9.0765729510167147964239120483398437500000e-07), SC_(-1.4035442352294921875000000000000000000000e+01), SC_(-3.2993243176535706454168625463832973038380e+05) }, 
      { SC_(-4.4300361423665890470147132873535156250000e-07), SC_(-6.2323601923708338290452957153320312500000e-07), SC_(9.3762992037227377295494079589843750000000e-08), SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.0975810014411379302338976457651255588469e+10) }, 
      { SC_(-2.9668103707081172615289688110351562500000e-07), SC_(-8.6480940808542072772979736328125000000000e-07), SC_(6.6165716816612984985113143920898437500000e-07), SC_(1.1743904113769531250000000000000000000000e+01), SC_(2.4177391692196965555221482837743174387890e+08) }, 
      { SC_(-2.3910831714601954445242881774902343750000e-07), SC_(-5.8386399359733331948518753051757812500000e-07), SC_(1.3564329037762945517897605895996093750000e-07), SC_(1.0948581695556640625000000000000000000000e+00), SC_(5.4771294650245066101941373271572776376353e+06) }, 
      { SC_(-1.5647742657165508717298507690429687500000e-07), SC_(-7.7507093010353855788707733154296875000000e-07), SC_(8.3147097029723227024078369140625000000000e-07), SC_(5.5905342102050781250000000000000000000000e+00), SC_(1.0893152733850533520090684232529022403115e+07) }, 
      { SC_(-1.2251126690898672677576541900634765625000e-07), SC_(-7.4820673034992069005966186523437500000000e-07), SC_(-2.3688312467129435390233993530273437500000e-07), SC_(-1.1591636657714843750000000000000000000000e+01), SC_(-1.4685772372841482180092747948737205248060e+05) }, 
      { SC_(-1.0882757806029985658824443817138671875000e-07), SC_(-2.4862174541340209543704986572265625000000e-08), SC_(2.9262605494295712560415267944335937500000e-07), SC_(1.1758998870849609375000000000000000000000e+01), SC_(7.0085733164307707904742546819325804581607e+09) }, 
      { SC_(1.1914153219549916684627532958984375000000e-08), SC_(8.8014803623082116246223449707031250000000e-07), SC_(3.9815347463445505127310752868652343750000e-07), SC_(-3.4933395385742187500000000000000000000000e+00), SC_(-2.4213395903710354080064139512889419313219e+03) }, 
      { SC_(6.1595073930220678448677062988281250000000e-08), SC_(1.8564776382845593616366386413574218750000e-07), SC_(5.5833447731856722384691238403320312500000e-07), SC_(-5.7461948394775390625000000000000000000000e+00), SC_(4.2373367640274608234301782138991819622589e+05) }, 
      { SC_(9.4431015895679593086242675781250000000000e-08), SC_(-6.8388499130378477275371551513671875000000e-07), SC_(-7.2275111051567364484071731567382812500000e-07), SC_(1.0469245910644531250000000000000000000000e+01), SC_(5.8815521327351612461922728099556521478707e+07) }, 
      { SC_(1.3764724826614838093519210815429687500000e-07), SC_(-2.1018354345869738608598709106445312500000e-07), SC_(-6.1218713653943268582224845886230468750000e-08), SC_(-4.5081634521484375000000000000000000000000e+00), SC_(3.5066052500807068305217003330435349102634e+06) }, 
      { SC_(1.7052821021934505552053451538085937500000e-07), SC_(1.8900720988312968984246253967285156250000e-07), SC_(9.9447220236470457166433334350585937500000e-08), SC_(9.3119468688964843750000000000000000000000e+00), SC_(1.8691175369107393543562706039240528488820e+09) }, 
      { SC_(1.7053548617695923894643783569335937500000e-07), SC_(6.1635091697098687291145324707031250000000e-07), SC_(-5.5237615015357732772827148437500000000000e-07), SC_(-1.9289047241210937500000000000000000000000e+01), SC_(5.8332851954635493442668807755042672277065e+05) }, 
      { SC_(2.3208940547192469239234924316406250000000e-07), SC_(5.5779537433409132063388824462890625000000e-07), SC_(-5.3422354540089145302772521972656250000000e-08), SC_(1.9498382568359375000000000000000000000000e+01), SC_(-3.0211337538599054448704455721377476905237e+10) }, 
      { SC_(2.6471855107956798747181892395019531250000e-07), SC_(-3.8366590615623863413929939270019531250000e-07), SC_(-8.0491918197367340326309204101562500000000e-07), SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.7129365099541520503695106638218506803419e+06) }, 
      { SC_(3.1019601465231971815228462219238281250000e-07), SC_(4.2140766254306072369217872619628906250000e-07), SC_(-6.7477662923920433968305587768554687500000e-07), SC_(5.7584381103515625000000000000000000000000e+00), SC_(-5.2985006221267513784402944329277986205465e+07) }, 
      { SC_(3.1095578378881327807903289794921875000000e-07), SC_(-6.5226981860178057104349136352539062500000e-07), SC_(-6.5762674239522311836481094360351562500000e-07), SC_(-7.9234752655029296875000000000000000000000e+00), SC_(6.7669482623762672110573258990526628535393e+05) }, 
      { SC_(3.1148135803960030898451805114746093750000e-07), SC_(5.9585727285593748092651367187500000000000e-07), SC_(-9.2857681011082604527473449707031250000000e-07), SC_(-5.5482406616210937500000000000000000000000e+00), SC_(-3.7308751004690476867804522335229260253607e+05) }, 
      { SC_(3.5747029869526159018278121948242187500000e-07), SC_(-2.0252292642908287234604358673095703125000e-07), SC_(5.1548022383940406143665313720703125000000e-07), SC_(9.6258888244628906250000000000000000000000e+00), SC_(-7.8869245769288846478831121480761041687716e+08) }, 
      { SC_(3.8965720250416779890656471252441406250000e-07), SC_(-7.4963463703170418739318847656250000000000e-07), SC_(-3.6580104278982616961002349853515625000000e-07), SC_(1.0549999237060546875000000000000000000000e+01), SC_(4.4947482223118792195663906339658280350159e+08) }, 
      { SC_(4.1209216306015150621533393859863281250000e-07), SC_(5.9455965129018295556306838989257812500000e-07), SC_(-9.3633434516959823668003082275390625000000e-07), SC_(-7.3379821777343750000000000000000000000000e+00), SC_(-6.9157066590404182102860822841792062600453e+05) }, 
      { SC_(4.1872965539369033649563789367675781250000e-07), SC_(8.4174939729564357548952102661132812500000e-07), SC_(5.0937319429067429155111312866210937500000e-07), SC_(1.2301239013671875000000000000000000000000e+01), SC_(5.4184782384285158550527607233643905152616e+08) }, 
      { SC_(4.8626498028170317411422729492187500000000e-07), SC_(-5.0482640290283598005771636962890625000000e-08), SC_(-2.1554592422035057097673416137695312500000e-07), SC_(-3.1164932250976562500000000000000000000000e+00), SC_(-9.8212756326249886949282257365893056987739e+06) }, 
      { SC_(5.0253402150701731443405151367187500000000e-07), SC_(6.4249184106301981955766677856445312500000e-07), SC_(-4.8980973588186316192150115966796875000000e-07), SC_(1.2833629608154296875000000000000000000000e+01), SC_(-1.0419146936547197259830585021874292240050e+09) }, 
      { SC_(5.1440042625472415238618850708007812500000e-07), SC_(-2.1535907990255509503185749053955078125000e-07), SC_(5.0745825319609139114618301391601562500000e-07), SC_(2.4622993469238281250000000000000000000000e+00), SC_(-3.3076803872606148811741541436856810536357e+07) }, 
      { SC_(5.3103349273442290723323822021484375000000e-07), SC_(-8.9756713350652717053890228271484375000000e-07), SC_(5.9039984989794902503490447998046875000000e-07), SC_(-1.8542350769042968750000000000000000000000e+01), SC_(1.1759847440127197068954442094213072822112e+06) }, 
      { SC_(5.8441446526558138430118560791015625000000e-07), SC_(7.5686125455831643193960189819335937500000e-07), SC_(9.1898482423857785761356353759765625000000e-07), SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.3234063058482241547871612859102948263635e+05) }, 
      { SC_(6.0056095207983162254095077514648437500000e-07), SC_(-4.0594113670522347092628479003906250000000e-07), SC_(-7.1622730501985643059015274047851562500000e-07), SC_(-1.9808662414550781250000000000000000000000e+01), SC_(-2.3513863463574376645307381118474192600379e+06) }, 
      { SC_(6.2856952354195527732372283935546875000000e-07), SC_(-4.0033660297922324389219284057617187500000e-07), SC_(-5.1295023695274721831083297729492187500000e-07), SC_(-1.9458435058593750000000000000000000000000e+01), SC_(-3.5438586643515318535937318266985290727183e+06) }, 
      { SC_(6.2944718592916615307331085205078125000000e-07), SC_(-7.2904595072031952440738677978515625000000e-07), SC_(8.1158373177458997815847396850585937500000e-07), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-8.2158831174835729949593632100068229355882e+08) }, 
      { SC_(6.8143435782985761761665344238281250000000e-07), SC_(9.7704287327360361814498901367187500000000e-07), SC_(-4.9143568503495771437883377075195312500000e-07), SC_(-6.7020702362060546875000000000000000000000e+00), SC_(-1.2570836330551324958141400528797778255573e+06) }, 
      { SC_(6.9825864557060413062572479248046875000000e-07), SC_(-5.7615147852629888802766799926757812500000e-07), SC_(8.6798627307871356606483459472656250000000e-07), SC_(7.2543811798095703125000000000000000000000e+00), SC_(-1.3070460592291642693293927319202580575874e+08) }, 
      { SC_(7.8180642049119342118501663208007812500000e-07), SC_(-1.5366975958386319689452648162841796875000e-07), SC_(9.1858260020671878010034561157226562500000e-07), SC_(3.2382678985595703125000000000000000000000e+00), SC_(-6.7641699010297380185938360549415753662493e+07) }, 
      { SC_(8.3438726505846716463565826416015625000000e-07), SC_(3.9046574329404393211007118225097656250000e-07), SC_(-4.2832198232645168900489807128906250000000e-07), SC_(7.1927909851074218750000000000000000000000e+00), SC_(-4.5530045634227704569418468380534251517225e+08) }, 
      { SC_(8.5852730080659966915845870971679687500000e-07), SC_(-5.6552448768343310803174972534179687500000e-07), SC_(-3.0003252504684496670961380004882812500000e-07), SC_(1.6294586181640625000000000000000000000000e+01), SC_(8.7528600373191785043084285508471581551059e+09) }, 
      { SC_(8.6802128862473182380199432373046875000000e-07), SC_(9.2993263933749403804540634155273437500000e-07), SC_(-7.4018771556438878178596496582031250000000e-07), SC_(-1.3822463989257812500000000000000000000000e+01), SC_(5.5770759202173580684235052463930770424976e+05) }, 
      { SC_(9.0044409262191038578748703002929687500000e-07), SC_(-1.8821879166353028267621994018554687500000e-08), SC_(-9.3110793386586010456085205078125000000000e-07), SC_(6.5442199707031250000000000000000000000000e+00), SC_(3.5599740007994579252376170967252840208664e+09) }, 
      { SC_(9.1433389570738654583692550659179687500000e-07), SC_(-7.8027665040281135588884353637695312500000e-07), SC_(-2.9248667487991042435169219970703125000000e-08), SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.9772357623726951534481318507530252109600e+10) }, 
      { SC_(9.1501351562328636646270751953125000000000e-07), SC_(9.9292265076655894517898559570312500000000e-07), SC_(9.2977688836981542408466339111328125000000e-07), SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.1721394412384312467200902074567235982111e+09) }, 
      { SC_(9.1948777480865828692913055419921875000000e-07), SC_(1.4750935406482312828302383422851562500000e-07), SC_(-3.1922854759613983333110809326171875000000e-07), SC_(1.5070297241210937500000000000000000000000e+01), SC_(-2.4262870589479507976160220386103259668574e+10) }, 
      { SC_(2.3828268051147460937500000000000000000000e-02), SC_(1.7602958679199218750000000000000000000000e+00), SC_(7.9630684852600097656250000000000000000000e-01), SC_(-1.7466697692871093750000000000000000000000e+01), SC_(9.1786858649690201565006550799607043966095e-01) }, 
      { SC_(1.2319016456604003906250000000000000000000e-01), SC_(3.7129545211791992187500000000000000000000e-01), SC_(1.1166687011718750000000000000000000000000e+00), SC_(-2.8730972290039062500000000000000000000000e+01), SC_(3.6921090863809142809351519838517798785965e-01) }, 
      { SC_(1.8886208534240722656250000000000000000000e-01), SC_(-1.3677697181701660156250000000000000000000e+00), SC_(-1.4455022811889648437500000000000000000000e+00), SC_(5.2346237182617187500000000000000000000000e+01), SC_(6.6852474817507046160150928842610934008294e+08) }, 
      { SC_(2.7529454231262207031250000000000000000000e-01), SC_(-4.2036712169647216796875000000000000000000e-01), SC_(-1.2243747711181640625000000000000000000000e-01), SC_(-2.2540817260742187500000000000000000000000e+01), SC_(2.8080108893937024432787128425701755703782e+01) }, 
      { SC_(3.4105634689331054687500000000000000000000e-01), SC_(3.7801432609558105468750000000000000000000e-01), SC_(1.9889450073242187500000000000000000000000e-01), SC_(4.6559738159179687500000000000000000000000e+01), SC_(1.6206408780105997607845273632988877245551e+06) }, 
      { SC_(3.4107089042663574218750000000000000000000e-01), SC_(1.2327017784118652343750000000000000000000e+00), SC_(-1.1047525405883789062500000000000000000000e+00), SC_(-9.6445220947265625000000000000000000000000e+01), SC_(-3.8484744081422763236114373523072489212112e+00) }, 
      { SC_(4.6417880058288574218750000000000000000000e-01), SC_(1.1155905723571777343750000000000000000000e+00), SC_(-1.0684466361999511718750000000000000000000e-01), SC_(9.7491912841796875000000000000000000000000e+01), SC_(-4.6010602165029492889181278892892394272558e+08) }, 
      { SC_(5.2943706512451171875000000000000000000000e-01), SC_(-7.6733183860778808593750000000000000000000e-01), SC_(-1.6098384857177734375000000000000000000000e+00), SC_(9.4441146850585937500000000000000000000000e+00), SC_(-3.2184998785567254019424485390781402683072e+04) }, 
      { SC_(6.2039208412170410156250000000000000000000e-01), SC_(8.4281539916992187500000000000000000000000e-01), SC_(-1.3495531082153320312500000000000000000000e+00), SC_(2.8792190551757812500000000000000000000000e+01), SC_(3.3588563871376330639319653028864899424982e+05) }, 
      { SC_(6.2191152572631835937500000000000000000000e-01), SC_(-1.3045396804809570312500000000000000000000e+00), SC_(-1.3152532577514648437500000000000000000000e+00), SC_(-3.9617385864257812500000000000000000000000e+01), SC_(3.8058731291130885829735340869502847662521e+03) }, 
      { SC_(6.2296271324157714843750000000000000000000e-01), SC_(1.1917142868041992187500000000000000000000e+00), SC_(-1.8571534156799316406250000000000000000000e+00), SC_(-2.7741203308105468750000000000000000000000e+01), SC_(8.2410199881943277664766976931650690574205e+00) }, 
      { SC_(7.1494054794311523437500000000000000000000e-01), SC_(-4.0504586696624755859375000000000000000000e-01), SC_(1.0309605598449707031250000000000000000000e+00), SC_(4.8129455566406250000000000000000000000000e+01), SC_(-2.4488176651174917791001931171899780426382e+06) }, 
      { SC_(7.7931451797485351562500000000000000000000e-01), SC_(-1.4992690086364746093750000000000000000000e+00), SC_(-7.3160219192504882812500000000000000000000e-01), SC_(5.2750000000000000000000000000000000000000e+01), SC_(-5.1763434184944586223726668339937105042164e+09) }, 
      { SC_(8.2418441772460937500000000000000000000000e-01), SC_(1.1891193389892578125000000000000000000000e+00), SC_(-1.8726687431335449218750000000000000000000e+00), SC_(-3.6689926147460937500000000000000000000000e+01), SC_(-7.8413804334785797548200728367626727514279e+01) }, 
      { SC_(8.3745932579040527343750000000000000000000e-01), SC_(1.6834988594055175781250000000000000000000e+00), SC_(1.0187463760375976562500000000000000000000e+00), SC_(6.1506195068359375000000000000000000000000e+01), SC_(8.8053034551352801101170927673985684736895e+04) }, 
      { SC_(9.7252988815307617187500000000000000000000e-01), SC_(-1.0096526145935058593750000000000000000000e-01), SC_(-4.3109190464019775390625000000000000000000e-01), SC_(-1.5582466125488281250000000000000000000000e+01), SC_(1.6077933149546216922448628799015568960147e+01) }, 
      { SC_(1.0050683021545410156250000000000000000000e+00), SC_(1.2849836349487304687500000000000000000000e+00), SC_(-9.7961950302124023437500000000000000000000e-01), SC_(6.4168151855468750000000000000000000000000e+01), SC_(-1.1874369689072521683636653467674927435810e+09) }, 
      { SC_(1.0288009643554687500000000000000000000000e+00), SC_(-4.3071818351745605468750000000000000000000e-01), SC_(1.0149164199829101562500000000000000000000e+00), SC_(1.2311492919921875000000000000000000000000e+01), SC_(-3.2939213001579530083865116401520578834902e+03) }, 
      { SC_(1.0620670318603515625000000000000000000000e+00), SC_(-1.7951345443725585937500000000000000000000e+00), SC_(1.1807994842529296875000000000000000000000e+00), SC_(-9.2711761474609375000000000000000000000000e+01), SC_(-1.4590778530503876337141360732700303176896e+02) }, 
      { SC_(1.1688289642333984375000000000000000000000e+00), SC_(1.5137224197387695312500000000000000000000e+00), SC_(1.8379697799682617187500000000000000000000e+00), SC_(7.3254394531250000000000000000000000000000e-01), SC_(1.3440572720877849358168904494767052766532e+00) }, 
      { SC_(1.2011218070983886718750000000000000000000e+00), SC_(-8.1188225746154785156250000000000000000000e-01), SC_(-1.4324545860290527343750000000000000000000e+00), SC_(-9.9043304443359375000000000000000000000000e+01), SC_(-4.9004437797159043695886284131083276977500e+04) }, 
      { SC_(1.2571392059326171875000000000000000000000e+00), SC_(-8.0067324638366699218750000000000000000000e-01), SC_(-1.0259003639221191406250000000000000000000e+00), SC_(-9.7292175292968750000000000000000000000000e+01), SC_(-4.9611653126187695509022702434847288272266e+05) }, 
      { SC_(1.2588944435119628906250000000000000000000e+00), SC_(-1.4580922126770019531250000000000000000000e+00), SC_(1.6231675148010253906250000000000000000000e+00), SC_(6.7001708984375000000000000000000000000000e+01), SC_(1.9571886076446839661949442328340278147547e+08) }, 
      { SC_(1.3628687858581542968750000000000000000000e+00), SC_(1.9540863037109375000000000000000000000000e+00), SC_(-9.8287129402160644531250000000000000000000e-01), SC_(-3.3510345458984375000000000000000000000000e+01), SC_(-1.3168915817072598325998765774517958524656e+02) }, 
      { SC_(1.3965172767639160156250000000000000000000e+00), SC_(-1.1523027420043945312500000000000000000000e+00), SC_(1.7359728813171386718750000000000000000000e+00), SC_(3.6271911621093750000000000000000000000000e+01), SC_(2.5239046799596093988854657736671488349122e+06) }, 
      { SC_(1.5636129379272460937500000000000000000000e+00), SC_(-3.0733954906463623046875000000000000000000e-01), SC_(1.8371653556823730468750000000000000000000e+00), SC_(1.6191337585449218750000000000000000000000e+01), SC_(-6.9826330494387275764584419133534245744731e+03) }, 
      { SC_(1.6687746047973632812500000000000000000000e+00), SC_(7.8093147277832031250000000000000000000000e-01), SC_(-8.5664391517639160156250000000000000000000e-01), SC_(3.5963958740234375000000000000000000000000e+01), SC_(-2.6849384707902083714388731634726088103218e+07) }, 
      { SC_(1.7170543670654296875000000000000000000000e+00), SC_(-1.1310486793518066406250000000000000000000e+00), SC_(-6.0006499290466308593750000000000000000000e-01), SC_(8.1472930908203125000000000000000000000000e+01), SC_(-4.1016277341529522594197248872635222722466e+12) }, 
      { SC_(1.7360424995422363281250000000000000000000e+00), SC_(1.8598651885986328125000000000000000000000e+00), SC_(-1.4803752899169921875000000000000000000000e+00), SC_(-6.9112335205078125000000000000000000000000e+01), SC_(4.4608058955134434027812700531415233517309e+01) }, 
      { SC_(1.8008880615234375000000000000000000000000e+00), SC_(-3.7643790245056152343750000000000000000000e-02), SC_(-1.8622159957885742187500000000000000000000e+00), SC_(3.2721099853515625000000000000000000000000e+01), SC_(-5.8025144246502271636528475791611268648017e+09) }, 
      { SC_(1.8286676406860351562500000000000000000000e+00), SC_(-1.5605530738830566406250000000000000000000e+00), SC_(-5.8497428894042968750000000000000000000000e-02), SC_(5.9621170043945312500000000000000000000000e+01), SC_(-2.3500838894502261351724773880095948691273e+11) }, 
      { SC_(1.8300271034240722656250000000000000000000e+00), SC_(1.9858450889587402343750000000000000000000e+00), SC_(1.8595538139343261718750000000000000000000e+00), SC_(9.3538970947265625000000000000000000000000e+01), SC_(2.2402948212223177127877298461199206322254e+06) }, 
      { SC_(1.8389759063720703125000000000000000000000e+00), SC_(2.9501867294311523437500000000000000000000e-01), SC_(-6.3845705986022949218750000000000000000000e-01), SC_(7.5351470947265625000000000000000000000000e+01), SC_(-4.6188765277433671547205922059114125063657e+10) }, 
      { SC_(5.9570617675781250000000000000000000000000e+00), SC_(4.4007397460937500000000000000000000000000e+02), SC_(1.9907672119140625000000000000000000000000e+02), SC_(-8.7333465576171875000000000000000000000000e+01), SC_(9.9408202789347440711233450541676536182022e-01) }, 
      { SC_(8.5086669921875000000000000000000000000000e+00), SC_(-1.0641015625000000000000000000000000000000e+02), SC_(1.0771575927734375000000000000000000000000e+01), SC_(3.7018676757812500000000000000000000000000e+02), SC_(7.2623516516618524029955680515314046153725e-02) }, 
      { SC_(3.0797546386718750000000000000000000000000e+01), SC_(9.2823852539062500000000000000000000000000e+01), SC_(2.7916723632812500000000000000000000000000e+02), SC_(-1.4365484619140625000000000000000000000000e+02), SC_(8.4326727659631721157174183460631559152188e-01) }, 
      { SC_(3.8342407226562500000000000000000000000000e+01), SC_(4.6591918945312500000000000000000000000000e+01), SC_(4.9613464355468750000000000000000000000000e+02), SC_(-5.2415618896484375000000000000000000000000e+01), SC_(9.1673888745882473859576194972962541813227e-01) }, 
      { SC_(4.7008850097656250000000000000000000000000e+01), SC_(2.1846997070312500000000000000000000000000e+02), SC_(-2.0367919921875000000000000000000000000000e+02), SC_(-2.1219500732421875000000000000000000000000e+02), SC_(1.2519657355138109275596480610260289714339e+00) }, 
      { SC_(4.7215515136718750000000000000000000000000e+01), SC_(-3.4194250488281250000000000000000000000000e+02), SC_(-3.6137561035156250000000000000000000000000e+02), SC_(2.6173120117187500000000000000000000000000e+02), SC_(1.1053277666865944797922760544446432575240e+00) }, 
      { SC_(4.9860168457031250000000000000000000000000e+01), SC_(-4.9190612792968750000000000000000000000000e+02), SC_(-3.5504528808593750000000000000000000000000e+02), SC_(1.8028704833984375000000000000000000000000e+02), SC_(1.0528522949754939235139478459583473047497e+00) }, 
      { SC_(6.8823608398437500000000000000000000000000e+01), SC_(-1.0509176635742187500000000000000000000000e+02), SC_(-3.0609375000000000000000000000000000000000e+01), SC_(-1.1270410156250000000000000000000000000000e+02), SC_(8.1882433453513698015868373598626589179897e-02) }, 
      { SC_(7.5208618164062500000000000000000000000000e+01), SC_(2.5750354003906250000000000000000000000000e+02), SC_(-4.4022045898437500000000000000000000000000e+02), SC_(-6.4754302978515625000000000000000000000000e+01), SC_(1.0439093035567952930037308345414953398907e+00) }, 
      { SC_(8.5264099121093750000000000000000000000000e+01), SC_(9.4503601074218750000000000000000000000000e+01), SC_(4.9723632812500000000000000000000000000000e+01), SC_(2.3279870605468750000000000000000000000000e+02), SC_(5.8750126590687399051494813676638267079334e+01) }, 
      { SC_(8.5267700195312500000000000000000000000000e+01), SC_(3.0817541503906250000000000000000000000000e+02), SC_(-2.7618811035156250000000000000000000000000e+02), SC_(-4.8222619628906250000000000000000000000000e+02), SC_(1.6233879657458505074002724075600326142420e+00) }, 
      { SC_(1.1604467773437500000000000000000000000000e+02), SC_(2.7889770507812500000000000000000000000000e+02), SC_(-2.6711151123046875000000000000000000000000e+01), SC_(4.8745959472656250000000000000000000000000e+02), SC_(-5.1806230097166898561484867910370677250847e+11) }, 
      { SC_(1.3235925292968750000000000000000000000000e+02), SC_(-1.9183294677734375000000000000000000000000e+02), SC_(-4.0245959472656250000000000000000000000000e+02), SC_(4.7220581054687500000000000000000000000000e+01), SC_(1.0843760236525485545300232781003619651486e+00) }, 
      { SC_(1.4431811523437500000000000000000000000000e+02), SC_(4.3805480957031250000000000000000000000000e+01), SC_(-1.2139062500000000000000000000000000000000e+02), SC_(-3.5985620117187500000000000000000000000000e+02), SC_(1.3357739425675917693250999924089324792270e+04) }, 
      { SC_(1.4774597167968750000000000000000000000000e+02), SC_(-6.6731567382812500000000000000000000000000e+00), SC_(-4.9076293945312500000000000000000000000000e+01), SC_(-1.2149957275390625000000000000000000000000e+02), SC_(5.1197828186533227158345362301702048091881e+28) }, 
      { SC_(1.4911547851562500000000000000000000000000e+02), SC_(-2.4170410156250000000000000000000000000000e+02), SC_(2.3172241210937500000000000000000000000000e+02), SC_(-3.7015356445312500000000000000000000000000e+02), SC_(2.6877066984629240237619084760338808431856e+00) }, 
      { SC_(1.5509802246093750000000000000000000000000e+02), SC_(2.1070385742187500000000000000000000000000e+02), SC_(-3.3738830566406250000000000000000000000000e+02), SC_(1.4396093750000000000000000000000000000000e+02), SC_(7.3062440833951586535134071449784945111317e-01) }, 
      { SC_(1.5547790527343750000000000000000000000000e+02), SC_(-3.2613488769531250000000000000000000000000e+02), SC_(-3.2881335449218750000000000000000000000000e+02), SC_(-1.9808691406250000000000000000000000000000e+02), SC_(7.5075383430041262036181333045794876434641e-01) }, 
      { SC_(1.5574066162109375000000000000000000000000e+02), SC_(2.9792858886718750000000000000000000000000e+02), SC_(-4.6428833007812500000000000000000000000000e+02), SC_(-1.3870599365234375000000000000000000000000e+02), SC_(1.1690992366280791280451092675281448474856e+00) }, 
      { SC_(1.7873510742187500000000000000000000000000e+02), SC_(-1.0126147460937500000000000000000000000000e+02), SC_(2.5774011230468750000000000000000000000000e+02), SC_(2.4064727783203125000000000000000000000000e+02), SC_(1.9544031713550955202857129631641108208979e-01) }, 
      { SC_(1.8677545166015625000000000000000000000000e+02), SC_(-1.8749200439453125000000000000000000000000e+02), SC_(-3.1648889160156250000000000000000000000000e+02), SC_(-1.1428948974609375000000000000000000000000e+02), SC_(6.9848690296299354656034435971521134384812e-01) }, 
      { SC_(1.8921453857421875000000000000000000000000e+02), SC_(2.1610070800781250000000000000000000000000e+02), SC_(2.4815161132812500000000000000000000000000e+02), SC_(4.8837939453125000000000000000000000000000e+02), SC_(5.5748017785187218308346802966558249227462e+00) }, 
      { SC_(1.9482861328125000000000000000000000000000e+02), SC_(-3.7481726074218750000000000000000000000000e+02), SC_(-1.8290051269531250000000000000000000000000e+02), SC_(2.6375000000000000000000000000000000000000e+02), SC_(2.1241257553875583463447574807800686251487e+00) }, 
      { SC_(2.0604608154296875000000000000000000000000e+02), SC_(2.9727990722656250000000000000000000000000e+02), SC_(-4.6816723632812500000000000000000000000000e+02), SC_(-1.8344958496093750000000000000000000000000e+02), SC_(1.3122252792894591667313671877695914708523e+00) }, 
      { SC_(2.0936480712890625000000000000000000000000e+02), SC_(4.2087475585937500000000000000000000000000e+02), SC_(2.5468664550781250000000000000000000000000e+02), SC_(3.0753100585937500000000000000000000000000e+02), SC_(1.8228325257149518968722585690474551162785e+00) }, 
      { SC_(2.4313244628906250000000000000000000000000e+02), SC_(-2.5241302490234375000000000000000000000000e+01), SC_(-1.0777297973632812500000000000000000000000e+02), SC_(-7.7912322998046875000000000000000000000000e+01), SC_(8.7691487492118718001505295364659231092406e+12) }, 
      { SC_(2.4469281005859375000000000000000000000000e+02), SC_(1.2343554687500000000000000000000000000000e+02), SC_(-3.1104504394531250000000000000000000000000e+02), SC_(3.1187390136718750000000000000000000000000e+02), SC_(1.3679995077611709748991235074299323249056e-01) }, 
      { SC_(2.5126708984375000000000000000000000000000e+02), SC_(3.2124597167968750000000000000000000000000e+02), SC_(-2.4490490722656250000000000000000000000000e+02), SC_(3.2084069824218750000000000000000000000000e+02), SC_(3.5984174600298931119002701409764053018282e-01) }, 
      { SC_(2.5720019531250000000000000000000000000000e+02), SC_(-1.0767953491210937500000000000000000000000e+02), SC_(2.5372912597656250000000000000000000000000e+02), SC_(6.1557495117187500000000000000000000000000e+01), SC_(5.6105290183520099850011748400929360300147e-01) }, 
      { SC_(2.6551684570312500000000000000000000000000e+02), SC_(-4.4878356933593750000000000000000000000000e+02), SC_(2.9519995117187500000000000000000000000000e+02), SC_(-4.6355883789062500000000000000000000000000e+02), SC_(2.5349908269374531321206547189382655961137e+00) }, 
      { SC_(2.8022741699218750000000000000000000000000e+02), SC_(1.6928509521484375000000000000000000000000e+02), SC_(-4.1887426757812500000000000000000000000000e+02), SC_(-1.2058114624023437500000000000000000000000e+02), SC_(1.6104839559394443238565405614701641112102e+00) }, 
      { SC_(2.8025195312500000000000000000000000000000e+02), SC_(3.7736389160156250000000000000000000000000e+02), SC_(-1.1026116943359375000000000000000000000000e+02), SC_(-2.8969812011718750000000000000000000000000e+02), SC_(7.1772875921003886045321611046529753942132e+00) }, 
      { SC_(2.9220727539062500000000000000000000000000e+02), SC_(3.7843066406250000000000000000000000000000e+02), SC_(4.5949243164062500000000000000000000000000e+02), SC_(3.6627197265625000000000000000000000000000e+00), SC_(1.0061739824673654390019792070836039118033e+00) }, 
      { SC_(3.0028039550781250000000000000000000000000e+02), SC_(-2.0297058105468750000000000000000000000000e+02), SC_(-3.5811364746093750000000000000000000000000e+02), SC_(-4.9521655273437500000000000000000000000000e+02), SC_(1.3224555718324446086245358664858068925167e-01) }, 
      { SC_(3.1428479003906250000000000000000000000000e+02), SC_(-2.0016827392578125000000000000000000000000e+02), SC_(-2.5647509765625000000000000000000000000000e+02), SC_(-4.8646093750000000000000000000000000000000e+02), SC_(5.3606043569822407678700658098436422934217e-02) }, 
      { SC_(3.1472363281250000000000000000000000000000e+02), SC_(-3.6452307128906250000000000000000000000000e+02), SC_(4.0579187011718750000000000000000000000000e+02), SC_(3.3500854492187500000000000000000000000000e+02), SC_(4.9070868113724046848391473903549599477217e-01) }, 
      { SC_(3.1730322265625000000000000000000000000000e+02), SC_(-1.3681353759765625000000000000000000000000e+02), SC_(3.6869470214843750000000000000000000000000e+02), SC_(1.7951971435546875000000000000000000000000e+02), SC_(3.2486969100887639397686279274711519871883e-01) }, 
      { SC_(3.1762768554687500000000000000000000000000e+02), SC_(-1.3913928222656250000000000000000000000000e+02), SC_(2.9483142089843750000000000000000000000000e+02), SC_(4.1711791992187500000000000000000000000000e+02), SC_(4.0997442016031168571088908036165895223187e-02) }, 
      { SC_(3.2119396972656250000000000000000000000000e+02), SC_(-1.7748925781250000000000000000000000000000e+02), SC_(-4.8459655761718750000000000000000000000000e+02), SC_(-9.5018615722656250000000000000000000000000e+01), SC_(7.0176937304609757982265942290364945142837e-01) }, 
      { SC_(3.4071728515625000000000000000000000000000e+02), SC_(4.8852160644531250000000000000000000000000e+02), SC_(-2.4571783447265625000000000000000000000000e+02), SC_(-1.6755175781250000000000000000000000000000e+02), SC_(1.6098537510564271775154622946473632101740e+00) }, 
      { SC_(3.4912927246093750000000000000000000000000e+02), SC_(-2.8807568359375000000000000000000000000000e+02), SC_(4.3399316406250000000000000000000000000000e+02), SC_(1.8135955810546875000000000000000000000000e+02), SC_(6.0294254404337351532959084802691688193664e-01) }, 
      { SC_(3.5303112792968750000000000000000000000000e+02), SC_(3.3933105468750000000000000000000000000000e+01), SC_(1.2205511474609375000000000000000000000000e+02), SC_(-6.1333190917968750000000000000000000000000e+01), SC_(2.9227845424513001188641505257754927836543e-03) }, 
      { SC_(3.6929211425781250000000000000000000000000e+02), SC_(-4.2244299316406250000000000000000000000000e+02), SC_(7.9704589843750000000000000000000000000000e+01), SC_(1.2738433837890625000000000000000000000000e+02), SC_(2.4550012097873731086926329665170573166183e-01) }, 
      { SC_(3.9090319824218750000000000000000000000000e+02), SC_(-7.6834899902343750000000000000000000000000e+01), SC_(4.5929138183593750000000000000000000000000e+02), SC_(8.0956726074218750000000000000000000000000e+01), SC_(4.1008638464621294670577937874274757421403e-01) }, 
      { SC_(4.0271606445312500000000000000000000000000e+02), SC_(-1.9817272949218750000000000000000000000000e+02), SC_(4.4478723144531250000000000000000000000000e+02), SC_(-4.5205578613281250000000000000000000000000e+02), SC_(7.9792084394359697149364995431404904951076e+00) }, 
      { SC_(4.1719360351562500000000000000000000000000e+02), SC_(1.9523284912109375000000000000000000000000e+02), SC_(-2.1416101074218750000000000000000000000000e+02), SC_(1.7981976318359375000000000000000000000000e+02), SC_(1.6677161550201597911217819138227481518146e-01) }, 
      { SC_(4.2926367187500000000000000000000000000000e+02), SC_(-2.8276220703125000000000000000000000000000e+02), SC_(-1.5001623535156250000000000000000000000000e+02), SC_(4.0736474609375000000000000000000000000000e+02), SC_(6.9169828474031185548966363292999294270636e+01) }, 
      { SC_(4.2938598632812500000000000000000000000000e+02), SC_(-4.1503112792968750000000000000000000000000e+01), SC_(2.7571264648437500000000000000000000000000e+02), SC_(-1.9638604736328125000000000000000000000000e+02), SC_(3.8677599404919126050288702417981127634707e+03) }, 
      { SC_(4.3401062011718750000000000000000000000000e+02), SC_(4.6496630859375000000000000000000000000000e+02), SC_(-3.7009387207031250000000000000000000000000e+02), SC_(-3.4556164550781250000000000000000000000000e+02), SC_(2.3932234491787327738182561861870260515121e+00) }, 
      { SC_(4.4205053710937500000000000000000000000000e+02), SC_(4.5494335937500000000000000000000000000000e+02), SC_(4.5613452148437500000000000000000000000000e+02), SC_(1.5196862792968750000000000000000000000000e+02), SC_(1.3821127954875742281701612743057268242803e+00) }, 
      { SC_(4.5022204589843750000000000000000000000000e+02), SC_(-9.4109497070312500000000000000000000000000e+00), SC_(-4.6555395507812500000000000000000000000000e+02), SC_(1.6360552978515625000000000000000000000000e+02), SC_(8.4971823818350884090250702761334177048449e+04) }, 
      { SC_(4.5716699218750000000000000000000000000000e+02), SC_(-3.9013830566406250000000000000000000000000e+02), SC_(-1.4624359130859375000000000000000000000000e+01), SC_(2.9810583496093750000000000000000000000000e+02), SC_(2.2895900262598367967724720672458868414459e+07) }, 
      { SC_(4.5750683593750000000000000000000000000000e+02), SC_(4.9646130371093750000000000000000000000000e+02), SC_(4.6488842773437500000000000000000000000000e+02), SC_(4.6769494628906250000000000000000000000000e+02), SC_(2.5250277249663024383341030945760911735103e+00) }, 
      { SC_(4.5974389648437500000000000000000000000000e+02), SC_(7.3754638671875000000000000000000000000000e+01), SC_(-1.5961425781250000000000000000000000000000e+02), SC_(3.7675744628906250000000000000000000000000e+02), SC_(1.9308146485371088709212764705092521101549e-07) }
   }};
//#undef SC_

