/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.CommandLineTokenizer;
import com.martiansoftware.jsap.DefaultSource;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Parser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.BigDecimalStringParser;
import com.martiansoftware.jsap.stringparsers.BigIntegerStringParser;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import com.martiansoftware.jsap.stringparsers.ByteStringParser;
import com.martiansoftware.jsap.stringparsers.CharacterStringParser;
import com.martiansoftware.jsap.stringparsers.ClassStringParser;
import com.martiansoftware.jsap.stringparsers.ColorStringParser;
import com.martiansoftware.jsap.stringparsers.DoubleStringParser;
import com.martiansoftware.jsap.stringparsers.FloatStringParser;
import com.martiansoftware.jsap.stringparsers.InetAddressStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import com.martiansoftware.jsap.stringparsers.LongSizeStringParser;
import com.martiansoftware.jsap.stringparsers.LongStringParser;
import com.martiansoftware.jsap.stringparsers.PackageStringParser;
import com.martiansoftware.jsap.stringparsers.ShortStringParser;
import com.martiansoftware.jsap.stringparsers.StringStringParser;
import com.martiansoftware.jsap.stringparsers.URLStringParser;
import com.martiansoftware.jsap.xml.JSAPConfig;
import com.martiansoftware.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSAP {
    private Map paramsByID = null;
    private Map paramsByShortFlag = null;
    private Map paramsByLongFlag = null;
    private List unflaggedOptions = null;
    private List paramsByDeclarationOrder = null;
    private List defaultSources = null;
    private String usage = null;
    private String help = null;
    public static final char NO_SHORTFLAG = '\u0000';
    public static final String NO_LONGFLAG = null;
    public static final char DEFAULT_LISTSEPARATOR = File.pathSeparatorChar;
    public static final String DEFAULT_PARAM_HELP_SEPARATOR = "\n";
    public static final boolean REQUIRED = true;
    public static final boolean NOT_REQUIRED = false;
    public static final boolean LIST = true;
    public static final boolean NOT_LIST = false;
    public static final boolean MULTIPLEDECLARATIONS = true;
    public static final boolean NO_MULTIPLEDECLARATIONS = false;
    public static final boolean GREEDY = true;
    public static final boolean NOT_GREEDY = false;
    public static final String NO_DEFAULT = null;
    public static final String NO_HELP = null;
    public static final BigDecimalStringParser BIGDECIMAL_PARSER = BigDecimalStringParser.getParser();
    public static final BigIntegerStringParser BIGINTEGER_PARSER = BigIntegerStringParser.getParser();
    public static final BooleanStringParser BOOLEAN_PARSER = BooleanStringParser.getParser();
    public static final ByteStringParser BYTE_PARSER = ByteStringParser.getParser();
    public static final CharacterStringParser CHARACTER_PARSER = CharacterStringParser.getParser();
    public static final ClassStringParser CLASS_PARSER = ClassStringParser.getParser();
    public static final ColorStringParser COLOR_PARSER = ColorStringParser.getParser();
    public static final DoubleStringParser DOUBLE_PARSER = DoubleStringParser.getParser();
    public static final FloatStringParser FLOAT_PARSER = FloatStringParser.getParser();
    public static final InetAddressStringParser INETADDRESS_PARSER = InetAddressStringParser.getParser();
    public static final IntegerStringParser INTEGER_PARSER = IntegerStringParser.getParser();
    public static final IntSizeStringParser INTSIZE_PARSER = IntSizeStringParser.getParser();
    public static final LongSizeStringParser LONGSIZE_PARSER = LongSizeStringParser.getParser();
    public static final LongStringParser LONG_PARSER = LongStringParser.getParser();
    public static final PackageStringParser PACKAGE_PARSER = PackageStringParser.getParser();
    public static final ShortStringParser SHORT_PARSER = ShortStringParser.getParser();
    public static final StringStringParser STRING_PARSER = StringStringParser.getParser();
    public static final URLStringParser URL_PARSER = URLStringParser.getParser();
    public static final int DEFAULT_SCREENWIDTH = 80;
    static char SYNTAX_SPACECHAR = (char)32;

    public JSAP() {
        this.init();
    }

    public JSAP(URL uRL) throws IOException, JSAPException {
        this.init();
        JSAPConfig.configure(this, uRL);
    }

    public JSAP(String string) throws IOException, JSAPException {
        this(JSAP.class.getClassLoader().getResource(string));
    }

    private void init() {
        this.paramsByID = new HashMap();
        this.paramsByShortFlag = new HashMap();
        this.paramsByLongFlag = new HashMap();
        this.unflaggedOptions = new ArrayList();
        this.paramsByDeclarationOrder = new ArrayList();
        this.defaultSources = new ArrayList();
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public void setHelp(String string) {
        this.help = string;
    }

    public String getHelp() {
        return this.getHelp(80, DEFAULT_PARAM_HELP_SEPARATOR);
    }

    public String getHelp(int n) {
        return this.getHelp(n, DEFAULT_PARAM_HELP_SEPARATOR);
    }

    public String getHelp(int n, String string) {
        String string2 = this.help;
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n - 8;
            Iterator iterator = this.paramsByDeclarationOrder.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                StringBuffer stringBuffer2 = new StringBuffer();
                String[] stringArray = parameter.getDefault();
                if (!(parameter instanceof Switch) && stringArray != null) {
                    stringBuffer2.append(" (default: ");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(stringArray[i]);
                    }
                    stringBuffer2.append(")");
                }
                Iterator iterator2 = StringUtils.wrapToList(parameter.getHelp() + stringBuffer2, n2).iterator();
                stringBuffer.append("  ");
                stringBuffer.append(parameter.getSyntax());
                stringBuffer.append(DEFAULT_PARAM_HELP_SEPARATOR);
                while (iterator2.hasNext()) {
                    stringBuffer.append("        ");
                    stringBuffer.append(iterator2.next());
                    stringBuffer.append(DEFAULT_PARAM_HELP_SEPARATOR);
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(string);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public String getUsage() {
        String string = this.usage;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.paramsByDeclarationOrder.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(parameter.getSyntax());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        return this.getUsage();
    }

    public IDMap getIDMap() {
        Object object;
        HashMap<String, String> hashMap;
        ArrayList<String> arrayList = new ArrayList<String>(this.paramsByDeclarationOrder.size());
        Object object2 = this.paramsByDeclarationOrder.iterator();
        while (object2.hasNext()) {
            hashMap = (Parameter)object2.next();
            arrayList.add(((Parameter)((Object)hashMap)).getID());
        }
        object2 = new HashMap();
        hashMap = this.paramsByShortFlag.keySet().iterator();
        while (hashMap.hasNext()) {
            object = (Character)hashMap.next();
            object2.put(object, ((Parameter)this.paramsByShortFlag.get(object)).getID());
        }
        hashMap = new HashMap<String, String>();
        object = this.paramsByLongFlag.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashMap.put(string, ((Parameter)this.paramsByLongFlag.get(string)).getID());
        }
        return new IDMap(arrayList, (Map)object2, hashMap);
    }

    public Parameter getByID(String string) {
        return (Parameter)this.paramsByID.get(string);
    }

    public Flagged getByLongFlag(String string) {
        return (Flagged)this.paramsByLongFlag.get(string);
    }

    public Flagged getByShortFlag(Character c) {
        return (Flagged)this.paramsByShortFlag.get(c);
    }

    public Flagged getByShortFlag(char c) {
        return this.getByShortFlag(new Character(c));
    }

    public Iterator getUnflaggedOptionsIterator() {
        return this.unflaggedOptions.iterator();
    }

    public void registerDefaultSource(DefaultSource defaultSource) {
        this.defaultSources.add(defaultSource);
    }

    public void unregisterDefaultSource(DefaultSource defaultSource) {
        this.defaultSources.remove(defaultSource);
    }

    private Defaults getSystemDefaults() {
        Defaults defaults = new Defaults();
        Iterator iterator = this.paramsByDeclarationOrder.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            defaults.setDefault(parameter.getID(), parameter.getDefault());
        }
        return defaults;
    }

    private void combineDefaults(Defaults defaults, Defaults defaults2) {
        if (defaults2 != null) {
            Iterator iterator = defaults2.idIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                defaults.setDefaultIfNeeded(string, defaults2.getDefault(string));
            }
        }
    }

    protected Defaults getDefaults(ExceptionMap exceptionMap) {
        Defaults defaults = new Defaults();
        IDMap iDMap = this.getIDMap();
        Iterator iterator = this.defaultSources.iterator();
        while (iterator.hasNext()) {
            DefaultSource defaultSource = (DefaultSource)iterator.next();
            this.combineDefaults(defaults, defaultSource.getDefaults(iDMap, exceptionMap));
        }
        this.combineDefaults(defaults, this.getSystemDefaults());
        return defaults;
    }

    public void registerParameter(Parameter parameter) throws JSAPException {
        Flagged flagged;
        String string = parameter.getID();
        if (this.paramsByID.containsKey(string)) {
            throw new JSAPException("A parameter with ID '" + string + "' has already been registered.");
        }
        if (parameter instanceof Flagged) {
            flagged = (Flagged)((Object)parameter);
            if (flagged.getShortFlagCharacter() == null && flagged.getLongFlag() == null) {
                throw new JSAPException("FlaggedOption '" + string + "' has no flags defined.");
            }
            if (this.paramsByShortFlag.containsKey(flagged.getShortFlagCharacter())) {
                throw new JSAPException("A parameter with short flag '" + flagged.getShortFlag() + "' has already been registered.");
            }
            if (this.paramsByLongFlag.containsKey(flagged.getLongFlag())) {
                throw new JSAPException("A parameter with long flag '" + flagged.getLongFlag() + "' has already been registered.");
            }
        } else if (this.unflaggedOptions.size() > 0 && ((UnflaggedOption)this.unflaggedOptions.get(this.unflaggedOptions.size() - 1)).isGreedy()) {
            throw new JSAPException("A greedy unflagged option has already been registered; option '" + string + "' will never be reached.");
        }
        if (parameter instanceof Option) {
            ((Option)parameter).register();
        }
        parameter.setLocked(true);
        this.paramsByID.put(string, parameter);
        this.paramsByDeclarationOrder.add(parameter);
        if (parameter instanceof Flagged) {
            flagged = (Flagged)((Object)parameter);
            if (flagged.getShortFlagCharacter() != null) {
                this.paramsByShortFlag.put(flagged.getShortFlagCharacter(), parameter);
            }
            if (flagged.getLongFlag() != null) {
                this.paramsByLongFlag.put(flagged.getLongFlag(), parameter);
            }
        } else if (parameter instanceof Option) {
            this.unflaggedOptions.add(parameter);
        }
    }

    public void unregisterParameter(Parameter parameter) {
        if (this.paramsByID.containsKey(parameter.getID())) {
            if (parameter instanceof Option) {
                ((Option)parameter).unregister();
            }
            this.paramsByID.remove(parameter.getID());
            this.paramsByDeclarationOrder.remove(parameter);
            if (parameter instanceof Flagged) {
                Flagged flagged = (Flagged)((Object)parameter);
                this.paramsByShortFlag.remove(flagged.getShortFlagCharacter());
                this.paramsByLongFlag.remove(flagged.getLongFlag());
            } else if (parameter instanceof UnflaggedOption) {
                this.unflaggedOptions.remove(parameter);
            }
            parameter.setLocked(false);
        }
    }

    public JSAPResult parse(String[] stringArray) {
        Parser parser = new Parser(this, stringArray);
        return parser.parse();
    }

    public JSAPResult parse(String string) {
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        return this.parse(stringArray);
    }

    public void finalize() {
        Parameter[] parameterArray = this.paramsByDeclarationOrder.toArray(new Parameter[0]);
        int n = parameterArray.length;
        for (int i = 0; i < n; ++i) {
            this.unregisterParameter(parameterArray[i]);
        }
    }

    static {
        if (Boolean.valueOf(System.getProperty("com.martiansoftware.jsap.usenbsp", "false")).booleanValue()) {
            SYNTAX_SPACECHAR = (char)160;
        }
    }
}

