/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DataWriterFactory {
    public Writer buildWriter(BitOutputStream bitOutputStream, Map<Integer, ExposedByteArrayOutputStream> outputMap, CompressionHeader h, int refId) throws IllegalArgumentException, IllegalAccessException {
        Writer writer = new Writer();
        writer.setCaptureReadNames(h.readNamesIncluded);
        writer.refId = refId;
        writer.substitutionMatrix = h.substitutionMatrix;
        writer.AP_delta = h.APDelta;
        for (Field f : writer.getClass().getFields()) {
            DataSeriesMap dsm;
            String name;
            if (f.isAnnotationPresent(DataSeries.class)) {
                DataSeries ds = f.getAnnotation(DataSeries.class);
                EncodingKey key = ds.key();
                DataSeriesType type = ds.type();
                f.set(writer, this.createWriter(type, h.encodingMap.get((Object)key), bitOutputStream, outputMap));
            }
            if (!f.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(name = (dsm = f.getAnnotation(DataSeriesMap.class)).name())) continue;
            HashMap map = new HashMap();
            for (Integer key : h.tMap.keySet()) {
                EncodingParams params = h.tMap.get(key);
                DataWriter tagWriter = this.createWriter(DataSeriesType.BYTE_ARRAY, params, bitOutputStream, outputMap);
                map.put(key, tagWriter);
            }
            f.set(writer, map);
        }
        return writer;
    }

    private <T> DataWriter<T> createWriter(DataSeriesType valueType, EncodingParams params, BitOutputStream bitOutputStream, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        EncodingFactory f = new EncodingFactory();
        Encoding encoding = f.createEncoding(valueType, params.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found: value type=" + valueType.name() + ", encoding id=" + params.id.name());
        }
        encoding.fromByteArray(params.params);
        return new DefaultDataWriter(encoding.buildCodec(null, outputMap), bitOutputStream);
    }

    private static class DefaultDataWriter<T>
    implements DataWriter<T> {
        private final BitCodec<T> codec;
        private final BitOutputStream bitOutputStream;

        public DefaultDataWriter(BitCodec<T> codec, BitOutputStream bitOutputStream) {
            this.codec = codec;
            this.bitOutputStream = bitOutputStream;
        }

        @Override
        public long writeData(T value) throws IOException {
            return this.codec.write(this.bitOutputStream, value);
        }
    }
}

