# Deepin Movie |../common/deepin-movie.svg|
## Overview |../common/icon_overview.svg|

Deepin Movie is a video player with various features built in deepin. It offers simple interface and rich shortcuts, supports various video formats. You can also play online video resources, freely set the sound, frame and subtitle.

Deepin Movie, shares extreme play experience with you. Use it, you will love it!

![1|main_interface](png/main_interface.png)

## Guide |../common/icon_guide.svg|

### Run Deepin Movie

1. On Dock, click on ![launcher-24](icon/launcher-24.svg) to enter Launcher.
2. Right click on ![movie-24](icon/movie-24.png), you can:
  - Click on **Send to desktop** to create a desktop shortcut.
  - Click on **Send to dock** to fix its icon on Dock.
  - Click on **Add to startup** to add it to startup, it will auto run when system boots.

> ![notes](icon/notes.svg): You can also right click on a video and select **Open with Deepin Movie** to run.

### Exit Deepin Movie

- On Deepin Movie interface, click on ![close](icon/close.svg) to exit.
- Right click on ![movie-24](icon/movie-24.png) on Dock, select **Close All** to exit.
- Click on ![main_memu](icon/main_menu.svg) and select **Exit** to exit.

![1|close_all](png/close_all.png)

### View Shortcuts

1. On Deepin Movie Interface, press ![Ctrl](icon/Ctrl.svg)+![Shift](icon/Shift.svg)+![QM](icon/QM.svg).
2. You can view all the shortcuts on the preview interface.

<p>
<table>
     <tr>
        <td colspan="2">PLAYBACK</td>
        <td colspan="2">FRAME/SOUND</td>
        <td colspan="2">SUBTITLE</td>
     </tr>
     <tr>
        <td>Pause/Play</td>
        <td>Space</td>
        <td>Mini mode</td>
        <td>F2</td>
        <td>0.5s forward</td>
        <td>Shift+Right</td>
     </tr>
     <tr>
        <td>Forward</td>
        <td>Right</td>
        <td>Volume up</td>
        <td>Up</td>
        <td>0.5s backward</td>
        <td>Shift+Left</td>
     </tr>
     <tr>
        <td>Rewind</td>
        <td>Left</td>
        <td>Volume down</td>
        <td>Down</td>
        <td>-</td>
        <td>-</td>
     </tr>
     <tr>
        <td>Fullscreen</td>
        <td>Return</td>
        <td>Mute</td>
        <td>M</td>
        <td>-</td>
        <td>-</td>
     </tr>
     <tr>
        <td>Playlist</td>
        <td>F3</td>
        <td colspan="2">FILE</td>
        <td colspan="2">SCREENSHOT</td>
     </tr>
     <tr>
        <td>Speed up</td>
        <td>Ctrl+right</td>
        <td>Open file</td>
        <td>Ctrl+O</td>
        <td>Film screenshot</td>
        <td>Alt+A</td>
     </tr>
     <tr>
        <td>Speed down</td>
        <td>Ctrl+left</td>
        <td>Open previous</td>
        <td>PgUp</td>
        <td>Burst screenshot</td>
        <td>Alt+S</td>
     </tr>
     <tr>
        <td>Reset speed</td>
        <td>R</td>
        <td>Open next</td>
        <td>PgDown</td>
        <td>-</td>
        <td>-</td>
     </tr>
</table>
</p>

![1|shortcuts](png/shortcuts.png)

## Main Interface|../common/icon_maininterface.svg|

![1|interface](png/interface.png)
<p>
<table>
  <tr>
            <td>1</td>
            <td width="60px">Play window</td>
            <td>Display the film content, film information and function icons will be displayed after the mouse pointer moved into the play window, otherwise will be hidden. Play window is the frameless mode, you can freely drag and drop play window to manually adjust its size. </td>
        </tr>
        <tr>
            <td>2</td>
            <td>Progress bar</td>
            <td>It's to display film play progress and you can change the progress by dragging and dropping the progress bar. Move the mouse pointer over the progress bar, and the progress bar will be bold intelligently and display the film preview window. </td>
        </tr>
         <tr>
            <td>3</td>
            <td>Time display</td>
            <td>Display the total time and played time information of current film. </td>
        </tr>
         <tr>
            <td>4</td>
            <td>Preview window</td>
            <td>Display the film preview, you can view the video content at a point in time by the preview window. </td>
        </tr>
         <tr>
            <td>5</td>
            <td>Film title</td>
            <td>Display the film name. </td>
        </tr>
</table>
</p>
### Icon Description
<p>
<table>
     <tr>
       <td><img src="icon/main_menu.svg" class="inline" /></td>
       <td>Main Menu</td>
       <td><img src="icon/minimize.svg" class="inline" /></td>
       <td>Minimize</td>
       <td><img src="icon/maximize.svg" class="inline" /></td>
       <td>Maximize</td>
       <td><img src="icon/close.svg" class="inline" /></td>
       <td>Close</td>
     </tr>
     <tr>
       <td><img src="icon/play.svg" class="inline" /></td>
       <td>Play</td>
       <td><img src="icon/pause.svg" class="inline" /></td>
       <td>Pause</td>
       <td><img src="icon/previous.svg" class="inline" /></td>
       <td>Play previous film</td>
       <td><img src="icon/next.svg" class="inline" /></td>
       <td>Play next film</td>
     </tr>
     <tr>
       <td><img src="icon/volume.svg" class="inline" /></td>
       <td>Volume</td>
       <td><img src="icon/fullscreen.svg" class="inline" /></td>
       <td>Fullscreen</td>
       <td><img src="icon/playlist.svg" class="inline" /></td>
       <td>Playlist</td>
       <td><img src="icon/mini.png" class="inline" /></td>
       <td>Exit mini mode</td>
     </tr>
</table>
</p>
### Play Film

You can play film by the following ways:

1. On Deepin Movie interface, right click or click on ![main_menu](icon/main_menu.svg) to select **Open File**.
2. On Deepin Movie interface, right click or click on ![main_menu](icon/main_menu.svg) to select **Open Folder**.
3. On Deepin Movie interface, right click to select **Open URL**.
4. On Deepin Movie interface, right click to select **Open CD/DVD**.
5. Drag and drop file/folder to the main interface.


### Play/Pause

- On Deepin Movie interface, click on ![Play](icon/play.svg)/![Pause](icon/pause.svg).
- On Deepin Movie interface, press ![Space](icon/Space.svg) on keyboard.
- On Deepin Movie interface, click the left mouse button.

>![notes](icon/notes.svg): Play and pause are mutually exclusive states.

### Previous/Next

- On Deepin Movie interface, press  ![Page Up](icon/PageUp.svg)/![Page Down](icon/PageDown.svg) .
- On Deepin Movie interface, click on ![Previous](icon/previous.svg)/![Next](icon/next.svg).


### Forward/Rewind

1. On Deepin Movie interface, press ![Right](icon/Right.svg) to forward the film.
2. Press ![Left](icon/Left.svg) on keyboard to rewind the film.


### Speed Up/Down

1. On Deepin Movie interface, press ![Ctrl](icon/Ctrl.svg)+![Right](icon/Right.svg) to speed up the film.
2. Press ![Ctrl](icon/Ctrl.svg)+![Left](icon/Left.svg) to speed down the film
3. If you want to restore the original play speed, press ![R](icon/R.svg) on keyboard.

>![notes](icon/notes.svg): Speed up/down is relative to the original play speed. Eevery pressing is 0.1 times. Maximum speed is 2 times of the original play speed and the minimum is 0.1 times.

## Basic operations|../common/icon_basicfuncton.svg|
On Deepin Movie interface, you can do many operations according to needs.

### Adjust Window

1. Right click on Deepin Movie interface.
2. Select **Fullscreen** to paly in fullscreen.
3. Select **Mini Mode** to play in mini mode.
4. Select **Always on Top** to put the window on top layer.

> ![notes](icon/notes.svg): You can also drag and drop the window in equal proportion by needs.

![0|window](png/window.png)

### Select Play Mode

1. Right click on Deepin Movie interface.
2. Select **Play Mode**, you can:
  - Check **Order Play**, films in playlist will be played orderly.
  - Check **Shuffle Play**, films in playlist will be played disorderly, but won't repeat a film over and over.
  - Check **Single Play**, the player will stop when the current film played.
  - Check **Single Loop**, the film will be played over and over.
  - Check ** List Loop**, the whole playlist will be played over and over.

![0|play_mode](png/play_mode.png)

### Adjust Frame

1. Right click on Deepin Movie interface.
2. Select **Frame**, you can:
  - Adjust the flim aspect ratio between 4:3, 16:9, 16:10, 1.85:1 and 2.35:1.
  - Rotate the flim frame clockwise or counterclockwise.

![0|frame](png/frame.png)

### Set Sound

1. Right click on Deepin Movie interface.
2. Select **Sound** > **Channel**, you can:
  - Check **Stereo**, the film will be played in stereo.
  - Check **Left channel**, the film will be played in left channel.
  - Check **Right channel**, the film will be played in right channel.
3. Select **Sound** > **track**, you can select to play the film in a track.

![0|sound](png/sound.png)

### Set Subtitle

1. Right click on Deepin Movie interface.
2. Select **Subtitle**, you can:
  - Check **Load**, to manually load subtitles.
  - Check **Online Search**, to search subtiles online for the film and auto load the subtitles.
  - Check **Select**, to select a subtitle for the film.
  - Check **Hide**, to hide the current film subtitle.
  - Check **Encodings**, to select an encoding for the film.

![0|subtitle](png/subtitle.png)

### Take a Screenshot

1. Right click on Deepin Movie interface.
2. Select **Screenshot**, you can:
  - Check **Film Screenshot**, to take a screenshot of the film in current frame.
  - Check **Burst Shooting**, to take 15 pictures of the film in different times.

![0|screenshot](png/screenshot.png)

### View Film Info

1. Right click on Deepin Movie interface.
2. Select **Film Info**, you can view the file type, resolution, file size, duration and file path of the file.

> ![notes](icon/notes.svg): You can also right click on playlist to select **Film Info** to view.

![1|info](png/info.png)

## Playlist Management|../common/icon_playlistsetting.svg|

### Show/Hide Playlist

1. Right click on Deepin Movie interface.
2. Check **Playlist** to show playlist and check again to hide playlist.

> ![notes](icon/notes.svg): You can also click on ![playlist](icon/playlist.svg) on the main interface to show/hide playlist.

![1|playlist](png/playlist.png)

### Add Film to Playlist

You can add film to playlist by the following ways:
- Show the playlist, drag and drop file/folder to it.
- Right click on the main interface, and select **Open File/Open Folder/Open URL/Open CD/DVD** to add.
- Click on ![main_menu](icon/main_menu.svg) on Deepin Movie interface, and select **Open File/Open Folder** to add.

### Delete Film from Playlist

1. On the playlist of Deepin Movie, hover on a film.
2. Click on the delete button on top right corner to delete file from playlist.

![1|delete](png/delete.png)

### Clear Playlist

1. Right click on the playlist.
2. Select **Clear playlist** to clear films from the playlist.

![1|clear](png/clear.png)


### Display in File Manager

1. Right click on the playlist.
2. Select **Display in file manager** to show the film file in file manager.

![1|display](png/display.png)

## Main Menu|../common/icon_optionsetting.svg|
### Basic Settings

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **Settings** > **Basic settings**.
3. In the option **Play**, you can:
 - Check the box of **Clear playlist when exit**, the playlist will be cleared when you exit Deepin Movie.
 - Check the box of **Remember playback position**, the film will be played automatically from last positon played when Deepin Movie runs.
 - Check the box of **Auto add similar files to play**,the related film files will be played one by one after the current film played.
 - Check the box of **Show video preview on mouseover**, the film preview will be shown when hovering on the progress bar.
 - Check the box of **Open a new player for each file played**, a new player will be opened when playing a film file.
 - Check the box of **Pause when minimized**, the film will be paused when minimizing Deepin Movie window.
4. In the option of **Screenshot**, you can select the path to save screenshot.

![1|basic](png/basic.png)

### Shortcuts Settings

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **Settings** > **Shortcuts**.
3. You can set the shortcuts for playback, frame/sound, file, subtitle and screenshot.

![1|settings](png/settings.png)

### Subtitle Settings

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **Settings** > **Subtitle**.
3. You can set the font and font size for subtitles.

> ![notes](icon/notes.svg): You can also click on **Restore Defaults** to restore all settings.

![1|subtitle_settings](png/subtitle_settings.png)

### Switch Theme

The theme of Deepin Movie is dark by default, you can click on **Light Theme** to swith.

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **Light Theme**.
3. The interface will switch to light theme.

![1|theme](png/theme.png)

### Help

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **Help**.
3. View the manual.

![1|help](png/help.png)

### About

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Select **About**.
3. View the version description.

![0|about](png/about.png)

### Exit

1. On Deepin Movie interface, click on ![main_menu](icon/main_menu.svg).
2. Click on **Exit** to exit.
