/* Utilities for reading/writing fstab, mtab, etc.
   Copyright (C) 1995-2000, 2001, 2002, 2003, 2006
   Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _LXCMNTENT_H
#define _LXCMNTENT_H

#include "../lxc/compiler.h"

#if IS_BIONIC
struct mntent
{
    char* mnt_fsname;
    char* mnt_dir;
    char* mnt_type;
    char* mnt_opts;
    int mnt_freq;
    int mnt_passno;
};

__hidden extern struct mntent *getmntent(FILE *stream);
__hidden extern struct mntent *getmntent_r(FILE *stream, struct mntent *mp,
					   char *buffer, int bufsiz);
#endif

#if !HAVE_SETMNTENT || IS_BIONIC
__hidden FILE *setmntent(const char *file, const char *mode);
#endif

#if !HAVE_ENDMNTENT || IS_BIONIC
__hidden int endmntent(FILE *stream);
#endif

#if !HAVE_HASMNTOPT || IS_BIONIC
__hidden extern char *hasmntopt(const struct mntent *mnt, const char *opt);
#endif

#endif
