/* msiextract.c generated by valac 0.30.0, the Vala compiler
 * generated from msiextract.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libmsi.h>
#include <libgcab.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <config.h>

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GHashTable* cab_to_name;
};


extern gboolean version;
gboolean version = FALSE;
extern gboolean list_only;
gboolean list_only = FALSE;
extern gchar** files;
gchar** files = NULL;
extern gchar* directory;
gchar* directory = NULL;

gchar* get_long_name (const gchar* str);
void extract_cab (LibmsiDatabase* db, const gchar* cab, GHashTable* cab_to_name, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda4_ (Block1Data* _data1_, GCabFile* current);
static gboolean ____lambda4__gcab_file_callback (GCabFile* file, gpointer self);
gchar* get_directory_name (LibmsiRecord* rec, GError** error);
void extract (const gchar* filename, GError** error);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &version, "Display version number", NULL}, {"directory", 'C', 0, G_OPTION_ARG_FILENAME, &directory, "Extract to directory", NULL}, {"list", 'l', 0, G_OPTION_ARG_NONE, &list_only, "List files only", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &files, NULL, "MSI_FILE..."}, {NULL}};

gchar* get_long_name (const gchar* str) {
	gchar* result = NULL;
	gchar** names = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "|", 2);
	names = _tmp2_;
	names_length1 = _vala_array_length (_tmp1_);
	_names_size_ = names_length1;
	_tmp3_ = names;
	_tmp3__length1 = names_length1;
	if (_tmp3__length1 == 2) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = names;
		_tmp4__length1 = names_length1;
		_tmp5_ = _tmp4_[1];
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp7_ = str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_hash_table_unref0 (_data1_->cab_to_name);
		g_slice_free (Block1Data, _data1_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean ___lambda4_ (Block1Data* _data1_, GCabFile* current) {
	gboolean result = FALSE;
	gchar* extname = NULL;
	GHashTable* _tmp0_ = NULL;
	GCabFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GCabFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FILE* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	g_return_val_if_fail (current != NULL, FALSE);
	_tmp0_ = _data1_->cab_to_name;
	_tmp1_ = current;
	_tmp2_ = gcab_file_get_name (_tmp1_);
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	extname = _tmp4_;
	_tmp5_ = extname;
	if (_tmp5_ == NULL) {
		GCabFile* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp6_ = current;
		_tmp7_ = gcab_file_get_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (extname);
		extname = _tmp8_;
		_tmp9_ = extname;
		g_warning ("msiextract.vala:40: couldn't lookup MSI name, fallback on cab name %s", _tmp9_);
	}
	_tmp10_ = current;
	_tmp11_ = extname;
	gcab_file_set_extract_name (_tmp10_, _tmp11_);
	_tmp12_ = stdout;
	_tmp13_ = extname;
	fprintf (_tmp12_, "%s\n", _tmp13_);
	result = TRUE;
	_g_free0 (extname);
	return result;
}


static gboolean ____lambda4__gcab_file_callback (GCabFile* file, gpointer self) {
	gboolean result;
	result = ___lambda4_ (self, file);
	return result;
}


void extract_cab (LibmsiDatabase* db, const gchar* cab, GHashTable* cab_to_name, GError** error) {
	Block1Data* _data1_;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (db != NULL);
	g_return_if_fail (cab != NULL);
	g_return_if_fail (cab_to_name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = cab_to_name;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (_data1_->cab_to_name);
	_data1_->cab_to_name = _tmp1_;
	_tmp2_ = cab;
	_tmp3_ = g_str_has_prefix (_tmp2_, "#");
	if (_tmp3_) {
		gchar* name = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		LibmsiQuery* query = NULL;
		LibmsiDatabase* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		LibmsiQuery* _tmp10_ = NULL;
		LibmsiQuery* _tmp11_ = NULL;
		LibmsiQuery* _tmp12_ = NULL;
		LibmsiRecord* rec = NULL;
		LibmsiQuery* _tmp13_ = NULL;
		LibmsiRecord* _tmp14_ = NULL;
		GCabCabinet* cabinet = NULL;
		GCabCabinet* _tmp15_ = NULL;
		GCabCabinet* _tmp16_ = NULL;
		LibmsiRecord* _tmp17_ = NULL;
		GInputStream* _tmp18_ = NULL;
		GInputStream* _tmp19_ = NULL;
		GFile* path = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GCabCabinet* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		_tmp4_ = cab;
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
		name = _tmp5_;
		_tmp6_ = db;
		_tmp7_ = name;
		_tmp8_ = g_strdup_printf ("SELECT `Data` FROM `_Streams` WHERE `Name` = '%s'", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = libmsi_query_new (_tmp6_, _tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		query = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp12_ = query;
		libmsi_query_execute (_tmp12_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp13_ = query;
		_tmp14_ = libmsi_query_fetch (_tmp13_, &_inner_error_);
		rec = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp15_ = gcab_cabinet_new ();
		cabinet = _tmp15_;
		_tmp16_ = cabinet;
		_tmp17_ = rec;
		_tmp18_ = libmsi_record_get_stream (_tmp17_, (guint) 1);
		_tmp19_ = _tmp18_;
		gcab_cabinet_load (_tmp16_, _tmp19_, NULL, &_inner_error_);
		_g_object_unref0 (_tmp19_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cabinet);
			_g_object_unref0 (rec);
			_g_object_unref0 (query);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp20_ = directory;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		path = _tmp21_;
		_tmp22_ = cabinet;
		_tmp23_ = path;
		gcab_cabinet_extract_simple (_tmp22_, _tmp23_, ____lambda4__gcab_file_callback, _data1_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (path);
			_g_object_unref0 (cabinet);
			_g_object_unref0 (rec);
			_g_object_unref0 (query);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_g_object_unref0 (path);
		_g_object_unref0 (cabinet);
		_g_object_unref0 (rec);
		_g_object_unref0 (query);
		_g_free0 (name);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


gchar* get_directory_name (LibmsiRecord* rec, GError** error) {
	gchar* result = NULL;
	gchar* name = NULL;
	LibmsiRecord* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	LibmsiRecord* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (rec != NULL, NULL);
	_tmp0_ = rec;
	_tmp1_ = libmsi_record_get_string (_tmp0_, (guint) 3);
	_tmp2_ = _tmp1_;
	_tmp3_ = get_long_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	name = _tmp4_;
	_tmp5_ = rec;
	_tmp6_ = libmsi_record_get_string (_tmp5_, (guint) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "ProgramFilesFolder") == 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("Program Files");
		result = _tmp9_;
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = name;
		if (g_strcmp0 (_tmp10_, ".") == 0) {
			gchar* _tmp11_ = NULL;
			_tmp11_ = g_strdup ("");
			result = _tmp11_;
			_g_free0 (name);
			return result;
		} else {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = name;
			if (g_strcmp0 (_tmp12_, "SourceDir") == 0) {
				result = NULL;
				_g_free0 (name);
				return result;
			}
		}
	}
	result = name;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void extract (const gchar* filename, GError** error) {
	LibmsiRecord* rec = NULL;
	LibmsiDatabase* db = NULL;
	const gchar* _tmp0_ = NULL;
	LibmsiDatabase* _tmp1_ = NULL;
	GHashTable* directories = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	LibmsiQuery* query = NULL;
	LibmsiDatabase* _tmp5_ = NULL;
	LibmsiQuery* _tmp6_ = NULL;
	LibmsiQuery* _tmp7_ = NULL;
	GHashTable* components_dir = NULL;
	GHashFunc _tmp18_ = NULL;
	GEqualFunc _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	LibmsiQuery* _tmp21_ = NULL;
	LibmsiDatabase* _tmp22_ = NULL;
	LibmsiQuery* _tmp23_ = NULL;
	LibmsiQuery* _tmp24_ = NULL;
	LibmsiQuery* _tmp25_ = NULL;
	GHashTable* cab_to_name = NULL;
	GHashFunc _tmp60_ = NULL;
	GEqualFunc _tmp61_ = NULL;
	GHashTable* _tmp62_ = NULL;
	LibmsiQuery* _tmp63_ = NULL;
	LibmsiDatabase* _tmp64_ = NULL;
	LibmsiQuery* _tmp65_ = NULL;
	LibmsiQuery* _tmp66_ = NULL;
	LibmsiQuery* _tmp67_ = NULL;
	gboolean _tmp96_ = FALSE;
	LibmsiQuery* _tmp97_ = NULL;
	LibmsiDatabase* _tmp98_ = NULL;
	LibmsiQuery* _tmp99_ = NULL;
	LibmsiQuery* _tmp100_ = NULL;
	LibmsiQuery* _tmp101_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = libmsi_database_new (_tmp0_, (guint) LIBMSI_DB_FLAGS_READONLY, NULL, &_inner_error_);
	db = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rec);
		return;
	}
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_object_unref0_);
	directories = _tmp4_;
	_tmp5_ = db;
	_tmp6_ = libmsi_query_new (_tmp5_, "SELECT * FROM `Directory`", &_inner_error_);
	query = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp7_ = query;
	libmsi_query_execute (_tmp7_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp8_ = NULL;
		LibmsiQuery* _tmp9_ = NULL;
		LibmsiRecord* _tmp10_ = NULL;
		LibmsiRecord* _tmp11_ = NULL;
		LibmsiRecord* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
		LibmsiRecord* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		LibmsiRecord* _tmp16_ = NULL;
		LibmsiRecord* _tmp17_ = NULL;
		_tmp9_ = query;
		_tmp10_ = libmsi_query_fetch (_tmp9_, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp11_;
		_tmp12_ = rec;
		if (!(_tmp12_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			break;
		}
		_tmp13_ = directories;
		_tmp14_ = rec;
		_tmp15_ = libmsi_record_get_string (_tmp14_, (guint) 1);
		_tmp16_ = rec;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		g_hash_table_insert (_tmp13_, _tmp15_, _tmp17_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, _g_free0_);
	components_dir = _tmp20_;
	_tmp22_ = db;
	_tmp23_ = libmsi_query_new (_tmp22_, "SELECT * FROM `Component`", &_inner_error_);
	_tmp21_ = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp24_ = _tmp21_;
	_tmp21_ = NULL;
	_g_object_unref0 (query);
	query = _tmp24_;
	_tmp25_ = query;
	libmsi_query_execute (_tmp25_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp21_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp26_ = NULL;
		LibmsiQuery* _tmp27_ = NULL;
		LibmsiRecord* _tmp28_ = NULL;
		LibmsiRecord* _tmp29_ = NULL;
		LibmsiRecord* _tmp30_ = NULL;
		gchar* dir_id = NULL;
		LibmsiRecord* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		LibmsiRecord* dir_rec = NULL;
		GHashTable* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gconstpointer _tmp35_ = NULL;
		LibmsiRecord* _tmp36_ = NULL;
		gchar* dir = NULL;
		LibmsiRecord* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GHashTable* _tmp55_ = NULL;
		LibmsiRecord* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		_tmp27_ = query;
		_tmp28_ = libmsi_query_fetch (_tmp27_, &_inner_error_);
		_tmp26_ = _tmp28_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp21_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp29_ = _tmp26_;
		_tmp26_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp29_;
		_tmp30_ = rec;
		if (!(_tmp30_ != NULL)) {
			_g_object_unref0 (_tmp26_);
			break;
		}
		_tmp31_ = rec;
		_tmp32_ = libmsi_record_get_string (_tmp31_, (guint) 3);
		dir_id = _tmp32_;
		_tmp33_ = directories;
		_tmp34_ = dir_id;
		_tmp35_ = g_hash_table_lookup (_tmp33_, _tmp34_);
		_tmp36_ = _g_object_ref0 ((LibmsiRecord*) _tmp35_);
		dir_rec = _tmp36_;
		_tmp37_ = dir_rec;
		_tmp38_ = get_directory_name (_tmp37_, &_inner_error_);
		dir = _tmp38_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (dir_rec);
			_g_free0 (dir_id);
			_g_object_unref0 (_tmp26_);
			_g_object_unref0 (_tmp21_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		while (TRUE) {
			gchar* parent = NULL;
			LibmsiRecord* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			GHashTable* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gconstpointer _tmp43_ = NULL;
			LibmsiRecord* _tmp44_ = NULL;
			LibmsiRecord* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			LibmsiRecord* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			_tmp39_ = dir_rec;
			_tmp40_ = libmsi_record_get_string (_tmp39_, (guint) 2);
			parent = _tmp40_;
			_tmp41_ = directories;
			_tmp42_ = parent;
			_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
			_tmp44_ = _g_object_ref0 ((LibmsiRecord*) _tmp43_);
			_g_object_unref0 (dir_rec);
			dir_rec = _tmp44_;
			_tmp45_ = dir_rec;
			if (_tmp45_ == NULL) {
				_g_free0 (parent);
				break;
			}
			_tmp47_ = dir_rec;
			_tmp48_ = get_directory_name (_tmp47_, &_inner_error_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (parent);
				_g_free0 (dir);
				_g_object_unref0 (dir_rec);
				_g_free0 (dir_id);
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp21_);
				_g_hash_table_unref0 (components_dir);
				_g_object_unref0 (query);
				_g_hash_table_unref0 (directories);
				_g_object_unref0 (db);
				_g_object_unref0 (rec);
				return;
			}
			_tmp49_ = _tmp46_;
			_tmp46_ = NULL;
			_g_free0 (parent);
			parent = _tmp49_;
			_tmp50_ = parent;
			if (_tmp50_ == NULL) {
				_g_free0 (_tmp46_);
				_g_free0 (parent);
				break;
			}
			_tmp51_ = parent;
			if (g_strcmp0 (_tmp51_, "") == 0) {
				_g_free0 (_tmp46_);
				_g_free0 (parent);
				continue;
			}
			_tmp52_ = parent;
			_tmp53_ = dir;
			_tmp54_ = g_build_filename (_tmp52_, _tmp53_, NULL);
			_g_free0 (dir);
			dir = _tmp54_;
			_g_free0 (_tmp46_);
			_g_free0 (parent);
		}
		_tmp55_ = components_dir;
		_tmp56_ = rec;
		_tmp57_ = libmsi_record_get_string (_tmp56_, (guint) 1);
		_tmp58_ = dir;
		_tmp59_ = g_strdup (_tmp58_);
		g_hash_table_insert (_tmp55_, _tmp57_, _tmp59_);
		_g_free0 (dir);
		_g_object_unref0 (dir_rec);
		_g_free0 (dir_id);
		_g_object_unref0 (_tmp26_);
	}
	_tmp60_ = g_str_hash;
	_tmp61_ = g_str_equal;
	_tmp62_ = g_hash_table_new_full (_tmp60_, _tmp61_, _g_free0_, _g_free0_);
	cab_to_name = _tmp62_;
	_tmp64_ = db;
	_tmp65_ = libmsi_query_new (_tmp64_, "SELECT * FROM `File`", &_inner_error_);
	_tmp63_ = _tmp65_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp21_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp66_ = _tmp63_;
	_tmp63_ = NULL;
	_g_object_unref0 (query);
	query = _tmp66_;
	_tmp67_ = query;
	libmsi_query_execute (_tmp67_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp63_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp21_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp68_ = NULL;
		LibmsiQuery* _tmp69_ = NULL;
		LibmsiRecord* _tmp70_ = NULL;
		LibmsiRecord* _tmp71_ = NULL;
		LibmsiRecord* _tmp72_ = NULL;
		gchar* dir = NULL;
		GHashTable* _tmp73_ = NULL;
		LibmsiRecord* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gconstpointer _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		gchar* file = NULL;
		const gchar* _tmp80_ = NULL;
		LibmsiRecord* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		gboolean _tmp88_ = FALSE;
		GHashTable* _tmp91_ = NULL;
		LibmsiRecord* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		const gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		_tmp69_ = query;
		_tmp70_ = libmsi_query_fetch (_tmp69_, &_inner_error_);
		_tmp68_ = _tmp70_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp63_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp21_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp71_ = _tmp68_;
		_tmp68_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp71_;
		_tmp72_ = rec;
		if (!(_tmp72_ != NULL)) {
			_g_object_unref0 (_tmp68_);
			break;
		}
		_tmp73_ = components_dir;
		_tmp74_ = rec;
		_tmp75_ = libmsi_record_get_string (_tmp74_, (guint) 2);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_hash_table_lookup (_tmp73_, _tmp76_);
		_tmp78_ = g_strdup ((const gchar*) _tmp77_);
		_tmp79_ = _tmp78_;
		_g_free0 (_tmp76_);
		dir = _tmp79_;
		_tmp80_ = dir;
		_tmp81_ = rec;
		_tmp82_ = libmsi_record_get_string (_tmp81_, (guint) 3);
		_tmp83_ = _tmp82_;
		_tmp84_ = get_long_name (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_build_filename (_tmp80_, _tmp85_, NULL);
		_tmp87_ = _tmp86_;
		_g_free0 (_tmp85_);
		_g_free0 (_tmp83_);
		file = _tmp87_;
		_tmp88_ = list_only;
		if (_tmp88_) {
			FILE* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			_tmp89_ = stdout;
			_tmp90_ = file;
			fprintf (_tmp89_, "%s\n", _tmp90_);
		}
		_tmp91_ = cab_to_name;
		_tmp92_ = rec;
		_tmp93_ = libmsi_record_get_string (_tmp92_, (guint) 1);
		_tmp94_ = file;
		_tmp95_ = g_strdup (_tmp94_);
		g_hash_table_insert (_tmp91_, _tmp93_, _tmp95_);
		_g_free0 (file);
		_g_free0 (dir);
		_g_object_unref0 (_tmp68_);
	}
	_tmp96_ = list_only;
	if (_tmp96_) {
		exit (0);
	}
	_tmp98_ = db;
	_tmp99_ = libmsi_query_new (_tmp98_, "SELECT * FROM `Media`", &_inner_error_);
	_tmp97_ = _tmp99_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp63_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp21_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp100_ = _tmp97_;
	_tmp97_ = NULL;
	_g_object_unref0 (query);
	query = _tmp100_;
	_tmp101_ = query;
	libmsi_query_execute (_tmp101_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp97_);
		_g_object_unref0 (_tmp63_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp21_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp102_ = NULL;
		LibmsiQuery* _tmp103_ = NULL;
		LibmsiRecord* _tmp104_ = NULL;
		LibmsiRecord* _tmp105_ = NULL;
		LibmsiRecord* _tmp106_ = NULL;
		gchar* cab = NULL;
		LibmsiRecord* _tmp107_ = NULL;
		gchar* _tmp108_ = NULL;
		LibmsiDatabase* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		GHashTable* _tmp111_ = NULL;
		_tmp103_ = query;
		_tmp104_ = libmsi_query_fetch (_tmp103_, &_inner_error_);
		_tmp102_ = _tmp104_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp97_);
			_g_object_unref0 (_tmp63_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp21_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp105_ = _tmp102_;
		_tmp102_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp105_;
		_tmp106_ = rec;
		if (!(_tmp106_ != NULL)) {
			_g_object_unref0 (_tmp102_);
			break;
		}
		_tmp107_ = rec;
		_tmp108_ = libmsi_record_get_string (_tmp107_, (guint) 4);
		cab = _tmp108_;
		_tmp109_ = db;
		_tmp110_ = cab;
		_tmp111_ = cab_to_name;
		extract_cab (_tmp109_, _tmp110_, _tmp111_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cab);
			_g_object_unref0 (_tmp102_);
			_g_object_unref0 (_tmp97_);
			_g_object_unref0 (_tmp63_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp21_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_g_free0 (cab);
		_g_object_unref0 (_tmp102_);
	}
	_g_object_unref0 (_tmp97_);
	_g_object_unref0 (_tmp63_);
	_g_hash_table_unref0 (cab_to_name);
	_g_object_unref0 (_tmp21_);
	_g_hash_table_unref0 (components_dir);
	_g_object_unref0 (query);
	_g_hash_table_unref0 (directories);
	_g_object_unref0 (db);
	_g_object_unref0 (rec);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* parameter_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GOptionContext* opt_context = NULL;
	const gchar* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* _tmp5_ = NULL;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name ("msiextract");
	_tmp0_ = _ ("- a msi files extracting tool");
	_tmp1_ = g_strdup (_tmp0_);
	parameter_string = _tmp1_;
	_tmp2_ = parameter_string;
	_tmp3_ = g_option_context_new (_tmp2_);
	opt_context = _tmp3_;
	_tmp4_ = opt_context;
	g_option_context_set_help_enabled (_tmp4_, TRUE);
	_tmp5_ = opt_context;
	g_option_context_add_main_entries (_tmp5_, options, NULL);
	{
		GOptionContext* _tmp6_ = NULL;
		_tmp6_ = opt_context;
		g_option_context_parse (_tmp6_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE)) {
				goto __catch0_g_option_error_bad_value;
			}
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error_bad_value:
	{
		GError* err = NULL;
		FILE* _tmp7_ = NULL;
		GOptionContext* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = opt_context;
		_tmp9_ = g_option_context_get_help (_tmp8_, TRUE, NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp7_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
		exit (1);
		_g_error_free0 (err);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning ("msiextract.vala:137: %s", _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp13_ = version;
	if (_tmp13_) {
		FILE* _tmp14_ = NULL;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "%s\n", PACKAGE_VERSION);
		exit (0);
	}
	_tmp15_ = files;
	_tmp15__length1 = _vala_array_length (files);
	if (_tmp15__length1 < 1) {
		FILE* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = _ ("Please specify input files.\n");
		fprintf (_tmp16_, "%s", _tmp17_);
		exit (1);
	}
	_tmp18_ = directory;
	if (_tmp18_ == NULL) {
		gchar* _tmp19_ = NULL;
		_tmp19_ = g_get_current_dir ();
		_g_free0 (directory);
		directory = _tmp19_;
	}
	{
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		_tmp20_ = files;
		_tmp20__length1 = _vala_array_length (files);
		{
			gchar** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
			file_collection = _tmp20_;
			file_collection_length1 = _tmp20__length1;
			for (file_it = 0; file_it < _tmp20__length1; file_it = file_it + 1) {
				gchar* _tmp21_ = NULL;
				gchar* file = NULL;
				_tmp21_ = g_strdup (file_collection[file_it]);
				file = _tmp21_;
				{
					const gchar* _tmp22_ = NULL;
					_tmp22_ = file;
					extract (_tmp22_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (file);
						goto __catch1_g_error;
					}
					_g_free0 (file);
				}
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = _error_;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s", _tmp25_);
		exit (1);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



