/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * A brush specifies how lines should be drawn.
 */

#ifndef iv_brush_h
#define iv_brush_h

#include <InterViews/coord.h>
#include <InterViews/resource.h>

#include <InterViews/_enter.h>

class BrushRep;
class BrushImpl;
class Display;

class Brush : public Resource {
public:
    Brush(Coord width);
    Brush(int pattern, Coord width);
    Brush(const int* pattern, int count, Coord width);
    virtual ~Brush();

    virtual Coord width() const;
#if !MAC
    virtual int dash_count() const;
    virtual int dash_list(int index) const;
#endif

    BrushRep* rep(Display*) const;
protected:
    void calc_dashes(int pat, int* dash, int& count);
private:
    void init(const int*, int, Coord);
#if defined(WIN32) || MAC
	BrushRep* rep_;
#else
    BrushImpl* impl_;
    /* anachronisms */
public:
    unsigned int Width() const;
#endif
};

#include <InterViews/_leave.h>

#endif
