/* ========================================================================
 * Copyright (c) 2005-2022 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Runtime.Serialization;

namespace Opc.Ua
{
    #region DataType Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class DataTypes
    {
        /// <remarks />
        public const uint BaseDataType = 24;

        /// <remarks />
        public const uint Number = 26;

        /// <remarks />
        public const uint Integer = 27;

        /// <remarks />
        public const uint UInteger = 28;

        /// <remarks />
        public const uint Enumeration = 29;

        /// <remarks />
        public const uint Boolean = 1;

        /// <remarks />
        public const uint SByte = 2;

        /// <remarks />
        public const uint Byte = 3;

        /// <remarks />
        public const uint Int16 = 4;

        /// <remarks />
        public const uint UInt16 = 5;

        /// <remarks />
        public const uint Int32 = 6;

        /// <remarks />
        public const uint UInt32 = 7;

        /// <remarks />
        public const uint Int64 = 8;

        /// <remarks />
        public const uint UInt64 = 9;

        /// <remarks />
        public const uint Float = 10;

        /// <remarks />
        public const uint Double = 11;

        /// <remarks />
        public const uint String = 12;

        /// <remarks />
        public const uint DateTime = 13;

        /// <remarks />
        public const uint Guid = 14;

        /// <remarks />
        public const uint ByteString = 15;

        /// <remarks />
        public const uint XmlElement = 16;

        /// <remarks />
        public const uint NodeId = 17;

        /// <remarks />
        public const uint ExpandedNodeId = 18;

        /// <remarks />
        public const uint StatusCode = 19;

        /// <remarks />
        public const uint QualifiedName = 20;

        /// <remarks />
        public const uint LocalizedText = 21;

        /// <remarks />
        public const uint Structure = 22;

        /// <remarks />
        public const uint DataValue = 23;

        /// <remarks />
        public const uint DiagnosticInfo = 25;

        /// <remarks />
        public const uint Image = 30;

        /// <remarks />
        public const uint Decimal = 50;

        /// <remarks />
        public const uint NamingRuleType = 120;

        /// <remarks />
        public const uint ImageBMP = 2000;

        /// <remarks />
        public const uint ImageGIF = 2001;

        /// <remarks />
        public const uint ImageJPG = 2002;

        /// <remarks />
        public const uint ImagePNG = 2003;

        /// <remarks />
        public const uint AudioDataType = 16307;

        /// <remarks />
        public const uint Union = 12756;

        /// <remarks />
        public const uint UriString = 23751;

        /// <remarks />
        public const uint BitFieldMaskDataType = 11737;

        /// <remarks />
        public const uint SemanticVersionString = 24263;

        /// <remarks />
        public const uint KeyValuePair = 14533;

        /// <remarks />
        public const uint AdditionalParametersType = 16313;

        /// <remarks />
        public const uint EphemeralKeyType = 17548;

        /// <remarks />
        public const uint EndpointType = 15528;

        /// <remarks />
        public const uint Handle = 31917;

        /// <remarks />
        public const uint TrimmedString = 31918;

        /// <remarks />
        public const uint RationalNumber = 18806;

        /// <remarks />
        public const uint Vector = 18807;

        /// <remarks />
        public const uint ThreeDVector = 18808;

        /// <remarks />
        public const uint CartesianCoordinates = 18809;

        /// <remarks />
        public const uint ThreeDCartesianCoordinates = 18810;

        /// <remarks />
        public const uint Orientation = 18811;

        /// <remarks />
        public const uint ThreeDOrientation = 18812;

        /// <remarks />
        public const uint Frame = 18813;

        /// <remarks />
        public const uint ThreeDFrame = 18814;

        /// <remarks />
        public const uint OpenFileMode = 11939;

        /// <remarks />
        public const uint IdentityCriteriaType = 15632;

        /// <remarks />
        public const uint IdentityMappingRuleType = 15634;

        /// <remarks />
        public const uint CurrencyUnitType = 23498;

        /// <remarks />
        public const uint AlarmMask = 32251;

        /// <remarks />
        public const uint TrustListValidationOptions = 23564;

        /// <remarks />
        public const uint TrustListMasks = 12552;

        /// <remarks />
        public const uint TrustListDataType = 12554;

        /// <remarks />
        public const uint TransactionErrorType = 32285;

        /// <remarks />
        public const uint DecimalDataType = 17861;

        /// <remarks />
        public const uint DataTypeSchemaHeader = 15534;

        /// <remarks />
        public const uint DataTypeDescription = 14525;

        /// <remarks />
        public const uint StructureDescription = 15487;

        /// <remarks />
        public const uint EnumDescription = 15488;

        /// <remarks />
        public const uint SimpleTypeDescription = 15005;

        /// <remarks />
        public const uint UABinaryFileDataType = 15006;

        /// <remarks />
        public const uint PortableQualifiedName = 24105;

        /// <remarks />
        public const uint PortableNodeId = 24106;

        /// <remarks />
        public const uint UnsignedRationalNumber = 24107;

        /// <remarks />
        public const uint PubSubState = 14647;

        /// <remarks />
        public const uint DataSetMetaDataType = 14523;

        /// <remarks />
        public const uint FieldMetaData = 14524;

        /// <remarks />
        public const uint DataSetFieldFlags = 15904;

        /// <remarks />
        public const uint ConfigurationVersionDataType = 14593;

        /// <remarks />
        public const uint PublishedDataSetDataType = 15578;

        /// <remarks />
        public const uint PublishedDataSetSourceDataType = 15580;

        /// <remarks />
        public const uint PublishedVariableDataType = 14273;

        /// <remarks />
        public const uint PublishedDataItemsDataType = 15581;

        /// <remarks />
        public const uint PublishedEventsDataType = 15582;

        /// <remarks />
        public const uint PublishedDataSetCustomSourceDataType = 25269;

        /// <remarks />
        public const uint DataSetFieldContentMask = 15583;

        /// <remarks />
        public const uint DataSetWriterDataType = 15597;

        /// <remarks />
        public const uint DataSetWriterTransportDataType = 15598;

        /// <remarks />
        public const uint DataSetWriterMessageDataType = 15605;

        /// <remarks />
        public const uint PubSubGroupDataType = 15609;

        /// <remarks />
        public const uint WriterGroupDataType = 15480;

        /// <remarks />
        public const uint WriterGroupTransportDataType = 15611;

        /// <remarks />
        public const uint WriterGroupMessageDataType = 15616;

        /// <remarks />
        public const uint PubSubConnectionDataType = 15617;

        /// <remarks />
        public const uint ConnectionTransportDataType = 15618;

        /// <remarks />
        public const uint NetworkAddressDataType = 15502;

        /// <remarks />
        public const uint NetworkAddressUrlDataType = 15510;

        /// <remarks />
        public const uint ReaderGroupDataType = 15520;

        /// <remarks />
        public const uint ReaderGroupTransportDataType = 15621;

        /// <remarks />
        public const uint ReaderGroupMessageDataType = 15622;

        /// <remarks />
        public const uint DataSetReaderDataType = 15623;

        /// <remarks />
        public const uint DataSetReaderTransportDataType = 15628;

        /// <remarks />
        public const uint DataSetReaderMessageDataType = 15629;

        /// <remarks />
        public const uint SubscribedDataSetDataType = 15630;

        /// <remarks />
        public const uint TargetVariablesDataType = 15631;

        /// <remarks />
        public const uint FieldTargetDataType = 14744;

        /// <remarks />
        public const uint OverrideValueHandling = 15874;

        /// <remarks />
        public const uint SubscribedDataSetMirrorDataType = 15635;

        /// <remarks />
        public const uint PubSubConfigurationDataType = 15530;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetRefDataType = 23599;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetDataType = 23600;

        /// <remarks />
        public const uint SecurityGroupDataType = 23601;

        /// <remarks />
        public const uint PubSubKeyPushTargetDataType = 25270;

        /// <remarks />
        public const uint PubSubConfiguration2DataType = 23602;

        /// <remarks />
        public const uint DataSetOrderingType = 20408;

        /// <remarks />
        public const uint UadpNetworkMessageContentMask = 15642;

        /// <remarks />
        public const uint UadpWriterGroupMessageDataType = 15645;

        /// <remarks />
        public const uint UadpDataSetMessageContentMask = 15646;

        /// <remarks />
        public const uint UadpDataSetWriterMessageDataType = 15652;

        /// <remarks />
        public const uint UadpDataSetReaderMessageDataType = 15653;

        /// <remarks />
        public const uint JsonNetworkMessageContentMask = 15654;

        /// <remarks />
        public const uint JsonWriterGroupMessageDataType = 15657;

        /// <remarks />
        public const uint JsonDataSetMessageContentMask = 15658;

        /// <remarks />
        public const uint JsonDataSetWriterMessageDataType = 15664;

        /// <remarks />
        public const uint JsonDataSetReaderMessageDataType = 15665;

        /// <remarks />
        public const uint QosDataType = 23603;

        /// <remarks />
        public const uint TransmitQosDataType = 23604;

        /// <remarks />
        public const uint TransmitQosPriorityDataType = 23605;

        /// <remarks />
        public const uint ReceiveQosDataType = 23608;

        /// <remarks />
        public const uint ReceiveQosPriorityDataType = 23609;

        /// <remarks />
        public const uint DatagramConnectionTransportDataType = 17467;

        /// <remarks />
        public const uint DatagramConnectionTransport2DataType = 23612;

        /// <remarks />
        public const uint DatagramWriterGroupTransportDataType = 15532;

        /// <remarks />
        public const uint DatagramWriterGroupTransport2DataType = 23613;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportDataType = 23614;

        /// <remarks />
        public const uint BrokerConnectionTransportDataType = 15007;

        /// <remarks />
        public const uint BrokerTransportQualityOfService = 15008;

        /// <remarks />
        public const uint BrokerWriterGroupTransportDataType = 15667;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportDataType = 15669;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportDataType = 15670;

        /// <remarks />
        public const uint PubSubConfigurationRefMask = 25517;

        /// <remarks />
        public const uint PubSubConfigurationRefDataType = 25519;

        /// <remarks />
        public const uint PubSubConfigurationValueDataType = 25520;

        /// <remarks />
        public const uint DiagnosticsLevel = 19723;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterClassification = 19730;

        /// <remarks />
        public const uint AliasNameDataType = 23468;

        /// <remarks />
        public const uint PasswordOptionsMask = 24277;

        /// <remarks />
        public const uint UserConfigurationMask = 24279;

        /// <remarks />
        public const uint UserManagementDataType = 24281;

        /// <remarks />
        public const uint EncodedTicket = 25726;

        /// <remarks />
        public const uint Duplex = 24210;

        /// <remarks />
        public const uint InterfaceAdminStatus = 24212;

        /// <remarks />
        public const uint InterfaceOperStatus = 24214;

        /// <remarks />
        public const uint NegotiationStatus = 24216;

        /// <remarks />
        public const uint TsnFailureCode = 24218;

        /// <remarks />
        public const uint TsnStreamState = 24220;

        /// <remarks />
        public const uint TsnTalkerStatus = 24222;

        /// <remarks />
        public const uint TsnListenerStatus = 24224;

        /// <remarks />
        public const uint PriorityMappingEntryType = 25220;

        /// <remarks />
        public const uint ReferenceDescriptionDataType = 32659;

        /// <remarks />
        public const uint ReferenceListEntryDataType = 32660;

        /// <remarks />
        public const uint IdType = 256;

        /// <remarks />
        public const uint NodeClass = 257;

        /// <remarks />
        public const uint PermissionType = 94;

        /// <remarks />
        public const uint AccessLevelType = 15031;

        /// <remarks />
        public const uint AccessLevelExType = 15406;

        /// <remarks />
        public const uint EventNotifierType = 15033;

        /// <remarks />
        public const uint AccessRestrictionType = 95;

        /// <remarks />
        public const uint RolePermissionType = 96;

        /// <remarks />
        public const uint DataTypeDefinition = 97;

        /// <remarks />
        public const uint StructureType = 98;

        /// <remarks />
        public const uint StructureField = 101;

        /// <remarks />
        public const uint StructureDefinition = 99;

        /// <remarks />
        public const uint EnumDefinition = 100;

        /// <remarks />
        public const uint Node = 258;

        /// <remarks />
        public const uint InstanceNode = 11879;

        /// <remarks />
        public const uint TypeNode = 11880;

        /// <remarks />
        public const uint ObjectNode = 261;

        /// <remarks />
        public const uint ObjectTypeNode = 264;

        /// <remarks />
        public const uint VariableNode = 267;

        /// <remarks />
        public const uint VariableTypeNode = 270;

        /// <remarks />
        public const uint ReferenceTypeNode = 273;

        /// <remarks />
        public const uint MethodNode = 276;

        /// <remarks />
        public const uint ViewNode = 279;

        /// <remarks />
        public const uint DataTypeNode = 282;

        /// <remarks />
        public const uint ReferenceNode = 285;

        /// <remarks />
        public const uint Argument = 296;

        /// <remarks />
        public const uint EnumValueType = 7594;

        /// <remarks />
        public const uint EnumField = 102;

        /// <remarks />
        public const uint OptionSet = 12755;

        /// <remarks />
        public const uint NormalizedString = 12877;

        /// <remarks />
        public const uint DecimalString = 12878;

        /// <remarks />
        public const uint DurationString = 12879;

        /// <remarks />
        public const uint TimeString = 12880;

        /// <remarks />
        public const uint DateString = 12881;

        /// <remarks />
        public const uint Duration = 290;

        /// <remarks />
        public const uint UtcTime = 294;

        /// <remarks />
        public const uint LocaleId = 295;

        /// <remarks />
        public const uint TimeZoneDataType = 8912;

        /// <remarks />
        public const uint Index = 17588;

        /// <remarks />
        public const uint IntegerId = 288;

        /// <remarks />
        public const uint ApplicationType = 307;

        /// <remarks />
        public const uint ApplicationDescription = 308;

        /// <remarks />
        public const uint RequestHeader = 389;

        /// <remarks />
        public const uint ResponseHeader = 392;

        /// <remarks />
        public const uint VersionTime = 20998;

        /// <remarks />
        public const uint ServiceFault = 395;

        /// <remarks />
        public const uint SessionlessInvokeRequestType = 15901;

        /// <remarks />
        public const uint SessionlessInvokeResponseType = 20999;

        /// <remarks />
        public const uint FindServersRequest = 420;

        /// <remarks />
        public const uint FindServersResponse = 423;

        /// <remarks />
        public const uint ServerOnNetwork = 12189;

        /// <remarks />
        public const uint FindServersOnNetworkRequest = 12190;

        /// <remarks />
        public const uint FindServersOnNetworkResponse = 12191;

        /// <remarks />
        public const uint ApplicationInstanceCertificate = 311;

        /// <remarks />
        public const uint MessageSecurityMode = 302;

        /// <remarks />
        public const uint UserTokenType = 303;

        /// <remarks />
        public const uint UserTokenPolicy = 304;

        /// <remarks />
        public const uint EndpointDescription = 312;

        /// <remarks />
        public const uint GetEndpointsRequest = 426;

        /// <remarks />
        public const uint GetEndpointsResponse = 429;

        /// <remarks />
        public const uint RegisteredServer = 432;

        /// <remarks />
        public const uint RegisterServerRequest = 435;

        /// <remarks />
        public const uint RegisterServerResponse = 438;

        /// <remarks />
        public const uint DiscoveryConfiguration = 12890;

        /// <remarks />
        public const uint MdnsDiscoveryConfiguration = 12891;

        /// <remarks />
        public const uint RegisterServer2Request = 12193;

        /// <remarks />
        public const uint RegisterServer2Response = 12194;

        /// <remarks />
        public const uint SecurityTokenRequestType = 315;

        /// <remarks />
        public const uint ChannelSecurityToken = 441;

        /// <remarks />
        public const uint OpenSecureChannelRequest = 444;

        /// <remarks />
        public const uint OpenSecureChannelResponse = 447;

        /// <remarks />
        public const uint CloseSecureChannelRequest = 450;

        /// <remarks />
        public const uint CloseSecureChannelResponse = 453;

        /// <remarks />
        public const uint SignedSoftwareCertificate = 344;

        /// <remarks />
        public const uint SessionAuthenticationToken = 388;

        /// <remarks />
        public const uint SignatureData = 456;

        /// <remarks />
        public const uint CreateSessionRequest = 459;

        /// <remarks />
        public const uint CreateSessionResponse = 462;

        /// <remarks />
        public const uint UserIdentityToken = 316;

        /// <remarks />
        public const uint AnonymousIdentityToken = 319;

        /// <remarks />
        public const uint UserNameIdentityToken = 322;

        /// <remarks />
        public const uint X509IdentityToken = 325;

        /// <remarks />
        public const uint IssuedIdentityToken = 938;

        /// <remarks />
        public const uint RsaEncryptedSecret = 17545;

        /// <remarks />
        public const uint EccEncryptedSecret = 17546;

        /// <remarks />
        public const uint ActivateSessionRequest = 465;

        /// <remarks />
        public const uint ActivateSessionResponse = 468;

        /// <remarks />
        public const uint CloseSessionRequest = 471;

        /// <remarks />
        public const uint CloseSessionResponse = 474;

        /// <remarks />
        public const uint CancelRequest = 477;

        /// <remarks />
        public const uint CancelResponse = 480;

        /// <remarks />
        public const uint NodeAttributesMask = 348;

        /// <remarks />
        public const uint NodeAttributes = 349;

        /// <remarks />
        public const uint ObjectAttributes = 352;

        /// <remarks />
        public const uint VariableAttributes = 355;

        /// <remarks />
        public const uint MethodAttributes = 358;

        /// <remarks />
        public const uint ObjectTypeAttributes = 361;

        /// <remarks />
        public const uint VariableTypeAttributes = 364;

        /// <remarks />
        public const uint ReferenceTypeAttributes = 367;

        /// <remarks />
        public const uint DataTypeAttributes = 370;

        /// <remarks />
        public const uint ViewAttributes = 373;

        /// <remarks />
        public const uint GenericAttributeValue = 17606;

        /// <remarks />
        public const uint GenericAttributes = 17607;

        /// <remarks />
        public const uint AddNodesItem = 376;

        /// <remarks />
        public const uint AddNodesResult = 483;

        /// <remarks />
        public const uint AddNodesRequest = 486;

        /// <remarks />
        public const uint AddNodesResponse = 489;

        /// <remarks />
        public const uint AddReferencesItem = 379;

        /// <remarks />
        public const uint AddReferencesRequest = 492;

        /// <remarks />
        public const uint AddReferencesResponse = 495;

        /// <remarks />
        public const uint DeleteNodesItem = 382;

        /// <remarks />
        public const uint DeleteNodesRequest = 498;

        /// <remarks />
        public const uint DeleteNodesResponse = 501;

        /// <remarks />
        public const uint DeleteReferencesItem = 385;

        /// <remarks />
        public const uint DeleteReferencesRequest = 504;

        /// <remarks />
        public const uint DeleteReferencesResponse = 507;

        /// <remarks />
        public const uint AttributeWriteMask = 347;

        /// <remarks />
        public const uint BrowseDirection = 510;

        /// <remarks />
        public const uint ViewDescription = 511;

        /// <remarks />
        public const uint BrowseDescription = 514;

        /// <remarks />
        public const uint BrowseResultMask = 517;

        /// <remarks />
        public const uint ReferenceDescription = 518;

        /// <remarks />
        public const uint ContinuationPoint = 521;

        /// <remarks />
        public const uint BrowseResult = 522;

        /// <remarks />
        public const uint BrowseRequest = 525;

        /// <remarks />
        public const uint BrowseResponse = 528;

        /// <remarks />
        public const uint BrowseNextRequest = 531;

        /// <remarks />
        public const uint BrowseNextResponse = 534;

        /// <remarks />
        public const uint RelativePathElement = 537;

        /// <remarks />
        public const uint RelativePath = 540;

        /// <remarks />
        public const uint BrowsePath = 543;

        /// <remarks />
        public const uint BrowsePathTarget = 546;

        /// <remarks />
        public const uint BrowsePathResult = 549;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsRequest = 552;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsResponse = 555;

        /// <remarks />
        public const uint RegisterNodesRequest = 558;

        /// <remarks />
        public const uint RegisterNodesResponse = 561;

        /// <remarks />
        public const uint UnregisterNodesRequest = 564;

        /// <remarks />
        public const uint UnregisterNodesResponse = 567;

        /// <remarks />
        public const uint Counter = 289;

        /// <remarks />
        public const uint NumericRange = 291;

        /// <remarks />
        public const uint EndpointConfiguration = 331;

        /// <remarks />
        public const uint QueryDataDescription = 570;

        /// <remarks />
        public const uint NodeTypeDescription = 573;

        /// <remarks />
        public const uint FilterOperator = 576;

        /// <remarks />
        public const uint QueryDataSet = 577;

        /// <remarks />
        public const uint NodeReference = 580;

        /// <remarks />
        public const uint ContentFilterElement = 583;

        /// <remarks />
        public const uint ContentFilter = 586;

        /// <remarks />
        public const uint FilterOperand = 589;

        /// <remarks />
        public const uint ElementOperand = 592;

        /// <remarks />
        public const uint LiteralOperand = 595;

        /// <remarks />
        public const uint AttributeOperand = 598;

        /// <remarks />
        public const uint SimpleAttributeOperand = 601;

        /// <remarks />
        public const uint ContentFilterElementResult = 604;

        /// <remarks />
        public const uint ContentFilterResult = 607;

        /// <remarks />
        public const uint ParsingResult = 610;

        /// <remarks />
        public const uint QueryFirstRequest = 613;

        /// <remarks />
        public const uint QueryFirstResponse = 616;

        /// <remarks />
        public const uint QueryNextRequest = 619;

        /// <remarks />
        public const uint QueryNextResponse = 622;

        /// <remarks />
        public const uint TimestampsToReturn = 625;

        /// <remarks />
        public const uint ReadValueId = 626;

        /// <remarks />
        public const uint ReadRequest = 629;

        /// <remarks />
        public const uint ReadResponse = 632;

        /// <remarks />
        public const uint HistoryReadValueId = 635;

        /// <remarks />
        public const uint HistoryReadResult = 638;

        /// <remarks />
        public const uint HistoryReadDetails = 641;

        /// <remarks />
        public const uint ReadEventDetails = 644;

        /// <remarks />
        public const uint ReadRawModifiedDetails = 647;

        /// <remarks />
        public const uint ReadProcessedDetails = 650;

        /// <remarks />
        public const uint ReadAtTimeDetails = 653;

        /// <remarks />
        public const uint ReadAnnotationDataDetails = 23497;

        /// <remarks />
        public const uint HistoryData = 656;

        /// <remarks />
        public const uint ModificationInfo = 11216;

        /// <remarks />
        public const uint HistoryModifiedData = 11217;

        /// <remarks />
        public const uint HistoryEvent = 659;

        /// <remarks />
        public const uint HistoryReadRequest = 662;

        /// <remarks />
        public const uint HistoryReadResponse = 665;

        /// <remarks />
        public const uint WriteValue = 668;

        /// <remarks />
        public const uint WriteRequest = 671;

        /// <remarks />
        public const uint WriteResponse = 674;

        /// <remarks />
        public const uint HistoryUpdateDetails = 677;

        /// <remarks />
        public const uint HistoryUpdateType = 11234;

        /// <remarks />
        public const uint PerformUpdateType = 11293;

        /// <remarks />
        public const uint UpdateDataDetails = 680;

        /// <remarks />
        public const uint UpdateStructureDataDetails = 11295;

        /// <remarks />
        public const uint UpdateEventDetails = 683;

        /// <remarks />
        public const uint DeleteRawModifiedDetails = 686;

        /// <remarks />
        public const uint DeleteAtTimeDetails = 689;

        /// <remarks />
        public const uint DeleteEventDetails = 692;

        /// <remarks />
        public const uint HistoryUpdateResult = 695;

        /// <remarks />
        public const uint HistoryUpdateRequest = 698;

        /// <remarks />
        public const uint HistoryUpdateResponse = 701;

        /// <remarks />
        public const uint CallMethodRequest = 704;

        /// <remarks />
        public const uint CallMethodResult = 707;

        /// <remarks />
        public const uint CallRequest = 710;

        /// <remarks />
        public const uint CallResponse = 713;

        /// <remarks />
        public const uint MonitoringMode = 716;

        /// <remarks />
        public const uint DataChangeTrigger = 717;

        /// <remarks />
        public const uint DeadbandType = 718;

        /// <remarks />
        public const uint MonitoringFilter = 719;

        /// <remarks />
        public const uint DataChangeFilter = 722;

        /// <remarks />
        public const uint EventFilter = 725;

        /// <remarks />
        public const uint AggregateConfiguration = 948;

        /// <remarks />
        public const uint AggregateFilter = 728;

        /// <remarks />
        public const uint MonitoringFilterResult = 731;

        /// <remarks />
        public const uint EventFilterResult = 734;

        /// <remarks />
        public const uint AggregateFilterResult = 737;

        /// <remarks />
        public const uint MonitoringParameters = 740;

        /// <remarks />
        public const uint MonitoredItemCreateRequest = 743;

        /// <remarks />
        public const uint MonitoredItemCreateResult = 746;

        /// <remarks />
        public const uint CreateMonitoredItemsRequest = 749;

        /// <remarks />
        public const uint CreateMonitoredItemsResponse = 752;

        /// <remarks />
        public const uint MonitoredItemModifyRequest = 755;

        /// <remarks />
        public const uint MonitoredItemModifyResult = 758;

        /// <remarks />
        public const uint ModifyMonitoredItemsRequest = 761;

        /// <remarks />
        public const uint ModifyMonitoredItemsResponse = 764;

        /// <remarks />
        public const uint SetMonitoringModeRequest = 767;

        /// <remarks />
        public const uint SetMonitoringModeResponse = 770;

        /// <remarks />
        public const uint SetTriggeringRequest = 773;

        /// <remarks />
        public const uint SetTriggeringResponse = 776;

        /// <remarks />
        public const uint DeleteMonitoredItemsRequest = 779;

        /// <remarks />
        public const uint DeleteMonitoredItemsResponse = 782;

        /// <remarks />
        public const uint CreateSubscriptionRequest = 785;

        /// <remarks />
        public const uint CreateSubscriptionResponse = 788;

        /// <remarks />
        public const uint ModifySubscriptionRequest = 791;

        /// <remarks />
        public const uint ModifySubscriptionResponse = 794;

        /// <remarks />
        public const uint SetPublishingModeRequest = 797;

        /// <remarks />
        public const uint SetPublishingModeResponse = 800;

        /// <remarks />
        public const uint NotificationMessage = 803;

        /// <remarks />
        public const uint NotificationData = 945;

        /// <remarks />
        public const uint DataChangeNotification = 809;

        /// <remarks />
        public const uint MonitoredItemNotification = 806;

        /// <remarks />
        public const uint EventNotificationList = 914;

        /// <remarks />
        public const uint EventFieldList = 917;

        /// <remarks />
        public const uint HistoryEventFieldList = 920;

        /// <remarks />
        public const uint StatusChangeNotification = 818;

        /// <remarks />
        public const uint SubscriptionAcknowledgement = 821;

        /// <remarks />
        public const uint PublishRequest = 824;

        /// <remarks />
        public const uint PublishResponse = 827;

        /// <remarks />
        public const uint RepublishRequest = 830;

        /// <remarks />
        public const uint RepublishResponse = 833;

        /// <remarks />
        public const uint TransferResult = 836;

        /// <remarks />
        public const uint TransferSubscriptionsRequest = 839;

        /// <remarks />
        public const uint TransferSubscriptionsResponse = 842;

        /// <remarks />
        public const uint DeleteSubscriptionsRequest = 845;

        /// <remarks />
        public const uint DeleteSubscriptionsResponse = 848;

        /// <remarks />
        public const uint BuildInfo = 338;

        /// <remarks />
        public const uint RedundancySupport = 851;

        /// <remarks />
        public const uint ServerState = 852;

        /// <remarks />
        public const uint RedundantServerDataType = 853;

        /// <remarks />
        public const uint EndpointUrlListDataType = 11943;

        /// <remarks />
        public const uint NetworkGroupDataType = 11944;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsDataType = 856;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryDataType = 859;

        /// <remarks />
        public const uint ServerStatusDataType = 862;

        /// <remarks />
        public const uint SessionDiagnosticsDataType = 865;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsDataType = 868;

        /// <remarks />
        public const uint ServiceCounterDataType = 871;

        /// <remarks />
        public const uint StatusResult = 299;

        /// <remarks />
        public const uint SubscriptionDiagnosticsDataType = 874;

        /// <remarks />
        public const uint ModelChangeStructureVerbMask = 11941;

        /// <remarks />
        public const uint ModelChangeStructureDataType = 877;

        /// <remarks />
        public const uint SemanticChangeStructureDataType = 897;

        /// <remarks />
        public const uint Range = 884;

        /// <remarks />
        public const uint EUInformation = 887;

        /// <remarks />
        public const uint AxisScaleEnumeration = 12077;

        /// <remarks />
        public const uint ComplexNumberType = 12171;

        /// <remarks />
        public const uint DoubleComplexNumberType = 12172;

        /// <remarks />
        public const uint AxisInformation = 12079;

        /// <remarks />
        public const uint XVType = 12080;

        /// <remarks />
        public const uint ProgramDiagnosticDataType = 894;

        /// <remarks />
        public const uint ProgramDiagnostic2DataType = 24033;

        /// <remarks />
        public const uint Annotation = 891;

        /// <remarks />
        public const uint ExceptionDeviationFormat = 890;
    }
    #endregion

    #region Method Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Methods
    {
        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open = 15971;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Close = 15974;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read = 15976;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Write = 15979;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition = 15981;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_SetPosition = 15984;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole = 16290;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_RoleSet_RemoveRole = 16293;

        /// <remarks />
        public const uint ServerType_GetMonitoredItems = 11489;

        /// <remarks />
        public const uint ServerType_ResendData = 12871;

        /// <remarks />
        public const uint ServerType_SetSubscriptionDurable = 12746;

        /// <remarks />
        public const uint ServerType_RequestServerStateChange = 12883;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet_AddRole = 16296;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet_RemoveRole = 16299;

        /// <remarks />
        public const uint FileType_Open = 11580;

        /// <remarks />
        public const uint FileType_Close = 11583;

        /// <remarks />
        public const uint FileType_Read = 11585;

        /// <remarks />
        public const uint FileType_Write = 11588;

        /// <remarks />
        public const uint FileType_GetPosition = 11590;

        /// <remarks />
        public const uint FileType_SetPosition = 11593;

        /// <remarks />
        public const uint AddressSpaceFileType_ExportNamespace = 11615;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Open = 11629;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Close = 11632;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Read = 11634;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Write = 11637;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition = 11639;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_SetPosition = 11642;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open = 11659;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close = 11662;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read = 11664;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write = 11667;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition = 11669;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition = 11672;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet_AddRole = 16301;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet_RemoveRole = 16304;

        /// <remarks />
        public const uint Server_GetMonitoredItems = 11492;

        /// <remarks />
        public const uint Server_ResendData = 12873;

        /// <remarks />
        public const uint Server_SetSubscriptionDurable = 12749;

        /// <remarks />
        public const uint Server_RequestServerStateChange = 12886;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory = 13355;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile = 13358;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject = 17718;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy = 13363;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Open = 13372;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Close = 13375;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Read = 13377;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Write = 13380;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition = 13382;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_SetPosition = 13385;

        /// <remarks />
        public const uint FileDirectoryType_CreateDirectory = 13387;

        /// <remarks />
        public const uint FileDirectoryType_CreateFile = 13390;

        /// <remarks />
        public const uint FileDirectoryType_DeleteFileSystemObject = 13393;

        /// <remarks />
        public const uint FileDirectoryType_MoveOrCopy = 13395;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory = 16316;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile = 16319;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject = 17722;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy = 16324;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Open = 16333;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Close = 16336;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Read = 16338;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Write = 16341;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_GetPosition = 16343;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_SetPosition = 16346;

        /// <remarks />
        public const uint FileSystem_CreateDirectory = 16348;

        /// <remarks />
        public const uint FileSystem_CreateFile = 16351;

        /// <remarks />
        public const uint FileSystem_DeleteFileSystemObject = 16354;

        /// <remarks />
        public const uint FileSystem_MoveOrCopy = 16356;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForRead = 15746;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForWrite = 15749;

        /// <remarks />
        public const uint TemporaryFileTransferType_CloseAndCommit = 15751;

        /// <remarks />
        public const uint TemporaryFileTransferType_TransferState_Placeholder_Reset = 15794;

        /// <remarks />
        public const uint FileTransferStateMachineType_Reset = 15843;

        /// <remarks />
        public const uint RoleSetType_AddRole = 15997;

        /// <remarks />
        public const uint RoleSetType_RemoveRole = 16000;

        /// <remarks />
        public const uint RoleType_AddIdentity = 15624;

        /// <remarks />
        public const uint RoleType_RemoveIdentity = 15626;

        /// <remarks />
        public const uint RoleType_AddApplication = 16176;

        /// <remarks />
        public const uint RoleType_RemoveApplication = 16178;

        /// <remarks />
        public const uint RoleType_AddEndpoint = 16180;

        /// <remarks />
        public const uint RoleType_RemoveEndpoint = 16182;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddIdentity = 15648;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveIdentity = 15650;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddApplication = 16195;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveApplication = 16197;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddEndpoint = 16199;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveEndpoint = 16201;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddIdentity = 15660;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveIdentity = 15662;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddApplication = 16206;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveApplication = 16208;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddEndpoint = 16210;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveEndpoint = 16212;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddIdentity = 15672;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveIdentity = 15674;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddApplication = 16217;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveApplication = 16219;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddEndpoint = 16221;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveEndpoint = 16223;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddIdentity = 15684;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveIdentity = 15686;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddApplication = 16228;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveApplication = 16230;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddEndpoint = 16232;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveEndpoint = 16234;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddIdentity = 16041;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveIdentity = 16043;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddApplication = 16239;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveApplication = 16241;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddEndpoint = 16243;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveEndpoint = 16245;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddIdentity = 15696;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveIdentity = 15698;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddApplication = 16250;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveApplication = 16252;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddEndpoint = 16254;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveEndpoint = 16256;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddIdentity = 15720;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveIdentity = 15722;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddApplication = 16272;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveApplication = 16274;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddEndpoint = 16276;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveEndpoint = 16278;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddIdentity = 15708;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveIdentity = 15710;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddApplication = 16261;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveApplication = 16263;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddEndpoint = 16265;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveEndpoint = 16267;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddIdentity = 25572;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity = 25574;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddApplication = 25576;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveApplication = 25578;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddEndpoint = 25580;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint = 25582;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddIdentity = 25610;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveIdentity = 25612;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddApplication = 25614;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveApplication = 25616;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddEndpoint = 25618;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint = 25620;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddIdentity = 25591;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveIdentity = 25593;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddApplication = 25595;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveApplication = 25597;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddEndpoint = 25599;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveEndpoint = 25601;

        /// <remarks />
        public const uint ConditionType_Disable = 9028;

        /// <remarks />
        public const uint ConditionType_Enable = 9027;

        /// <remarks />
        public const uint ConditionType_AddComment = 9029;

        /// <remarks />
        public const uint ConditionType_ConditionRefresh = 3875;

        /// <remarks />
        public const uint ConditionType_ConditionRefresh2 = 12912;

        /// <remarks />
        public const uint DialogConditionType_Respond = 9069;

        /// <remarks />
        public const uint DialogConditionType_Respond2 = 24312;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Acknowledge = 9111;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Confirm = 9113;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_TimedShelve = 9213;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_Unshelve = 9211;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_OneShotShelve = 9212;

        /// <remarks />
        public const uint AlarmConditionType_Silence = 16402;

        /// <remarks />
        public const uint AlarmConditionType_Suppress = 16403;

        /// <remarks />
        public const uint AlarmConditionType_Suppress2 = 24316;

        /// <remarks />
        public const uint AlarmConditionType_Unsuppress = 17868;

        /// <remarks />
        public const uint AlarmConditionType_Unsuppress2 = 24318;

        /// <remarks />
        public const uint AlarmConditionType_RemoveFromService = 17869;

        /// <remarks />
        public const uint AlarmConditionType_RemoveFromService2 = 24320;

        /// <remarks />
        public const uint AlarmConditionType_PlaceInService = 17870;

        /// <remarks />
        public const uint AlarmConditionType_PlaceInService2 = 24322;

        /// <remarks />
        public const uint AlarmConditionType_Reset = 18199;

        /// <remarks />
        public const uint AlarmConditionType_Reset2 = 24324;

        /// <remarks />
        public const uint AlarmConditionType_GetGroupMemberships = 24744;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Disable = 16439;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Enable = 16440;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment = 16441;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge = 16461;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve = 16517;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve = 16515;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve = 16516;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Disable = 32098;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Enable = 32099;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment = 32100;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge = 32120;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve = 32167;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve = 32171;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve = 32174;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelve = 2949;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelve2 = 24756;

        /// <remarks />
        public const uint ShelvedStateMachineType_Unshelve = 2947;

        /// <remarks />
        public const uint ShelvedStateMachineType_Unshelve2 = 24758;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelve = 2948;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelve2 = 24760;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_TimedShelve = 9314;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_Unshelve = 9312;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_OneShotShelve = 9313;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_TimedShelve = 9451;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_Unshelve = 9449;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_OneShotShelve = 9450;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_TimedShelve = 10016;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_Unshelve = 10014;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve = 10015;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_TimedShelve = 10170;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_Unshelve = 10168;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve = 10169;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_TimedShelve = 9592;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_Unshelve = 9590;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_OneShotShelve = 9591;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve = 10478;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_Unshelve = 10476;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve = 10477;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve = 10324;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve = 10322;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve = 10323;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_TimedShelve = 9874;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_Unshelve = 9872;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve = 9873;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve = 9733;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve = 9731;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve = 9732;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_TimedShelve = 10633;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_Unshelve = 10631;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_OneShotShelve = 10632;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_TimedShelve = 10747;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_Unshelve = 10745;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_OneShotShelve = 10746;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_TimedShelve = 11846;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_Unshelve = 11844;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_OneShotShelve = 11845;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_TimedShelve = 10861;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_Unshelve = 10859;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_OneShotShelve = 10860;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve = 18453;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_Unshelve = 18455;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve = 18456;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_TimedShelve = 18602;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_Unshelve = 18604;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_OneShotShelve = 18605;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_TimedShelve = 13320;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_Unshelve = 13318;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_OneShotShelve = 13319;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_TimedShelve = 17195;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_Unshelve = 17193;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_OneShotShelve = 17194;

        /// <remarks />
        public const uint AlarmMetricsType_Reset = 18666;

        /// <remarks />
        public const uint ProgramStateMachineType_Start = 2426;

        /// <remarks />
        public const uint ProgramStateMachineType_Suspend = 2427;

        /// <remarks />
        public const uint ProgramStateMachineType_Resume = 2428;

        /// <remarks />
        public const uint ProgramStateMachineType_Halt = 2429;

        /// <remarks />
        public const uint ProgramStateMachineType_Reset = 2430;

        /// <remarks />
        public const uint TrustListType_OpenWithMasks = 12543;

        /// <remarks />
        public const uint TrustListType_CloseAndUpdate = 12546;

        /// <remarks />
        public const uint TrustListType_AddCertificate = 12548;

        /// <remarks />
        public const uint TrustListType_RemoveCertificate = 12550;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_TimedShelve = 19403;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_Unshelve = 19405;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve = 19406;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Open = 13605;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Close = 13608;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Read = 13610;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Write = 13613;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_GetPosition = 13615;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_SetPosition = 13618;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_OpenWithMasks = 13621;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_CloseAndUpdate = 13624;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_AddCertificate = 13627;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_RemoveCertificate = 13629;

        /// <remarks />
        public const uint CertificateGroupType_GetRejectedList = 23526;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Disable = 19483;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Enable = 19484;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_AddComment = 19485;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Acknowledge = 19505;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve = 20097;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_Unshelve = 20099;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve = 20100;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Disable = 20176;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Enable = 20177;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_AddComment = 20178;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Acknowledge = 20198;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve = 20245;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve = 20247;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve = 20248;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open = 13821;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close = 13824;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read = 13826;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write = 13829;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition = 13831;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition = 13834;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks = 13837;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate = 13840;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate = 13843;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate = 13845;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable = 20324;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable = 20325;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment = 20326;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge = 20346;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 20393;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 20395;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 20396;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable = 20474;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable = 20475;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 20476;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 20496;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 20543;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 20545;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 20546;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open = 13855;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close = 13858;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read = 13860;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write = 13863;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition = 13865;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition = 13868;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks = 13871;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate = 13874;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate = 13877;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate = 13879;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable = 20622;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable = 20623;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment = 20624;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge = 20644;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 20691;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 20693;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 20694;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable = 20770;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable = 20771;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 20772;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 20792;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 20839;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 20841;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 20842;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open = 13889;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close = 13892;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read = 13894;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write = 13897;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition = 13899;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition = 13902;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks = 13905;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 13908;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate = 13911;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate = 13913;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable = 20918;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable = 20919;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment = 20920;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 20940;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 20987;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 20989;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 20990;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 21269;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 21270;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 21271;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 21291;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 21338;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 21340;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 21341;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open = 13923;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close = 13926;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read = 13928;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write = 13931;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition = 13933;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition = 13936;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks = 13939;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate = 13942;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate = 13945;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate = 13947;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable = 21417;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable = 21418;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment = 21419;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge = 21439;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve = 21486;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve = 21488;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve = 21489;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable = 21565;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable = 21566;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment = 21567;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge = 21587;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve = 21634;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve = 21636;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve = 21637;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 13958;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 13961;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 13963;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 13966;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 13968;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 13971;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 13974;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 13977;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 13980;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 13982;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 21713;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 21714;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 21715;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 21735;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 21782;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 21784;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 21785;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 21861;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 21862;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 21863;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 21883;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 21930;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 21932;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 21933;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 13992;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 13995;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 13997;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 14000;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 14002;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 14005;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 14008;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 14011;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 14014;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 14016;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 22009;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 22010;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 22011;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 22031;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 22078;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 22080;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 22081;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 22157;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 22158;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 22159;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 22179;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22226;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22228;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22229;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 14026;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 14029;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 14031;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 14034;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 14036;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 14039;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 14042;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 14045;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 14048;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 14050;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 22305;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 22306;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 22307;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 22327;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 22374;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 22376;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 22377;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 22453;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 22454;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 22455;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 22475;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22522;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22524;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22525;

        /// <remarks />
        public const uint ServerConfigurationType_UpdateCertificate = 12616;

        /// <remarks />
        public const uint ServerConfigurationType_GetCertificates = 32296;

        /// <remarks />
        public const uint ServerConfigurationType_ApplyChanges = 12734;

        /// <remarks />
        public const uint ServerConfigurationType_CancelChanges = 25698;

        /// <remarks />
        public const uint ServerConfigurationType_CreateSigningRequest = 12731;

        /// <remarks />
        public const uint ServerConfigurationType_GetRejectedList = 12775;

        /// <remarks />
        public const uint ServerConfigurationType_ResetToServerDefaults = 25699;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 12647;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 12650;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 12652;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 12655;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 12657;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 12660;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 12663;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 12666;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 12668;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 12670;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 22601;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 22602;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 22603;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 22623;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 22670;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 22672;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 22673;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 22749;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 22750;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 22751;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 22771;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22818;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22820;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22821;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 14095;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 14098;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 14100;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 14103;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 14105;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 14108;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 14111;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 14114;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 14117;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 14119;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 22897;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 22898;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 22899;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 22919;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 22966;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 22968;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 22969;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 23045;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 23046;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 23047;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 23067;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 23114;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 23116;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 23117;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 14129;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 14132;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 14134;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 14137;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 14139;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 14142;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 14145;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 14148;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 14151;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 14153;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 23193;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 23194;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 23195;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 23215;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 23262;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 23264;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 23265;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 23341;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 23342;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 23343;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 23363;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 23410;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 23412;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 23413;

        /// <remarks />
        public const uint ServerConfiguration_UpdateCertificate = 13737;

        /// <remarks />
        public const uint ServerConfiguration_ApplyChanges = 12740;

        /// <remarks />
        public const uint ServerConfiguration_CancelChanges = 25708;

        /// <remarks />
        public const uint ServerConfiguration_CreateSigningRequest = 12737;

        /// <remarks />
        public const uint ServerConfiguration_GetRejectedList = 12777;

        /// <remarks />
        public const uint ServerConfiguration_ResetToServerDefaults = 25709;

        /// <remarks />
        public const uint ServerConfiguration_SetAdminPassword = 25710;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_CreateCredential = 17522;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_GetEncryptingKey = 17534;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_UpdateCredential = 18006;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_DeleteCredential = 18008;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityKeys = 15907;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityGroup = 15910;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroup = 15914;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup = 15917;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_AddPushTarget = 25278;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_RemovePushTarget = 25281;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup = 15454;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup = 15457;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder = 25293;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder = 25296;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroup = 15461;

        /// <remarks />
        public const uint SecurityGroupFolderType_RemoveSecurityGroup = 15464;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroupFolder = 25312;

        /// <remarks />
        public const uint SecurityGroupFolderType_RemoveSecurityGroupFolder = 25315;

        /// <remarks />
        public const uint SecurityGroupType_InvalidateKeys = 25624;

        /// <remarks />
        public const uint SecurityGroupType_ForceKeyRotation = 25625;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_ConnectSecurityGroups = 25641;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_DisconnectSecurityGroups = 25644;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_TriggerKeyUpdate = 25647;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget = 25348;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget = 25351;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder = 25353;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder = 25356;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups = 25655;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups = 25658;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate = 25661;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTarget = 25366;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_RemovePushTarget = 25369;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTargetFolder = 25371;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_RemovePushTargetFolder = 25374;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroup = 15435;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_RemoveSecurityGroup = 15438;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_AddPushTarget = 25393;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_RemovePushTarget = 25396;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset = 18679;

        /// <remarks />
        public const uint PublishSubscribeType_SetSecurityKeys = 17296;

        /// <remarks />
        public const uint PublishSubscribeType_AddConnection = 16598;

        /// <remarks />
        public const uint PublishSubscribeType_RemoveConnection = 14432;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Open = 25411;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Close = 25414;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Read = 25416;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Write = 25419;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_GetPosition = 25421;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_SetPosition = 25424;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_ReserveIds = 25426;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_CloseAndUpdate = 25429;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Reset = 18727;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityKeys = 15215;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityGroup = 15440;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroup = 15444;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_RemoveSecurityGroup = 15447;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_AddPushTarget = 25441;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_RemovePushTarget = 25444;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset = 16076;

        /// <remarks />
        public const uint PublishSubscribe_SetSecurityKeys = 17364;

        /// <remarks />
        public const uint PublishSubscribe_AddConnection = 17366;

        /// <remarks />
        public const uint PublishSubscribe_RemoveConnection = 17369;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Open = 25459;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Close = 25462;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Read = 25464;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Write = 25467;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_GetPosition = 25469;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_SetPosition = 25472;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_ReserveIds = 25474;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_CloseAndUpdate = 25477;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Reset = 17421;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityKeys = 32406;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityGroup = 32409;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_AddSecurityGroup = 32413;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_RemoveSecurityGroup = 32416;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_AddPushTarget = 32425;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_RemovePushTarget = 32428;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Reset = 32464;

        /// <remarks />
        public const uint DataSetClasses_SetSecurityKeys = 32508;

        /// <remarks />
        public const uint DataSetClasses_AddConnection = 32510;

        /// <remarks />
        public const uint DataSetClasses_RemoveConnection = 32513;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Open = 32554;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Close = 32557;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Read = 32559;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Write = 32562;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_GetPosition = 32564;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_SetPosition = 32567;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_ReserveIds = 32569;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_CloseAndUpdate = 32572;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Reset = 32591;

        /// <remarks />
        public const uint PubSubConfigurationType_ReserveIds = 25505;

        /// <remarks />
        public const uint PubSubConfigurationType_CloseAndUpdate = 25508;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset = 18883;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields_AddExtensionField = 15482;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields_RemoveExtensionField = 15485;

        /// <remarks />
        public const uint ExtensionFieldsType_AddExtensionField = 15491;

        /// <remarks />
        public const uint ExtensionFieldsType_RemoveExtensionField = 15494;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset = 18942;

        /// <remarks />
        public const uint PublishedDataItemsType_ExtensionFields_AddExtensionField = 15504;

        /// <remarks />
        public const uint PublishedDataItemsType_ExtensionFields_RemoveExtensionField = 15507;

        /// <remarks />
        public const uint PublishedDataItemsType_AddVariables = 14555;

        /// <remarks />
        public const uint PublishedDataItemsType_RemoveVariables = 14558;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset = 19001;

        /// <remarks />
        public const uint PublishedEventsType_ExtensionFields_AddExtensionField = 15512;

        /// <remarks />
        public const uint PublishedEventsType_ExtensionFields_RemoveExtensionField = 15515;

        /// <remarks />
        public const uint PublishedEventsType_ModifyFieldSelection = 15052;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems = 14479;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents = 14482;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate = 16842;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate = 16881;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet = 14485;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder = 16884;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder = 16923;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField = 15474;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField = 15477;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItems = 14493;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEvents = 14496;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItemsTemplate = 16935;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEventsTemplate = 16960;

        /// <remarks />
        public const uint DataSetFolderType_RemovePublishedDataSet = 14499;

        /// <remarks />
        public const uint DataSetFolderType_AddDataSetFolder = 16994;

        /// <remarks />
        public const uint DataSetFolderType_RemoveDataSetFolder = 16997;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset = 19119;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset = 19188;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Reset = 19253;

        /// <remarks />
        public const uint PubSubConnectionType_AddWriterGroup = 17427;

        /// <remarks />
        public const uint PubSubConnectionType_AddReaderGroup = 17465;

        /// <remarks />
        public const uint PubSubConnectionType_RemoveGroup = 14225;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset = 17765;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Reset = 17824;

        /// <remarks />
        public const uint WriterGroupType_AddDataSetWriter = 17969;

        /// <remarks />
        public const uint WriterGroupType_RemoveDataSetWriter = 17992;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset = 18104;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Reset = 21027;

        /// <remarks />
        public const uint ReaderGroupType_AddDataSetReader = 21082;

        /// <remarks />
        public const uint ReaderGroupType_RemoveDataSetReader = 21085;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Reset = 19562;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Reset = 19621;

        /// <remarks />
        public const uint DataSetReaderType_CreateTargetVariables = 17386;

        /// <remarks />
        public const uint DataSetReaderType_CreateDataSetMirror = 17389;

        /// <remarks />
        public const uint TargetVariablesType_AddTargetVariables = 15115;

        /// <remarks />
        public const uint TargetVariablesType_RemoveTargetVariables = 15118;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet = 23797;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet = 23800;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder = 23802;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder = 23805;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddSubscribedDataSet = 23811;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_RemoveSubscribedDataSet = 23814;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddDataSetFolder = 23816;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_RemoveDataSetFolder = 23819;

        /// <remarks />
        public const uint PubSubStatusType_Enable = 14645;

        /// <remarks />
        public const uint PubSubStatusType_Disable = 14646;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Reset = 19689;

        /// <remarks />
        public const uint AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias = 23459;

        /// <remarks />
        public const uint AliasNameCategoryType_FindAlias = 23462;

        /// <remarks />
        public const uint Aliases_SubAliasNameCategories_Placeholder_FindAlias = 23473;

        /// <remarks />
        public const uint Aliases_FindAlias = 23476;

        /// <remarks />
        public const uint TagVariables_SubAliasNameCategories_Placeholder_FindAlias = 23482;

        /// <remarks />
        public const uint TagVariables_FindAlias = 23485;

        /// <remarks />
        public const uint Topics_SubAliasNameCategories_Placeholder_FindAlias = 23491;

        /// <remarks />
        public const uint Topics_FindAlias = 23494;

        /// <remarks />
        public const uint UserManagementType_AddUser = 24269;

        /// <remarks />
        public const uint UserManagementType_ModifyUser = 24271;

        /// <remarks />
        public const uint UserManagementType_RemoveUser = 24273;

        /// <remarks />
        public const uint UserManagementType_ChangePassword = 24275;

        /// <remarks />
        public const uint UserManagement_AddUser = 24304;

        /// <remarks />
        public const uint UserManagement_ModifyUser = 24306;

        /// <remarks />
        public const uint UserManagement_RemoveUser = 24308;

        /// <remarks />
        public const uint UserManagement_ChangePassword = 24310;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 25742;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 25745;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 25747;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 25750;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 25752;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 25755;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 25760;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 25763;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 25766;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 25768;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 25807;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 25808;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 25809;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 25829;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 25876;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 25880;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 25883;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 25973;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 25974;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 25975;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 25995;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 26042;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 26046;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 26049;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 26114;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 26117;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 26119;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 26122;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 26124;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 26127;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 26132;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 26135;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 26138;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 26140;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 26179;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 26180;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 26181;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 26201;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 26248;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 26252;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 26255;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 26345;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 26346;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 26347;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 26367;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 26414;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 26418;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 26421;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 26486;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 26489;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 26491;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 26494;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 26496;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 26499;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 26504;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 26507;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 26510;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 26512;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 26551;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 26552;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 26553;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 26573;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 26620;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 26624;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 26627;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 26717;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 26718;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 26719;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 26739;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 26786;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 26790;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 26793;

        /// <remarks />
        public const uint ProvisionableDeviceType_RequestTickets = 26873;

        /// <remarks />
        public const uint ProvisionableDeviceType_SetRegistrarEndpoints = 26875;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 26889;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 26892;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 26894;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 26897;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 26899;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 26902;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 26907;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 26910;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 26913;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 26915;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 26954;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 26955;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 26956;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 26976;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 27023;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 27027;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 27030;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 27120;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 27121;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 27122;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 27142;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 27189;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 27193;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 27196;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 27261;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 27264;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 27266;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 27269;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 27271;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 27274;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 27279;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 27282;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 27285;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 27287;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 27326;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 27327;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 27328;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 27348;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 27395;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 27399;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 27402;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 27492;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 27493;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 27494;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 27514;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 27561;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 27565;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 27568;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 27633;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 27636;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 27638;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 27641;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 27643;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 27646;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 27651;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 27654;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 27657;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 27659;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 27698;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 27699;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 27700;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 27720;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 27767;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 27771;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 27774;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 27864;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 27865;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 27866;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 27886;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 27933;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 27937;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 27940;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate = 28005;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges = 28008;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest = 28010;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList = 28013;

        /// <remarks />
        public const uint ProvisionableDevice_RequestTickets = 29880;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 29896;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 29899;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 29901;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 29904;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 29906;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 29909;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 29914;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 29917;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 29920;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 29922;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 29961;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 29962;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 29963;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 29983;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 30030;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 30034;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 30037;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 30127;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 30128;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 30129;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 30149;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 30196;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 30200;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 30203;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 30268;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 30271;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 30273;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 30276;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 30278;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 30281;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 30286;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 30289;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 30292;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 30294;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 30333;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 30334;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 30335;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 30355;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 30402;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 30406;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 30409;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 30499;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 30500;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 30501;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 30521;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 30568;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 30572;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 30575;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 30640;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 30643;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 30645;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 30648;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 30650;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 30653;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 30658;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 30661;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 30664;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 30666;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 30705;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 30706;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 30707;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 30727;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 30774;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 30778;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 30781;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 30871;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 30872;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 30873;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 30893;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 30940;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 30944;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 30947;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate = 31384;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_ApplyChanges = 31387;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest = 31389;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList = 31392;

        /// <remarks />
        public const uint PriorityMappingTableType_AddPriorityMappingEntry = 25229;

        /// <remarks />
        public const uint PriorityMappingTableType_DeletePriorityMappingEntry = 25231;
    }
    #endregion

    #region Object Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Objects
    {
        /// <remarks />
        public const uint DefaultBinary = 3062;

        /// <remarks />
        public const uint DefaultXml = 3063;

        /// <remarks />
        public const uint ModellingRule_Mandatory = 78;

        /// <remarks />
        public const uint ModellingRule_Optional = 80;

        /// <remarks />
        public const uint ModellingRule_ExposesItsArray = 83;

        /// <remarks />
        public const uint ModellingRule_OptionalPlaceholder = 11508;

        /// <remarks />
        public const uint ModellingRule_MandatoryPlaceholder = 11510;

        /// <remarks />
        public const uint RootFolder = 84;

        /// <remarks />
        public const uint ObjectsFolder = 85;

        /// <remarks />
        public const uint TypesFolder = 86;

        /// <remarks />
        public const uint ViewsFolder = 87;

        /// <remarks />
        public const uint ObjectTypesFolder = 88;

        /// <remarks />
        public const uint VariableTypesFolder = 89;

        /// <remarks />
        public const uint DataTypesFolder = 90;

        /// <remarks />
        public const uint ReferenceTypesFolder = 91;

        /// <remarks />
        public const uint XmlSchema_TypeSystem = 92;

        /// <remarks />
        public const uint OPCBinarySchema_TypeSystem = 93;

        /// <remarks />
        public const uint OPCUANamespaceMetadata = 15957;

        /// <remarks />
        public const uint ServerType_ServerCapabilities = 2009;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_ModellingRules = 3093;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_AggregateFunctions = 3094;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics = 2010;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary = 3111;

        /// <remarks />
        public const uint ServerType_VendorServerInfo = 2011;

        /// <remarks />
        public const uint ServerType_ServerRedundancy = 2012;

        /// <remarks />
        public const uint ServerType_Namespaces = 11527;

        /// <remarks />
        public const uint ServerCapabilitiesType_OperationLimits = 11551;

        /// <remarks />
        public const uint ServerCapabilitiesType_ModellingRules = 2019;

        /// <remarks />
        public const uint ServerCapabilitiesType_AggregateFunctions = 2754;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet = 16295;

        /// <remarks />
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary = 2744;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder = 12097;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile = 11624;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder = 11646;

        /// <remarks />
        public const uint EventTypesFolder = 3048;

        /// <remarks />
        public const uint Locations = 31915;

        /// <remarks />
        public const uint Server = 2253;

        /// <remarks />
        public const uint Server_ServerCapabilities = 2268;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits = 11704;

        /// <remarks />
        public const uint Server_ServerCapabilities_ModellingRules = 2996;

        /// <remarks />
        public const uint Server_ServerCapabilities_AggregateFunctions = 2997;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet = 15606;

        /// <remarks />
        public const uint Server_ServerDiagnostics = 2274;

        /// <remarks />
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary = 3706;

        /// <remarks />
        public const uint Server_VendorServerInfo = 2295;

        /// <remarks />
        public const uint Server_ServerRedundancy = 2296;

        /// <remarks />
        public const uint Server_Namespaces = 11715;

        /// <remarks />
        public const uint HistoryServerCapabilities = 11192;

        /// <remarks />
        public const uint HistoryServerCapabilities_AggregateFunctions = 11201;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder = 13354;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder = 13366;

        /// <remarks />
        public const uint FileSystem = 16314;

        /// <remarks />
        public const uint TemporaryFileTransferType_TransferState_Placeholder = 15754;

        /// <remarks />
        public const uint FileTransferStateMachineType_Idle = 15815;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepare = 15817;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransfer = 15819;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWrite = 15821;

        /// <remarks />
        public const uint FileTransferStateMachineType_Error = 15823;

        /// <remarks />
        public const uint FileTransferStateMachineType_IdleToReadPrepare = 15825;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepareToReadTransfer = 15827;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransferToIdle = 15829;

        /// <remarks />
        public const uint FileTransferStateMachineType_IdleToApplyWrite = 15831;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWriteToIdle = 15833;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepareToError = 15835;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransferToError = 15837;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWriteToError = 15839;

        /// <remarks />
        public const uint FileTransferStateMachineType_ErrorToIdle = 15841;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder = 15608;

        /// <remarks />
        public const uint WellKnownRole_Anonymous = 15644;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser = 15656;

        /// <remarks />
        public const uint WellKnownRole_Observer = 15668;

        /// <remarks />
        public const uint WellKnownRole_Operator = 15680;

        /// <remarks />
        public const uint WellKnownRole_Engineer = 16036;

        /// <remarks />
        public const uint WellKnownRole_Supervisor = 15692;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin = 15716;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin = 15704;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin = 25565;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess = 25603;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush = 25584;

        /// <remarks />
        public const uint DictionaryEntryType_DictionaryEntryName_Placeholder = 17590;

        /// <remarks />
        public const uint DictionaryFolderType_DictionaryFolderName_Placeholder = 17592;

        /// <remarks />
        public const uint DictionaryFolderType_DictionaryEntryName_Placeholder = 17593;

        /// <remarks />
        public const uint Dictionaries = 17594;

        /// <remarks />
        public const uint InterfaceTypes = 17708;

        /// <remarks />
        public const uint OrderedListType_OrderedObject_Placeholder = 23519;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState = 9178;

        /// <remarks />
        public const uint AlarmConditionType_FirstInGroup = 16398;

        /// <remarks />
        public const uint AlarmConditionType_AlarmGroup_Placeholder = 16399;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder = 16406;

        /// <remarks />
        public const uint ShelvedStateMachineType_Unshelved = 2930;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelved = 2932;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelved = 2933;

        /// <remarks />
        public const uint ShelvedStateMachineType_UnshelvedToTimedShelved = 2935;

        /// <remarks />
        public const uint ShelvedStateMachineType_UnshelvedToOneShotShelved = 2936;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelvedToUnshelved = 2940;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelvedToOneShotShelved = 2942;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelvedToUnshelved = 2943;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelvedToTimedShelved = 2945;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighHigh = 9329;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_High = 9331;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_Low = 9333;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowLow = 9335;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowLowToLow = 9337;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowToLowLow = 9338;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighHighToHigh = 9339;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighToHighHigh = 9340;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState = 9455;

        /// <remarks />
        public const uint ProgramStateMachineType_FinalResultData = 3850;

        /// <remarks />
        public const uint ProgramStateMachineType_Halted = 2406;

        /// <remarks />
        public const uint ProgramStateMachineType_Ready = 2400;

        /// <remarks />
        public const uint ProgramStateMachineType_Running = 2402;

        /// <remarks />
        public const uint ProgramStateMachineType_Suspended = 2404;

        /// <remarks />
        public const uint ProgramStateMachineType_HaltedToReady = 2408;

        /// <remarks />
        public const uint ProgramStateMachineType_ReadyToRunning = 2410;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToHalted = 2412;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToReady = 2414;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToSuspended = 2416;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToRunning = 2418;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToHalted = 2420;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToReady = 2422;

        /// <remarks />
        public const uint ProgramStateMachineType_ReadyToHalted = 2424;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateConfiguration = 3059;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateFunctions = 11876;

        /// <remarks />
        public const uint HAConfiguration = 11202;

        /// <remarks />
        public const uint HAConfiguration_AggregateConfiguration = 11203;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_AggregateFunctions = 11172;

        /// <remarks />
        public const uint CertificateGroupType_TrustList = 13599;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired = 19450;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate = 20143;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup = 13814;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList = 13815;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup = 13848;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList = 13849;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup = 13882;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList = 13883;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder = 13916;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList = 13917;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups = 13950;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup = 13951;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList = 13952;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList = 13986;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList = 14020;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics = 32299;

        /// <remarks />
        public const uint ServerConfiguration = 12637;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups = 14053;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup = 14156;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList = 12642;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup = 14088;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList = 14089;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup = 14122;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList = 14123;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder = 17511;

        /// <remarks />
        public const uint KeyCredentialConfiguration = 18155;

        /// <remarks />
        public const uint AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder = 23557;

        /// <remarks />
        public const uint AuthorizationServices = 17732;

        /// <remarks />
        public const uint AggregateFunction_Interpolative = 2341;

        /// <remarks />
        public const uint AggregateFunction_Average = 2342;

        /// <remarks />
        public const uint AggregateFunction_TimeAverage = 2343;

        /// <remarks />
        public const uint AggregateFunction_TimeAverage2 = 11285;

        /// <remarks />
        public const uint AggregateFunction_Total = 2344;

        /// <remarks />
        public const uint AggregateFunction_Total2 = 11304;

        /// <remarks />
        public const uint AggregateFunction_Minimum = 2346;

        /// <remarks />
        public const uint AggregateFunction_Maximum = 2347;

        /// <remarks />
        public const uint AggregateFunction_MinimumActualTime = 2348;

        /// <remarks />
        public const uint AggregateFunction_MaximumActualTime = 2349;

        /// <remarks />
        public const uint AggregateFunction_Range = 2350;

        /// <remarks />
        public const uint AggregateFunction_Minimum2 = 11286;

        /// <remarks />
        public const uint AggregateFunction_Maximum2 = 11287;

        /// <remarks />
        public const uint AggregateFunction_MinimumActualTime2 = 11305;

        /// <remarks />
        public const uint AggregateFunction_MaximumActualTime2 = 11306;

        /// <remarks />
        public const uint AggregateFunction_Range2 = 11288;

        /// <remarks />
        public const uint AggregateFunction_AnnotationCount = 2351;

        /// <remarks />
        public const uint AggregateFunction_Count = 2352;

        /// <remarks />
        public const uint AggregateFunction_DurationInStateZero = 11307;

        /// <remarks />
        public const uint AggregateFunction_DurationInStateNonZero = 11308;

        /// <remarks />
        public const uint AggregateFunction_NumberOfTransitions = 2355;

        /// <remarks />
        public const uint AggregateFunction_Start = 2357;

        /// <remarks />
        public const uint AggregateFunction_End = 2358;

        /// <remarks />
        public const uint AggregateFunction_Delta = 2359;

        /// <remarks />
        public const uint AggregateFunction_StartBound = 11505;

        /// <remarks />
        public const uint AggregateFunction_EndBound = 11506;

        /// <remarks />
        public const uint AggregateFunction_DeltaBounds = 11507;

        /// <remarks />
        public const uint AggregateFunction_DurationGood = 2360;

        /// <remarks />
        public const uint AggregateFunction_DurationBad = 2361;

        /// <remarks />
        public const uint AggregateFunction_PercentGood = 2362;

        /// <remarks />
        public const uint AggregateFunction_PercentBad = 2363;

        /// <remarks />
        public const uint AggregateFunction_WorstQuality = 2364;

        /// <remarks />
        public const uint AggregateFunction_WorstQuality2 = 11292;

        /// <remarks />
        public const uint AggregateFunction_StandardDeviationSample = 11426;

        /// <remarks />
        public const uint AggregateFunction_StandardDeviationPopulation = 11427;

        /// <remarks />
        public const uint AggregateFunction_VarianceSample = 11428;

        /// <remarks />
        public const uint AggregateFunction_VariancePopulation = 11429;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups = 15913;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets = 25277;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder = 15453;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder = 15459;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder = 25626;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder = 25347;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder = 25358;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder = 14417;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Address = 14423;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Status = 14419;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters = 18681;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues = 18712;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets = 14434;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets = 23622;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration = 25403;

        /// <remarks />
        public const uint PublishSubscribeType_Status = 15844;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics = 18715;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters = 18729;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues = 18760;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities = 23642;

        /// <remarks />
        public const uint PublishSubscribeType_DataSetClasses = 23649;

        /// <remarks />
        public const uint PublishSubscribe = 14443;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups = 15443;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets = 25440;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Address = 15851;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Status = 15865;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters = 16102;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues = 17352;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets = 17371;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets = 23658;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration = 25451;

        /// <remarks />
        public const uint PublishSubscribe_Status = 17405;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics = 17409;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters = 17423;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues = 17457;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities = 23678;

        /// <remarks />
        public const uint PublishSubscribe_DataSetClasses = 23685;

        /// <remarks />
        public const uint DataSetClasses = 32405;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups = 32412;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets = 32424;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Address = 32442;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Status = 32448;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters = 32466;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues = 32497;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets = 32515;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets = 32535;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration = 32546;

        /// <remarks />
        public const uint DataSetClasses_Status = 32575;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics = 32579;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters = 32593;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues = 32624;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities = 32633;

        /// <remarks />
        public const uint DataSetClasses_DataSetClasses = 32644;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder = 15222;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Status = 15223;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters = 18885;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 18916;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields = 15481;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Status = 15231;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters = 18944;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 18975;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Status = 15239;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters = 19003;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 19034;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder = 14478;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder = 14487;

        /// <remarks />
        public const uint PubSubConnectionType_Address = 14221;

        /// <remarks />
        public const uint PubSubConnectionType_TransportSettings = 17203;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder = 17310;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Status = 17314;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters = 19121;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues = 19152;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder = 17325;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Status = 17329;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters = 19190;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues = 19221;

        /// <remarks />
        public const uint PubSubConnectionType_Status = 14600;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics = 19241;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters = 19255;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_LiveValues = 19286;

        /// <remarks />
        public const uint PubSubGroupType_Status = 15265;

        /// <remarks />
        public const uint WriterGroupType_TransportSettings = 17741;

        /// <remarks />
        public const uint WriterGroupType_MessageSettings = 17742;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder = 17743;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Status = 17749;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters = 17767;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 17798;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics = 17812;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters = 17826;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues = 17858;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder = 18076;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Status = 18088;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters = 18106;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues = 18137;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet = 21006;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics = 21015;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters = 21029;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_LiveValues = 21060;

        /// <remarks />
        public const uint ReaderGroupType_TransportSettings = 21080;

        /// <remarks />
        public const uint ReaderGroupType_MessageSettings = 21081;

        /// <remarks />
        public const uint DataSetWriterType_TransportSettings = 15303;

        /// <remarks />
        public const uint DataSetWriterType_MessageSettings = 21095;

        /// <remarks />
        public const uint DataSetWriterType_Status = 15299;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics = 19550;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters = 19564;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_LiveValues = 19595;

        /// <remarks />
        public const uint DataSetReaderType_TransportSettings = 15311;

        /// <remarks />
        public const uint DataSetReaderType_MessageSettings = 21103;

        /// <remarks />
        public const uint DataSetReaderType_Status = 15307;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics = 19609;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters = 19623;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues = 19654;

        /// <remarks />
        public const uint DataSetReaderType_SubscribedDataSet = 15316;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder = 23796;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder = 23807;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet = 23808;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetType_SubscribedDataSet = 23829;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters = 19691;

        /// <remarks />
        public const uint PubSubDiagnosticsType_LiveValues = 19722;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues = 19777;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_LiveValues = 19831;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters = 19848;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues = 19879;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters = 19917;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues = 19948;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters = 19982;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues = 20013;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters = 20041;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues = 20072;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DiscoveryAddress = 15072;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_Address = 23842;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_Address = 24017;

        /// <remarks />
        public const uint AliasNameCategoryType_Alias_Placeholder = 23457;

        /// <remarks />
        public const uint AliasNameCategoryType_SubAliasNameCategories_Placeholder = 23458;

        /// <remarks />
        public const uint Aliases = 23470;

        /// <remarks />
        public const uint TagVariables = 23479;

        /// <remarks />
        public const uint Topics = 23488;

        /// <remarks />
        public const uint UserManagement = 24290;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup = 25733;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList = 25734;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList = 26106;

        /// <remarks />
        public const uint ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList = 26478;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder = 26878;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups = 26879;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup = 26880;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList = 26881;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList = 27253;

        /// <remarks />
        public const uint ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList = 27625;

        /// <remarks />
        public const uint ProvisionableDevice = 29878;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups = 29886;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup = 29887;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList = 29888;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList = 30260;

        /// <remarks />
        public const uint ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList = 30632;

        /// <remarks />
        public const uint Resources = 24226;

        /// <remarks />
        public const uint Communication = 24227;

        /// <remarks />
        public const uint MappingTables = 24228;

        /// <remarks />
        public const uint NetworkInterfaces = 24229;

        /// <remarks />
        public const uint Streams = 24230;

        /// <remarks />
        public const uint TalkerStreams = 24231;

        /// <remarks />
        public const uint ListenerStreams = 24232;

        /// <remarks />
        public const uint IetfBaseNetworkInterfaceType_InterfaceName_Placeholder = 25226;

        /// <remarks />
        public const uint Union_Encoding_DefaultBinary = 12766;

        /// <remarks />
        public const uint KeyValuePair_Encoding_DefaultBinary = 14846;

        /// <remarks />
        public const uint AdditionalParametersType_Encoding_DefaultBinary = 17537;

        /// <remarks />
        public const uint EphemeralKeyType_Encoding_DefaultBinary = 17549;

        /// <remarks />
        public const uint EndpointType_Encoding_DefaultBinary = 15671;

        /// <remarks />
        public const uint RationalNumber_Encoding_DefaultBinary = 18815;

        /// <remarks />
        public const uint Vector_Encoding_DefaultBinary = 18816;

        /// <remarks />
        public const uint ThreeDVector_Encoding_DefaultBinary = 18817;

        /// <remarks />
        public const uint CartesianCoordinates_Encoding_DefaultBinary = 18818;

        /// <remarks />
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultBinary = 18819;

        /// <remarks />
        public const uint Orientation_Encoding_DefaultBinary = 18820;

        /// <remarks />
        public const uint ThreeDOrientation_Encoding_DefaultBinary = 18821;

        /// <remarks />
        public const uint Frame_Encoding_DefaultBinary = 18822;

        /// <remarks />
        public const uint ThreeDFrame_Encoding_DefaultBinary = 18823;

        /// <remarks />
        public const uint IdentityMappingRuleType_Encoding_DefaultBinary = 15736;

        /// <remarks />
        public const uint CurrencyUnitType_Encoding_DefaultBinary = 23507;

        /// <remarks />
        public const uint TrustListDataType_Encoding_DefaultBinary = 12680;

        /// <remarks />
        public const uint TransactionErrorType_Encoding_DefaultBinary = 32382;

        /// <remarks />
        public const uint DecimalDataType_Encoding_DefaultBinary = 17863;

        /// <remarks />
        public const uint DataTypeSchemaHeader_Encoding_DefaultBinary = 15676;

        /// <remarks />
        public const uint DataTypeDescription_Encoding_DefaultBinary = 125;

        /// <remarks />
        public const uint StructureDescription_Encoding_DefaultBinary = 126;

        /// <remarks />
        public const uint EnumDescription_Encoding_DefaultBinary = 127;

        /// <remarks />
        public const uint SimpleTypeDescription_Encoding_DefaultBinary = 15421;

        /// <remarks />
        public const uint UABinaryFileDataType_Encoding_DefaultBinary = 15422;

        /// <remarks />
        public const uint PortableQualifiedName_Encoding_DefaultBinary = 24108;

        /// <remarks />
        public const uint PortableNodeId_Encoding_DefaultBinary = 24109;

        /// <remarks />
        public const uint UnsignedRationalNumber_Encoding_DefaultBinary = 24110;

        /// <remarks />
        public const uint DataSetMetaDataType_Encoding_DefaultBinary = 124;

        /// <remarks />
        public const uint FieldMetaData_Encoding_DefaultBinary = 14839;

        /// <remarks />
        public const uint ConfigurationVersionDataType_Encoding_DefaultBinary = 14847;

        /// <remarks />
        public const uint PublishedDataSetDataType_Encoding_DefaultBinary = 15677;

        /// <remarks />
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultBinary = 15678;

        /// <remarks />
        public const uint PublishedVariableDataType_Encoding_DefaultBinary = 14323;

        /// <remarks />
        public const uint PublishedDataItemsDataType_Encoding_DefaultBinary = 15679;

        /// <remarks />
        public const uint PublishedEventsDataType_Encoding_DefaultBinary = 15681;

        /// <remarks />
        public const uint PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary = 25529;

        /// <remarks />
        public const uint DataSetWriterDataType_Encoding_DefaultBinary = 15682;

        /// <remarks />
        public const uint DataSetWriterTransportDataType_Encoding_DefaultBinary = 15683;

        /// <remarks />
        public const uint DataSetWriterMessageDataType_Encoding_DefaultBinary = 15688;

        /// <remarks />
        public const uint PubSubGroupDataType_Encoding_DefaultBinary = 15689;

        /// <remarks />
        public const uint WriterGroupDataType_Encoding_DefaultBinary = 21150;

        /// <remarks />
        public const uint WriterGroupTransportDataType_Encoding_DefaultBinary = 15691;

        /// <remarks />
        public const uint WriterGroupMessageDataType_Encoding_DefaultBinary = 15693;

        /// <remarks />
        public const uint PubSubConnectionDataType_Encoding_DefaultBinary = 15694;

        /// <remarks />
        public const uint ConnectionTransportDataType_Encoding_DefaultBinary = 15695;

        /// <remarks />
        public const uint NetworkAddressDataType_Encoding_DefaultBinary = 21151;

        /// <remarks />
        public const uint NetworkAddressUrlDataType_Encoding_DefaultBinary = 21152;

        /// <remarks />
        public const uint ReaderGroupDataType_Encoding_DefaultBinary = 21153;

        /// <remarks />
        public const uint ReaderGroupTransportDataType_Encoding_DefaultBinary = 15701;

        /// <remarks />
        public const uint ReaderGroupMessageDataType_Encoding_DefaultBinary = 15702;

        /// <remarks />
        public const uint DataSetReaderDataType_Encoding_DefaultBinary = 15703;

        /// <remarks />
        public const uint DataSetReaderTransportDataType_Encoding_DefaultBinary = 15705;

        /// <remarks />
        public const uint DataSetReaderMessageDataType_Encoding_DefaultBinary = 15706;

        /// <remarks />
        public const uint SubscribedDataSetDataType_Encoding_DefaultBinary = 15707;

        /// <remarks />
        public const uint TargetVariablesDataType_Encoding_DefaultBinary = 15712;

        /// <remarks />
        public const uint FieldTargetDataType_Encoding_DefaultBinary = 14848;

        /// <remarks />
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultBinary = 15713;

        /// <remarks />
        public const uint PubSubConfigurationDataType_Encoding_DefaultBinary = 21154;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary = 23851;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary = 23852;

        /// <remarks />
        public const uint SecurityGroupDataType_Encoding_DefaultBinary = 23853;

        /// <remarks />
        public const uint PubSubKeyPushTargetDataType_Encoding_DefaultBinary = 25530;

        /// <remarks />
        public const uint PubSubConfiguration2DataType_Encoding_DefaultBinary = 23854;

        /// <remarks />
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultBinary = 15715;

        /// <remarks />
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultBinary = 15717;

        /// <remarks />
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultBinary = 15718;

        /// <remarks />
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultBinary = 15719;

        /// <remarks />
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultBinary = 15724;

        /// <remarks />
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultBinary = 15725;

        /// <remarks />
        public const uint QosDataType_Encoding_DefaultBinary = 23855;

        /// <remarks />
        public const uint TransmitQosDataType_Encoding_DefaultBinary = 23856;

        /// <remarks />
        public const uint TransmitQosPriorityDataType_Encoding_DefaultBinary = 23857;

        /// <remarks />
        public const uint ReceiveQosDataType_Encoding_DefaultBinary = 23860;

        /// <remarks />
        public const uint ReceiveQosPriorityDataType_Encoding_DefaultBinary = 23861;

        /// <remarks />
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultBinary = 17468;

        /// <remarks />
        public const uint DatagramConnectionTransport2DataType_Encoding_DefaultBinary = 23864;

        /// <remarks />
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultBinary = 21155;

        /// <remarks />
        public const uint DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary = 23865;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary = 23866;

        /// <remarks />
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultBinary = 15479;

        /// <remarks />
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultBinary = 15727;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary = 15729;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary = 15733;

        /// <remarks />
        public const uint PubSubConfigurationRefDataType_Encoding_DefaultBinary = 25531;

        /// <remarks />
        public const uint PubSubConfigurationValueDataType_Encoding_DefaultBinary = 25532;

        /// <remarks />
        public const uint AliasNameDataType_Encoding_DefaultBinary = 23499;

        /// <remarks />
        public const uint UserManagementDataType_Encoding_DefaultBinary = 24292;

        /// <remarks />
        public const uint PriorityMappingEntryType_Encoding_DefaultBinary = 25239;

        /// <remarks />
        public const uint ReferenceDescriptionDataType_Encoding_DefaultBinary = 32661;

        /// <remarks />
        public const uint ReferenceListEntryDataType_Encoding_DefaultBinary = 32662;

        /// <remarks />
        public const uint RolePermissionType_Encoding_DefaultBinary = 128;

        /// <remarks />
        public const uint DataTypeDefinition_Encoding_DefaultBinary = 121;

        /// <remarks />
        public const uint StructureField_Encoding_DefaultBinary = 14844;

        /// <remarks />
        public const uint StructureDefinition_Encoding_DefaultBinary = 122;

        /// <remarks />
        public const uint EnumDefinition_Encoding_DefaultBinary = 123;

        /// <remarks />
        public const uint Node_Encoding_DefaultBinary = 260;

        /// <remarks />
        public const uint InstanceNode_Encoding_DefaultBinary = 11889;

        /// <remarks />
        public const uint TypeNode_Encoding_DefaultBinary = 11890;

        /// <remarks />
        public const uint ObjectNode_Encoding_DefaultBinary = 263;

        /// <remarks />
        public const uint ObjectTypeNode_Encoding_DefaultBinary = 266;

        /// <remarks />
        public const uint VariableNode_Encoding_DefaultBinary = 269;

        /// <remarks />
        public const uint VariableTypeNode_Encoding_DefaultBinary = 272;

        /// <remarks />
        public const uint ReferenceTypeNode_Encoding_DefaultBinary = 275;

        /// <remarks />
        public const uint MethodNode_Encoding_DefaultBinary = 278;

        /// <remarks />
        public const uint ViewNode_Encoding_DefaultBinary = 281;

        /// <remarks />
        public const uint DataTypeNode_Encoding_DefaultBinary = 284;

        /// <remarks />
        public const uint ReferenceNode_Encoding_DefaultBinary = 287;

        /// <remarks />
        public const uint Argument_Encoding_DefaultBinary = 298;

        /// <remarks />
        public const uint EnumValueType_Encoding_DefaultBinary = 8251;

        /// <remarks />
        public const uint EnumField_Encoding_DefaultBinary = 14845;

        /// <remarks />
        public const uint OptionSet_Encoding_DefaultBinary = 12765;

        /// <remarks />
        public const uint TimeZoneDataType_Encoding_DefaultBinary = 8917;

        /// <remarks />
        public const uint ApplicationDescription_Encoding_DefaultBinary = 310;

        /// <remarks />
        public const uint RequestHeader_Encoding_DefaultBinary = 391;

        /// <remarks />
        public const uint ResponseHeader_Encoding_DefaultBinary = 394;

        /// <remarks />
        public const uint ServiceFault_Encoding_DefaultBinary = 397;

        /// <remarks />
        public const uint SessionlessInvokeRequestType_Encoding_DefaultBinary = 15903;

        /// <remarks />
        public const uint SessionlessInvokeResponseType_Encoding_DefaultBinary = 21001;

        /// <remarks />
        public const uint FindServersRequest_Encoding_DefaultBinary = 422;

        /// <remarks />
        public const uint FindServersResponse_Encoding_DefaultBinary = 425;

        /// <remarks />
        public const uint ServerOnNetwork_Encoding_DefaultBinary = 12207;

        /// <remarks />
        public const uint FindServersOnNetworkRequest_Encoding_DefaultBinary = 12208;

        /// <remarks />
        public const uint FindServersOnNetworkResponse_Encoding_DefaultBinary = 12209;

        /// <remarks />
        public const uint UserTokenPolicy_Encoding_DefaultBinary = 306;

        /// <remarks />
        public const uint EndpointDescription_Encoding_DefaultBinary = 314;

        /// <remarks />
        public const uint GetEndpointsRequest_Encoding_DefaultBinary = 428;

        /// <remarks />
        public const uint GetEndpointsResponse_Encoding_DefaultBinary = 431;

        /// <remarks />
        public const uint RegisteredServer_Encoding_DefaultBinary = 434;

        /// <remarks />
        public const uint RegisterServerRequest_Encoding_DefaultBinary = 437;

        /// <remarks />
        public const uint RegisterServerResponse_Encoding_DefaultBinary = 440;

        /// <remarks />
        public const uint DiscoveryConfiguration_Encoding_DefaultBinary = 12900;

        /// <remarks />
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultBinary = 12901;

        /// <remarks />
        public const uint RegisterServer2Request_Encoding_DefaultBinary = 12211;

        /// <remarks />
        public const uint RegisterServer2Response_Encoding_DefaultBinary = 12212;

        /// <remarks />
        public const uint ChannelSecurityToken_Encoding_DefaultBinary = 443;

        /// <remarks />
        public const uint OpenSecureChannelRequest_Encoding_DefaultBinary = 446;

        /// <remarks />
        public const uint OpenSecureChannelResponse_Encoding_DefaultBinary = 449;

        /// <remarks />
        public const uint CloseSecureChannelRequest_Encoding_DefaultBinary = 452;

        /// <remarks />
        public const uint CloseSecureChannelResponse_Encoding_DefaultBinary = 455;

        /// <remarks />
        public const uint SignedSoftwareCertificate_Encoding_DefaultBinary = 346;

        /// <remarks />
        public const uint SignatureData_Encoding_DefaultBinary = 458;

        /// <remarks />
        public const uint CreateSessionRequest_Encoding_DefaultBinary = 461;

        /// <remarks />
        public const uint CreateSessionResponse_Encoding_DefaultBinary = 464;

        /// <remarks />
        public const uint UserIdentityToken_Encoding_DefaultBinary = 318;

        /// <remarks />
        public const uint AnonymousIdentityToken_Encoding_DefaultBinary = 321;

        /// <remarks />
        public const uint UserNameIdentityToken_Encoding_DefaultBinary = 324;

        /// <remarks />
        public const uint X509IdentityToken_Encoding_DefaultBinary = 327;

        /// <remarks />
        public const uint IssuedIdentityToken_Encoding_DefaultBinary = 940;

        /// <remarks />
        public const uint ActivateSessionRequest_Encoding_DefaultBinary = 467;

        /// <remarks />
        public const uint ActivateSessionResponse_Encoding_DefaultBinary = 470;

        /// <remarks />
        public const uint CloseSessionRequest_Encoding_DefaultBinary = 473;

        /// <remarks />
        public const uint CloseSessionResponse_Encoding_DefaultBinary = 476;

        /// <remarks />
        public const uint CancelRequest_Encoding_DefaultBinary = 479;

        /// <remarks />
        public const uint CancelResponse_Encoding_DefaultBinary = 482;

        /// <remarks />
        public const uint NodeAttributes_Encoding_DefaultBinary = 351;

        /// <remarks />
        public const uint ObjectAttributes_Encoding_DefaultBinary = 354;

        /// <remarks />
        public const uint VariableAttributes_Encoding_DefaultBinary = 357;

        /// <remarks />
        public const uint MethodAttributes_Encoding_DefaultBinary = 360;

        /// <remarks />
        public const uint ObjectTypeAttributes_Encoding_DefaultBinary = 363;

        /// <remarks />
        public const uint VariableTypeAttributes_Encoding_DefaultBinary = 366;

        /// <remarks />
        public const uint ReferenceTypeAttributes_Encoding_DefaultBinary = 369;

        /// <remarks />
        public const uint DataTypeAttributes_Encoding_DefaultBinary = 372;

        /// <remarks />
        public const uint ViewAttributes_Encoding_DefaultBinary = 375;

        /// <remarks />
        public const uint GenericAttributeValue_Encoding_DefaultBinary = 17610;

        /// <remarks />
        public const uint GenericAttributes_Encoding_DefaultBinary = 17611;

        /// <remarks />
        public const uint AddNodesItem_Encoding_DefaultBinary = 378;

        /// <remarks />
        public const uint AddNodesResult_Encoding_DefaultBinary = 485;

        /// <remarks />
        public const uint AddNodesRequest_Encoding_DefaultBinary = 488;

        /// <remarks />
        public const uint AddNodesResponse_Encoding_DefaultBinary = 491;

        /// <remarks />
        public const uint AddReferencesItem_Encoding_DefaultBinary = 381;

        /// <remarks />
        public const uint AddReferencesRequest_Encoding_DefaultBinary = 494;

        /// <remarks />
        public const uint AddReferencesResponse_Encoding_DefaultBinary = 497;

        /// <remarks />
        public const uint DeleteNodesItem_Encoding_DefaultBinary = 384;

        /// <remarks />
        public const uint DeleteNodesRequest_Encoding_DefaultBinary = 500;

        /// <remarks />
        public const uint DeleteNodesResponse_Encoding_DefaultBinary = 503;

        /// <remarks />
        public const uint DeleteReferencesItem_Encoding_DefaultBinary = 387;

        /// <remarks />
        public const uint DeleteReferencesRequest_Encoding_DefaultBinary = 506;

        /// <remarks />
        public const uint DeleteReferencesResponse_Encoding_DefaultBinary = 509;

        /// <remarks />
        public const uint ViewDescription_Encoding_DefaultBinary = 513;

        /// <remarks />
        public const uint BrowseDescription_Encoding_DefaultBinary = 516;

        /// <remarks />
        public const uint ReferenceDescription_Encoding_DefaultBinary = 520;

        /// <remarks />
        public const uint BrowseResult_Encoding_DefaultBinary = 524;

        /// <remarks />
        public const uint BrowseRequest_Encoding_DefaultBinary = 527;

        /// <remarks />
        public const uint BrowseResponse_Encoding_DefaultBinary = 530;

        /// <remarks />
        public const uint BrowseNextRequest_Encoding_DefaultBinary = 533;

        /// <remarks />
        public const uint BrowseNextResponse_Encoding_DefaultBinary = 536;

        /// <remarks />
        public const uint RelativePathElement_Encoding_DefaultBinary = 539;

        /// <remarks />
        public const uint RelativePath_Encoding_DefaultBinary = 542;

        /// <remarks />
        public const uint BrowsePath_Encoding_DefaultBinary = 545;

        /// <remarks />
        public const uint BrowsePathTarget_Encoding_DefaultBinary = 548;

        /// <remarks />
        public const uint BrowsePathResult_Encoding_DefaultBinary = 551;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary = 554;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary = 557;

        /// <remarks />
        public const uint RegisterNodesRequest_Encoding_DefaultBinary = 560;

        /// <remarks />
        public const uint RegisterNodesResponse_Encoding_DefaultBinary = 563;

        /// <remarks />
        public const uint UnregisterNodesRequest_Encoding_DefaultBinary = 566;

        /// <remarks />
        public const uint UnregisterNodesResponse_Encoding_DefaultBinary = 569;

        /// <remarks />
        public const uint EndpointConfiguration_Encoding_DefaultBinary = 333;

        /// <remarks />
        public const uint QueryDataDescription_Encoding_DefaultBinary = 572;

        /// <remarks />
        public const uint NodeTypeDescription_Encoding_DefaultBinary = 575;

        /// <remarks />
        public const uint QueryDataSet_Encoding_DefaultBinary = 579;

        /// <remarks />
        public const uint NodeReference_Encoding_DefaultBinary = 582;

        /// <remarks />
        public const uint ContentFilterElement_Encoding_DefaultBinary = 585;

        /// <remarks />
        public const uint ContentFilter_Encoding_DefaultBinary = 588;

        /// <remarks />
        public const uint FilterOperand_Encoding_DefaultBinary = 591;

        /// <remarks />
        public const uint ElementOperand_Encoding_DefaultBinary = 594;

        /// <remarks />
        public const uint LiteralOperand_Encoding_DefaultBinary = 597;

        /// <remarks />
        public const uint AttributeOperand_Encoding_DefaultBinary = 600;

        /// <remarks />
        public const uint SimpleAttributeOperand_Encoding_DefaultBinary = 603;

        /// <remarks />
        public const uint ContentFilterElementResult_Encoding_DefaultBinary = 606;

        /// <remarks />
        public const uint ContentFilterResult_Encoding_DefaultBinary = 609;

        /// <remarks />
        public const uint ParsingResult_Encoding_DefaultBinary = 612;

        /// <remarks />
        public const uint QueryFirstRequest_Encoding_DefaultBinary = 615;

        /// <remarks />
        public const uint QueryFirstResponse_Encoding_DefaultBinary = 618;

        /// <remarks />
        public const uint QueryNextRequest_Encoding_DefaultBinary = 621;

        /// <remarks />
        public const uint QueryNextResponse_Encoding_DefaultBinary = 624;

        /// <remarks />
        public const uint ReadValueId_Encoding_DefaultBinary = 628;

        /// <remarks />
        public const uint ReadRequest_Encoding_DefaultBinary = 631;

        /// <remarks />
        public const uint ReadResponse_Encoding_DefaultBinary = 634;

        /// <remarks />
        public const uint HistoryReadValueId_Encoding_DefaultBinary = 637;

        /// <remarks />
        public const uint HistoryReadResult_Encoding_DefaultBinary = 640;

        /// <remarks />
        public const uint HistoryReadDetails_Encoding_DefaultBinary = 643;

        /// <remarks />
        public const uint ReadEventDetails_Encoding_DefaultBinary = 646;

        /// <remarks />
        public const uint ReadRawModifiedDetails_Encoding_DefaultBinary = 649;

        /// <remarks />
        public const uint ReadProcessedDetails_Encoding_DefaultBinary = 652;

        /// <remarks />
        public const uint ReadAtTimeDetails_Encoding_DefaultBinary = 655;

        /// <remarks />
        public const uint ReadAnnotationDataDetails_Encoding_DefaultBinary = 23500;

        /// <remarks />
        public const uint HistoryData_Encoding_DefaultBinary = 658;

        /// <remarks />
        public const uint ModificationInfo_Encoding_DefaultBinary = 11226;

        /// <remarks />
        public const uint HistoryModifiedData_Encoding_DefaultBinary = 11227;

        /// <remarks />
        public const uint HistoryEvent_Encoding_DefaultBinary = 661;

        /// <remarks />
        public const uint HistoryReadRequest_Encoding_DefaultBinary = 664;

        /// <remarks />
        public const uint HistoryReadResponse_Encoding_DefaultBinary = 667;

        /// <remarks />
        public const uint WriteValue_Encoding_DefaultBinary = 670;

        /// <remarks />
        public const uint WriteRequest_Encoding_DefaultBinary = 673;

        /// <remarks />
        public const uint WriteResponse_Encoding_DefaultBinary = 676;

        /// <remarks />
        public const uint HistoryUpdateDetails_Encoding_DefaultBinary = 679;

        /// <remarks />
        public const uint UpdateDataDetails_Encoding_DefaultBinary = 682;

        /// <remarks />
        public const uint UpdateStructureDataDetails_Encoding_DefaultBinary = 11300;

        /// <remarks />
        public const uint UpdateEventDetails_Encoding_DefaultBinary = 685;

        /// <remarks />
        public const uint DeleteRawModifiedDetails_Encoding_DefaultBinary = 688;

        /// <remarks />
        public const uint DeleteAtTimeDetails_Encoding_DefaultBinary = 691;

        /// <remarks />
        public const uint DeleteEventDetails_Encoding_DefaultBinary = 694;

        /// <remarks />
        public const uint HistoryUpdateResult_Encoding_DefaultBinary = 697;

        /// <remarks />
        public const uint HistoryUpdateRequest_Encoding_DefaultBinary = 700;

        /// <remarks />
        public const uint HistoryUpdateResponse_Encoding_DefaultBinary = 703;

        /// <remarks />
        public const uint CallMethodRequest_Encoding_DefaultBinary = 706;

        /// <remarks />
        public const uint CallMethodResult_Encoding_DefaultBinary = 709;

        /// <remarks />
        public const uint CallRequest_Encoding_DefaultBinary = 712;

        /// <remarks />
        public const uint CallResponse_Encoding_DefaultBinary = 715;

        /// <remarks />
        public const uint MonitoringFilter_Encoding_DefaultBinary = 721;

        /// <remarks />
        public const uint DataChangeFilter_Encoding_DefaultBinary = 724;

        /// <remarks />
        public const uint EventFilter_Encoding_DefaultBinary = 727;

        /// <remarks />
        public const uint AggregateConfiguration_Encoding_DefaultBinary = 950;

        /// <remarks />
        public const uint AggregateFilter_Encoding_DefaultBinary = 730;

        /// <remarks />
        public const uint MonitoringFilterResult_Encoding_DefaultBinary = 733;

        /// <remarks />
        public const uint EventFilterResult_Encoding_DefaultBinary = 736;

        /// <remarks />
        public const uint AggregateFilterResult_Encoding_DefaultBinary = 739;

        /// <remarks />
        public const uint MonitoringParameters_Encoding_DefaultBinary = 742;

        /// <remarks />
        public const uint MonitoredItemCreateRequest_Encoding_DefaultBinary = 745;

        /// <remarks />
        public const uint MonitoredItemCreateResult_Encoding_DefaultBinary = 748;

        /// <remarks />
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultBinary = 751;

        /// <remarks />
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultBinary = 754;

        /// <remarks />
        public const uint MonitoredItemModifyRequest_Encoding_DefaultBinary = 757;

        /// <remarks />
        public const uint MonitoredItemModifyResult_Encoding_DefaultBinary = 760;

        /// <remarks />
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultBinary = 763;

        /// <remarks />
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultBinary = 766;

        /// <remarks />
        public const uint SetMonitoringModeRequest_Encoding_DefaultBinary = 769;

        /// <remarks />
        public const uint SetMonitoringModeResponse_Encoding_DefaultBinary = 772;

        /// <remarks />
        public const uint SetTriggeringRequest_Encoding_DefaultBinary = 775;

        /// <remarks />
        public const uint SetTriggeringResponse_Encoding_DefaultBinary = 778;

        /// <remarks />
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultBinary = 781;

        /// <remarks />
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultBinary = 784;

        /// <remarks />
        public const uint CreateSubscriptionRequest_Encoding_DefaultBinary = 787;

        /// <remarks />
        public const uint CreateSubscriptionResponse_Encoding_DefaultBinary = 790;

        /// <remarks />
        public const uint ModifySubscriptionRequest_Encoding_DefaultBinary = 793;

        /// <remarks />
        public const uint ModifySubscriptionResponse_Encoding_DefaultBinary = 796;

        /// <remarks />
        public const uint SetPublishingModeRequest_Encoding_DefaultBinary = 799;

        /// <remarks />
        public const uint SetPublishingModeResponse_Encoding_DefaultBinary = 802;

        /// <remarks />
        public const uint NotificationMessage_Encoding_DefaultBinary = 805;

        /// <remarks />
        public const uint NotificationData_Encoding_DefaultBinary = 947;

        /// <remarks />
        public const uint DataChangeNotification_Encoding_DefaultBinary = 811;

        /// <remarks />
        public const uint MonitoredItemNotification_Encoding_DefaultBinary = 808;

        /// <remarks />
        public const uint EventNotificationList_Encoding_DefaultBinary = 916;

        /// <remarks />
        public const uint EventFieldList_Encoding_DefaultBinary = 919;

        /// <remarks />
        public const uint HistoryEventFieldList_Encoding_DefaultBinary = 922;

        /// <remarks />
        public const uint StatusChangeNotification_Encoding_DefaultBinary = 820;

        /// <remarks />
        public const uint SubscriptionAcknowledgement_Encoding_DefaultBinary = 823;

        /// <remarks />
        public const uint PublishRequest_Encoding_DefaultBinary = 826;

        /// <remarks />
        public const uint PublishResponse_Encoding_DefaultBinary = 829;

        /// <remarks />
        public const uint RepublishRequest_Encoding_DefaultBinary = 832;

        /// <remarks />
        public const uint RepublishResponse_Encoding_DefaultBinary = 835;

        /// <remarks />
        public const uint TransferResult_Encoding_DefaultBinary = 838;

        /// <remarks />
        public const uint TransferSubscriptionsRequest_Encoding_DefaultBinary = 841;

        /// <remarks />
        public const uint TransferSubscriptionsResponse_Encoding_DefaultBinary = 844;

        /// <remarks />
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultBinary = 847;

        /// <remarks />
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultBinary = 850;

        /// <remarks />
        public const uint BuildInfo_Encoding_DefaultBinary = 340;

        /// <remarks />
        public const uint RedundantServerDataType_Encoding_DefaultBinary = 855;

        /// <remarks />
        public const uint EndpointUrlListDataType_Encoding_DefaultBinary = 11957;

        /// <remarks />
        public const uint NetworkGroupDataType_Encoding_DefaultBinary = 11958;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary = 858;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary = 861;

        /// <remarks />
        public const uint ServerStatusDataType_Encoding_DefaultBinary = 864;

        /// <remarks />
        public const uint SessionDiagnosticsDataType_Encoding_DefaultBinary = 867;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary = 870;

        /// <remarks />
        public const uint ServiceCounterDataType_Encoding_DefaultBinary = 873;

        /// <remarks />
        public const uint StatusResult_Encoding_DefaultBinary = 301;

        /// <remarks />
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultBinary = 876;

        /// <remarks />
        public const uint ModelChangeStructureDataType_Encoding_DefaultBinary = 879;

        /// <remarks />
        public const uint SemanticChangeStructureDataType_Encoding_DefaultBinary = 899;

        /// <remarks />
        public const uint Range_Encoding_DefaultBinary = 886;

        /// <remarks />
        public const uint EUInformation_Encoding_DefaultBinary = 889;

        /// <remarks />
        public const uint ComplexNumberType_Encoding_DefaultBinary = 12181;

        /// <remarks />
        public const uint DoubleComplexNumberType_Encoding_DefaultBinary = 12182;

        /// <remarks />
        public const uint AxisInformation_Encoding_DefaultBinary = 12089;

        /// <remarks />
        public const uint XVType_Encoding_DefaultBinary = 12090;

        /// <remarks />
        public const uint ProgramDiagnosticDataType_Encoding_DefaultBinary = 896;

        /// <remarks />
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultBinary = 24034;

        /// <remarks />
        public const uint Annotation_Encoding_DefaultBinary = 893;

        /// <remarks />
        public const uint Union_Encoding_DefaultXml = 12758;

        /// <remarks />
        public const uint KeyValuePair_Encoding_DefaultXml = 14802;

        /// <remarks />
        public const uint AdditionalParametersType_Encoding_DefaultXml = 17541;

        /// <remarks />
        public const uint EphemeralKeyType_Encoding_DefaultXml = 17553;

        /// <remarks />
        public const uint EndpointType_Encoding_DefaultXml = 15949;

        /// <remarks />
        public const uint RationalNumber_Encoding_DefaultXml = 18851;

        /// <remarks />
        public const uint Vector_Encoding_DefaultXml = 18852;

        /// <remarks />
        public const uint ThreeDVector_Encoding_DefaultXml = 18853;

        /// <remarks />
        public const uint CartesianCoordinates_Encoding_DefaultXml = 18854;

        /// <remarks />
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultXml = 18855;

        /// <remarks />
        public const uint Orientation_Encoding_DefaultXml = 18856;

        /// <remarks />
        public const uint ThreeDOrientation_Encoding_DefaultXml = 18857;

        /// <remarks />
        public const uint Frame_Encoding_DefaultXml = 18858;

        /// <remarks />
        public const uint ThreeDFrame_Encoding_DefaultXml = 18859;

        /// <remarks />
        public const uint IdentityMappingRuleType_Encoding_DefaultXml = 15728;

        /// <remarks />
        public const uint CurrencyUnitType_Encoding_DefaultXml = 23520;

        /// <remarks />
        public const uint TrustListDataType_Encoding_DefaultXml = 12676;

        /// <remarks />
        public const uint TransactionErrorType_Encoding_DefaultXml = 32386;

        /// <remarks />
        public const uint DecimalDataType_Encoding_DefaultXml = 17862;

        /// <remarks />
        public const uint DataTypeSchemaHeader_Encoding_DefaultXml = 15950;

        /// <remarks />
        public const uint DataTypeDescription_Encoding_DefaultXml = 14796;

        /// <remarks />
        public const uint StructureDescription_Encoding_DefaultXml = 15589;

        /// <remarks />
        public const uint EnumDescription_Encoding_DefaultXml = 15590;

        /// <remarks />
        public const uint SimpleTypeDescription_Encoding_DefaultXml = 15529;

        /// <remarks />
        public const uint UABinaryFileDataType_Encoding_DefaultXml = 15531;

        /// <remarks />
        public const uint PortableQualifiedName_Encoding_DefaultXml = 24120;

        /// <remarks />
        public const uint PortableNodeId_Encoding_DefaultXml = 24121;

        /// <remarks />
        public const uint UnsignedRationalNumber_Encoding_DefaultXml = 24122;

        /// <remarks />
        public const uint DataSetMetaDataType_Encoding_DefaultXml = 14794;

        /// <remarks />
        public const uint FieldMetaData_Encoding_DefaultXml = 14795;

        /// <remarks />
        public const uint ConfigurationVersionDataType_Encoding_DefaultXml = 14803;

        /// <remarks />
        public const uint PublishedDataSetDataType_Encoding_DefaultXml = 15951;

        /// <remarks />
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultXml = 15952;

        /// <remarks />
        public const uint PublishedVariableDataType_Encoding_DefaultXml = 14319;

        /// <remarks />
        public const uint PublishedDataItemsDataType_Encoding_DefaultXml = 15953;

        /// <remarks />
        public const uint PublishedEventsDataType_Encoding_DefaultXml = 15954;

        /// <remarks />
        public const uint PublishedDataSetCustomSourceDataType_Encoding_DefaultXml = 25545;

        /// <remarks />
        public const uint DataSetWriterDataType_Encoding_DefaultXml = 15955;

        /// <remarks />
        public const uint DataSetWriterTransportDataType_Encoding_DefaultXml = 15956;

        /// <remarks />
        public const uint DataSetWriterMessageDataType_Encoding_DefaultXml = 15987;

        /// <remarks />
        public const uint PubSubGroupDataType_Encoding_DefaultXml = 15988;

        /// <remarks />
        public const uint WriterGroupDataType_Encoding_DefaultXml = 21174;

        /// <remarks />
        public const uint WriterGroupTransportDataType_Encoding_DefaultXml = 15990;

        /// <remarks />
        public const uint WriterGroupMessageDataType_Encoding_DefaultXml = 15991;

        /// <remarks />
        public const uint PubSubConnectionDataType_Encoding_DefaultXml = 15992;

        /// <remarks />
        public const uint ConnectionTransportDataType_Encoding_DefaultXml = 15993;

        /// <remarks />
        public const uint NetworkAddressDataType_Encoding_DefaultXml = 21175;

        /// <remarks />
        public const uint NetworkAddressUrlDataType_Encoding_DefaultXml = 21176;

        /// <remarks />
        public const uint ReaderGroupDataType_Encoding_DefaultXml = 21177;

        /// <remarks />
        public const uint ReaderGroupTransportDataType_Encoding_DefaultXml = 15995;

        /// <remarks />
        public const uint ReaderGroupMessageDataType_Encoding_DefaultXml = 15996;

        /// <remarks />
        public const uint DataSetReaderDataType_Encoding_DefaultXml = 16007;

        /// <remarks />
        public const uint DataSetReaderTransportDataType_Encoding_DefaultXml = 16008;

        /// <remarks />
        public const uint DataSetReaderMessageDataType_Encoding_DefaultXml = 16009;

        /// <remarks />
        public const uint SubscribedDataSetDataType_Encoding_DefaultXml = 16010;

        /// <remarks />
        public const uint TargetVariablesDataType_Encoding_DefaultXml = 16011;

        /// <remarks />
        public const uint FieldTargetDataType_Encoding_DefaultXml = 14804;

        /// <remarks />
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultXml = 16012;

        /// <remarks />
        public const uint PubSubConfigurationDataType_Encoding_DefaultXml = 21178;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml = 23919;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetDataType_Encoding_DefaultXml = 23920;

        /// <remarks />
        public const uint SecurityGroupDataType_Encoding_DefaultXml = 23921;

        /// <remarks />
        public const uint PubSubKeyPushTargetDataType_Encoding_DefaultXml = 25546;

        /// <remarks />
        public const uint PubSubConfiguration2DataType_Encoding_DefaultXml = 23922;

        /// <remarks />
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultXml = 16014;

        /// <remarks />
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultXml = 16015;

        /// <remarks />
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultXml = 16016;

        /// <remarks />
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultXml = 16017;

        /// <remarks />
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultXml = 16018;

        /// <remarks />
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultXml = 16019;

        /// <remarks />
        public const uint QosDataType_Encoding_DefaultXml = 23923;

        /// <remarks />
        public const uint TransmitQosDataType_Encoding_DefaultXml = 23924;

        /// <remarks />
        public const uint TransmitQosPriorityDataType_Encoding_DefaultXml = 23925;

        /// <remarks />
        public const uint ReceiveQosDataType_Encoding_DefaultXml = 23928;

        /// <remarks />
        public const uint ReceiveQosPriorityDataType_Encoding_DefaultXml = 23929;

        /// <remarks />
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultXml = 17472;

        /// <remarks />
        public const uint DatagramConnectionTransport2DataType_Encoding_DefaultXml = 23932;

        /// <remarks />
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultXml = 21179;

        /// <remarks />
        public const uint DatagramWriterGroupTransport2DataType_Encoding_DefaultXml = 23933;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportDataType_Encoding_DefaultXml = 23934;

        /// <remarks />
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultXml = 15579;

        /// <remarks />
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultXml = 16021;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultXml = 16022;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultXml = 16023;

        /// <remarks />
        public const uint PubSubConfigurationRefDataType_Encoding_DefaultXml = 25547;

        /// <remarks />
        public const uint PubSubConfigurationValueDataType_Encoding_DefaultXml = 25548;

        /// <remarks />
        public const uint AliasNameDataType_Encoding_DefaultXml = 23505;

        /// <remarks />
        public const uint UserManagementDataType_Encoding_DefaultXml = 24296;

        /// <remarks />
        public const uint PriorityMappingEntryType_Encoding_DefaultXml = 25243;

        /// <remarks />
        public const uint ReferenceDescriptionDataType_Encoding_DefaultXml = 32669;

        /// <remarks />
        public const uint ReferenceListEntryDataType_Encoding_DefaultXml = 32670;

        /// <remarks />
        public const uint RolePermissionType_Encoding_DefaultXml = 16126;

        /// <remarks />
        public const uint DataTypeDefinition_Encoding_DefaultXml = 14797;

        /// <remarks />
        public const uint StructureField_Encoding_DefaultXml = 14800;

        /// <remarks />
        public const uint StructureDefinition_Encoding_DefaultXml = 14798;

        /// <remarks />
        public const uint EnumDefinition_Encoding_DefaultXml = 14799;

        /// <remarks />
        public const uint Node_Encoding_DefaultXml = 259;

        /// <remarks />
        public const uint InstanceNode_Encoding_DefaultXml = 11887;

        /// <remarks />
        public const uint TypeNode_Encoding_DefaultXml = 11888;

        /// <remarks />
        public const uint ObjectNode_Encoding_DefaultXml = 262;

        /// <remarks />
        public const uint ObjectTypeNode_Encoding_DefaultXml = 265;

        /// <remarks />
        public const uint VariableNode_Encoding_DefaultXml = 268;

        /// <remarks />
        public const uint VariableTypeNode_Encoding_DefaultXml = 271;

        /// <remarks />
        public const uint ReferenceTypeNode_Encoding_DefaultXml = 274;

        /// <remarks />
        public const uint MethodNode_Encoding_DefaultXml = 277;

        /// <remarks />
        public const uint ViewNode_Encoding_DefaultXml = 280;

        /// <remarks />
        public const uint DataTypeNode_Encoding_DefaultXml = 283;

        /// <remarks />
        public const uint ReferenceNode_Encoding_DefaultXml = 286;

        /// <remarks />
        public const uint Argument_Encoding_DefaultXml = 297;

        /// <remarks />
        public const uint EnumValueType_Encoding_DefaultXml = 7616;

        /// <remarks />
        public const uint EnumField_Encoding_DefaultXml = 14801;

        /// <remarks />
        public const uint OptionSet_Encoding_DefaultXml = 12757;

        /// <remarks />
        public const uint TimeZoneDataType_Encoding_DefaultXml = 8913;

        /// <remarks />
        public const uint ApplicationDescription_Encoding_DefaultXml = 309;

        /// <remarks />
        public const uint RequestHeader_Encoding_DefaultXml = 390;

        /// <remarks />
        public const uint ResponseHeader_Encoding_DefaultXml = 393;

        /// <remarks />
        public const uint ServiceFault_Encoding_DefaultXml = 396;

        /// <remarks />
        public const uint SessionlessInvokeRequestType_Encoding_DefaultXml = 15902;

        /// <remarks />
        public const uint SessionlessInvokeResponseType_Encoding_DefaultXml = 21000;

        /// <remarks />
        public const uint FindServersRequest_Encoding_DefaultXml = 421;

        /// <remarks />
        public const uint FindServersResponse_Encoding_DefaultXml = 424;

        /// <remarks />
        public const uint ServerOnNetwork_Encoding_DefaultXml = 12195;

        /// <remarks />
        public const uint FindServersOnNetworkRequest_Encoding_DefaultXml = 12196;

        /// <remarks />
        public const uint FindServersOnNetworkResponse_Encoding_DefaultXml = 12197;

        /// <remarks />
        public const uint UserTokenPolicy_Encoding_DefaultXml = 305;

        /// <remarks />
        public const uint EndpointDescription_Encoding_DefaultXml = 313;

        /// <remarks />
        public const uint GetEndpointsRequest_Encoding_DefaultXml = 427;

        /// <remarks />
        public const uint GetEndpointsResponse_Encoding_DefaultXml = 430;

        /// <remarks />
        public const uint RegisteredServer_Encoding_DefaultXml = 433;

        /// <remarks />
        public const uint RegisterServerRequest_Encoding_DefaultXml = 436;

        /// <remarks />
        public const uint RegisterServerResponse_Encoding_DefaultXml = 439;

        /// <remarks />
        public const uint DiscoveryConfiguration_Encoding_DefaultXml = 12892;

        /// <remarks />
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultXml = 12893;

        /// <remarks />
        public const uint RegisterServer2Request_Encoding_DefaultXml = 12199;

        /// <remarks />
        public const uint RegisterServer2Response_Encoding_DefaultXml = 12200;

        /// <remarks />
        public const uint ChannelSecurityToken_Encoding_DefaultXml = 442;

        /// <remarks />
        public const uint OpenSecureChannelRequest_Encoding_DefaultXml = 445;

        /// <remarks />
        public const uint OpenSecureChannelResponse_Encoding_DefaultXml = 448;

        /// <remarks />
        public const uint CloseSecureChannelRequest_Encoding_DefaultXml = 451;

        /// <remarks />
        public const uint CloseSecureChannelResponse_Encoding_DefaultXml = 454;

        /// <remarks />
        public const uint SignedSoftwareCertificate_Encoding_DefaultXml = 345;

        /// <remarks />
        public const uint SignatureData_Encoding_DefaultXml = 457;

        /// <remarks />
        public const uint CreateSessionRequest_Encoding_DefaultXml = 460;

        /// <remarks />
        public const uint CreateSessionResponse_Encoding_DefaultXml = 463;

        /// <remarks />
        public const uint UserIdentityToken_Encoding_DefaultXml = 317;

        /// <remarks />
        public const uint AnonymousIdentityToken_Encoding_DefaultXml = 320;

        /// <remarks />
        public const uint UserNameIdentityToken_Encoding_DefaultXml = 323;

        /// <remarks />
        public const uint X509IdentityToken_Encoding_DefaultXml = 326;

        /// <remarks />
        public const uint IssuedIdentityToken_Encoding_DefaultXml = 939;

        /// <remarks />
        public const uint ActivateSessionRequest_Encoding_DefaultXml = 466;

        /// <remarks />
        public const uint ActivateSessionResponse_Encoding_DefaultXml = 469;

        /// <remarks />
        public const uint CloseSessionRequest_Encoding_DefaultXml = 472;

        /// <remarks />
        public const uint CloseSessionResponse_Encoding_DefaultXml = 475;

        /// <remarks />
        public const uint CancelRequest_Encoding_DefaultXml = 478;

        /// <remarks />
        public const uint CancelResponse_Encoding_DefaultXml = 481;

        /// <remarks />
        public const uint NodeAttributes_Encoding_DefaultXml = 350;

        /// <remarks />
        public const uint ObjectAttributes_Encoding_DefaultXml = 353;

        /// <remarks />
        public const uint VariableAttributes_Encoding_DefaultXml = 356;

        /// <remarks />
        public const uint MethodAttributes_Encoding_DefaultXml = 359;

        /// <remarks />
        public const uint ObjectTypeAttributes_Encoding_DefaultXml = 362;

        /// <remarks />
        public const uint VariableTypeAttributes_Encoding_DefaultXml = 365;

        /// <remarks />
        public const uint ReferenceTypeAttributes_Encoding_DefaultXml = 368;

        /// <remarks />
        public const uint DataTypeAttributes_Encoding_DefaultXml = 371;

        /// <remarks />
        public const uint ViewAttributes_Encoding_DefaultXml = 374;

        /// <remarks />
        public const uint GenericAttributeValue_Encoding_DefaultXml = 17608;

        /// <remarks />
        public const uint GenericAttributes_Encoding_DefaultXml = 17609;

        /// <remarks />
        public const uint AddNodesItem_Encoding_DefaultXml = 377;

        /// <remarks />
        public const uint AddNodesResult_Encoding_DefaultXml = 484;

        /// <remarks />
        public const uint AddNodesRequest_Encoding_DefaultXml = 487;

        /// <remarks />
        public const uint AddNodesResponse_Encoding_DefaultXml = 490;

        /// <remarks />
        public const uint AddReferencesItem_Encoding_DefaultXml = 380;

        /// <remarks />
        public const uint AddReferencesRequest_Encoding_DefaultXml = 493;

        /// <remarks />
        public const uint AddReferencesResponse_Encoding_DefaultXml = 496;

        /// <remarks />
        public const uint DeleteNodesItem_Encoding_DefaultXml = 383;

        /// <remarks />
        public const uint DeleteNodesRequest_Encoding_DefaultXml = 499;

        /// <remarks />
        public const uint DeleteNodesResponse_Encoding_DefaultXml = 502;

        /// <remarks />
        public const uint DeleteReferencesItem_Encoding_DefaultXml = 386;

        /// <remarks />
        public const uint DeleteReferencesRequest_Encoding_DefaultXml = 505;

        /// <remarks />
        public const uint DeleteReferencesResponse_Encoding_DefaultXml = 508;

        /// <remarks />
        public const uint ViewDescription_Encoding_DefaultXml = 512;

        /// <remarks />
        public const uint BrowseDescription_Encoding_DefaultXml = 515;

        /// <remarks />
        public const uint ReferenceDescription_Encoding_DefaultXml = 519;

        /// <remarks />
        public const uint BrowseResult_Encoding_DefaultXml = 523;

        /// <remarks />
        public const uint BrowseRequest_Encoding_DefaultXml = 526;

        /// <remarks />
        public const uint BrowseResponse_Encoding_DefaultXml = 529;

        /// <remarks />
        public const uint BrowseNextRequest_Encoding_DefaultXml = 532;

        /// <remarks />
        public const uint BrowseNextResponse_Encoding_DefaultXml = 535;

        /// <remarks />
        public const uint RelativePathElement_Encoding_DefaultXml = 538;

        /// <remarks />
        public const uint RelativePath_Encoding_DefaultXml = 541;

        /// <remarks />
        public const uint BrowsePath_Encoding_DefaultXml = 544;

        /// <remarks />
        public const uint BrowsePathTarget_Encoding_DefaultXml = 547;

        /// <remarks />
        public const uint BrowsePathResult_Encoding_DefaultXml = 550;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml = 553;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml = 556;

        /// <remarks />
        public const uint RegisterNodesRequest_Encoding_DefaultXml = 559;

        /// <remarks />
        public const uint RegisterNodesResponse_Encoding_DefaultXml = 562;

        /// <remarks />
        public const uint UnregisterNodesRequest_Encoding_DefaultXml = 565;

        /// <remarks />
        public const uint UnregisterNodesResponse_Encoding_DefaultXml = 568;

        /// <remarks />
        public const uint EndpointConfiguration_Encoding_DefaultXml = 332;

        /// <remarks />
        public const uint QueryDataDescription_Encoding_DefaultXml = 571;

        /// <remarks />
        public const uint NodeTypeDescription_Encoding_DefaultXml = 574;

        /// <remarks />
        public const uint QueryDataSet_Encoding_DefaultXml = 578;

        /// <remarks />
        public const uint NodeReference_Encoding_DefaultXml = 581;

        /// <remarks />
        public const uint ContentFilterElement_Encoding_DefaultXml = 584;

        /// <remarks />
        public const uint ContentFilter_Encoding_DefaultXml = 587;

        /// <remarks />
        public const uint FilterOperand_Encoding_DefaultXml = 590;

        /// <remarks />
        public const uint ElementOperand_Encoding_DefaultXml = 593;

        /// <remarks />
        public const uint LiteralOperand_Encoding_DefaultXml = 596;

        /// <remarks />
        public const uint AttributeOperand_Encoding_DefaultXml = 599;

        /// <remarks />
        public const uint SimpleAttributeOperand_Encoding_DefaultXml = 602;

        /// <remarks />
        public const uint ContentFilterElementResult_Encoding_DefaultXml = 605;

        /// <remarks />
        public const uint ContentFilterResult_Encoding_DefaultXml = 608;

        /// <remarks />
        public const uint ParsingResult_Encoding_DefaultXml = 611;

        /// <remarks />
        public const uint QueryFirstRequest_Encoding_DefaultXml = 614;

        /// <remarks />
        public const uint QueryFirstResponse_Encoding_DefaultXml = 617;

        /// <remarks />
        public const uint QueryNextRequest_Encoding_DefaultXml = 620;

        /// <remarks />
        public const uint QueryNextResponse_Encoding_DefaultXml = 623;

        /// <remarks />
        public const uint ReadValueId_Encoding_DefaultXml = 627;

        /// <remarks />
        public const uint ReadRequest_Encoding_DefaultXml = 630;

        /// <remarks />
        public const uint ReadResponse_Encoding_DefaultXml = 633;

        /// <remarks />
        public const uint HistoryReadValueId_Encoding_DefaultXml = 636;

        /// <remarks />
        public const uint HistoryReadResult_Encoding_DefaultXml = 639;

        /// <remarks />
        public const uint HistoryReadDetails_Encoding_DefaultXml = 642;

        /// <remarks />
        public const uint ReadEventDetails_Encoding_DefaultXml = 645;

        /// <remarks />
        public const uint ReadRawModifiedDetails_Encoding_DefaultXml = 648;

        /// <remarks />
        public const uint ReadProcessedDetails_Encoding_DefaultXml = 651;

        /// <remarks />
        public const uint ReadAtTimeDetails_Encoding_DefaultXml = 654;

        /// <remarks />
        public const uint ReadAnnotationDataDetails_Encoding_DefaultXml = 23506;

        /// <remarks />
        public const uint HistoryData_Encoding_DefaultXml = 657;

        /// <remarks />
        public const uint ModificationInfo_Encoding_DefaultXml = 11218;

        /// <remarks />
        public const uint HistoryModifiedData_Encoding_DefaultXml = 11219;

        /// <remarks />
        public const uint HistoryEvent_Encoding_DefaultXml = 660;

        /// <remarks />
        public const uint HistoryReadRequest_Encoding_DefaultXml = 663;

        /// <remarks />
        public const uint HistoryReadResponse_Encoding_DefaultXml = 666;

        /// <remarks />
        public const uint WriteValue_Encoding_DefaultXml = 669;

        /// <remarks />
        public const uint WriteRequest_Encoding_DefaultXml = 672;

        /// <remarks />
        public const uint WriteResponse_Encoding_DefaultXml = 675;

        /// <remarks />
        public const uint HistoryUpdateDetails_Encoding_DefaultXml = 678;

        /// <remarks />
        public const uint UpdateDataDetails_Encoding_DefaultXml = 681;

        /// <remarks />
        public const uint UpdateStructureDataDetails_Encoding_DefaultXml = 11296;

        /// <remarks />
        public const uint UpdateEventDetails_Encoding_DefaultXml = 684;

        /// <remarks />
        public const uint DeleteRawModifiedDetails_Encoding_DefaultXml = 687;

        /// <remarks />
        public const uint DeleteAtTimeDetails_Encoding_DefaultXml = 690;

        /// <remarks />
        public const uint DeleteEventDetails_Encoding_DefaultXml = 693;

        /// <remarks />
        public const uint HistoryUpdateResult_Encoding_DefaultXml = 696;

        /// <remarks />
        public const uint HistoryUpdateRequest_Encoding_DefaultXml = 699;

        /// <remarks />
        public const uint HistoryUpdateResponse_Encoding_DefaultXml = 702;

        /// <remarks />
        public const uint CallMethodRequest_Encoding_DefaultXml = 705;

        /// <remarks />
        public const uint CallMethodResult_Encoding_DefaultXml = 708;

        /// <remarks />
        public const uint CallRequest_Encoding_DefaultXml = 711;

        /// <remarks />
        public const uint CallResponse_Encoding_DefaultXml = 714;

        /// <remarks />
        public const uint MonitoringFilter_Encoding_DefaultXml = 720;

        /// <remarks />
        public const uint DataChangeFilter_Encoding_DefaultXml = 723;

        /// <remarks />
        public const uint EventFilter_Encoding_DefaultXml = 726;

        /// <remarks />
        public const uint AggregateConfiguration_Encoding_DefaultXml = 949;

        /// <remarks />
        public const uint AggregateFilter_Encoding_DefaultXml = 729;

        /// <remarks />
        public const uint MonitoringFilterResult_Encoding_DefaultXml = 732;

        /// <remarks />
        public const uint EventFilterResult_Encoding_DefaultXml = 735;

        /// <remarks />
        public const uint AggregateFilterResult_Encoding_DefaultXml = 738;

        /// <remarks />
        public const uint MonitoringParameters_Encoding_DefaultXml = 741;

        /// <remarks />
        public const uint MonitoredItemCreateRequest_Encoding_DefaultXml = 744;

        /// <remarks />
        public const uint MonitoredItemCreateResult_Encoding_DefaultXml = 747;

        /// <remarks />
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultXml = 750;

        /// <remarks />
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultXml = 753;

        /// <remarks />
        public const uint MonitoredItemModifyRequest_Encoding_DefaultXml = 756;

        /// <remarks />
        public const uint MonitoredItemModifyResult_Encoding_DefaultXml = 759;

        /// <remarks />
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultXml = 762;

        /// <remarks />
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultXml = 765;

        /// <remarks />
        public const uint SetMonitoringModeRequest_Encoding_DefaultXml = 768;

        /// <remarks />
        public const uint SetMonitoringModeResponse_Encoding_DefaultXml = 771;

        /// <remarks />
        public const uint SetTriggeringRequest_Encoding_DefaultXml = 774;

        /// <remarks />
        public const uint SetTriggeringResponse_Encoding_DefaultXml = 777;

        /// <remarks />
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultXml = 780;

        /// <remarks />
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultXml = 783;

        /// <remarks />
        public const uint CreateSubscriptionRequest_Encoding_DefaultXml = 786;

        /// <remarks />
        public const uint CreateSubscriptionResponse_Encoding_DefaultXml = 789;

        /// <remarks />
        public const uint ModifySubscriptionRequest_Encoding_DefaultXml = 792;

        /// <remarks />
        public const uint ModifySubscriptionResponse_Encoding_DefaultXml = 795;

        /// <remarks />
        public const uint SetPublishingModeRequest_Encoding_DefaultXml = 798;

        /// <remarks />
        public const uint SetPublishingModeResponse_Encoding_DefaultXml = 801;

        /// <remarks />
        public const uint NotificationMessage_Encoding_DefaultXml = 804;

        /// <remarks />
        public const uint NotificationData_Encoding_DefaultXml = 946;

        /// <remarks />
        public const uint DataChangeNotification_Encoding_DefaultXml = 810;

        /// <remarks />
        public const uint MonitoredItemNotification_Encoding_DefaultXml = 807;

        /// <remarks />
        public const uint EventNotificationList_Encoding_DefaultXml = 915;

        /// <remarks />
        public const uint EventFieldList_Encoding_DefaultXml = 918;

        /// <remarks />
        public const uint HistoryEventFieldList_Encoding_DefaultXml = 921;

        /// <remarks />
        public const uint StatusChangeNotification_Encoding_DefaultXml = 819;

        /// <remarks />
        public const uint SubscriptionAcknowledgement_Encoding_DefaultXml = 822;

        /// <remarks />
        public const uint PublishRequest_Encoding_DefaultXml = 825;

        /// <remarks />
        public const uint PublishResponse_Encoding_DefaultXml = 828;

        /// <remarks />
        public const uint RepublishRequest_Encoding_DefaultXml = 831;

        /// <remarks />
        public const uint RepublishResponse_Encoding_DefaultXml = 834;

        /// <remarks />
        public const uint TransferResult_Encoding_DefaultXml = 837;

        /// <remarks />
        public const uint TransferSubscriptionsRequest_Encoding_DefaultXml = 840;

        /// <remarks />
        public const uint TransferSubscriptionsResponse_Encoding_DefaultXml = 843;

        /// <remarks />
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultXml = 846;

        /// <remarks />
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultXml = 849;

        /// <remarks />
        public const uint BuildInfo_Encoding_DefaultXml = 339;

        /// <remarks />
        public const uint RedundantServerDataType_Encoding_DefaultXml = 854;

        /// <remarks />
        public const uint EndpointUrlListDataType_Encoding_DefaultXml = 11949;

        /// <remarks />
        public const uint NetworkGroupDataType_Encoding_DefaultXml = 11950;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml = 857;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultXml = 860;

        /// <remarks />
        public const uint ServerStatusDataType_Encoding_DefaultXml = 863;

        /// <remarks />
        public const uint SessionDiagnosticsDataType_Encoding_DefaultXml = 866;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultXml = 869;

        /// <remarks />
        public const uint ServiceCounterDataType_Encoding_DefaultXml = 872;

        /// <remarks />
        public const uint StatusResult_Encoding_DefaultXml = 300;

        /// <remarks />
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultXml = 875;

        /// <remarks />
        public const uint ModelChangeStructureDataType_Encoding_DefaultXml = 878;

        /// <remarks />
        public const uint SemanticChangeStructureDataType_Encoding_DefaultXml = 898;

        /// <remarks />
        public const uint Range_Encoding_DefaultXml = 885;

        /// <remarks />
        public const uint EUInformation_Encoding_DefaultXml = 888;

        /// <remarks />
        public const uint ComplexNumberType_Encoding_DefaultXml = 12173;

        /// <remarks />
        public const uint DoubleComplexNumberType_Encoding_DefaultXml = 12174;

        /// <remarks />
        public const uint AxisInformation_Encoding_DefaultXml = 12081;

        /// <remarks />
        public const uint XVType_Encoding_DefaultXml = 12082;

        /// <remarks />
        public const uint ProgramDiagnosticDataType_Encoding_DefaultXml = 895;

        /// <remarks />
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultXml = 24038;

        /// <remarks />
        public const uint Annotation_Encoding_DefaultXml = 892;

        /// <remarks />
        public const uint Union_Encoding_DefaultJson = 15085;

        /// <remarks />
        public const uint KeyValuePair_Encoding_DefaultJson = 15041;

        /// <remarks />
        public const uint AdditionalParametersType_Encoding_DefaultJson = 17547;

        /// <remarks />
        public const uint EphemeralKeyType_Encoding_DefaultJson = 17557;

        /// <remarks />
        public const uint EndpointType_Encoding_DefaultJson = 16150;

        /// <remarks />
        public const uint RationalNumber_Encoding_DefaultJson = 19064;

        /// <remarks />
        public const uint Vector_Encoding_DefaultJson = 19065;

        /// <remarks />
        public const uint ThreeDVector_Encoding_DefaultJson = 19066;

        /// <remarks />
        public const uint CartesianCoordinates_Encoding_DefaultJson = 19067;

        /// <remarks />
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultJson = 19068;

        /// <remarks />
        public const uint Orientation_Encoding_DefaultJson = 19069;

        /// <remarks />
        public const uint ThreeDOrientation_Encoding_DefaultJson = 19070;

        /// <remarks />
        public const uint Frame_Encoding_DefaultJson = 19071;

        /// <remarks />
        public const uint ThreeDFrame_Encoding_DefaultJson = 19072;

        /// <remarks />
        public const uint IdentityMappingRuleType_Encoding_DefaultJson = 15042;

        /// <remarks />
        public const uint CurrencyUnitType_Encoding_DefaultJson = 23528;

        /// <remarks />
        public const uint TrustListDataType_Encoding_DefaultJson = 15044;

        /// <remarks />
        public const uint TransactionErrorType_Encoding_DefaultJson = 32390;

        /// <remarks />
        public const uint DecimalDataType_Encoding_DefaultJson = 15045;

        /// <remarks />
        public const uint DataTypeSchemaHeader_Encoding_DefaultJson = 16151;

        /// <remarks />
        public const uint DataTypeDescription_Encoding_DefaultJson = 15057;

        /// <remarks />
        public const uint StructureDescription_Encoding_DefaultJson = 15058;

        /// <remarks />
        public const uint EnumDescription_Encoding_DefaultJson = 15059;

        /// <remarks />
        public const uint SimpleTypeDescription_Encoding_DefaultJson = 15700;

        /// <remarks />
        public const uint UABinaryFileDataType_Encoding_DefaultJson = 15714;

        /// <remarks />
        public const uint PortableQualifiedName_Encoding_DefaultJson = 24132;

        /// <remarks />
        public const uint PortableNodeId_Encoding_DefaultJson = 24133;

        /// <remarks />
        public const uint UnsignedRationalNumber_Encoding_DefaultJson = 24134;

        /// <remarks />
        public const uint DataSetMetaDataType_Encoding_DefaultJson = 15050;

        /// <remarks />
        public const uint FieldMetaData_Encoding_DefaultJson = 15051;

        /// <remarks />
        public const uint ConfigurationVersionDataType_Encoding_DefaultJson = 15049;

        /// <remarks />
        public const uint PublishedDataSetDataType_Encoding_DefaultJson = 16152;

        /// <remarks />
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultJson = 16153;

        /// <remarks />
        public const uint PublishedVariableDataType_Encoding_DefaultJson = 15060;

        /// <remarks />
        public const uint PublishedDataItemsDataType_Encoding_DefaultJson = 16154;

        /// <remarks />
        public const uint PublishedEventsDataType_Encoding_DefaultJson = 16155;

        /// <remarks />
        public const uint PublishedDataSetCustomSourceDataType_Encoding_DefaultJson = 25561;

        /// <remarks />
        public const uint DataSetWriterDataType_Encoding_DefaultJson = 16156;

        /// <remarks />
        public const uint DataSetWriterTransportDataType_Encoding_DefaultJson = 16157;

        /// <remarks />
        public const uint DataSetWriterMessageDataType_Encoding_DefaultJson = 16158;

        /// <remarks />
        public const uint PubSubGroupDataType_Encoding_DefaultJson = 16159;

        /// <remarks />
        public const uint WriterGroupDataType_Encoding_DefaultJson = 21198;

        /// <remarks />
        public const uint WriterGroupTransportDataType_Encoding_DefaultJson = 16161;

        /// <remarks />
        public const uint WriterGroupMessageDataType_Encoding_DefaultJson = 16280;

        /// <remarks />
        public const uint PubSubConnectionDataType_Encoding_DefaultJson = 16281;

        /// <remarks />
        public const uint ConnectionTransportDataType_Encoding_DefaultJson = 16282;

        /// <remarks />
        public const uint NetworkAddressDataType_Encoding_DefaultJson = 21199;

        /// <remarks />
        public const uint NetworkAddressUrlDataType_Encoding_DefaultJson = 21200;

        /// <remarks />
        public const uint ReaderGroupDataType_Encoding_DefaultJson = 21201;

        /// <remarks />
        public const uint ReaderGroupTransportDataType_Encoding_DefaultJson = 16284;

        /// <remarks />
        public const uint ReaderGroupMessageDataType_Encoding_DefaultJson = 16285;

        /// <remarks />
        public const uint DataSetReaderDataType_Encoding_DefaultJson = 16286;

        /// <remarks />
        public const uint DataSetReaderTransportDataType_Encoding_DefaultJson = 16287;

        /// <remarks />
        public const uint DataSetReaderMessageDataType_Encoding_DefaultJson = 16288;

        /// <remarks />
        public const uint SubscribedDataSetDataType_Encoding_DefaultJson = 16308;

        /// <remarks />
        public const uint TargetVariablesDataType_Encoding_DefaultJson = 16310;

        /// <remarks />
        public const uint FieldTargetDataType_Encoding_DefaultJson = 15061;

        /// <remarks />
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultJson = 16311;

        /// <remarks />
        public const uint PubSubConfigurationDataType_Encoding_DefaultJson = 21202;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson = 23987;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetDataType_Encoding_DefaultJson = 23988;

        /// <remarks />
        public const uint SecurityGroupDataType_Encoding_DefaultJson = 23989;

        /// <remarks />
        public const uint PubSubKeyPushTargetDataType_Encoding_DefaultJson = 25562;

        /// <remarks />
        public const uint PubSubConfiguration2DataType_Encoding_DefaultJson = 23990;

        /// <remarks />
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultJson = 16323;

        /// <remarks />
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultJson = 16391;

        /// <remarks />
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultJson = 16392;

        /// <remarks />
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultJson = 16393;

        /// <remarks />
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultJson = 16394;

        /// <remarks />
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultJson = 16404;

        /// <remarks />
        public const uint QosDataType_Encoding_DefaultJson = 23991;

        /// <remarks />
        public const uint TransmitQosDataType_Encoding_DefaultJson = 23992;

        /// <remarks />
        public const uint TransmitQosPriorityDataType_Encoding_DefaultJson = 23993;

        /// <remarks />
        public const uint ReceiveQosDataType_Encoding_DefaultJson = 23996;

        /// <remarks />
        public const uint ReceiveQosPriorityDataType_Encoding_DefaultJson = 23997;

        /// <remarks />
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultJson = 17476;

        /// <remarks />
        public const uint DatagramConnectionTransport2DataType_Encoding_DefaultJson = 24000;

        /// <remarks />
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultJson = 21203;

        /// <remarks />
        public const uint DatagramWriterGroupTransport2DataType_Encoding_DefaultJson = 24001;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportDataType_Encoding_DefaultJson = 24002;

        /// <remarks />
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultJson = 15726;

        /// <remarks />
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultJson = 16524;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultJson = 16525;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultJson = 16526;

        /// <remarks />
        public const uint PubSubConfigurationRefDataType_Encoding_DefaultJson = 25563;

        /// <remarks />
        public const uint PubSubConfigurationValueDataType_Encoding_DefaultJson = 25564;

        /// <remarks />
        public const uint AliasNameDataType_Encoding_DefaultJson = 23511;

        /// <remarks />
        public const uint UserManagementDataType_Encoding_DefaultJson = 24300;

        /// <remarks />
        public const uint PriorityMappingEntryType_Encoding_DefaultJson = 25247;

        /// <remarks />
        public const uint ReferenceDescriptionDataType_Encoding_DefaultJson = 32677;

        /// <remarks />
        public const uint ReferenceListEntryDataType_Encoding_DefaultJson = 32678;

        /// <remarks />
        public const uint RolePermissionType_Encoding_DefaultJson = 15062;

        /// <remarks />
        public const uint DataTypeDefinition_Encoding_DefaultJson = 15063;

        /// <remarks />
        public const uint StructureField_Encoding_DefaultJson = 15065;

        /// <remarks />
        public const uint StructureDefinition_Encoding_DefaultJson = 15066;

        /// <remarks />
        public const uint EnumDefinition_Encoding_DefaultJson = 15067;

        /// <remarks />
        public const uint Node_Encoding_DefaultJson = 15068;

        /// <remarks />
        public const uint InstanceNode_Encoding_DefaultJson = 15069;

        /// <remarks />
        public const uint TypeNode_Encoding_DefaultJson = 15070;

        /// <remarks />
        public const uint ObjectNode_Encoding_DefaultJson = 15071;

        /// <remarks />
        public const uint ObjectTypeNode_Encoding_DefaultJson = 15073;

        /// <remarks />
        public const uint VariableNode_Encoding_DefaultJson = 15074;

        /// <remarks />
        public const uint VariableTypeNode_Encoding_DefaultJson = 15075;

        /// <remarks />
        public const uint ReferenceTypeNode_Encoding_DefaultJson = 15076;

        /// <remarks />
        public const uint MethodNode_Encoding_DefaultJson = 15077;

        /// <remarks />
        public const uint ViewNode_Encoding_DefaultJson = 15078;

        /// <remarks />
        public const uint DataTypeNode_Encoding_DefaultJson = 15079;

        /// <remarks />
        public const uint ReferenceNode_Encoding_DefaultJson = 15080;

        /// <remarks />
        public const uint Argument_Encoding_DefaultJson = 15081;

        /// <remarks />
        public const uint EnumValueType_Encoding_DefaultJson = 15082;

        /// <remarks />
        public const uint EnumField_Encoding_DefaultJson = 15083;

        /// <remarks />
        public const uint OptionSet_Encoding_DefaultJson = 15084;

        /// <remarks />
        public const uint TimeZoneDataType_Encoding_DefaultJson = 15086;

        /// <remarks />
        public const uint ApplicationDescription_Encoding_DefaultJson = 15087;

        /// <remarks />
        public const uint RequestHeader_Encoding_DefaultJson = 15088;

        /// <remarks />
        public const uint ResponseHeader_Encoding_DefaultJson = 15089;

        /// <remarks />
        public const uint ServiceFault_Encoding_DefaultJson = 15090;

        /// <remarks />
        public const uint SessionlessInvokeRequestType_Encoding_DefaultJson = 15091;

        /// <remarks />
        public const uint SessionlessInvokeResponseType_Encoding_DefaultJson = 15092;

        /// <remarks />
        public const uint FindServersRequest_Encoding_DefaultJson = 15093;

        /// <remarks />
        public const uint FindServersResponse_Encoding_DefaultJson = 15094;

        /// <remarks />
        public const uint ServerOnNetwork_Encoding_DefaultJson = 15095;

        /// <remarks />
        public const uint FindServersOnNetworkRequest_Encoding_DefaultJson = 15096;

        /// <remarks />
        public const uint FindServersOnNetworkResponse_Encoding_DefaultJson = 15097;

        /// <remarks />
        public const uint UserTokenPolicy_Encoding_DefaultJson = 15098;

        /// <remarks />
        public const uint EndpointDescription_Encoding_DefaultJson = 15099;

        /// <remarks />
        public const uint GetEndpointsRequest_Encoding_DefaultJson = 15100;

        /// <remarks />
        public const uint GetEndpointsResponse_Encoding_DefaultJson = 15101;

        /// <remarks />
        public const uint RegisteredServer_Encoding_DefaultJson = 15102;

        /// <remarks />
        public const uint RegisterServerRequest_Encoding_DefaultJson = 15103;

        /// <remarks />
        public const uint RegisterServerResponse_Encoding_DefaultJson = 15104;

        /// <remarks />
        public const uint DiscoveryConfiguration_Encoding_DefaultJson = 15105;

        /// <remarks />
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultJson = 15106;

        /// <remarks />
        public const uint RegisterServer2Request_Encoding_DefaultJson = 15107;

        /// <remarks />
        public const uint RegisterServer2Response_Encoding_DefaultJson = 15130;

        /// <remarks />
        public const uint ChannelSecurityToken_Encoding_DefaultJson = 15131;

        /// <remarks />
        public const uint OpenSecureChannelRequest_Encoding_DefaultJson = 15132;

        /// <remarks />
        public const uint OpenSecureChannelResponse_Encoding_DefaultJson = 15133;

        /// <remarks />
        public const uint CloseSecureChannelRequest_Encoding_DefaultJson = 15134;

        /// <remarks />
        public const uint CloseSecureChannelResponse_Encoding_DefaultJson = 15135;

        /// <remarks />
        public const uint SignedSoftwareCertificate_Encoding_DefaultJson = 15136;

        /// <remarks />
        public const uint SignatureData_Encoding_DefaultJson = 15137;

        /// <remarks />
        public const uint CreateSessionRequest_Encoding_DefaultJson = 15138;

        /// <remarks />
        public const uint CreateSessionResponse_Encoding_DefaultJson = 15139;

        /// <remarks />
        public const uint UserIdentityToken_Encoding_DefaultJson = 15140;

        /// <remarks />
        public const uint AnonymousIdentityToken_Encoding_DefaultJson = 15141;

        /// <remarks />
        public const uint UserNameIdentityToken_Encoding_DefaultJson = 15142;

        /// <remarks />
        public const uint X509IdentityToken_Encoding_DefaultJson = 15143;

        /// <remarks />
        public const uint IssuedIdentityToken_Encoding_DefaultJson = 15144;

        /// <remarks />
        public const uint ActivateSessionRequest_Encoding_DefaultJson = 15145;

        /// <remarks />
        public const uint ActivateSessionResponse_Encoding_DefaultJson = 15146;

        /// <remarks />
        public const uint CloseSessionRequest_Encoding_DefaultJson = 15147;

        /// <remarks />
        public const uint CloseSessionResponse_Encoding_DefaultJson = 15148;

        /// <remarks />
        public const uint CancelRequest_Encoding_DefaultJson = 15149;

        /// <remarks />
        public const uint CancelResponse_Encoding_DefaultJson = 15150;

        /// <remarks />
        public const uint NodeAttributes_Encoding_DefaultJson = 15151;

        /// <remarks />
        public const uint ObjectAttributes_Encoding_DefaultJson = 15152;

        /// <remarks />
        public const uint VariableAttributes_Encoding_DefaultJson = 15153;

        /// <remarks />
        public const uint MethodAttributes_Encoding_DefaultJson = 15157;

        /// <remarks />
        public const uint ObjectTypeAttributes_Encoding_DefaultJson = 15158;

        /// <remarks />
        public const uint VariableTypeAttributes_Encoding_DefaultJson = 15159;

        /// <remarks />
        public const uint ReferenceTypeAttributes_Encoding_DefaultJson = 15160;

        /// <remarks />
        public const uint DataTypeAttributes_Encoding_DefaultJson = 15161;

        /// <remarks />
        public const uint ViewAttributes_Encoding_DefaultJson = 15162;

        /// <remarks />
        public const uint GenericAttributeValue_Encoding_DefaultJson = 15163;

        /// <remarks />
        public const uint GenericAttributes_Encoding_DefaultJson = 15164;

        /// <remarks />
        public const uint AddNodesItem_Encoding_DefaultJson = 15165;

        /// <remarks />
        public const uint AddNodesResult_Encoding_DefaultJson = 15166;

        /// <remarks />
        public const uint AddNodesRequest_Encoding_DefaultJson = 15167;

        /// <remarks />
        public const uint AddNodesResponse_Encoding_DefaultJson = 15168;

        /// <remarks />
        public const uint AddReferencesItem_Encoding_DefaultJson = 15169;

        /// <remarks />
        public const uint AddReferencesRequest_Encoding_DefaultJson = 15170;

        /// <remarks />
        public const uint AddReferencesResponse_Encoding_DefaultJson = 15171;

        /// <remarks />
        public const uint DeleteNodesItem_Encoding_DefaultJson = 15172;

        /// <remarks />
        public const uint DeleteNodesRequest_Encoding_DefaultJson = 15173;

        /// <remarks />
        public const uint DeleteNodesResponse_Encoding_DefaultJson = 15174;

        /// <remarks />
        public const uint DeleteReferencesItem_Encoding_DefaultJson = 15175;

        /// <remarks />
        public const uint DeleteReferencesRequest_Encoding_DefaultJson = 15176;

        /// <remarks />
        public const uint DeleteReferencesResponse_Encoding_DefaultJson = 15177;

        /// <remarks />
        public const uint ViewDescription_Encoding_DefaultJson = 15179;

        /// <remarks />
        public const uint BrowseDescription_Encoding_DefaultJson = 15180;

        /// <remarks />
        public const uint ReferenceDescription_Encoding_DefaultJson = 15182;

        /// <remarks />
        public const uint BrowseResult_Encoding_DefaultJson = 15183;

        /// <remarks />
        public const uint BrowseRequest_Encoding_DefaultJson = 15184;

        /// <remarks />
        public const uint BrowseResponse_Encoding_DefaultJson = 15185;

        /// <remarks />
        public const uint BrowseNextRequest_Encoding_DefaultJson = 15186;

        /// <remarks />
        public const uint BrowseNextResponse_Encoding_DefaultJson = 15187;

        /// <remarks />
        public const uint RelativePathElement_Encoding_DefaultJson = 15188;

        /// <remarks />
        public const uint RelativePath_Encoding_DefaultJson = 15189;

        /// <remarks />
        public const uint BrowsePath_Encoding_DefaultJson = 15190;

        /// <remarks />
        public const uint BrowsePathTarget_Encoding_DefaultJson = 15191;

        /// <remarks />
        public const uint BrowsePathResult_Encoding_DefaultJson = 15192;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson = 15193;

        /// <remarks />
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson = 15194;

        /// <remarks />
        public const uint RegisterNodesRequest_Encoding_DefaultJson = 15195;

        /// <remarks />
        public const uint RegisterNodesResponse_Encoding_DefaultJson = 15196;

        /// <remarks />
        public const uint UnregisterNodesRequest_Encoding_DefaultJson = 15197;

        /// <remarks />
        public const uint UnregisterNodesResponse_Encoding_DefaultJson = 15198;

        /// <remarks />
        public const uint EndpointConfiguration_Encoding_DefaultJson = 15199;

        /// <remarks />
        public const uint QueryDataDescription_Encoding_DefaultJson = 15200;

        /// <remarks />
        public const uint NodeTypeDescription_Encoding_DefaultJson = 15201;

        /// <remarks />
        public const uint QueryDataSet_Encoding_DefaultJson = 15202;

        /// <remarks />
        public const uint NodeReference_Encoding_DefaultJson = 15203;

        /// <remarks />
        public const uint ContentFilterElement_Encoding_DefaultJson = 15204;

        /// <remarks />
        public const uint ContentFilter_Encoding_DefaultJson = 15205;

        /// <remarks />
        public const uint FilterOperand_Encoding_DefaultJson = 15206;

        /// <remarks />
        public const uint ElementOperand_Encoding_DefaultJson = 15207;

        /// <remarks />
        public const uint LiteralOperand_Encoding_DefaultJson = 15208;

        /// <remarks />
        public const uint AttributeOperand_Encoding_DefaultJson = 15209;

        /// <remarks />
        public const uint SimpleAttributeOperand_Encoding_DefaultJson = 15210;

        /// <remarks />
        public const uint ContentFilterElementResult_Encoding_DefaultJson = 15211;

        /// <remarks />
        public const uint ContentFilterResult_Encoding_DefaultJson = 15228;

        /// <remarks />
        public const uint ParsingResult_Encoding_DefaultJson = 15236;

        /// <remarks />
        public const uint QueryFirstRequest_Encoding_DefaultJson = 15244;

        /// <remarks />
        public const uint QueryFirstResponse_Encoding_DefaultJson = 15252;

        /// <remarks />
        public const uint QueryNextRequest_Encoding_DefaultJson = 15254;

        /// <remarks />
        public const uint QueryNextResponse_Encoding_DefaultJson = 15255;

        /// <remarks />
        public const uint ReadValueId_Encoding_DefaultJson = 15256;

        /// <remarks />
        public const uint ReadRequest_Encoding_DefaultJson = 15257;

        /// <remarks />
        public const uint ReadResponse_Encoding_DefaultJson = 15258;

        /// <remarks />
        public const uint HistoryReadValueId_Encoding_DefaultJson = 15259;

        /// <remarks />
        public const uint HistoryReadResult_Encoding_DefaultJson = 15260;

        /// <remarks />
        public const uint HistoryReadDetails_Encoding_DefaultJson = 15261;

        /// <remarks />
        public const uint ReadEventDetails_Encoding_DefaultJson = 15262;

        /// <remarks />
        public const uint ReadRawModifiedDetails_Encoding_DefaultJson = 15263;

        /// <remarks />
        public const uint ReadProcessedDetails_Encoding_DefaultJson = 15264;

        /// <remarks />
        public const uint ReadAtTimeDetails_Encoding_DefaultJson = 15269;

        /// <remarks />
        public const uint ReadAnnotationDataDetails_Encoding_DefaultJson = 23512;

        /// <remarks />
        public const uint HistoryData_Encoding_DefaultJson = 15270;

        /// <remarks />
        public const uint ModificationInfo_Encoding_DefaultJson = 15271;

        /// <remarks />
        public const uint HistoryModifiedData_Encoding_DefaultJson = 15272;

        /// <remarks />
        public const uint HistoryEvent_Encoding_DefaultJson = 15273;

        /// <remarks />
        public const uint HistoryReadRequest_Encoding_DefaultJson = 15274;

        /// <remarks />
        public const uint HistoryReadResponse_Encoding_DefaultJson = 15275;

        /// <remarks />
        public const uint WriteValue_Encoding_DefaultJson = 15276;

        /// <remarks />
        public const uint WriteRequest_Encoding_DefaultJson = 15277;

        /// <remarks />
        public const uint WriteResponse_Encoding_DefaultJson = 15278;

        /// <remarks />
        public const uint HistoryUpdateDetails_Encoding_DefaultJson = 15279;

        /// <remarks />
        public const uint UpdateDataDetails_Encoding_DefaultJson = 15280;

        /// <remarks />
        public const uint UpdateStructureDataDetails_Encoding_DefaultJson = 15281;

        /// <remarks />
        public const uint UpdateEventDetails_Encoding_DefaultJson = 15282;

        /// <remarks />
        public const uint DeleteRawModifiedDetails_Encoding_DefaultJson = 15283;

        /// <remarks />
        public const uint DeleteAtTimeDetails_Encoding_DefaultJson = 15284;

        /// <remarks />
        public const uint DeleteEventDetails_Encoding_DefaultJson = 15285;

        /// <remarks />
        public const uint HistoryUpdateResult_Encoding_DefaultJson = 15286;

        /// <remarks />
        public const uint HistoryUpdateRequest_Encoding_DefaultJson = 15287;

        /// <remarks />
        public const uint HistoryUpdateResponse_Encoding_DefaultJson = 15288;

        /// <remarks />
        public const uint CallMethodRequest_Encoding_DefaultJson = 15289;

        /// <remarks />
        public const uint CallMethodResult_Encoding_DefaultJson = 15290;

        /// <remarks />
        public const uint CallRequest_Encoding_DefaultJson = 15291;

        /// <remarks />
        public const uint CallResponse_Encoding_DefaultJson = 15292;

        /// <remarks />
        public const uint MonitoringFilter_Encoding_DefaultJson = 15293;

        /// <remarks />
        public const uint DataChangeFilter_Encoding_DefaultJson = 15294;

        /// <remarks />
        public const uint EventFilter_Encoding_DefaultJson = 15295;

        /// <remarks />
        public const uint AggregateConfiguration_Encoding_DefaultJson = 15304;

        /// <remarks />
        public const uint AggregateFilter_Encoding_DefaultJson = 15312;

        /// <remarks />
        public const uint MonitoringFilterResult_Encoding_DefaultJson = 15313;

        /// <remarks />
        public const uint EventFilterResult_Encoding_DefaultJson = 15314;

        /// <remarks />
        public const uint AggregateFilterResult_Encoding_DefaultJson = 15315;

        /// <remarks />
        public const uint MonitoringParameters_Encoding_DefaultJson = 15320;

        /// <remarks />
        public const uint MonitoredItemCreateRequest_Encoding_DefaultJson = 15321;

        /// <remarks />
        public const uint MonitoredItemCreateResult_Encoding_DefaultJson = 15322;

        /// <remarks />
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultJson = 15323;

        /// <remarks />
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultJson = 15324;

        /// <remarks />
        public const uint MonitoredItemModifyRequest_Encoding_DefaultJson = 15325;

        /// <remarks />
        public const uint MonitoredItemModifyResult_Encoding_DefaultJson = 15326;

        /// <remarks />
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultJson = 15327;

        /// <remarks />
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultJson = 15328;

        /// <remarks />
        public const uint SetMonitoringModeRequest_Encoding_DefaultJson = 15329;

        /// <remarks />
        public const uint SetMonitoringModeResponse_Encoding_DefaultJson = 15331;

        /// <remarks />
        public const uint SetTriggeringRequest_Encoding_DefaultJson = 15332;

        /// <remarks />
        public const uint SetTriggeringResponse_Encoding_DefaultJson = 15333;

        /// <remarks />
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultJson = 15335;

        /// <remarks />
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultJson = 15336;

        /// <remarks />
        public const uint CreateSubscriptionRequest_Encoding_DefaultJson = 15337;

        /// <remarks />
        public const uint CreateSubscriptionResponse_Encoding_DefaultJson = 15338;

        /// <remarks />
        public const uint ModifySubscriptionRequest_Encoding_DefaultJson = 15339;

        /// <remarks />
        public const uint ModifySubscriptionResponse_Encoding_DefaultJson = 15340;

        /// <remarks />
        public const uint SetPublishingModeRequest_Encoding_DefaultJson = 15341;

        /// <remarks />
        public const uint SetPublishingModeResponse_Encoding_DefaultJson = 15342;

        /// <remarks />
        public const uint NotificationMessage_Encoding_DefaultJson = 15343;

        /// <remarks />
        public const uint NotificationData_Encoding_DefaultJson = 15344;

        /// <remarks />
        public const uint DataChangeNotification_Encoding_DefaultJson = 15345;

        /// <remarks />
        public const uint MonitoredItemNotification_Encoding_DefaultJson = 15346;

        /// <remarks />
        public const uint EventNotificationList_Encoding_DefaultJson = 15347;

        /// <remarks />
        public const uint EventFieldList_Encoding_DefaultJson = 15348;

        /// <remarks />
        public const uint HistoryEventFieldList_Encoding_DefaultJson = 15349;

        /// <remarks />
        public const uint StatusChangeNotification_Encoding_DefaultJson = 15350;

        /// <remarks />
        public const uint SubscriptionAcknowledgement_Encoding_DefaultJson = 15351;

        /// <remarks />
        public const uint PublishRequest_Encoding_DefaultJson = 15352;

        /// <remarks />
        public const uint PublishResponse_Encoding_DefaultJson = 15353;

        /// <remarks />
        public const uint RepublishRequest_Encoding_DefaultJson = 15354;

        /// <remarks />
        public const uint RepublishResponse_Encoding_DefaultJson = 15355;

        /// <remarks />
        public const uint TransferResult_Encoding_DefaultJson = 15356;

        /// <remarks />
        public const uint TransferSubscriptionsRequest_Encoding_DefaultJson = 15357;

        /// <remarks />
        public const uint TransferSubscriptionsResponse_Encoding_DefaultJson = 15358;

        /// <remarks />
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultJson = 15359;

        /// <remarks />
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultJson = 15360;

        /// <remarks />
        public const uint BuildInfo_Encoding_DefaultJson = 15361;

        /// <remarks />
        public const uint RedundantServerDataType_Encoding_DefaultJson = 15362;

        /// <remarks />
        public const uint EndpointUrlListDataType_Encoding_DefaultJson = 15363;

        /// <remarks />
        public const uint NetworkGroupDataType_Encoding_DefaultJson = 15364;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson = 15365;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultJson = 15366;

        /// <remarks />
        public const uint ServerStatusDataType_Encoding_DefaultJson = 15367;

        /// <remarks />
        public const uint SessionDiagnosticsDataType_Encoding_DefaultJson = 15368;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultJson = 15369;

        /// <remarks />
        public const uint ServiceCounterDataType_Encoding_DefaultJson = 15370;

        /// <remarks />
        public const uint StatusResult_Encoding_DefaultJson = 15371;

        /// <remarks />
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultJson = 15372;

        /// <remarks />
        public const uint ModelChangeStructureDataType_Encoding_DefaultJson = 15373;

        /// <remarks />
        public const uint SemanticChangeStructureDataType_Encoding_DefaultJson = 15374;

        /// <remarks />
        public const uint Range_Encoding_DefaultJson = 15375;

        /// <remarks />
        public const uint EUInformation_Encoding_DefaultJson = 15376;

        /// <remarks />
        public const uint ComplexNumberType_Encoding_DefaultJson = 15377;

        /// <remarks />
        public const uint DoubleComplexNumberType_Encoding_DefaultJson = 15378;

        /// <remarks />
        public const uint AxisInformation_Encoding_DefaultJson = 15379;

        /// <remarks />
        public const uint XVType_Encoding_DefaultJson = 15380;

        /// <remarks />
        public const uint ProgramDiagnosticDataType_Encoding_DefaultJson = 15381;

        /// <remarks />
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultJson = 24042;

        /// <remarks />
        public const uint Annotation_Encoding_DefaultJson = 15382;
    }
    #endregion

    #region ObjectType Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ObjectTypes
    {
        /// <remarks />
        public const uint BaseObjectType = 58;

        /// <remarks />
        public const uint FolderType = 61;

        /// <remarks />
        public const uint DataTypeSystemType = 75;

        /// <remarks />
        public const uint DataTypeEncodingType = 76;

        /// <remarks />
        public const uint ModellingRuleType = 77;

        /// <remarks />
        public const uint ServerType = 2004;

        /// <remarks />
        public const uint ServerCapabilitiesType = 2013;

        /// <remarks />
        public const uint ServerDiagnosticsType = 2020;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType = 2026;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType = 2029;

        /// <remarks />
        public const uint VendorServerInfoType = 2033;

        /// <remarks />
        public const uint ServerRedundancyType = 2034;

        /// <remarks />
        public const uint TransparentRedundancyType = 2036;

        /// <remarks />
        public const uint NonTransparentRedundancyType = 2039;

        /// <remarks />
        public const uint NonTransparentNetworkRedundancyType = 11945;

        /// <remarks />
        public const uint OperationLimitsType = 11564;

        /// <remarks />
        public const uint FileType = 11575;

        /// <remarks />
        public const uint AddressSpaceFileType = 11595;

        /// <remarks />
        public const uint NamespaceMetadataType = 11616;

        /// <remarks />
        public const uint NamespacesType = 11645;

        /// <remarks />
        public const uint BaseEventType = 2041;

        /// <remarks />
        public const uint AuditEventType = 2052;

        /// <remarks />
        public const uint AuditSecurityEventType = 2058;

        /// <remarks />
        public const uint AuditChannelEventType = 2059;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType = 2060;

        /// <remarks />
        public const uint AuditSessionEventType = 2069;

        /// <remarks />
        public const uint AuditCreateSessionEventType = 2071;

        /// <remarks />
        public const uint AuditUrlMismatchEventType = 2748;

        /// <remarks />
        public const uint AuditActivateSessionEventType = 2075;

        /// <remarks />
        public const uint AuditCancelEventType = 2078;

        /// <remarks />
        public const uint AuditCertificateEventType = 2080;

        /// <remarks />
        public const uint AuditCertificateDataMismatchEventType = 2082;

        /// <remarks />
        public const uint AuditCertificateExpiredEventType = 2085;

        /// <remarks />
        public const uint AuditCertificateInvalidEventType = 2086;

        /// <remarks />
        public const uint AuditCertificateUntrustedEventType = 2087;

        /// <remarks />
        public const uint AuditCertificateRevokedEventType = 2088;

        /// <remarks />
        public const uint AuditCertificateMismatchEventType = 2089;

        /// <remarks />
        public const uint AuditNodeManagementEventType = 2090;

        /// <remarks />
        public const uint AuditAddNodesEventType = 2091;

        /// <remarks />
        public const uint AuditDeleteNodesEventType = 2093;

        /// <remarks />
        public const uint AuditAddReferencesEventType = 2095;

        /// <remarks />
        public const uint AuditDeleteReferencesEventType = 2097;

        /// <remarks />
        public const uint AuditUpdateEventType = 2099;

        /// <remarks />
        public const uint AuditWriteUpdateEventType = 2100;

        /// <remarks />
        public const uint AuditHistoryUpdateEventType = 2104;

        /// <remarks />
        public const uint AuditUpdateMethodEventType = 2127;

        /// <remarks />
        public const uint SystemEventType = 2130;

        /// <remarks />
        public const uint DeviceFailureEventType = 2131;

        /// <remarks />
        public const uint SystemStatusChangeEventType = 11446;

        /// <remarks />
        public const uint BaseModelChangeEventType = 2132;

        /// <remarks />
        public const uint GeneralModelChangeEventType = 2133;

        /// <remarks />
        public const uint SemanticChangeEventType = 2738;

        /// <remarks />
        public const uint EventQueueOverflowEventType = 3035;

        /// <remarks />
        public const uint ProgressEventType = 11436;

        /// <remarks />
        public const uint AuditClientEventType = 23606;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType = 23926;

        /// <remarks />
        public const uint AggregateFunctionType = 2340;

        /// <remarks />
        public const uint StateMachineType = 2299;

        /// <remarks />
        public const uint FiniteStateMachineType = 2771;

        /// <remarks />
        public const uint StateType = 2307;

        /// <remarks />
        public const uint InitialStateType = 2309;

        /// <remarks />
        public const uint TransitionType = 2310;

        /// <remarks />
        public const uint ChoiceStateType = 15109;

        /// <remarks />
        public const uint TransitionEventType = 2311;

        /// <remarks />
        public const uint AuditUpdateStateEventType = 2315;

        /// <remarks />
        public const uint FileDirectoryType = 13353;

        /// <remarks />
        public const uint TemporaryFileTransferType = 15744;

        /// <remarks />
        public const uint FileTransferStateMachineType = 15803;

        /// <remarks />
        public const uint RoleSetType = 15607;

        /// <remarks />
        public const uint RoleType = 15620;

        /// <remarks />
        public const uint RoleMappingRuleChangedAuditEventType = 17641;

        /// <remarks />
        public const uint DictionaryEntryType = 17589;

        /// <remarks />
        public const uint DictionaryFolderType = 17591;

        /// <remarks />
        public const uint IrdiDictionaryEntryType = 17598;

        /// <remarks />
        public const uint UriDictionaryEntryType = 17600;

        /// <remarks />
        public const uint BaseInterfaceType = 17602;

        /// <remarks />
        public const uint IOrderedObjectType = 23513;

        /// <remarks />
        public const uint OrderedListType = 23518;

        /// <remarks />
        public const uint ConditionType = 2782;

        /// <remarks />
        public const uint DialogConditionType = 2830;

        /// <remarks />
        public const uint AcknowledgeableConditionType = 2881;

        /// <remarks />
        public const uint AlarmConditionType = 2915;

        /// <remarks />
        public const uint AlarmGroupType = 16405;

        /// <remarks />
        public const uint AlarmSuppressionGroupType = 32064;

        /// <remarks />
        public const uint ShelvedStateMachineType = 2929;

        /// <remarks />
        public const uint LimitAlarmType = 2955;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType = 9318;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType = 9341;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType = 9906;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType = 10060;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType = 9482;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType = 10368;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType = 10214;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType = 9764;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType = 9623;

        /// <remarks />
        public const uint DiscreteAlarmType = 10523;

        /// <remarks />
        public const uint OffNormalAlarmType = 10637;

        /// <remarks />
        public const uint SystemOffNormalAlarmType = 11753;

        /// <remarks />
        public const uint TripAlarmType = 10751;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType = 18347;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType = 18496;

        /// <remarks />
        public const uint CertificateExpirationAlarmType = 13225;

        /// <remarks />
        public const uint DiscrepancyAlarmType = 17080;

        /// <remarks />
        public const uint BaseConditionClassType = 11163;

        /// <remarks />
        public const uint ProcessConditionClassType = 11164;

        /// <remarks />
        public const uint MaintenanceConditionClassType = 11165;

        /// <remarks />
        public const uint SystemConditionClassType = 11166;

        /// <remarks />
        public const uint SafetyConditionClassType = 17218;

        /// <remarks />
        public const uint HighlyManagedAlarmConditionClassType = 17219;

        /// <remarks />
        public const uint TrainingConditionClassType = 17220;

        /// <remarks />
        public const uint StatisticalConditionClassType = 18665;

        /// <remarks />
        public const uint TestingConditionClassType = 17221;

        /// <remarks />
        public const uint AuditConditionEventType = 2790;

        /// <remarks />
        public const uint AuditConditionEnableEventType = 2803;

        /// <remarks />
        public const uint AuditConditionCommentEventType = 2829;

        /// <remarks />
        public const uint AuditConditionRespondEventType = 8927;

        /// <remarks />
        public const uint AuditConditionAcknowledgeEventType = 8944;

        /// <remarks />
        public const uint AuditConditionConfirmEventType = 8961;

        /// <remarks />
        public const uint AuditConditionShelvingEventType = 11093;

        /// <remarks />
        public const uint AuditConditionSuppressionEventType = 17225;

        /// <remarks />
        public const uint AuditConditionSilenceEventType = 17242;

        /// <remarks />
        public const uint AuditConditionResetEventType = 15013;

        /// <remarks />
        public const uint AuditConditionOutOfServiceEventType = 17259;

        /// <remarks />
        public const uint RefreshStartEventType = 2787;

        /// <remarks />
        public const uint RefreshEndEventType = 2788;

        /// <remarks />
        public const uint RefreshRequiredEventType = 2789;

        /// <remarks />
        public const uint AlarmMetricsType = 17279;

        /// <remarks />
        public const uint ProgramStateMachineType = 2391;

        /// <remarks />
        public const uint ProgramTransitionEventType = 2378;

        /// <remarks />
        public const uint AuditProgramTransitionEventType = 11856;

        /// <remarks />
        public const uint ProgramTransitionAuditEventType = 3806;

        /// <remarks />
        public const uint HistoricalDataConfigurationType = 2318;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType = 2330;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType = 2999;

        /// <remarks />
        public const uint AuditHistoryValueUpdateEventType = 3006;

        /// <remarks />
        public const uint AuditHistoryAnnotationUpdateEventType = 19095;

        /// <remarks />
        public const uint AuditHistoryDeleteEventType = 3012;

        /// <remarks />
        public const uint AuditHistoryRawModifyDeleteEventType = 3014;

        /// <remarks />
        public const uint AuditHistoryAtTimeDeleteEventType = 3019;

        /// <remarks />
        public const uint AuditHistoryEventDeleteEventType = 3022;

        /// <remarks />
        public const uint TrustListType = 12522;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType = 19297;

        /// <remarks />
        public const uint CertificateGroupType = 12555;

        /// <remarks />
        public const uint CertificateGroupFolderType = 13813;

        /// <remarks />
        public const uint CertificateType = 12556;

        /// <remarks />
        public const uint ApplicationCertificateType = 12557;

        /// <remarks />
        public const uint HttpsCertificateType = 12558;

        /// <remarks />
        public const uint UserCredentialCertificateType = 15181;

        /// <remarks />
        public const uint RsaMinApplicationCertificateType = 12559;

        /// <remarks />
        public const uint RsaSha256ApplicationCertificateType = 12560;

        /// <remarks />
        public const uint EccApplicationCertificateType = 23537;

        /// <remarks />
        public const uint EccNistP256ApplicationCertificateType = 23538;

        /// <remarks />
        public const uint EccNistP384ApplicationCertificateType = 23539;

        /// <remarks />
        public const uint EccBrainpoolP256r1ApplicationCertificateType = 23540;

        /// <remarks />
        public const uint EccBrainpoolP384r1ApplicationCertificateType = 23541;

        /// <remarks />
        public const uint EccCurve25519ApplicationCertificateType = 23542;

        /// <remarks />
        public const uint EccCurve448ApplicationCertificateType = 23543;

        /// <remarks />
        public const uint TrustListUpdateRequestedAuditEventType = 32260;

        /// <remarks />
        public const uint TrustListUpdatedAuditEventType = 12561;

        /// <remarks />
        public const uint TransactionDiagnosticsType = 32286;

        /// <remarks />
        public const uint ServerConfigurationType = 12581;

        /// <remarks />
        public const uint CertificateUpdateRequestedAuditEventType = 32306;

        /// <remarks />
        public const uint CertificateUpdatedAuditEventType = 12620;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType = 17496;

        /// <remarks />
        public const uint KeyCredentialConfigurationType = 18001;

        /// <remarks />
        public const uint KeyCredentialAuditEventType = 18011;

        /// <remarks />
        public const uint KeyCredentialUpdatedAuditEventType = 18029;

        /// <remarks />
        public const uint KeyCredentialDeletedAuditEventType = 18047;

        /// <remarks />
        public const uint AuthorizationServicesConfigurationFolderType = 23556;

        /// <remarks />
        public const uint AuthorizationServiceConfigurationType = 17852;

        /// <remarks />
        public const uint AggregateConfigurationType = 11187;

        /// <remarks />
        public const uint PubSubKeyServiceType = 15906;

        /// <remarks />
        public const uint SecurityGroupFolderType = 15452;

        /// <remarks />
        public const uint SecurityGroupType = 15471;

        /// <remarks />
        public const uint PubSubKeyPushTargetType = 25337;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType = 25346;

        /// <remarks />
        public const uint PublishSubscribeType = 14416;

        /// <remarks />
        public const uint PubSubConfigurationType = 25482;

        /// <remarks />
        public const uint PublishedDataSetType = 14509;

        /// <remarks />
        public const uint ExtensionFieldsType = 15489;

        /// <remarks />
        public const uint PublishedDataItemsType = 14534;

        /// <remarks />
        public const uint PublishedEventsType = 14572;

        /// <remarks />
        public const uint DataSetFolderType = 14477;

        /// <remarks />
        public const uint PubSubConnectionType = 14209;

        /// <remarks />
        public const uint ConnectionTransportType = 17721;

        /// <remarks />
        public const uint PubSubGroupType = 14232;

        /// <remarks />
        public const uint WriterGroupType = 17725;

        /// <remarks />
        public const uint WriterGroupTransportType = 17997;

        /// <remarks />
        public const uint WriterGroupMessageType = 17998;

        /// <remarks />
        public const uint ReaderGroupType = 17999;

        /// <remarks />
        public const uint ReaderGroupTransportType = 21090;

        /// <remarks />
        public const uint ReaderGroupMessageType = 21091;

        /// <remarks />
        public const uint DataSetWriterType = 15298;

        /// <remarks />
        public const uint DataSetWriterTransportType = 15305;

        /// <remarks />
        public const uint DataSetWriterMessageType = 21096;

        /// <remarks />
        public const uint DataSetReaderType = 15306;

        /// <remarks />
        public const uint DataSetReaderTransportType = 15319;

        /// <remarks />
        public const uint DataSetReaderMessageType = 21104;

        /// <remarks />
        public const uint SubscribedDataSetType = 15108;

        /// <remarks />
        public const uint TargetVariablesType = 15111;

        /// <remarks />
        public const uint SubscribedDataSetMirrorType = 15127;

        /// <remarks />
        public const uint SubscribedDataSetFolderType = 23795;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetType = 23828;

        /// <remarks />
        public const uint PubSubStatusType = 14643;

        /// <remarks />
        public const uint PubSubDiagnosticsType = 19677;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType = 19732;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType = 19786;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType = 19834;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType = 19903;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType = 19968;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType = 20027;

        /// <remarks />
        public const uint PubSubCapabilitiesType = 23832;

        /// <remarks />
        public const uint PubSubStatusEventType = 15535;

        /// <remarks />
        public const uint PubSubTransportLimitsExceedEventType = 15548;

        /// <remarks />
        public const uint PubSubCommunicationFailureEventType = 15563;

        /// <remarks />
        public const uint UadpWriterGroupMessageType = 21105;

        /// <remarks />
        public const uint UadpDataSetWriterMessageType = 21111;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType = 21116;

        /// <remarks />
        public const uint JsonWriterGroupMessageType = 21126;

        /// <remarks />
        public const uint JsonDataSetWriterMessageType = 21128;

        /// <remarks />
        public const uint JsonDataSetReaderMessageType = 21130;

        /// <remarks />
        public const uint DatagramConnectionTransportType = 15064;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType = 21133;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType = 24016;

        /// <remarks />
        public const uint BrokerConnectionTransportType = 15155;

        /// <remarks />
        public const uint BrokerWriterGroupTransportType = 21136;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType = 21138;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType = 21142;

        /// <remarks />
        public const uint NetworkAddressType = 21145;

        /// <remarks />
        public const uint NetworkAddressUrlType = 21147;

        /// <remarks />
        public const uint AliasNameType = 23455;

        /// <remarks />
        public const uint AliasNameCategoryType = 23456;

        /// <remarks />
        public const uint UserManagementType = 24264;

        /// <remarks />
        public const uint ApplicationConfigurationType = 25731;

        /// <remarks />
        public const uint ProvisionableDeviceType = 26871;

        /// <remarks />
        public const uint IIetfBaseNetworkInterfaceType = 24148;

        /// <remarks />
        public const uint IIeeeBaseEthernetPortType = 24158;

        /// <remarks />
        public const uint IIeeeAutoNegotiationStatusType = 24233;

        /// <remarks />
        public const uint IBaseEthernetCapabilitiesType = 24167;

        /// <remarks />
        public const uint IVlanIdType = 25218;

        /// <remarks />
        public const uint ISrClassType = 24169;

        /// <remarks />
        public const uint IIeeeBaseTsnStreamType = 24173;

        /// <remarks />
        public const uint IIeeeBaseTsnTrafficSpecificationType = 24179;

        /// <remarks />
        public const uint IIeeeBaseTsnStatusStreamType = 24183;

        /// <remarks />
        public const uint IIeeeTsnInterfaceConfigurationType = 24188;

        /// <remarks />
        public const uint IIeeeTsnInterfaceConfigurationTalkerType = 24191;

        /// <remarks />
        public const uint IIeeeTsnInterfaceConfigurationListenerType = 24195;

        /// <remarks />
        public const uint IIeeeTsnMacAddressType = 24199;

        /// <remarks />
        public const uint IIeeeTsnVlanTagType = 24202;

        /// <remarks />
        public const uint IPriorityMappingEntryType = 24205;

        /// <remarks />
        public const uint IetfBaseNetworkInterfaceType = 25221;

        /// <remarks />
        public const uint PriorityMappingTableType = 25227;
    }
    #endregion

    #region ReferenceType Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ReferenceTypes
    {
        /// <remarks />
        public const uint References = 31;

        /// <remarks />
        public const uint NonHierarchicalReferences = 32;

        /// <remarks />
        public const uint HierarchicalReferences = 33;

        /// <remarks />
        public const uint HasChild = 34;

        /// <remarks />
        public const uint Organizes = 35;

        /// <remarks />
        public const uint HasEventSource = 36;

        /// <remarks />
        public const uint HasModellingRule = 37;

        /// <remarks />
        public const uint HasEncoding = 38;

        /// <remarks />
        public const uint HasDescription = 39;

        /// <remarks />
        public const uint HasTypeDefinition = 40;

        /// <remarks />
        public const uint GeneratesEvent = 41;

        /// <remarks />
        public const uint AlwaysGeneratesEvent = 3065;

        /// <remarks />
        public const uint Aggregates = 44;

        /// <remarks />
        public const uint HasSubtype = 45;

        /// <remarks />
        public const uint HasProperty = 46;

        /// <remarks />
        public const uint HasComponent = 47;

        /// <remarks />
        public const uint HasNotifier = 48;

        /// <remarks />
        public const uint HasOrderedComponent = 49;

        /// <remarks />
        public const uint FromState = 51;

        /// <remarks />
        public const uint ToState = 52;

        /// <remarks />
        public const uint HasCause = 53;

        /// <remarks />
        public const uint HasEffect = 54;

        /// <remarks />
        public const uint HasSubStateMachine = 117;

        /// <remarks />
        public const uint HasHistoricalConfiguration = 56;

        /// <remarks />
        public const uint HasStructuredComponent = 24136;

        /// <remarks />
        public const uint AssociatedWith = 24137;

        /// <remarks />
        public const uint HasArgumentDescription = 129;

        /// <remarks />
        public const uint HasOptionalInputArgumentDescription = 131;

        /// <remarks />
        public const uint IsDeprecated = 23562;

        /// <remarks />
        public const uint HasGuard = 15112;

        /// <remarks />
        public const uint HasDictionaryEntry = 17597;

        /// <remarks />
        public const uint HasInterface = 17603;

        /// <remarks />
        public const uint HasAddIn = 17604;

        /// <remarks />
        public const uint HasTrueSubState = 9004;

        /// <remarks />
        public const uint HasFalseSubState = 9005;

        /// <remarks />
        public const uint HasAlarmSuppressionGroup = 16361;

        /// <remarks />
        public const uint AlarmGroupMember = 16362;

        /// <remarks />
        public const uint AlarmSuppressionGroupMember = 32059;

        /// <remarks />
        public const uint HasCondition = 9006;

        /// <remarks />
        public const uint HasEffectDisable = 17276;

        /// <remarks />
        public const uint HasEffectEnable = 17983;

        /// <remarks />
        public const uint HasEffectSuppressed = 17984;

        /// <remarks />
        public const uint HasEffectUnsuppressed = 17985;

        /// <remarks />
        public const uint HasPushedSecurityGroup = 25345;

        /// <remarks />
        public const uint HasPubSubConnection = 14476;

        /// <remarks />
        public const uint DataSetToWriter = 14936;

        /// <remarks />
        public const uint HasDataSetWriter = 15296;

        /// <remarks />
        public const uint HasWriterGroup = 18804;

        /// <remarks />
        public const uint HasDataSetReader = 15297;

        /// <remarks />
        public const uint HasReaderGroup = 18805;

        /// <remarks />
        public const uint AliasFor = 23469;

        /// <remarks />
        public const uint UsesPriorityMappingTable = 25237;

        /// <remarks />
        public const uint HasLowerLayerInterface = 25238;

        /// <remarks />
        public const uint IsExecutableOn = 25253;

        /// <remarks />
        public const uint Controls = 25254;

        /// <remarks />
        public const uint Utilizes = 25255;

        /// <remarks />
        public const uint IsExecutingOn = 25265;

        /// <remarks />
        public const uint Requires = 25256;

        /// <remarks />
        public const uint IsPhysicallyConnectedTo = 25257;

        /// <remarks />
        public const uint RepresentsSameEntityAs = 25258;

        /// <remarks />
        public const uint RepresentsSameHardwareAs = 25259;

        /// <remarks />
        public const uint RepresentsSameFunctionalityAs = 25260;

        /// <remarks />
        public const uint IsHostedBy = 25261;

        /// <remarks />
        public const uint HasPhysicalComponent = 25262;

        /// <remarks />
        public const uint HasContainedComponent = 25263;

        /// <remarks />
        public const uint HasAttachedComponent = 25264;

        /// <remarks />
        public const uint HasReferenceDescription = 32679;
    }
    #endregion

    #region Variable Identifiers
    /// <remarks />
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Variables
    {
        /// <remarks />
        public const uint DataTypeDescriptionType_DataTypeVersion = 104;

        /// <remarks />
        public const uint DataTypeDescriptionType_DictionaryFragment = 105;

        /// <remarks />
        public const uint DataTypeDictionaryType_DataTypeVersion = 106;

        /// <remarks />
        public const uint DataTypeDictionaryType_NamespaceUri = 107;

        /// <remarks />
        public const uint DataTypeDictionaryType_Deprecated = 15001;

        /// <remarks />
        public const uint NamingRuleType_EnumValues = 12169;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceUri = 15958;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceVersion = 15959;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespacePublicationDate = 15960;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_IsNamespaceSubset = 15961;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_StaticNodeIdTypes = 15962;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_StaticNumericNodeIdRange = 15963;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_StaticStringNodeIdPattern = 15964;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Size = 15966;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Writable = 15967;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_UserWritable = 15968;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_OpenCount = 15969;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments = 15972;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments = 15973;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments = 15975;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments = 15977;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments = 15978;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments = 15980;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments = 15982;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments = 15983;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments = 15985;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_DefaultRolePermissions = 16134;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_DefaultUserRolePermissions = 16135;

        /// <remarks />
        public const uint OPCUANamespaceMetadata_DefaultAccessRestrictions = 16136;

        /// <remarks />
        public const uint NodeVersion = 3068;

        /// <remarks />
        public const uint ViewVersion = 12170;

        /// <remarks />
        public const uint Icon = 3067;

        /// <remarks />
        public const uint LocalTime = 3069;

        /// <remarks />
        public const uint AllowNulls = 3070;

        /// <remarks />
        public const uint ValueAsText = 11433;

        /// <remarks />
        public const uint MaxStringLength = 11498;

        /// <remarks />
        public const uint MaxCharacters = 15002;

        /// <remarks />
        public const uint MaxByteStringLength = 12908;

        /// <remarks />
        public const uint MaxArrayLength = 11512;

        /// <remarks />
        public const uint EngineeringUnits = 11513;

        /// <remarks />
        public const uint EnumStrings = 11432;

        /// <remarks />
        public const uint EnumValues = 3071;

        /// <remarks />
        public const uint OptionSetValues = 12745;

        /// <remarks />
        public const uint OptionSetLength = 32750;

        /// <remarks />
        public const uint InputArguments = 3072;

        /// <remarks />
        public const uint OutputArguments = 3073;

        /// <remarks />
        public const uint DefaultInstanceBrowseName = 17605;

        /// <remarks />
        public const uint ServerType_ServerArray = 2005;

        /// <remarks />
        public const uint ServerType_NamespaceArray = 2006;

        /// <remarks />
        public const uint ServerType_UrisVersion = 15003;

        /// <remarks />
        public const uint ServerType_ServerStatus = 2007;

        /// <remarks />
        public const uint ServerType_ServerStatus_StartTime = 3074;

        /// <remarks />
        public const uint ServerType_ServerStatus_CurrentTime = 3075;

        /// <remarks />
        public const uint ServerType_ServerStatus_State = 3076;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo = 3077;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_ProductUri = 3078;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_ManufacturerName = 3079;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_ProductName = 3080;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_SoftwareVersion = 3081;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_BuildNumber = 3082;

        /// <remarks />
        public const uint ServerType_ServerStatus_BuildInfo_BuildDate = 3083;

        /// <remarks />
        public const uint ServerType_ServerStatus_SecondsTillShutdown = 3084;

        /// <remarks />
        public const uint ServerType_ServerStatus_ShutdownReason = 3085;

        /// <remarks />
        public const uint ServerType_ServiceLevel = 2008;

        /// <remarks />
        public const uint ServerType_Auditing = 2742;

        /// <remarks />
        public const uint ServerType_EstimatedReturnTime = 12882;

        /// <remarks />
        public const uint ServerType_LocalTime = 17612;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_ServerProfileArray = 3086;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_LocaleIdArray = 3087;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_MinSupportedSampleRate = 3088;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_MaxBrowseContinuationPoints = 3089;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_MaxQueryContinuationPoints = 3090;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_MaxHistoryContinuationPoints = 3091;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_SoftwareCertificates = 3092;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments = 16291;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments = 16292;

        /// <remarks />
        public const uint ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments = 16294;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary = 3095;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount = 3096;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount = 3097;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount = 3098;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 3099;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount = 3100;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount = 3101;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount = 3102;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount = 3104;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount = 3105;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 3106;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 3107;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount = 3108;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray = 3110;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3112;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3113;

        /// <remarks />
        public const uint ServerType_ServerDiagnostics_EnabledFlag = 3114;

        /// <remarks />
        public const uint ServerType_ServerRedundancy_RedundancySupport = 3115;

        /// <remarks />
        public const uint ServerType_GetMonitoredItems_InputArguments = 11490;

        /// <remarks />
        public const uint ServerType_GetMonitoredItems_OutputArguments = 11491;

        /// <remarks />
        public const uint ServerType_ResendData_InputArguments = 12872;

        /// <remarks />
        public const uint ServerType_SetSubscriptionDurable_InputArguments = 12747;

        /// <remarks />
        public const uint ServerType_SetSubscriptionDurable_OutputArguments = 12748;

        /// <remarks />
        public const uint ServerType_RequestServerStateChange_InputArguments = 12884;

        /// <remarks />
        public const uint ServerCapabilitiesType_ServerProfileArray = 2014;

        /// <remarks />
        public const uint ServerCapabilitiesType_LocaleIdArray = 2016;

        /// <remarks />
        public const uint ServerCapabilitiesType_MinSupportedSampleRate = 2017;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxBrowseContinuationPoints = 2732;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxQueryContinuationPoints = 2733;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxHistoryContinuationPoints = 2734;

        /// <remarks />
        public const uint ServerCapabilitiesType_SoftwareCertificates = 3049;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxArrayLength = 11549;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxStringLength = 11550;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxByteStringLength = 12910;

        /// <remarks />
        public const uint ServerCapabilitiesType_VendorCapability_Placeholder = 11562;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet_AddRole_InputArguments = 16297;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet_AddRole_OutputArguments = 16298;

        /// <remarks />
        public const uint ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments = 16300;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxSessions = 24088;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxSubscriptions = 24089;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxMonitoredItems = 24090;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxSubscriptionsPerSession = 24091;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxMonitoredItemsPerSubscription = 24103;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxSelectClauseParameters = 24092;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxWhereClauseParameters = 24093;

        /// <remarks />
        public const uint ServerCapabilitiesType_MaxMonitoredItemsQueueSize = 31770;

        /// <remarks />
        public const uint ServerCapabilitiesType_ConformanceUnits = 24094;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary = 2021;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount = 3116;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount = 3117;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount = 3118;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 3119;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount = 3120;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount = 3121;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount = 3122;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount = 3124;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount = 3125;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 3126;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 3127;

        /// <remarks />
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount = 3128;

        /// <remarks />
        public const uint ServerDiagnosticsType_SamplingIntervalDiagnosticsArray = 2022;

        /// <remarks />
        public const uint ServerDiagnosticsType_SubscriptionDiagnosticsArray = 2023;

        /// <remarks />
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3129;

        /// <remarks />
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3130;

        /// <remarks />
        public const uint ServerDiagnosticsType_EnabledFlag = 2025;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_SessionDiagnosticsArray = 2027;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray = 2028;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics = 12098;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId = 12099;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName = 12100;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription = 12101;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri = 12102;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl = 12103;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds = 12104;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout = 12105;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize = 12106;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime = 12107;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime = 12108;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount = 12109;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount = 12110;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue = 12111;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount = 12112;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount = 12113;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount = 12114;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount = 12115;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount = 12116;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount = 12117;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount = 12118;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount = 12119;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount = 12120;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount = 12121;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount = 12122;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount = 12123;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount = 12124;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount = 12125;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount = 12126;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount = 12127;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount = 12128;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount = 12129;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount = 12130;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount = 12131;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount = 12132;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount = 12133;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount = 12134;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount = 12135;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount = 12136;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 12137;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount = 12138;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount = 12139;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount = 12140;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount = 12141;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics = 12142;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId = 12143;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession = 12144;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory = 12145;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism = 12146;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding = 12147;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol = 12148;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode = 12149;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri = 12150;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate = 12151;

        /// <remarks />
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray = 12152;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics = 2030;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SessionId = 3131;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SessionName = 3132;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription = 3133;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri = 3134;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl = 3135;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds = 3136;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout = 3137;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize = 3138;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime = 3139;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime = 3140;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount = 3141;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount = 3142;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue = 3143;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount = 8898;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount = 11891;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount = 3151;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount = 3152;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount = 3153;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount = 3154;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CallCount = 3155;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount = 3156;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount = 3157;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount = 3158;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount = 3159;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount = 3160;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount = 3161;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount = 3162;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount = 3163;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount = 3164;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount = 3165;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount = 3166;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount = 3167;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount = 3168;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount = 3169;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount = 3170;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount = 3171;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount = 3172;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount = 3173;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 3174;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount = 3175;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount = 3176;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount = 3177;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount = 3178;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics = 2031;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId = 3179;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession = 3180;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory = 3181;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism = 3182;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding = 3183;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol = 3184;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode = 3185;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri = 3186;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate = 3187;

        /// <remarks />
        public const uint SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray = 2032;

        /// <remarks />
        public const uint ServerRedundancyType_RedundancySupport = 2035;

        /// <remarks />
        public const uint TransparentRedundancyType_CurrentServerId = 2037;

        /// <remarks />
        public const uint TransparentRedundancyType_RedundantServerArray = 2038;

        /// <remarks />
        public const uint NonTransparentRedundancyType_ServerUriArray = 2040;

        /// <remarks />
        public const uint NonTransparentNetworkRedundancyType_ServerNetworkGroups = 11948;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerRead = 11565;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerHistoryReadData = 12161;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerHistoryReadEvents = 12162;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerWrite = 11567;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerHistoryUpdateData = 12163;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerHistoryUpdateEvents = 12164;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerMethodCall = 11569;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerBrowse = 11570;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerRegisterNodes = 11571;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds = 11572;

        /// <remarks />
        public const uint OperationLimitsType_MaxNodesPerNodeManagement = 11573;

        /// <remarks />
        public const uint OperationLimitsType_MaxMonitoredItemsPerCall = 11574;

        /// <remarks />
        public const uint FileType_Size = 11576;

        /// <remarks />
        public const uint FileType_Writable = 12686;

        /// <remarks />
        public const uint FileType_UserWritable = 12687;

        /// <remarks />
        public const uint FileType_OpenCount = 11579;

        /// <remarks />
        public const uint FileType_MimeType = 13341;

        /// <remarks />
        public const uint FileType_MaxByteStringLength = 24244;

        /// <remarks />
        public const uint FileType_LastModifiedTime = 25200;

        /// <remarks />
        public const uint FileType_Open_InputArguments = 11581;

        /// <remarks />
        public const uint FileType_Open_OutputArguments = 11582;

        /// <remarks />
        public const uint FileType_Close_InputArguments = 11584;

        /// <remarks />
        public const uint FileType_Read_InputArguments = 11586;

        /// <remarks />
        public const uint FileType_Read_OutputArguments = 11587;

        /// <remarks />
        public const uint FileType_Write_InputArguments = 11589;

        /// <remarks />
        public const uint FileType_GetPosition_InputArguments = 11591;

        /// <remarks />
        public const uint FileType_GetPosition_OutputArguments = 11592;

        /// <remarks />
        public const uint FileType_SetPosition_InputArguments = 11594;

        /// <remarks />
        public const uint AddressSpaceFileType_Open_InputArguments = 11601;

        /// <remarks />
        public const uint AddressSpaceFileType_Open_OutputArguments = 11602;

        /// <remarks />
        public const uint AddressSpaceFileType_Close_InputArguments = 11604;

        /// <remarks />
        public const uint AddressSpaceFileType_Read_InputArguments = 11606;

        /// <remarks />
        public const uint AddressSpaceFileType_Read_OutputArguments = 11607;

        /// <remarks />
        public const uint AddressSpaceFileType_Write_InputArguments = 11609;

        /// <remarks />
        public const uint AddressSpaceFileType_GetPosition_InputArguments = 11611;

        /// <remarks />
        public const uint AddressSpaceFileType_GetPosition_OutputArguments = 11612;

        /// <remarks />
        public const uint AddressSpaceFileType_SetPosition_InputArguments = 11614;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceUri = 11617;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceVersion = 11618;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespacePublicationDate = 11619;

        /// <remarks />
        public const uint NamespaceMetadataType_IsNamespaceSubset = 11620;

        /// <remarks />
        public const uint NamespaceMetadataType_StaticNodeIdTypes = 11621;

        /// <remarks />
        public const uint NamespaceMetadataType_StaticNumericNodeIdRange = 11622;

        /// <remarks />
        public const uint NamespaceMetadataType_StaticStringNodeIdPattern = 11623;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Size = 11625;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Writable = 12690;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_UserWritable = 12691;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_OpenCount = 11628;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Open_InputArguments = 11630;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Open_OutputArguments = 11631;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Close_InputArguments = 11633;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Read_InputArguments = 11635;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Read_OutputArguments = 11636;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_Write_InputArguments = 11638;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments = 11640;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments = 11641;

        /// <remarks />
        public const uint NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments = 11643;

        /// <remarks />
        public const uint NamespaceMetadataType_DefaultRolePermissions = 16137;

        /// <remarks />
        public const uint NamespaceMetadataType_DefaultUserRolePermissions = 16138;

        /// <remarks />
        public const uint NamespaceMetadataType_DefaultAccessRestrictions = 16139;

        /// <remarks />
        public const uint NamespaceMetadataType_ConfigurationVersion = 25267;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri = 11647;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion = 11648;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate = 11649;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset = 11650;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes = 11651;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange = 11652;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern = 11653;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size = 11655;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable = 12692;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable = 12693;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount = 11658;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments = 11660;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments = 11661;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments = 11663;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments = 11665;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments = 11666;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments = 11668;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments = 11670;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments = 11671;

        /// <remarks />
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments = 11673;

        /// <remarks />
        public const uint BaseEventType_EventId = 2042;

        /// <remarks />
        public const uint BaseEventType_EventType = 2043;

        /// <remarks />
        public const uint BaseEventType_SourceNode = 2044;

        /// <remarks />
        public const uint BaseEventType_SourceName = 2045;

        /// <remarks />
        public const uint BaseEventType_Time = 2046;

        /// <remarks />
        public const uint BaseEventType_ReceiveTime = 2047;

        /// <remarks />
        public const uint BaseEventType_LocalTime = 3190;

        /// <remarks />
        public const uint BaseEventType_Message = 2050;

        /// <remarks />
        public const uint BaseEventType_Severity = 2051;

        /// <remarks />
        public const uint BaseEventType_ConditionClassId = 31771;

        /// <remarks />
        public const uint BaseEventType_ConditionClassName = 31772;

        /// <remarks />
        public const uint BaseEventType_ConditionSubClassId = 31773;

        /// <remarks />
        public const uint BaseEventType_ConditionSubClassName = 31774;

        /// <remarks />
        public const uint AuditEventType_ActionTimeStamp = 2053;

        /// <remarks />
        public const uint AuditEventType_Status = 2054;

        /// <remarks />
        public const uint AuditEventType_ServerId = 2055;

        /// <remarks />
        public const uint AuditEventType_ClientAuditEntryId = 2056;

        /// <remarks />
        public const uint AuditEventType_ClientUserId = 2057;

        /// <remarks />
        public const uint AuditSecurityEventType_StatusCodeId = 17615;

        /// <remarks />
        public const uint AuditChannelEventType_SecureChannelId = 2745;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_ClientCertificate = 2061;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_ClientCertificateThumbprint = 2746;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_RequestType = 2062;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_SecurityPolicyUri = 2063;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_SecurityMode = 2065;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_RequestedLifetime = 2066;

        /// <remarks />
        public const uint AuditOpenSecureChannelEventType_CertificateErrorEventId = 24135;

        /// <remarks />
        public const uint AuditSessionEventType_SessionId = 2070;

        /// <remarks />
        public const uint AuditCreateSessionEventType_SecureChannelId = 2072;

        /// <remarks />
        public const uint AuditCreateSessionEventType_ClientCertificate = 2073;

        /// <remarks />
        public const uint AuditCreateSessionEventType_ClientCertificateThumbprint = 2747;

        /// <remarks />
        public const uint AuditCreateSessionEventType_RevisedSessionTimeout = 2074;

        /// <remarks />
        public const uint AuditUrlMismatchEventType_EndpointUrl = 2749;

        /// <remarks />
        public const uint AuditActivateSessionEventType_ClientSoftwareCertificates = 2076;

        /// <remarks />
        public const uint AuditActivateSessionEventType_UserIdentityToken = 2077;

        /// <remarks />
        public const uint AuditActivateSessionEventType_SecureChannelId = 11485;

        /// <remarks />
        public const uint AuditCancelEventType_RequestHandle = 2079;

        /// <remarks />
        public const uint AuditCertificateEventType_Certificate = 2081;

        /// <remarks />
        public const uint AuditCertificateDataMismatchEventType_InvalidHostname = 2083;

        /// <remarks />
        public const uint AuditCertificateDataMismatchEventType_InvalidUri = 2084;

        /// <remarks />
        public const uint AuditAddNodesEventType_NodesToAdd = 2092;

        /// <remarks />
        public const uint AuditDeleteNodesEventType_NodesToDelete = 2094;

        /// <remarks />
        public const uint AuditAddReferencesEventType_ReferencesToAdd = 2096;

        /// <remarks />
        public const uint AuditDeleteReferencesEventType_ReferencesToDelete = 2098;

        /// <remarks />
        public const uint AuditWriteUpdateEventType_AttributeId = 2750;

        /// <remarks />
        public const uint AuditWriteUpdateEventType_IndexRange = 2101;

        /// <remarks />
        public const uint AuditWriteUpdateEventType_OldValue = 2102;

        /// <remarks />
        public const uint AuditWriteUpdateEventType_NewValue = 2103;

        /// <remarks />
        public const uint AuditHistoryUpdateEventType_ParameterDataTypeId = 2751;

        /// <remarks />
        public const uint AuditUpdateMethodEventType_MethodId = 2128;

        /// <remarks />
        public const uint AuditUpdateMethodEventType_InputArguments = 2129;

        /// <remarks />
        public const uint SystemStatusChangeEventType_SystemState = 11696;

        /// <remarks />
        public const uint GeneralModelChangeEventType_Changes = 2134;

        /// <remarks />
        public const uint SemanticChangeEventType_Changes = 2739;

        /// <remarks />
        public const uint ProgressEventType_Context = 12502;

        /// <remarks />
        public const uint ProgressEventType_Progress = 12503;

        /// <remarks />
        public const uint AuditClientEventType_ServerUri = 23908;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType_ObjectId = 23994;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType_MethodId = 23995;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType_StatusCodeId = 23998;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType_InputArguments = 23999;

        /// <remarks />
        public const uint AuditClientUpdateMethodResultEventType_OutputArguments = 25684;

        /// <remarks />
        public const uint ServerStatusType_StartTime = 2139;

        /// <remarks />
        public const uint ServerStatusType_CurrentTime = 2140;

        /// <remarks />
        public const uint ServerStatusType_State = 2141;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo = 2142;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_ProductUri = 3698;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_ManufacturerName = 3699;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_ProductName = 3700;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_SoftwareVersion = 3701;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_BuildNumber = 3702;

        /// <remarks />
        public const uint ServerStatusType_BuildInfo_BuildDate = 3703;

        /// <remarks />
        public const uint ServerStatusType_SecondsTillShutdown = 2752;

        /// <remarks />
        public const uint ServerStatusType_ShutdownReason = 2753;

        /// <remarks />
        public const uint BuildInfoType_ProductUri = 3052;

        /// <remarks />
        public const uint BuildInfoType_ManufacturerName = 3053;

        /// <remarks />
        public const uint BuildInfoType_ProductName = 3054;

        /// <remarks />
        public const uint BuildInfoType_SoftwareVersion = 3055;

        /// <remarks />
        public const uint BuildInfoType_BuildNumber = 3056;

        /// <remarks />
        public const uint BuildInfoType_BuildDate = 3057;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_ServerViewCount = 2151;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_CurrentSessionCount = 2152;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_CumulatedSessionCount = 2153;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_SecurityRejectedSessionCount = 2154;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_RejectedSessionCount = 2155;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_SessionTimeoutCount = 2156;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_SessionAbortCount = 2157;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_PublishingIntervalCount = 2159;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_CurrentSubscriptionCount = 2160;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_CumulatedSubscriptionCount = 2161;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount = 2162;

        /// <remarks />
        public const uint ServerDiagnosticsSummaryType_RejectedRequestsCount = 2163;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics = 12779;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval = 12780;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount = 12781;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount = 12782;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount = 12783;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsType_SamplingInterval = 2166;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount = 11697;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount = 11698;

        /// <remarks />
        public const uint SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount = 11699;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics = 12784;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId = 12785;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId = 12786;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority = 12787;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval = 12788;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount = 12789;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount = 12790;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish = 12791;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled = 12792;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount = 12793;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount = 12794;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount = 12795;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount = 12796;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount = 12797;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount = 12798;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount = 12799;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount = 12800;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount = 12801;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount = 12802;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount = 12803;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount = 12804;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount = 12805;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount = 12806;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount = 12807;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount = 12808;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount = 12809;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount = 12810;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount = 12811;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount = 12812;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount = 12813;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber = 12814;

        /// <remarks />
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount = 12815;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_SessionId = 2173;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_SubscriptionId = 2174;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_Priority = 2175;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_PublishingInterval = 2176;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_MaxKeepAliveCount = 2177;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_MaxLifetimeCount = 8888;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_MaxNotificationsPerPublish = 2179;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_PublishingEnabled = 2180;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_ModifyCount = 2181;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_EnableCount = 2182;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_DisableCount = 2183;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_RepublishRequestCount = 2184;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_RepublishMessageRequestCount = 2185;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_RepublishMessageCount = 2186;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_TransferRequestCount = 2187;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_TransferredToAltClientCount = 2188;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_TransferredToSameClientCount = 2189;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_PublishRequestCount = 2190;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_DataChangeNotificationsCount = 2191;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_EventNotificationsCount = 2998;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_NotificationsCount = 2193;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_LatePublishRequestCount = 8889;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_CurrentKeepAliveCount = 8890;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_CurrentLifetimeCount = 8891;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_UnacknowledgedMessageCount = 8892;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_DiscardedMessageCount = 8893;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_MonitoredItemCount = 8894;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_DisabledMonitoredItemCount = 8895;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_MonitoringQueueOverflowCount = 8896;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_NextSequenceNumber = 8897;

        /// <remarks />
        public const uint SubscriptionDiagnosticsType_EventQueueOverflowCount = 8902;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics = 12816;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SessionId = 12817;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SessionName = 12818;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription = 12819;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri = 12820;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl = 12821;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds = 12822;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout = 12823;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize = 12824;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime = 12825;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime = 12826;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount = 12827;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount = 12828;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue = 12829;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount = 12830;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount = 12831;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount = 12832;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount = 12833;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount = 12834;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount = 12835;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CallCount = 12836;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount = 12837;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount = 12838;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount = 12839;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount = 12840;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount = 12841;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount = 12842;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount = 12843;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount = 12844;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount = 12845;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount = 12846;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount = 12847;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount = 12848;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount = 12849;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount = 12850;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount = 12851;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount = 12852;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount = 12853;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount = 12854;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 12855;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount = 12856;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount = 12857;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount = 12858;

        /// <remarks />
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount = 12859;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_SessionId = 2198;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_SessionName = 2199;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ClientDescription = 2200;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ServerUri = 2201;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_EndpointUrl = 2202;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_LocaleIds = 2203;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ActualSessionTimeout = 2204;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_MaxResponseMessageSize = 3050;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ClientConnectionTime = 2205;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ClientLastContactTime = 2206;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CurrentSubscriptionsCount = 2207;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CurrentMonitoredItemsCount = 2208;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue = 2209;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_TotalRequestCount = 8900;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_UnauthorizedRequestCount = 11892;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ReadCount = 2217;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_HistoryReadCount = 2218;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_WriteCount = 2219;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_HistoryUpdateCount = 2220;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CallCount = 2221;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CreateMonitoredItemsCount = 2222;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ModifyMonitoredItemsCount = 2223;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_SetMonitoringModeCount = 2224;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_SetTriggeringCount = 2225;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_DeleteMonitoredItemsCount = 2226;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_CreateSubscriptionCount = 2227;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_ModifySubscriptionCount = 2228;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_SetPublishingModeCount = 2229;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_PublishCount = 2230;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_RepublishCount = 2231;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_TransferSubscriptionsCount = 2232;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_DeleteSubscriptionsCount = 2233;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_AddNodesCount = 2234;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_AddReferencesCount = 2235;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_DeleteNodesCount = 2236;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_DeleteReferencesCount = 2237;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_BrowseCount = 2238;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_BrowseNextCount = 2239;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount = 2240;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_QueryFirstCount = 2241;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_QueryNextCount = 2242;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_RegisterNodesCount = 2730;

        /// <remarks />
        public const uint SessionDiagnosticsVariableType_UnregisterNodesCount = 2731;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics = 12860;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId = 12861;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession = 12862;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory = 12863;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism = 12864;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding = 12865;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol = 12866;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode = 12867;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri = 12868;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate = 12869;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_SessionId = 2245;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_ClientUserIdOfSession = 2246;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_ClientUserIdHistory = 2247;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_AuthenticationMechanism = 2248;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_Encoding = 2249;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_TransportProtocol = 2250;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_SecurityMode = 2251;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_SecurityPolicyUri = 2252;

        /// <remarks />
        public const uint SessionSecurityDiagnosticsType_ClientCertificate = 3058;

        /// <remarks />
        public const uint OptionSetType_OptionSetValues = 11488;

        /// <remarks />
        public const uint OptionSetType_BitMask = 11701;

        /// <remarks />
        public const uint SelectionListType_Selections = 17632;

        /// <remarks />
        public const uint SelectionListType_SelectionDescriptions = 17633;

        /// <remarks />
        public const uint SelectionListType_RestrictToList = 16312;

        /// <remarks />
        public const uint AudioVariableType_ListId = 17988;

        /// <remarks />
        public const uint AudioVariableType_AgencyId = 17989;

        /// <remarks />
        public const uint AudioVariableType_VersionId = 17990;

        /// <remarks />
        public const uint Server_ServerArray = 2254;

        /// <remarks />
        public const uint Server_NamespaceArray = 2255;

        /// <remarks />
        public const uint Server_UrisVersion = 15004;

        /// <remarks />
        public const uint Server_ServerStatus = 2256;

        /// <remarks />
        public const uint Server_ServerStatus_StartTime = 2257;

        /// <remarks />
        public const uint Server_ServerStatus_CurrentTime = 2258;

        /// <remarks />
        public const uint Server_ServerStatus_State = 2259;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo = 2260;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_ProductUri = 2262;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_ManufacturerName = 2263;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_ProductName = 2261;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_SoftwareVersion = 2264;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_BuildNumber = 2265;

        /// <remarks />
        public const uint Server_ServerStatus_BuildInfo_BuildDate = 2266;

        /// <remarks />
        public const uint Server_ServerStatus_SecondsTillShutdown = 2992;

        /// <remarks />
        public const uint Server_ServerStatus_ShutdownReason = 2993;

        /// <remarks />
        public const uint Server_ServiceLevel = 2267;

        /// <remarks />
        public const uint Server_Auditing = 2994;

        /// <remarks />
        public const uint Server_EstimatedReturnTime = 12885;

        /// <remarks />
        public const uint Server_LocalTime = 17634;

        /// <remarks />
        public const uint Server_ServerCapabilities_ServerProfileArray = 2269;

        /// <remarks />
        public const uint Server_ServerCapabilities_LocaleIdArray = 2271;

        /// <remarks />
        public const uint Server_ServerCapabilities_MinSupportedSampleRate = 2272;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxBrowseContinuationPoints = 2735;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxQueryContinuationPoints = 2736;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxHistoryContinuationPoints = 2737;

        /// <remarks />
        public const uint Server_ServerCapabilities_SoftwareCertificates = 3704;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxArrayLength = 11702;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxStringLength = 11703;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxByteStringLength = 12911;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerRead = 11705;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData = 12165;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents = 12166;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite = 11707;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData = 12167;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents = 12168;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall = 11709;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse = 11710;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes = 11711;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds = 11712;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement = 11713;

        /// <remarks />
        public const uint Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall = 11714;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet_AddRole_InputArguments = 16302;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet_AddRole_OutputArguments = 16303;

        /// <remarks />
        public const uint Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments = 16305;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxSessions = 24095;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxSubscriptions = 24096;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxMonitoredItems = 24097;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxSubscriptionsPerSession = 24098;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxMonitoredItemsPerSubscription = 24104;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxSelectClauseParameters = 24099;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxWhereClauseParameters = 24100;

        /// <remarks />
        public const uint Server_ServerCapabilities_MaxMonitoredItemsQueueSize = 31916;

        /// <remarks />
        public const uint Server_ServerCapabilities_ConformanceUnits = 24101;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary = 2275;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount = 2276;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount = 2277;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount = 2278;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 2279;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount = 3705;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount = 2281;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount = 2282;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount = 2284;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount = 2285;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 2286;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 2287;

        /// <remarks />
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount = 2288;

        /// <remarks />
        public const uint Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray = 2289;

        /// <remarks />
        public const uint Server_ServerDiagnostics_SubscriptionDiagnosticsArray = 2290;

        /// <remarks />
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3707;

        /// <remarks />
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3708;

        /// <remarks />
        public const uint Server_ServerDiagnostics_EnabledFlag = 2294;

        /// <remarks />
        public const uint Server_ServerRedundancy_RedundancySupport = 3709;

        /// <remarks />
        public const uint Server_GetMonitoredItems_InputArguments = 11493;

        /// <remarks />
        public const uint Server_GetMonitoredItems_OutputArguments = 11494;

        /// <remarks />
        public const uint Server_ResendData_InputArguments = 12874;

        /// <remarks />
        public const uint Server_SetSubscriptionDurable_InputArguments = 12750;

        /// <remarks />
        public const uint Server_SetSubscriptionDurable_OutputArguments = 12751;

        /// <remarks />
        public const uint Server_RequestServerStateChange_InputArguments = 12887;

        /// <remarks />
        public const uint Server_ServerRedundancy_CurrentServerId = 11312;

        /// <remarks />
        public const uint Server_ServerRedundancy_RedundantServerArray = 11313;

        /// <remarks />
        public const uint Server_ServerRedundancy_ServerUriArray = 11314;

        /// <remarks />
        public const uint Server_ServerRedundancy_ServerNetworkGroups = 14415;

        /// <remarks />
        public const uint HistoryServerCapabilities_AccessHistoryDataCapability = 11193;

        /// <remarks />
        public const uint HistoryServerCapabilities_AccessHistoryEventsCapability = 11242;

        /// <remarks />
        public const uint HistoryServerCapabilities_MaxReturnDataValues = 11273;

        /// <remarks />
        public const uint HistoryServerCapabilities_MaxReturnEventValues = 11274;

        /// <remarks />
        public const uint HistoryServerCapabilities_InsertDataCapability = 11196;

        /// <remarks />
        public const uint HistoryServerCapabilities_ReplaceDataCapability = 11197;

        /// <remarks />
        public const uint HistoryServerCapabilities_UpdateDataCapability = 11198;

        /// <remarks />
        public const uint HistoryServerCapabilities_DeleteRawCapability = 11199;

        /// <remarks />
        public const uint HistoryServerCapabilities_DeleteAtTimeCapability = 11200;

        /// <remarks />
        public const uint HistoryServerCapabilities_InsertEventCapability = 11281;

        /// <remarks />
        public const uint HistoryServerCapabilities_ReplaceEventCapability = 11282;

        /// <remarks />
        public const uint HistoryServerCapabilities_UpdateEventCapability = 11283;

        /// <remarks />
        public const uint HistoryServerCapabilities_DeleteEventCapability = 11502;

        /// <remarks />
        public const uint HistoryServerCapabilities_InsertAnnotationCapability = 11275;

        /// <remarks />
        public const uint HistoryServerCapabilities_ServerTimestampSupported = 19091;

        /// <remarks />
        public const uint StateMachineType_CurrentState = 2769;

        /// <remarks />
        public const uint StateMachineType_CurrentState_Id = 3720;

        /// <remarks />
        public const uint StateMachineType_LastTransition = 2770;

        /// <remarks />
        public const uint StateMachineType_LastTransition_Id = 3724;

        /// <remarks />
        public const uint StateVariableType_Id = 2756;

        /// <remarks />
        public const uint StateVariableType_Name = 2757;

        /// <remarks />
        public const uint StateVariableType_Number = 2758;

        /// <remarks />
        public const uint StateVariableType_EffectiveDisplayName = 2759;

        /// <remarks />
        public const uint TransitionVariableType_Id = 2763;

        /// <remarks />
        public const uint TransitionVariableType_Name = 2764;

        /// <remarks />
        public const uint TransitionVariableType_Number = 2765;

        /// <remarks />
        public const uint TransitionVariableType_TransitionTime = 2766;

        /// <remarks />
        public const uint TransitionVariableType_EffectiveTransitionTime = 11456;

        /// <remarks />
        public const uint FiniteStateMachineType_CurrentState = 2772;

        /// <remarks />
        public const uint FiniteStateMachineType_CurrentState_Id = 3728;

        /// <remarks />
        public const uint FiniteStateMachineType_LastTransition = 2773;

        /// <remarks />
        public const uint FiniteStateMachineType_LastTransition_Id = 3732;

        /// <remarks />
        public const uint FiniteStateMachineType_AvailableStates = 17635;

        /// <remarks />
        public const uint FiniteStateMachineType_AvailableTransitions = 17636;

        /// <remarks />
        public const uint FiniteStateVariableType_Id = 2761;

        /// <remarks />
        public const uint FiniteTransitionVariableType_Id = 2768;

        /// <remarks />
        public const uint StateType_StateNumber = 2308;

        /// <remarks />
        public const uint TransitionType_TransitionNumber = 2312;

        /// <remarks />
        public const uint ExpressionGuardVariableType_Expression = 15129;

        /// <remarks />
        public const uint RationalNumberType_Numerator = 17712;

        /// <remarks />
        public const uint RationalNumberType_Denominator = 17713;

        /// <remarks />
        public const uint VectorType_VectorUnit = 17715;

        /// <remarks />
        public const uint ThreeDVectorType_X = 18769;

        /// <remarks />
        public const uint ThreeDVectorType_Y = 18770;

        /// <remarks />
        public const uint ThreeDVectorType_Z = 18771;

        /// <remarks />
        public const uint CartesianCoordinatesType_LengthUnit = 18773;

        /// <remarks />
        public const uint ThreeDCartesianCoordinatesType_X = 18776;

        /// <remarks />
        public const uint ThreeDCartesianCoordinatesType_Y = 18777;

        /// <remarks />
        public const uint ThreeDCartesianCoordinatesType_Z = 18778;

        /// <remarks />
        public const uint OrientationType_AngleUnit = 18780;

        /// <remarks />
        public const uint ThreeDOrientationType_A = 18783;

        /// <remarks />
        public const uint ThreeDOrientationType_B = 18784;

        /// <remarks />
        public const uint ThreeDOrientationType_C = 18785;

        /// <remarks />
        public const uint FrameType_CartesianCoordinates = 18801;

        /// <remarks />
        public const uint FrameType_Orientation = 18787;

        /// <remarks />
        public const uint FrameType_Constant = 18788;

        /// <remarks />
        public const uint FrameType_BaseFrame = 18789;

        /// <remarks />
        public const uint FrameType_FixedBase = 18790;

        /// <remarks />
        public const uint ThreeDFrameType_CartesianCoordinates = 18796;

        /// <remarks />
        public const uint ThreeDFrameType_Orientation = 18792;

        /// <remarks />
        public const uint ThreeDFrameType_CartesianCoordinates_X = 18798;

        /// <remarks />
        public const uint ThreeDFrameType_CartesianCoordinates_Y = 18799;

        /// <remarks />
        public const uint ThreeDFrameType_CartesianCoordinates_Z = 18800;

        /// <remarks />
        public const uint ThreeDFrameType_Orientation_A = 19074;

        /// <remarks />
        public const uint ThreeDFrameType_Orientation_B = 19075;

        /// <remarks />
        public const uint ThreeDFrameType_Orientation_C = 19076;

        /// <remarks />
        public const uint TransitionEventType_Transition = 2774;

        /// <remarks />
        public const uint TransitionEventType_Transition_Id = 3754;

        /// <remarks />
        public const uint TransitionEventType_FromState = 2775;

        /// <remarks />
        public const uint TransitionEventType_FromState_Id = 3746;

        /// <remarks />
        public const uint TransitionEventType_ToState = 2776;

        /// <remarks />
        public const uint TransitionEventType_ToState_Id = 3750;

        /// <remarks />
        public const uint AuditUpdateStateEventType_OldStateId = 2777;

        /// <remarks />
        public const uint AuditUpdateStateEventType_NewStateId = 2778;

        /// <remarks />
        public const uint OpenFileMode_EnumValues = 11940;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments = 13356;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments = 13357;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments = 13359;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments = 13360;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments = 17719;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments = 13364;

        /// <remarks />
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments = 13365;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Size = 13367;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Writable = 13368;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_UserWritable = 13369;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_OpenCount = 13370;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Open_InputArguments = 13373;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Open_OutputArguments = 13374;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Close_InputArguments = 13376;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Read_InputArguments = 13378;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Read_OutputArguments = 13379;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_Write_InputArguments = 13381;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments = 13383;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments = 13384;

        /// <remarks />
        public const uint FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments = 13386;

        /// <remarks />
        public const uint FileDirectoryType_CreateDirectory_InputArguments = 13388;

        /// <remarks />
        public const uint FileDirectoryType_CreateDirectory_OutputArguments = 13389;

        /// <remarks />
        public const uint FileDirectoryType_CreateFile_InputArguments = 13391;

        /// <remarks />
        public const uint FileDirectoryType_CreateFile_OutputArguments = 13392;

        /// <remarks />
        public const uint FileDirectoryType_DeleteFileSystemObject_InputArguments = 13394;

        /// <remarks />
        public const uint FileDirectoryType_MoveOrCopy_InputArguments = 13396;

        /// <remarks />
        public const uint FileDirectoryType_MoveOrCopy_OutputArguments = 13397;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments = 16317;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments = 16318;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments = 16320;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments = 16321;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments = 17723;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments = 16325;

        /// <remarks />
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments = 16326;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Size = 16328;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Writable = 16329;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_UserWritable = 16330;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_OpenCount = 16331;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Open_InputArguments = 16334;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Open_OutputArguments = 16335;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Close_InputArguments = 16337;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Read_InputArguments = 16339;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Read_OutputArguments = 16340;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_Write_InputArguments = 16342;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_GetPosition_InputArguments = 16344;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_GetPosition_OutputArguments = 16345;

        /// <remarks />
        public const uint FileSystem_FileName_Placeholder_SetPosition_InputArguments = 16347;

        /// <remarks />
        public const uint FileSystem_CreateDirectory_InputArguments = 16349;

        /// <remarks />
        public const uint FileSystem_CreateDirectory_OutputArguments = 16350;

        /// <remarks />
        public const uint FileSystem_CreateFile_InputArguments = 16352;

        /// <remarks />
        public const uint FileSystem_CreateFile_OutputArguments = 16353;

        /// <remarks />
        public const uint FileSystem_DeleteFileSystemObject_InputArguments = 16355;

        /// <remarks />
        public const uint FileSystem_MoveOrCopy_InputArguments = 16357;

        /// <remarks />
        public const uint FileSystem_MoveOrCopy_OutputArguments = 16358;

        /// <remarks />
        public const uint TemporaryFileTransferType_ClientProcessingTimeout = 15745;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForRead_InputArguments = 15747;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForRead_OutputArguments = 15748;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForWrite_InputArguments = 16359;

        /// <remarks />
        public const uint TemporaryFileTransferType_GenerateFileForWrite_OutputArguments = 15750;

        /// <remarks />
        public const uint TemporaryFileTransferType_CloseAndCommit_InputArguments = 15752;

        /// <remarks />
        public const uint TemporaryFileTransferType_CloseAndCommit_OutputArguments = 15753;

        /// <remarks />
        public const uint TemporaryFileTransferType_TransferState_Placeholder_CurrentState = 15755;

        /// <remarks />
        public const uint TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Id = 15756;

        /// <remarks />
        public const uint TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Id = 15761;

        /// <remarks />
        public const uint FileTransferStateMachineType_CurrentState_Id = 15805;

        /// <remarks />
        public const uint FileTransferStateMachineType_LastTransition_Id = 15810;

        /// <remarks />
        public const uint FileTransferStateMachineType_Idle_StateNumber = 15816;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepare_StateNumber = 15818;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransfer_StateNumber = 15820;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWrite_StateNumber = 15822;

        /// <remarks />
        public const uint FileTransferStateMachineType_Error_StateNumber = 15824;

        /// <remarks />
        public const uint FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber = 15826;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber = 15828;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber = 15830;

        /// <remarks />
        public const uint FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber = 15832;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber = 15834;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadPrepareToError_TransitionNumber = 15836;

        /// <remarks />
        public const uint FileTransferStateMachineType_ReadTransferToError_TransitionNumber = 15838;

        /// <remarks />
        public const uint FileTransferStateMachineType_ApplyWriteToError_TransitionNumber = 15840;

        /// <remarks />
        public const uint FileTransferStateMachineType_ErrorToIdle_TransitionNumber = 15842;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_Identities = 16162;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments = 15613;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments = 15615;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_AddApplication_InputArguments = 16166;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments = 16168;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments = 16170;

        /// <remarks />
        public const uint RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments = 16172;

        /// <remarks />
        public const uint RoleSetType_AddRole_InputArguments = 15998;

        /// <remarks />
        public const uint RoleSetType_AddRole_OutputArguments = 15999;

        /// <remarks />
        public const uint RoleSetType_RemoveRole_InputArguments = 16001;

        /// <remarks />
        public const uint RoleType_Identities = 16173;

        /// <remarks />
        public const uint RoleType_ApplicationsExclude = 15410;

        /// <remarks />
        public const uint RoleType_Applications = 16174;

        /// <remarks />
        public const uint RoleType_EndpointsExclude = 15411;

        /// <remarks />
        public const uint RoleType_Endpoints = 16175;

        /// <remarks />
        public const uint RoleType_CustomConfiguration = 24139;

        /// <remarks />
        public const uint RoleType_AddIdentity_InputArguments = 15625;

        /// <remarks />
        public const uint RoleType_RemoveIdentity_InputArguments = 15627;

        /// <remarks />
        public const uint RoleType_AddApplication_InputArguments = 16177;

        /// <remarks />
        public const uint RoleType_RemoveApplication_InputArguments = 16179;

        /// <remarks />
        public const uint RoleType_AddEndpoint_InputArguments = 16181;

        /// <remarks />
        public const uint RoleType_RemoveEndpoint_InputArguments = 16183;

        /// <remarks />
        public const uint IdentityCriteriaType_EnumValues = 15633;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_Identities = 16192;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_ApplicationsExclude = 15412;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_Applications = 16193;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_EndpointsExclude = 15413;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_Endpoints = 16194;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddIdentity_InputArguments = 15649;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveIdentity_InputArguments = 15651;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddApplication_InputArguments = 16196;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveApplication_InputArguments = 16198;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_AddEndpoint_InputArguments = 16200;

        /// <remarks />
        public const uint WellKnownRole_Anonymous_RemoveEndpoint_InputArguments = 16202;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_Identities = 16203;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_ApplicationsExclude = 15414;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_Applications = 16204;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_EndpointsExclude = 15415;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_Endpoints = 16205;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_CustomConfiguration = 24141;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments = 15661;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments = 15663;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddApplication_InputArguments = 16207;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments = 16209;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments = 16211;

        /// <remarks />
        public const uint WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments = 16213;

        /// <remarks />
        public const uint WellKnownRole_Observer_Identities = 16214;

        /// <remarks />
        public const uint WellKnownRole_Observer_ApplicationsExclude = 15416;

        /// <remarks />
        public const uint WellKnownRole_Observer_Applications = 16215;

        /// <remarks />
        public const uint WellKnownRole_Observer_EndpointsExclude = 15417;

        /// <remarks />
        public const uint WellKnownRole_Observer_Endpoints = 16216;

        /// <remarks />
        public const uint WellKnownRole_Observer_CustomConfiguration = 24142;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddIdentity_InputArguments = 15673;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveIdentity_InputArguments = 15675;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddApplication_InputArguments = 16218;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveApplication_InputArguments = 16220;

        /// <remarks />
        public const uint WellKnownRole_Observer_AddEndpoint_InputArguments = 16222;

        /// <remarks />
        public const uint WellKnownRole_Observer_RemoveEndpoint_InputArguments = 16224;

        /// <remarks />
        public const uint WellKnownRole_Operator_Identities = 16225;

        /// <remarks />
        public const uint WellKnownRole_Operator_ApplicationsExclude = 15418;

        /// <remarks />
        public const uint WellKnownRole_Operator_Applications = 16226;

        /// <remarks />
        public const uint WellKnownRole_Operator_EndpointsExclude = 15423;

        /// <remarks />
        public const uint WellKnownRole_Operator_Endpoints = 16227;

        /// <remarks />
        public const uint WellKnownRole_Operator_CustomConfiguration = 24143;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddIdentity_InputArguments = 15685;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveIdentity_InputArguments = 15687;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddApplication_InputArguments = 16229;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveApplication_InputArguments = 16231;

        /// <remarks />
        public const uint WellKnownRole_Operator_AddEndpoint_InputArguments = 16233;

        /// <remarks />
        public const uint WellKnownRole_Operator_RemoveEndpoint_InputArguments = 16235;

        /// <remarks />
        public const uint WellKnownRole_Engineer_Identities = 16236;

        /// <remarks />
        public const uint WellKnownRole_Engineer_ApplicationsExclude = 15424;

        /// <remarks />
        public const uint WellKnownRole_Engineer_Applications = 16237;

        /// <remarks />
        public const uint WellKnownRole_Engineer_EndpointsExclude = 15425;

        /// <remarks />
        public const uint WellKnownRole_Engineer_Endpoints = 16238;

        /// <remarks />
        public const uint WellKnownRole_Engineer_CustomConfiguration = 24144;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddIdentity_InputArguments = 16042;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveIdentity_InputArguments = 16044;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddApplication_InputArguments = 16240;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveApplication_InputArguments = 16242;

        /// <remarks />
        public const uint WellKnownRole_Engineer_AddEndpoint_InputArguments = 16244;

        /// <remarks />
        public const uint WellKnownRole_Engineer_RemoveEndpoint_InputArguments = 16246;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_Identities = 16247;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_ApplicationsExclude = 15426;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_Applications = 16248;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_EndpointsExclude = 15427;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_Endpoints = 16249;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_CustomConfiguration = 24145;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddIdentity_InputArguments = 15697;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveIdentity_InputArguments = 15699;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddApplication_InputArguments = 16251;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveApplication_InputArguments = 16253;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_AddEndpoint_InputArguments = 16255;

        /// <remarks />
        public const uint WellKnownRole_Supervisor_RemoveEndpoint_InputArguments = 16257;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_Identities = 16269;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_ApplicationsExclude = 15428;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_Applications = 16270;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_EndpointsExclude = 15429;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_Endpoints = 16271;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_CustomConfiguration = 24146;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments = 15721;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments = 15723;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddApplication_InputArguments = 16273;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments = 16275;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments = 16277;

        /// <remarks />
        public const uint WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments = 16279;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_Identities = 16258;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_ApplicationsExclude = 15430;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_Applications = 16259;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_EndpointsExclude = 15527;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_Endpoints = 16260;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_CustomConfiguration = 24147;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddIdentity_InputArguments = 15709;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments = 15711;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddApplication_InputArguments = 16262;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments = 16264;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments = 16266;

        /// <remarks />
        public const uint WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments = 16268;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_Identities = 25566;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude = 25567;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_Applications = 25568;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude = 25569;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_Endpoints = 25570;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration = 25571;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments = 25573;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments = 25575;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments = 25577;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments = 25579;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments = 25581;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments = 25583;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_Identities = 25604;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude = 25605;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_Applications = 25606;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_EndpointsExclude = 25607;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_Endpoints = 25608;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_CustomConfiguration = 25609;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments = 25611;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments = 25613;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments = 25615;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments = 25617;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments = 25619;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments = 25621;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_Identities = 25585;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_ApplicationsExclude = 25586;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_Applications = 25587;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_EndpointsExclude = 25588;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_Endpoints = 25589;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_CustomConfiguration = 25590;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments = 25592;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments = 25594;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments = 25596;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments = 25598;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments = 25600;

        /// <remarks />
        public const uint WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments = 25602;

        /// <remarks />
        public const uint CurrencyUnit = 23501;

        /// <remarks />
        public const uint IOrderedObjectType_NumberInList = 23517;

        /// <remarks />
        public const uint OrderedListType_OrderedObject_Placeholder_NumberInList = 23521;

        /// <remarks />
        public const uint OrderedListType_NodeVersion = 23525;

        /// <remarks />
        public const uint DataItemType_Definition = 2366;

        /// <remarks />
        public const uint DataItemType_ValuePrecision = 2367;

        /// <remarks />
        public const uint BaseAnalogType_InstrumentRange = 17567;

        /// <remarks />
        public const uint BaseAnalogType_EURange = 17568;

        /// <remarks />
        public const uint BaseAnalogType_EngineeringUnits = 17569;

        /// <remarks />
        public const uint AnalogItemType_EURange = 2369;

        /// <remarks />
        public const uint AnalogUnitType_EngineeringUnits = 17502;

        /// <remarks />
        public const uint AnalogUnitRangeType_EngineeringUnits = 17575;

        /// <remarks />
        public const uint TwoStateDiscreteType_FalseState = 2374;

        /// <remarks />
        public const uint TwoStateDiscreteType_TrueState = 2375;

        /// <remarks />
        public const uint MultiStateDiscreteType_EnumStrings = 2377;

        /// <remarks />
        public const uint MultiStateValueDiscreteType_EnumValues = 11241;

        /// <remarks />
        public const uint MultiStateValueDiscreteType_ValueAsText = 11461;

        /// <remarks />
        public const uint ArrayItemType_InstrumentRange = 12024;

        /// <remarks />
        public const uint ArrayItemType_EURange = 12025;

        /// <remarks />
        public const uint ArrayItemType_EngineeringUnits = 12026;

        /// <remarks />
        public const uint ArrayItemType_Title = 12027;

        /// <remarks />
        public const uint ArrayItemType_AxisScaleType = 12028;

        /// <remarks />
        public const uint YArrayItemType_XAxisDefinition = 12037;

        /// <remarks />
        public const uint XYArrayItemType_XAxisDefinition = 12046;

        /// <remarks />
        public const uint ImageItemType_XAxisDefinition = 12055;

        /// <remarks />
        public const uint ImageItemType_YAxisDefinition = 12056;

        /// <remarks />
        public const uint CubeItemType_XAxisDefinition = 12065;

        /// <remarks />
        public const uint CubeItemType_YAxisDefinition = 12066;

        /// <remarks />
        public const uint CubeItemType_ZAxisDefinition = 12067;

        /// <remarks />
        public const uint NDimensionArrayItemType_AxisDefinition = 12076;

        /// <remarks />
        public const uint TwoStateVariableType_Id = 8996;

        /// <remarks />
        public const uint TwoStateVariableType_TransitionTime = 9000;

        /// <remarks />
        public const uint TwoStateVariableType_EffectiveTransitionTime = 9001;

        /// <remarks />
        public const uint TwoStateVariableType_TrueState = 11110;

        /// <remarks />
        public const uint TwoStateVariableType_FalseState = 11111;

        /// <remarks />
        public const uint ConditionVariableType_SourceTimestamp = 9003;

        /// <remarks />
        public const uint ConditionType_ConditionClassId = 11112;

        /// <remarks />
        public const uint ConditionType_ConditionClassName = 11113;

        /// <remarks />
        public const uint ConditionType_ConditionName = 9009;

        /// <remarks />
        public const uint ConditionType_BranchId = 9010;

        /// <remarks />
        public const uint ConditionType_Retain = 3874;

        /// <remarks />
        public const uint ConditionType_SupportsFilteredRetain = 32060;

        /// <remarks />
        public const uint ConditionType_EnabledState = 9011;

        /// <remarks />
        public const uint ConditionType_EnabledState_Id = 9012;

        /// <remarks />
        public const uint ConditionType_EnabledState_EffectiveDisplayName = 9015;

        /// <remarks />
        public const uint ConditionType_EnabledState_TransitionTime = 9016;

        /// <remarks />
        public const uint ConditionType_EnabledState_EffectiveTransitionTime = 9017;

        /// <remarks />
        public const uint ConditionType_EnabledState_TrueState = 9018;

        /// <remarks />
        public const uint ConditionType_EnabledState_FalseState = 9019;

        /// <remarks />
        public const uint ConditionType_Quality = 9020;

        /// <remarks />
        public const uint ConditionType_Quality_SourceTimestamp = 9021;

        /// <remarks />
        public const uint ConditionType_LastSeverity = 9022;

        /// <remarks />
        public const uint ConditionType_LastSeverity_SourceTimestamp = 9023;

        /// <remarks />
        public const uint ConditionType_Comment = 9024;

        /// <remarks />
        public const uint ConditionType_Comment_SourceTimestamp = 9025;

        /// <remarks />
        public const uint ConditionType_ClientUserId = 9026;

        /// <remarks />
        public const uint ConditionType_AddComment_InputArguments = 9030;

        /// <remarks />
        public const uint ConditionType_ConditionRefresh_InputArguments = 3876;

        /// <remarks />
        public const uint ConditionType_ConditionRefresh2_InputArguments = 12913;

        /// <remarks />
        public const uint DialogConditionType_EnabledState = 9035;

        /// <remarks />
        public const uint DialogConditionType_EnabledState_Id = 9036;

        /// <remarks />
        public const uint DialogConditionType_Quality_SourceTimestamp = 9045;

        /// <remarks />
        public const uint DialogConditionType_LastSeverity_SourceTimestamp = 9047;

        /// <remarks />
        public const uint DialogConditionType_Comment_SourceTimestamp = 9049;

        /// <remarks />
        public const uint DialogConditionType_AddComment_InputArguments = 9054;

        /// <remarks />
        public const uint DialogConditionType_ConditionRefresh_InputArguments = 4199;

        /// <remarks />
        public const uint DialogConditionType_ConditionRefresh2_InputArguments = 12917;

        /// <remarks />
        public const uint DialogConditionType_DialogState = 9055;

        /// <remarks />
        public const uint DialogConditionType_DialogState_Id = 9056;

        /// <remarks />
        public const uint DialogConditionType_DialogState_TransitionTime = 9060;

        /// <remarks />
        public const uint DialogConditionType_DialogState_TrueState = 9062;

        /// <remarks />
        public const uint DialogConditionType_DialogState_FalseState = 9063;

        /// <remarks />
        public const uint DialogConditionType_Prompt = 2831;

        /// <remarks />
        public const uint DialogConditionType_ResponseOptionSet = 9064;

        /// <remarks />
        public const uint DialogConditionType_DefaultResponse = 9065;

        /// <remarks />
        public const uint DialogConditionType_OkResponse = 9066;

        /// <remarks />
        public const uint DialogConditionType_CancelResponse = 9067;

        /// <remarks />
        public const uint DialogConditionType_LastResponse = 9068;

        /// <remarks />
        public const uint DialogConditionType_Respond_InputArguments = 9070;

        /// <remarks />
        public const uint DialogConditionType_Respond2_InputArguments = 24313;

        /// <remarks />
        public const uint AcknowledgeableConditionType_EnabledState = 9073;

        /// <remarks />
        public const uint AcknowledgeableConditionType_EnabledState_Id = 9074;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Quality_SourceTimestamp = 9083;

        /// <remarks />
        public const uint AcknowledgeableConditionType_LastSeverity_SourceTimestamp = 9085;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Comment_SourceTimestamp = 9087;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AddComment_InputArguments = 9092;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConditionRefresh_InputArguments = 5124;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConditionRefresh2_InputArguments = 12919;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AckedState = 9093;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AckedState_Id = 9094;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AckedState_TransitionTime = 9098;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AckedState_TrueState = 9100;

        /// <remarks />
        public const uint AcknowledgeableConditionType_AckedState_FalseState = 9101;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConfirmedState = 9102;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConfirmedState_Id = 9103;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConfirmedState_TransitionTime = 9107;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConfirmedState_TrueState = 9109;

        /// <remarks />
        public const uint AcknowledgeableConditionType_ConfirmedState_FalseState = 9110;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Acknowledge_InputArguments = 9112;

        /// <remarks />
        public const uint AcknowledgeableConditionType_Confirm_InputArguments = 9114;

        /// <remarks />
        public const uint AlarmConditionType_EnabledState = 9118;

        /// <remarks />
        public const uint AlarmConditionType_EnabledState_Id = 9119;

        /// <remarks />
        public const uint AlarmConditionType_Quality_SourceTimestamp = 9128;

        /// <remarks />
        public const uint AlarmConditionType_LastSeverity_SourceTimestamp = 9130;

        /// <remarks />
        public const uint AlarmConditionType_Comment_SourceTimestamp = 9132;

        /// <remarks />
        public const uint AlarmConditionType_AddComment_InputArguments = 9137;

        /// <remarks />
        public const uint AlarmConditionType_ConditionRefresh_InputArguments = 5551;

        /// <remarks />
        public const uint AlarmConditionType_ConditionRefresh2_InputArguments = 12985;

        /// <remarks />
        public const uint AlarmConditionType_AckedState_Id = 9139;

        /// <remarks />
        public const uint AlarmConditionType_ConfirmedState_Id = 9148;

        /// <remarks />
        public const uint AlarmConditionType_Acknowledge_InputArguments = 9157;

        /// <remarks />
        public const uint AlarmConditionType_Confirm_InputArguments = 9159;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState = 9160;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_Id = 9161;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_EffectiveDisplayName = 9164;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_TransitionTime = 9165;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_EffectiveTransitionTime = 9166;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_TrueState = 9167;

        /// <remarks />
        public const uint AlarmConditionType_ActiveState_FalseState = 9168;

        /// <remarks />
        public const uint AlarmConditionType_InputNode = 11120;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedState = 9169;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedState_Id = 9170;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedState_TransitionTime = 9174;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedState_TrueState = 9176;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedState_FalseState = 9177;

        /// <remarks />
        public const uint AlarmConditionType_OutOfServiceState = 16371;

        /// <remarks />
        public const uint AlarmConditionType_OutOfServiceState_Id = 16372;

        /// <remarks />
        public const uint AlarmConditionType_OutOfServiceState_TransitionTime = 16376;

        /// <remarks />
        public const uint AlarmConditionType_OutOfServiceState_TrueState = 16378;

        /// <remarks />
        public const uint AlarmConditionType_OutOfServiceState_FalseState = 16379;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_CurrentState = 9179;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_CurrentState_Id = 9180;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_LastTransition = 9184;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_LastTransition_Id = 9185;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_LastTransition_TransitionTime = 9188;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_UnshelveTime = 9189;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_TimedShelve_InputArguments = 9214;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_TimedShelve2_InputArguments = 24739;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_Unshelve2_InputArguments = 24741;

        /// <remarks />
        public const uint AlarmConditionType_ShelvingState_OneShotShelve2_InputArguments = 24743;

        /// <remarks />
        public const uint AlarmConditionType_SuppressedOrShelved = 9215;

        /// <remarks />
        public const uint AlarmConditionType_MaxTimeShelved = 9216;

        /// <remarks />
        public const uint AlarmConditionType_AudibleEnabled = 16389;

        /// <remarks />
        public const uint AlarmConditionType_AudibleSound = 16390;

        /// <remarks />
        public const uint AlarmConditionType_SilenceState = 16380;

        /// <remarks />
        public const uint AlarmConditionType_SilenceState_Id = 16381;

        /// <remarks />
        public const uint AlarmConditionType_SilenceState_TransitionTime = 16385;

        /// <remarks />
        public const uint AlarmConditionType_SilenceState_TrueState = 16387;

        /// <remarks />
        public const uint AlarmConditionType_SilenceState_FalseState = 16388;

        /// <remarks />
        public const uint AlarmConditionType_OnDelay = 16395;

        /// <remarks />
        public const uint AlarmConditionType_OffDelay = 16396;

        /// <remarks />
        public const uint AlarmConditionType_FirstInGroupFlag = 16397;

        /// <remarks />
        public const uint AlarmConditionType_LatchedState = 18190;

        /// <remarks />
        public const uint AlarmConditionType_LatchedState_Id = 18191;

        /// <remarks />
        public const uint AlarmConditionType_LatchedState_TransitionTime = 18195;

        /// <remarks />
        public const uint AlarmConditionType_LatchedState_TrueState = 18197;

        /// <remarks />
        public const uint AlarmConditionType_LatchedState_FalseState = 18198;

        /// <remarks />
        public const uint AlarmConditionType_ReAlarmTime = 16400;

        /// <remarks />
        public const uint AlarmConditionType_ReAlarmRepeatCount = 16401;

        /// <remarks />
        public const uint AlarmConditionType_Suppress2_InputArguments = 24317;

        /// <remarks />
        public const uint AlarmConditionType_Unsuppress2_InputArguments = 24319;

        /// <remarks />
        public const uint AlarmConditionType_RemoveFromService2_InputArguments = 24321;

        /// <remarks />
        public const uint AlarmConditionType_PlaceInService2_InputArguments = 24323;

        /// <remarks />
        public const uint AlarmConditionType_Reset2_InputArguments = 24325;

        /// <remarks />
        public const uint AlarmConditionType_GetGroupMemberships_OutputArguments = 25154;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EventId = 16407;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EventType = 16408;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode = 16409;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName = 16410;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Time = 16411;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime = 16412;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Message = 16414;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Severity = 16415;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId = 16416;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName = 16417;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName = 16420;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId = 16421;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Retain = 16422;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState = 16423;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id = 16424;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Quality = 16432;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp = 16433;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity = 16434;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp = 16435;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Comment = 16436;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp = 16437;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId = 16438;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments = 16442;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState = 16443;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id = 16444;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id = 16453;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments = 16462;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments = 16464;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState = 16465;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id = 16466;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode = 16474;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id = 16476;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id = 16485;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState = 16503;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id = 16504;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id = 16509;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime = 16514;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments = 16518;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments = 24749;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments = 24751;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments = 24753;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved = 16519;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id = 16494;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id = 18204;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments = 24329;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments = 24331;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments = 24333;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments = 24335;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments = 24337;

        /// <remarks />
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments = 25156;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventId = 32066;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventType = 32067;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceNode = 32068;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceName = 32069;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Time = 32070;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ReceiveTime = 32071;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Message = 32073;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Severity = 32074;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassId = 32075;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassName = 32076;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionName = 32079;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_BranchId = 32080;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Retain = 32081;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState = 32082;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id = 32083;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality = 32091;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp = 32092;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity = 32093;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp = 32094;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment = 32095;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp = 32096;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ClientUserId = 32097;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments = 32101;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState = 32102;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_Id = 32103;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id = 32112;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments = 32121;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments = 32123;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState = 32124;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id = 32125;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_InputNode = 32133;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id = 32135;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id = 32144;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState = 32153;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id = 32154;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id = 32159;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime = 32166;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments = 32168;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments = 32170;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments = 32173;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments = 32176;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved = 32177;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id = 32185;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id = 32198;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments = 32211;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments = 32214;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments = 32217;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments = 32220;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments = 32223;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments = 32225;

        /// <remarks />
        public const uint AlarmSuppressionGroupType_DigitalVariable_Placeholder = 32226;

        /// <remarks />
        public const uint ShelvedStateMachineType_CurrentState_Id = 6089;

        /// <remarks />
        public const uint ShelvedStateMachineType_LastTransition_Id = 6094;

        /// <remarks />
        public const uint ShelvedStateMachineType_UnshelveTime = 9115;

        /// <remarks />
        public const uint ShelvedStateMachineType_Unshelved_StateNumber = 6098;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelved_StateNumber = 6100;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelved_StateNumber = 6101;

        /// <remarks />
        public const uint ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber = 11322;

        /// <remarks />
        public const uint ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber = 11323;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber = 11324;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber = 11325;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber = 11326;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber = 11327;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelve_InputArguments = 2991;

        /// <remarks />
        public const uint ShelvedStateMachineType_TimedShelve2_InputArguments = 24757;

        /// <remarks />
        public const uint ShelvedStateMachineType_Unshelve2_InputArguments = 24759;

        /// <remarks />
        public const uint ShelvedStateMachineType_OneShotShelve2_InputArguments = 24761;

        /// <remarks />
        public const uint LimitAlarmType_EnabledState_Id = 9220;

        /// <remarks />
        public const uint LimitAlarmType_Quality_SourceTimestamp = 9229;

        /// <remarks />
        public const uint LimitAlarmType_LastSeverity_SourceTimestamp = 9231;

        /// <remarks />
        public const uint LimitAlarmType_Comment_SourceTimestamp = 9233;

        /// <remarks />
        public const uint LimitAlarmType_AddComment_InputArguments = 9238;

        /// <remarks />
        public const uint LimitAlarmType_ConditionRefresh_InputArguments = 6127;

        /// <remarks />
        public const uint LimitAlarmType_ConditionRefresh2_InputArguments = 12987;

        /// <remarks />
        public const uint LimitAlarmType_AckedState_Id = 9240;

        /// <remarks />
        public const uint LimitAlarmType_ConfirmedState_Id = 9249;

        /// <remarks />
        public const uint LimitAlarmType_Acknowledge_InputArguments = 9258;

        /// <remarks />
        public const uint LimitAlarmType_Confirm_InputArguments = 9260;

        /// <remarks />
        public const uint LimitAlarmType_ActiveState_Id = 9262;

        /// <remarks />
        public const uint LimitAlarmType_SuppressedState_Id = 9271;

        /// <remarks />
        public const uint LimitAlarmType_OutOfServiceState_Id = 16539;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_CurrentState = 9280;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_CurrentState_Id = 9281;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_LastTransition_Id = 9286;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_UnshelveTime = 9290;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_TimedShelve_InputArguments = 9315;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_TimedShelve2_InputArguments = 24763;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_Unshelve2_InputArguments = 24765;

        /// <remarks />
        public const uint LimitAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24767;

        /// <remarks />
        public const uint LimitAlarmType_SilenceState_Id = 16548;

        /// <remarks />
        public const uint LimitAlarmType_LatchedState_Id = 18214;

        /// <remarks />
        public const uint LimitAlarmType_Suppress2_InputArguments = 24339;

        /// <remarks />
        public const uint LimitAlarmType_Unsuppress2_InputArguments = 24341;

        /// <remarks />
        public const uint LimitAlarmType_RemoveFromService2_InputArguments = 24343;

        /// <remarks />
        public const uint LimitAlarmType_PlaceInService2_InputArguments = 24345;

        /// <remarks />
        public const uint LimitAlarmType_Reset2_InputArguments = 24347;

        /// <remarks />
        public const uint LimitAlarmType_GetGroupMemberships_OutputArguments = 25159;

        /// <remarks />
        public const uint LimitAlarmType_HighHighLimit = 11124;

        /// <remarks />
        public const uint LimitAlarmType_HighLimit = 11125;

        /// <remarks />
        public const uint LimitAlarmType_LowLimit = 11126;

        /// <remarks />
        public const uint LimitAlarmType_LowLowLimit = 11127;

        /// <remarks />
        public const uint LimitAlarmType_BaseHighHighLimit = 16572;

        /// <remarks />
        public const uint LimitAlarmType_BaseHighLimit = 16573;

        /// <remarks />
        public const uint LimitAlarmType_BaseLowLimit = 16574;

        /// <remarks />
        public const uint LimitAlarmType_BaseLowLowLimit = 16575;

        /// <remarks />
        public const uint LimitAlarmType_SeverityHighHigh = 24770;

        /// <remarks />
        public const uint LimitAlarmType_SeverityHigh = 24771;

        /// <remarks />
        public const uint LimitAlarmType_SeverityLow = 24772;

        /// <remarks />
        public const uint LimitAlarmType_SeverityLowLow = 24773;

        /// <remarks />
        public const uint LimitAlarmType_HighHighDeadband = 24774;

        /// <remarks />
        public const uint LimitAlarmType_HighDeadband = 24775;

        /// <remarks />
        public const uint LimitAlarmType_LowDeadband = 24776;

        /// <remarks />
        public const uint LimitAlarmType_LowLowDeadband = 24777;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_CurrentState_Id = 9320;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LastTransition_Id = 9325;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighHigh_StateNumber = 9330;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_High_StateNumber = 9332;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_Low_StateNumber = 9334;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowLow_StateNumber = 9336;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber = 11340;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber = 11341;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber = 11342;

        /// <remarks />
        public const uint ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber = 11343;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_EnabledState_Id = 9355;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Quality_SourceTimestamp = 9364;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp = 9366;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Comment_SourceTimestamp = 9368;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_AddComment_InputArguments = 9373;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ConditionRefresh_InputArguments = 9375;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments = 12989;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_AckedState_Id = 9377;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ConfirmedState_Id = 9386;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Acknowledge_InputArguments = 9395;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Confirm_InputArguments = 9397;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ActiveState = 9398;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ActiveState_Id = 9399;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_SuppressedState_Id = 9408;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_OutOfServiceState_Id = 16579;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_CurrentState = 9417;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id = 9418;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id = 9423;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_UnshelveTime = 9427;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments = 9452;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments = 24779;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments = 24781;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24783;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_SilenceState_Id = 16588;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LatchedState_Id = 18224;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Suppress2_InputArguments = 24349;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Unsuppress2_InputArguments = 24351;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_RemoveFromService2_InputArguments = 24353;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_PlaceInService2_InputArguments = 24355;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_Reset2_InputArguments = 24357;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments = 25160;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState_CurrentState = 9456;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState_CurrentState_Id = 9457;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition = 9461;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition_Id = 9462;

        /// <remarks />
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime = 9465;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_EnabledState_Id = 9920;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Quality_SourceTimestamp = 9929;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp = 9931;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Comment_SourceTimestamp = 9933;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_AddComment_InputArguments = 9938;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments = 9940;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments = 12991;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_AckedState_Id = 9942;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ConfirmedState_Id = 9951;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Acknowledge_InputArguments = 9960;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Confirm_InputArguments = 9962;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ActiveState = 9963;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ActiveState_Id = 9964;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_SuppressedState_Id = 9973;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_OutOfServiceState_Id = 16619;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_CurrentState = 9982;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id = 9983;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id = 9988;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime = 9992;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments = 10017;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments = 24795;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments = 24797;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24799;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_SilenceState_Id = 16628;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LatchedState_Id = 18234;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Suppress2_InputArguments = 24359;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Unsuppress2_InputArguments = 24361;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments = 24363;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_PlaceInService2_InputArguments = 24365;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_Reset2_InputArguments = 24367;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments = 25161;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighHighState = 10020;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighHighState_Id = 10021;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighHighState_TransitionTime = 10025;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighHighState_TrueState = 10027;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighHighState_FalseState = 10028;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighState = 10029;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighState_Id = 10030;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighState_TransitionTime = 10034;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighState_TrueState = 10036;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_HighState_FalseState = 10037;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowState = 10038;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowState_Id = 10039;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowState_TransitionTime = 10043;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowState_TrueState = 10045;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowState_FalseState = 10046;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowLowState = 10047;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowLowState_Id = 10048;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowLowState_TransitionTime = 10052;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowLowState_TrueState = 10054;

        /// <remarks />
        public const uint NonExclusiveLimitAlarmType_LowLowState_FalseState = 10055;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_EnabledState_Id = 10074;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Quality_SourceTimestamp = 10083;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp = 10085;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Comment_SourceTimestamp = 10087;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_AddComment_InputArguments = 10092;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments = 10094;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments = 12993;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_AckedState_Id = 10096;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ConfirmedState_Id = 10105;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Acknowledge_InputArguments = 10114;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Confirm_InputArguments = 10116;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ActiveState_Id = 10118;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_SuppressedState_Id = 10127;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_OutOfServiceState_Id = 16659;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_CurrentState = 10136;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id = 10137;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id = 10142;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime = 10146;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments = 10171;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments = 24811;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments = 24813;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24815;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_SilenceState_Id = 16668;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_LatchedState_Id = 18247;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Suppress2_InputArguments = 24369;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Unsuppress2_InputArguments = 24371;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments = 24373;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_PlaceInService2_InputArguments = 24375;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_Reset2_InputArguments = 24377;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments = 25162;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_HighHighState_Id = 10175;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_HighState_Id = 10184;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_LowState_Id = 10193;

        /// <remarks />
        public const uint NonExclusiveLevelAlarmType_LowLowState_Id = 10202;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_EnabledState_Id = 9496;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Quality_SourceTimestamp = 9505;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp = 9507;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Comment_SourceTimestamp = 9509;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_AddComment_InputArguments = 9514;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ConditionRefresh_InputArguments = 9516;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments = 12995;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_AckedState_Id = 9518;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ConfirmedState_Id = 9527;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Acknowledge_InputArguments = 9536;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Confirm_InputArguments = 9538;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ActiveState_Id = 9540;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_SuppressedState_Id = 9549;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_OutOfServiceState_Id = 16699;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_CurrentState = 9558;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id = 9559;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id = 9564;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_UnshelveTime = 9568;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments = 9593;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments = 24827;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments = 24829;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24831;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_SilenceState_Id = 16708;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_LatchedState_Id = 18258;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Suppress2_InputArguments = 24379;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Unsuppress2_InputArguments = 24381;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_RemoveFromService2_InputArguments = 24383;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_PlaceInService2_InputArguments = 24385;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_Reset2_InputArguments = 24387;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments = 25163;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_LimitState_CurrentState = 9597;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_LimitState_CurrentState_Id = 9598;

        /// <remarks />
        public const uint ExclusiveLevelAlarmType_LimitState_LastTransition_Id = 9603;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_EnabledState_Id = 10382;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Quality_SourceTimestamp = 10391;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp = 10393;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Comment_SourceTimestamp = 10395;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_AddComment_InputArguments = 10400;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments = 10402;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments = 12997;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_AckedState_Id = 10404;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ConfirmedState_Id = 10413;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Acknowledge_InputArguments = 10422;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Confirm_InputArguments = 10424;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ActiveState_Id = 10426;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_SuppressedState_Id = 10435;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_OutOfServiceState_Id = 16739;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_CurrentState = 10444;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id = 10445;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id = 10450;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime = 10454;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments = 10479;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments = 24843;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments = 24845;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24847;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_SilenceState_Id = 16748;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_LatchedState_Id = 18268;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Suppress2_InputArguments = 24389;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments = 24391;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments = 24393;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments = 24395;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_Reset2_InputArguments = 24397;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments = 25164;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_HighHighState_Id = 10483;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_HighState_Id = 10492;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_LowState_Id = 10501;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_LowLowState_Id = 10510;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_SetpointNode = 10522;

        /// <remarks />
        public const uint NonExclusiveDeviationAlarmType_BaseSetpointNode = 16776;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_EnabledState_Id = 10228;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp = 10237;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp = 10239;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp = 10241;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments = 10246;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments = 10248;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments = 13001;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_AckedState_Id = 10250;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id = 10259;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments = 10268;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments = 10270;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ActiveState_Id = 10272;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_SuppressedState_Id = 10281;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id = 16821;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState = 10290;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id = 10291;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id = 10296;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime = 10300;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments = 10325;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments = 24859;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments = 24861;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24863;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_SilenceState_Id = 16830;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_LatchedState_Id = 18278;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments = 24399;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments = 24401;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments = 24403;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments = 24405;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments = 24407;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments = 25165;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_HighHighState_Id = 10329;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_HighState_Id = 10338;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_LowState_Id = 10347;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_LowLowState_Id = 10356;

        /// <remarks />
        public const uint NonExclusiveRateOfChangeAlarmType_EngineeringUnits = 16858;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_EnabledState_Id = 9778;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Quality_SourceTimestamp = 9787;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp = 9789;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Comment_SourceTimestamp = 9791;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_AddComment_InputArguments = 9796;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments = 9798;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments = 12999;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_AckedState_Id = 9800;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ConfirmedState_Id = 9809;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Acknowledge_InputArguments = 9818;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Confirm_InputArguments = 9820;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ActiveState_Id = 9822;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_SuppressedState_Id = 9831;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_OutOfServiceState_Id = 16780;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_CurrentState = 9840;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id = 9841;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id = 9846;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime = 9850;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments = 9875;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments = 24875;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments = 24877;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24879;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_SilenceState_Id = 16789;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_LatchedState_Id = 18288;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Suppress2_InputArguments = 24409;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Unsuppress2_InputArguments = 24411;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments = 24413;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_PlaceInService2_InputArguments = 24415;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_Reset2_InputArguments = 24417;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments = 25166;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_LimitState_CurrentState = 9879;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_LimitState_CurrentState_Id = 9880;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_LimitState_LastTransition_Id = 9885;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_SetpointNode = 9905;

        /// <remarks />
        public const uint ExclusiveDeviationAlarmType_BaseSetpointNode = 16817;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_EnabledState_Id = 9637;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp = 9646;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp = 9648;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp = 9650;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_AddComment_InputArguments = 9655;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments = 9657;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments = 13003;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_AckedState_Id = 9659;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ConfirmedState_Id = 9668;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments = 9677;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Confirm_InputArguments = 9679;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ActiveState_Id = 9681;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_SuppressedState_Id = 9690;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id = 16862;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState = 9699;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id = 9700;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id = 9705;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime = 9709;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments = 9734;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments = 24891;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments = 24893;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24895;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_SilenceState_Id = 16871;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_LatchedState_Id = 18298;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments = 24419;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments = 24421;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments = 24423;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments = 24425;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_Reset2_InputArguments = 24427;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments = 25167;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_CurrentState = 9738;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id = 9739;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id = 9744;

        /// <remarks />
        public const uint ExclusiveRateOfChangeAlarmType_EngineeringUnits = 16899;

        /// <remarks />
        public const uint DiscreteAlarmType_EnabledState_Id = 10537;

        /// <remarks />
        public const uint DiscreteAlarmType_Quality_SourceTimestamp = 10546;

        /// <remarks />
        public const uint DiscreteAlarmType_LastSeverity_SourceTimestamp = 10548;

        /// <remarks />
        public const uint DiscreteAlarmType_Comment_SourceTimestamp = 10550;

        /// <remarks />
        public const uint DiscreteAlarmType_AddComment_InputArguments = 10555;

        /// <remarks />
        public const uint DiscreteAlarmType_ConditionRefresh_InputArguments = 10557;

        /// <remarks />
        public const uint DiscreteAlarmType_ConditionRefresh2_InputArguments = 13005;

        /// <remarks />
        public const uint DiscreteAlarmType_AckedState_Id = 10559;

        /// <remarks />
        public const uint DiscreteAlarmType_ConfirmedState_Id = 10568;

        /// <remarks />
        public const uint DiscreteAlarmType_Acknowledge_InputArguments = 10577;

        /// <remarks />
        public const uint DiscreteAlarmType_Confirm_InputArguments = 10579;

        /// <remarks />
        public const uint DiscreteAlarmType_ActiveState_Id = 10581;

        /// <remarks />
        public const uint DiscreteAlarmType_SuppressedState_Id = 10590;

        /// <remarks />
        public const uint DiscreteAlarmType_OutOfServiceState_Id = 16903;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_CurrentState = 10599;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_CurrentState_Id = 10600;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_LastTransition_Id = 10605;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_UnshelveTime = 10609;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments = 10634;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments = 24907;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments = 24909;

        /// <remarks />
        public const uint DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24911;

        /// <remarks />
        public const uint DiscreteAlarmType_SilenceState_Id = 16912;

        /// <remarks />
        public const uint DiscreteAlarmType_LatchedState_Id = 18308;

        /// <remarks />
        public const uint DiscreteAlarmType_Suppress2_InputArguments = 24429;

        /// <remarks />
        public const uint DiscreteAlarmType_Unsuppress2_InputArguments = 24431;

        /// <remarks />
        public const uint DiscreteAlarmType_RemoveFromService2_InputArguments = 24433;

        /// <remarks />
        public const uint DiscreteAlarmType_PlaceInService2_InputArguments = 24435;

        /// <remarks />
        public const uint DiscreteAlarmType_Reset2_InputArguments = 24437;

        /// <remarks />
        public const uint DiscreteAlarmType_GetGroupMemberships_OutputArguments = 25168;

        /// <remarks />
        public const uint OffNormalAlarmType_EnabledState_Id = 10651;

        /// <remarks />
        public const uint OffNormalAlarmType_Quality_SourceTimestamp = 10660;

        /// <remarks />
        public const uint OffNormalAlarmType_LastSeverity_SourceTimestamp = 10662;

        /// <remarks />
        public const uint OffNormalAlarmType_Comment_SourceTimestamp = 10664;

        /// <remarks />
        public const uint OffNormalAlarmType_AddComment_InputArguments = 10669;

        /// <remarks />
        public const uint OffNormalAlarmType_ConditionRefresh_InputArguments = 10671;

        /// <remarks />
        public const uint OffNormalAlarmType_ConditionRefresh2_InputArguments = 13007;

        /// <remarks />
        public const uint OffNormalAlarmType_AckedState_Id = 10673;

        /// <remarks />
        public const uint OffNormalAlarmType_ConfirmedState_Id = 10682;

        /// <remarks />
        public const uint OffNormalAlarmType_Acknowledge_InputArguments = 10691;

        /// <remarks />
        public const uint OffNormalAlarmType_Confirm_InputArguments = 10693;

        /// <remarks />
        public const uint OffNormalAlarmType_ActiveState_Id = 10695;

        /// <remarks />
        public const uint OffNormalAlarmType_SuppressedState_Id = 10704;

        /// <remarks />
        public const uint OffNormalAlarmType_OutOfServiceState_Id = 16939;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_CurrentState = 10713;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_CurrentState_Id = 10714;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_LastTransition_Id = 10719;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_UnshelveTime = 10723;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments = 10748;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_TimedShelve2_InputArguments = 24915;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_Unshelve2_InputArguments = 24917;

        /// <remarks />
        public const uint OffNormalAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24919;

        /// <remarks />
        public const uint OffNormalAlarmType_SilenceState_Id = 16948;

        /// <remarks />
        public const uint OffNormalAlarmType_LatchedState_Id = 18318;

        /// <remarks />
        public const uint OffNormalAlarmType_Suppress2_InputArguments = 24439;

        /// <remarks />
        public const uint OffNormalAlarmType_Unsuppress2_InputArguments = 24441;

        /// <remarks />
        public const uint OffNormalAlarmType_RemoveFromService2_InputArguments = 24443;

        /// <remarks />
        public const uint OffNormalAlarmType_PlaceInService2_InputArguments = 24445;

        /// <remarks />
        public const uint OffNormalAlarmType_Reset2_InputArguments = 24447;

        /// <remarks />
        public const uint OffNormalAlarmType_GetGroupMemberships_OutputArguments = 25169;

        /// <remarks />
        public const uint OffNormalAlarmType_NormalState = 11158;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_EnabledState_Id = 11769;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Quality_SourceTimestamp = 11778;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_LastSeverity_SourceTimestamp = 11780;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Comment_SourceTimestamp = 11782;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_AddComment_InputArguments = 11787;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ConditionRefresh_InputArguments = 11789;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ConditionRefresh2_InputArguments = 13009;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_AckedState_Id = 11791;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ConfirmedState_Id = 11800;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Acknowledge_InputArguments = 11809;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Confirm_InputArguments = 11811;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ActiveState_Id = 11813;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_SuppressedState_Id = 11823;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_OutOfServiceState_Id = 16975;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_CurrentState = 11832;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_CurrentState_Id = 11833;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_LastTransition_Id = 11838;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_UnshelveTime = 11843;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments = 11847;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_TimedShelve2_InputArguments = 24923;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_Unshelve2_InputArguments = 24925;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24927;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_SilenceState_Id = 16984;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_LatchedState_Id = 18328;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Suppress2_InputArguments = 24449;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Unsuppress2_InputArguments = 24451;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_RemoveFromService2_InputArguments = 24453;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_PlaceInService2_InputArguments = 24455;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_Reset2_InputArguments = 24457;

        /// <remarks />
        public const uint SystemOffNormalAlarmType_GetGroupMemberships_OutputArguments = 25170;

        /// <remarks />
        public const uint TripAlarmType_EnabledState_Id = 10765;

        /// <remarks />
        public const uint TripAlarmType_Quality_SourceTimestamp = 10774;

        /// <remarks />
        public const uint TripAlarmType_LastSeverity_SourceTimestamp = 10776;

        /// <remarks />
        public const uint TripAlarmType_Comment_SourceTimestamp = 10778;

        /// <remarks />
        public const uint TripAlarmType_AddComment_InputArguments = 10783;

        /// <remarks />
        public const uint TripAlarmType_ConditionRefresh_InputArguments = 10785;

        /// <remarks />
        public const uint TripAlarmType_ConditionRefresh2_InputArguments = 13011;

        /// <remarks />
        public const uint TripAlarmType_AckedState_Id = 10787;

        /// <remarks />
        public const uint TripAlarmType_ConfirmedState_Id = 10796;

        /// <remarks />
        public const uint TripAlarmType_Acknowledge_InputArguments = 10805;

        /// <remarks />
        public const uint TripAlarmType_Confirm_InputArguments = 10807;

        /// <remarks />
        public const uint TripAlarmType_ActiveState_Id = 10809;

        /// <remarks />
        public const uint TripAlarmType_SuppressedState_Id = 10818;

        /// <remarks />
        public const uint TripAlarmType_OutOfServiceState_Id = 17011;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_CurrentState = 10827;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_CurrentState_Id = 10828;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_LastTransition_Id = 10833;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_UnshelveTime = 10837;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_TimedShelve_InputArguments = 10862;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_TimedShelve2_InputArguments = 24931;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_Unshelve2_InputArguments = 24933;

        /// <remarks />
        public const uint TripAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24935;

        /// <remarks />
        public const uint TripAlarmType_SilenceState_Id = 17020;

        /// <remarks />
        public const uint TripAlarmType_LatchedState_Id = 18338;

        /// <remarks />
        public const uint TripAlarmType_Suppress2_InputArguments = 24459;

        /// <remarks />
        public const uint TripAlarmType_Unsuppress2_InputArguments = 24461;

        /// <remarks />
        public const uint TripAlarmType_RemoveFromService2_InputArguments = 24463;

        /// <remarks />
        public const uint TripAlarmType_PlaceInService2_InputArguments = 24465;

        /// <remarks />
        public const uint TripAlarmType_Reset2_InputArguments = 24467;

        /// <remarks />
        public const uint TripAlarmType_GetGroupMemberships_OutputArguments = 25171;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_EnabledState_Id = 18365;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Quality_SourceTimestamp = 18374;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp = 18376;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Comment_SourceTimestamp = 18378;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_AddComment_InputArguments = 18383;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments = 18385;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments = 18387;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_AckedState_Id = 18389;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ConfirmedState_Id = 18398;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Acknowledge_InputArguments = 18407;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Confirm_InputArguments = 18409;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ActiveState_Id = 18411;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_SuppressedState_Id = 18421;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_OutOfServiceState_Id = 18430;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_CurrentState = 18439;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id = 18440;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id = 18445;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime = 18452;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments = 18454;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments = 24939;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments = 24941;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24943;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_SilenceState_Id = 18465;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_LatchedState_Id = 18478;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Suppress2_InputArguments = 24469;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments = 24471;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments = 24473;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments = 24475;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_Reset2_InputArguments = 24477;

        /// <remarks />
        public const uint InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments = 25172;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_EnabledState_Id = 18514;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Quality_SourceTimestamp = 18523;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_LastSeverity_SourceTimestamp = 18525;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Comment_SourceTimestamp = 18527;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_AddComment_InputArguments = 18532;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ConditionRefresh_InputArguments = 18534;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ConditionRefresh2_InputArguments = 18536;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_AckedState_Id = 18538;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ConfirmedState_Id = 18547;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Acknowledge_InputArguments = 18556;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Confirm_InputArguments = 18558;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ActiveState_Id = 18560;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_SuppressedState_Id = 18570;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_OutOfServiceState_Id = 18579;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_CurrentState = 18588;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_CurrentState_Id = 18589;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_LastTransition_Id = 18594;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_UnshelveTime = 18601;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments = 18603;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments = 24947;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments = 24949;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24951;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_SilenceState_Id = 18614;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_LatchedState_Id = 18627;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Suppress2_InputArguments = 24479;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Unsuppress2_InputArguments = 24481;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_RemoveFromService2_InputArguments = 24483;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_PlaceInService2_InputArguments = 24485;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_Reset2_InputArguments = 24487;

        /// <remarks />
        public const uint SystemDiagnosticAlarmType_GetGroupMemberships_OutputArguments = 25173;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_EnabledState_Id = 13241;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Quality_SourceTimestamp = 13250;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_LastSeverity_SourceTimestamp = 13252;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Comment_SourceTimestamp = 13254;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_AddComment_InputArguments = 13259;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ConditionRefresh_InputArguments = 13261;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ConditionRefresh2_InputArguments = 13263;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_AckedState_Id = 13265;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ConfirmedState_Id = 13274;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Acknowledge_InputArguments = 13283;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Confirm_InputArguments = 13285;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ActiveState_Id = 13287;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_SuppressedState_Id = 13297;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_OutOfServiceState_Id = 17047;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_CurrentState = 13306;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_CurrentState_Id = 13307;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_LastTransition_Id = 13312;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_UnshelveTime = 13317;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments = 13321;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_TimedShelve2_InputArguments = 24955;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_Unshelve2_InputArguments = 24957;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24959;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_SilenceState_Id = 17056;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_LatchedState_Id = 18646;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Suppress2_InputArguments = 24489;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Unsuppress2_InputArguments = 24491;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_RemoveFromService2_InputArguments = 24493;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_PlaceInService2_InputArguments = 24495;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Reset2_InputArguments = 24497;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_GetGroupMemberships_OutputArguments = 25174;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ExpirationDate = 13325;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_ExpirationLimit = 14900;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_CertificateType = 13326;

        /// <remarks />
        public const uint CertificateExpirationAlarmType_Certificate = 13327;

        /// <remarks />
        public const uint DiscrepancyAlarmType_EnabledState_Id = 17098;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Quality_SourceTimestamp = 17107;

        /// <remarks />
        public const uint DiscrepancyAlarmType_LastSeverity_SourceTimestamp = 17109;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Comment_SourceTimestamp = 17111;

        /// <remarks />
        public const uint DiscrepancyAlarmType_AddComment_InputArguments = 17116;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ConditionRefresh_InputArguments = 17118;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ConditionRefresh2_InputArguments = 17120;

        /// <remarks />
        public const uint DiscrepancyAlarmType_AckedState_Id = 17122;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ConfirmedState_Id = 17131;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Acknowledge_InputArguments = 17140;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Confirm_InputArguments = 17142;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ActiveState_Id = 17144;

        /// <remarks />
        public const uint DiscrepancyAlarmType_SuppressedState_Id = 17154;

        /// <remarks />
        public const uint DiscrepancyAlarmType_OutOfServiceState_Id = 17163;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_CurrentState = 17181;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_CurrentState_Id = 17182;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_LastTransition_Id = 17187;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_UnshelveTime = 17192;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments = 17196;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments = 24963;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments = 24965;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24967;

        /// <remarks />
        public const uint DiscrepancyAlarmType_SilenceState_Id = 17172;

        /// <remarks />
        public const uint DiscrepancyAlarmType_LatchedState_Id = 18656;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Suppress2_InputArguments = 24499;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Unsuppress2_InputArguments = 24501;

        /// <remarks />
        public const uint DiscrepancyAlarmType_RemoveFromService2_InputArguments = 24503;

        /// <remarks />
        public const uint DiscrepancyAlarmType_PlaceInService2_InputArguments = 24505;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Reset2_InputArguments = 24507;

        /// <remarks />
        public const uint DiscrepancyAlarmType_GetGroupMemberships_OutputArguments = 25175;

        /// <remarks />
        public const uint DiscrepancyAlarmType_TargetValueNode = 17215;

        /// <remarks />
        public const uint DiscrepancyAlarmType_ExpectedTime = 17216;

        /// <remarks />
        public const uint DiscrepancyAlarmType_Tolerance = 17217;

        /// <remarks />
        public const uint AuditConditionCommentEventType_ConditionEventId = 17222;

        /// <remarks />
        public const uint AuditConditionCommentEventType_Comment = 11851;

        /// <remarks />
        public const uint AuditConditionRespondEventType_SelectedResponse = 11852;

        /// <remarks />
        public const uint AuditConditionAcknowledgeEventType_ConditionEventId = 17223;

        /// <remarks />
        public const uint AuditConditionAcknowledgeEventType_Comment = 11853;

        /// <remarks />
        public const uint AuditConditionConfirmEventType_ConditionEventId = 17224;

        /// <remarks />
        public const uint AuditConditionConfirmEventType_Comment = 11854;

        /// <remarks />
        public const uint AuditConditionShelvingEventType_ShelvingTime = 11855;

        /// <remarks />
        public const uint AlarmMetricsType_AlarmCount = 17280;

        /// <remarks />
        public const uint AlarmMetricsType_StartTime = 17991;

        /// <remarks />
        public const uint AlarmMetricsType_MaximumActiveState = 17281;

        /// <remarks />
        public const uint AlarmMetricsType_MaximumUnAck = 17282;

        /// <remarks />
        public const uint AlarmMetricsType_CurrentAlarmRate = 17284;

        /// <remarks />
        public const uint AlarmMetricsType_CurrentAlarmRate_Rate = 17285;

        /// <remarks />
        public const uint AlarmMetricsType_MaximumAlarmRate = 17286;

        /// <remarks />
        public const uint AlarmMetricsType_MaximumAlarmRate_Rate = 17287;

        /// <remarks />
        public const uint AlarmMetricsType_MaximumReAlarmCount = 17283;

        /// <remarks />
        public const uint AlarmMetricsType_AverageAlarmRate = 17288;

        /// <remarks />
        public const uint AlarmMetricsType_AverageAlarmRate_Rate = 17289;

        /// <remarks />
        public const uint AlarmRateVariableType_Rate = 17278;

        /// <remarks />
        public const uint AlarmStateVariableType_HighestActiveSeverity = 32245;

        /// <remarks />
        public const uint AlarmStateVariableType_HighestUnackSeverity = 32246;

        /// <remarks />
        public const uint AlarmStateVariableType_ActiveCount = 32247;

        /// <remarks />
        public const uint AlarmStateVariableType_UnacknowledgedCount = 32248;

        /// <remarks />
        public const uint AlarmStateVariableType_UnconfirmedCount = 32249;

        /// <remarks />
        public const uint AlarmStateVariableType_Filter = 32250;

        /// <remarks />
        public const uint AlarmMask_OptionSetValues = 32252;

        /// <remarks />
        public const uint ProgramStateMachineType_CurrentState = 3830;

        /// <remarks />
        public const uint ProgramStateMachineType_CurrentState_Id = 3831;

        /// <remarks />
        public const uint ProgramStateMachineType_CurrentState_Number = 3833;

        /// <remarks />
        public const uint ProgramStateMachineType_LastTransition = 3835;

        /// <remarks />
        public const uint ProgramStateMachineType_LastTransition_Id = 3836;

        /// <remarks />
        public const uint ProgramStateMachineType_LastTransition_Number = 3838;

        /// <remarks />
        public const uint ProgramStateMachineType_LastTransition_TransitionTime = 3839;

        /// <remarks />
        public const uint ProgramStateMachineType_Creatable = 2392;

        /// <remarks />
        public const uint ProgramStateMachineType_Deletable = 2393;

        /// <remarks />
        public const uint ProgramStateMachineType_AutoDelete = 2394;

        /// <remarks />
        public const uint ProgramStateMachineType_RecycleCount = 2395;

        /// <remarks />
        public const uint ProgramStateMachineType_InstanceCount = 2396;

        /// <remarks />
        public const uint ProgramStateMachineType_MaxInstanceCount = 2397;

        /// <remarks />
        public const uint ProgramStateMachineType_MaxRecycleCount = 2398;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic = 2399;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_CreateSessionId = 3840;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_CreateClientName = 3841;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime = 3842;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime = 3843;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodCall = 3844;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId = 3845;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments = 3846;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments = 3847;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues = 15038;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues = 15040;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime = 3848;

        /// <remarks />
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus = 3849;

        /// <remarks />
        public const uint ProgramStateMachineType_Halted_StateNumber = 2407;

        /// <remarks />
        public const uint ProgramStateMachineType_Ready_StateNumber = 2401;

        /// <remarks />
        public const uint ProgramStateMachineType_Running_StateNumber = 2403;

        /// <remarks />
        public const uint ProgramStateMachineType_Suspended_StateNumber = 2405;

        /// <remarks />
        public const uint ProgramStateMachineType_HaltedToReady_TransitionNumber = 2409;

        /// <remarks />
        public const uint ProgramStateMachineType_ReadyToRunning_TransitionNumber = 2411;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToHalted_TransitionNumber = 2413;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToReady_TransitionNumber = 2415;

        /// <remarks />
        public const uint ProgramStateMachineType_RunningToSuspended_TransitionNumber = 2417;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToRunning_TransitionNumber = 2419;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToHalted_TransitionNumber = 2421;

        /// <remarks />
        public const uint ProgramStateMachineType_SuspendedToReady_TransitionNumber = 2423;

        /// <remarks />
        public const uint ProgramStateMachineType_ReadyToHalted_TransitionNumber = 2425;

        /// <remarks />
        public const uint ProgramTransitionEventType_Transition_Id = 3802;

        /// <remarks />
        public const uint ProgramTransitionEventType_FromState_Id = 3792;

        /// <remarks />
        public const uint ProgramTransitionEventType_ToState_Id = 3797;

        /// <remarks />
        public const uint ProgramTransitionEventType_IntermediateResult = 2379;

        /// <remarks />
        public const uint AuditProgramTransitionEventType_TransitionNumber = 11875;

        /// <remarks />
        public const uint ProgramTransitionAuditEventType_Transition = 3825;

        /// <remarks />
        public const uint ProgramTransitionAuditEventType_Transition_Id = 3826;

        /// <remarks />
        public const uint ProgramDiagnosticType_CreateSessionId = 2381;

        /// <remarks />
        public const uint ProgramDiagnosticType_CreateClientName = 2382;

        /// <remarks />
        public const uint ProgramDiagnosticType_InvocationCreationTime = 2383;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastTransitionTime = 2384;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodCall = 2385;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodSessionId = 2386;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodInputArguments = 2387;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodOutputArguments = 2388;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodCallTime = 2389;

        /// <remarks />
        public const uint ProgramDiagnosticType_LastMethodReturnStatus = 2390;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_CreateSessionId = 15384;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_CreateClientName = 15385;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_InvocationCreationTime = 15386;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastTransitionTime = 15387;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodCall = 15388;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodSessionId = 15389;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodInputArguments = 15390;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodOutputArguments = 15391;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodInputValues = 15392;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodOutputValues = 15393;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodCallTime = 15394;

        /// <remarks />
        public const uint ProgramDiagnostic2Type_LastMethodReturnStatus = 15395;

        /// <remarks />
        public const uint Annotations = 11214;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad = 11168;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad = 11169;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood = 11170;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation = 11171;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_Stepped = 2323;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_Definition = 2324;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_MaxTimeInterval = 2325;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_MinTimeInterval = 2326;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_ExceptionDeviation = 2327;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_ExceptionDeviationFormat = 2328;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_StartOfArchive = 11499;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_StartOfOnlineArchive = 11500;

        /// <remarks />
        public const uint HistoricalDataConfigurationType_ServerTimestampSupported = 19092;

        /// <remarks />
        public const uint HAConfiguration_AggregateConfiguration_TreatUncertainAsBad = 11204;

        /// <remarks />
        public const uint HAConfiguration_AggregateConfiguration_PercentDataBad = 11205;

        /// <remarks />
        public const uint HAConfiguration_AggregateConfiguration_PercentDataGood = 11206;

        /// <remarks />
        public const uint HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation = 11207;

        /// <remarks />
        public const uint HAConfiguration_Stepped = 11208;

        /// <remarks />
        public const uint HistoricalEventFilter = 11215;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_AccessHistoryDataCapability = 2331;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_AccessHistoryEventsCapability = 2332;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_MaxReturnDataValues = 11268;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_MaxReturnEventValues = 11269;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_InsertDataCapability = 2334;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_ReplaceDataCapability = 2335;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_UpdateDataCapability = 2336;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_DeleteRawCapability = 2337;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_DeleteAtTimeCapability = 2338;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_InsertEventCapability = 11278;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_ReplaceEventCapability = 11279;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_UpdateEventCapability = 11280;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_DeleteEventCapability = 11501;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_InsertAnnotationCapability = 11270;

        /// <remarks />
        public const uint HistoryServerCapabilitiesType_ServerTimestampSupported = 19094;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType_UpdatedNode = 3025;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType_PerformInsertReplace = 3028;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType_Filter = 3003;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType_NewValues = 3029;

        /// <remarks />
        public const uint AuditHistoryEventUpdateEventType_OldValues = 3030;

        /// <remarks />
        public const uint AuditHistoryValueUpdateEventType_UpdatedNode = 3026;

        /// <remarks />
        public const uint AuditHistoryValueUpdateEventType_PerformInsertReplace = 3031;

        /// <remarks />
        public const uint AuditHistoryValueUpdateEventType_NewValues = 3032;

        /// <remarks />
        public const uint AuditHistoryValueUpdateEventType_OldValues = 3033;

        /// <remarks />
        public const uint AuditHistoryAnnotationUpdateEventType_PerformInsertReplace = 19293;

        /// <remarks />
        public const uint AuditHistoryAnnotationUpdateEventType_NewValues = 19294;

        /// <remarks />
        public const uint AuditHistoryAnnotationUpdateEventType_OldValues = 19295;

        /// <remarks />
        public const uint AuditHistoryDeleteEventType_UpdatedNode = 3027;

        /// <remarks />
        public const uint AuditHistoryRawModifyDeleteEventType_IsDeleteModified = 3015;

        /// <remarks />
        public const uint AuditHistoryRawModifyDeleteEventType_StartTime = 3016;

        /// <remarks />
        public const uint AuditHistoryRawModifyDeleteEventType_EndTime = 3017;

        /// <remarks />
        public const uint AuditHistoryRawModifyDeleteEventType_OldValues = 3034;

        /// <remarks />
        public const uint AuditHistoryAtTimeDeleteEventType_ReqTimes = 3020;

        /// <remarks />
        public const uint AuditHistoryAtTimeDeleteEventType_OldValues = 3021;

        /// <remarks />
        public const uint AuditHistoryEventDeleteEventType_EventIds = 3023;

        /// <remarks />
        public const uint AuditHistoryEventDeleteEventType_OldValues = 3024;

        /// <remarks />
        public const uint TrustListType_Open_InputArguments = 12528;

        /// <remarks />
        public const uint TrustListType_Open_OutputArguments = 12529;

        /// <remarks />
        public const uint TrustListType_Close_InputArguments = 12531;

        /// <remarks />
        public const uint TrustListType_Read_InputArguments = 12533;

        /// <remarks />
        public const uint TrustListType_Read_OutputArguments = 12534;

        /// <remarks />
        public const uint TrustListType_Write_InputArguments = 12536;

        /// <remarks />
        public const uint TrustListType_GetPosition_InputArguments = 12538;

        /// <remarks />
        public const uint TrustListType_GetPosition_OutputArguments = 12539;

        /// <remarks />
        public const uint TrustListType_SetPosition_InputArguments = 12541;

        /// <remarks />
        public const uint TrustListType_LastUpdateTime = 12542;

        /// <remarks />
        public const uint TrustListType_UpdateFrequency = 19296;

        /// <remarks />
        public const uint TrustListType_ActivityTimeout = 32254;

        /// <remarks />
        public const uint TrustListType_DefaultValidationOptions = 23563;

        /// <remarks />
        public const uint TrustListType_OpenWithMasks_InputArguments = 12544;

        /// <remarks />
        public const uint TrustListType_OpenWithMasks_OutputArguments = 12545;

        /// <remarks />
        public const uint TrustListType_CloseAndUpdate_InputArguments = 12705;

        /// <remarks />
        public const uint TrustListType_CloseAndUpdate_OutputArguments = 12547;

        /// <remarks />
        public const uint TrustListType_AddCertificate_InputArguments = 12549;

        /// <remarks />
        public const uint TrustListType_RemoveCertificate_InputArguments = 12551;

        /// <remarks />
        public const uint TrustListValidationOptions_OptionSetValues = 23565;

        /// <remarks />
        public const uint TrustListMasks_EnumValues = 12553;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_EnabledState_Id = 19315;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Quality_SourceTimestamp = 19324;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp = 19326;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Comment_SourceTimestamp = 19328;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_AddComment_InputArguments = 19333;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments = 19335;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments = 19337;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_AckedState_Id = 19339;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ConfirmedState_Id = 19348;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Acknowledge_InputArguments = 19357;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Confirm_InputArguments = 19359;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ActiveState_Id = 19361;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_SuppressedState_Id = 19371;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_OutOfServiceState_Id = 19380;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_CurrentState = 19389;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id = 19390;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id = 19395;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime = 19402;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments = 19404;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments = 24971;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments = 24973;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments = 24975;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_SilenceState_Id = 19415;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_LatchedState_Id = 19428;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Suppress2_InputArguments = 24509;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Unsuppress2_InputArguments = 24511;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments = 24513;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_PlaceInService2_InputArguments = 24515;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_Reset2_InputArguments = 24517;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments = 25176;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_TrustListId = 19446;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_LastUpdateTime = 19447;

        /// <remarks />
        public const uint TrustListOutOfDateAlarmType_UpdateFrequency = 19448;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Size = 13600;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Writable = 13601;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_UserWritable = 13602;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_OpenCount = 13603;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Open_InputArguments = 13606;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Open_OutputArguments = 13607;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Close_InputArguments = 13609;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Read_InputArguments = 13611;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Read_OutputArguments = 13612;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_Write_InputArguments = 13614;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_GetPosition_InputArguments = 13616;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_GetPosition_OutputArguments = 13617;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_SetPosition_InputArguments = 13619;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_LastUpdateTime = 13620;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_OpenWithMasks_InputArguments = 13622;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_OpenWithMasks_OutputArguments = 13623;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_CloseAndUpdate_InputArguments = 13625;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments = 13626;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_AddCertificate_InputArguments = 13628;

        /// <remarks />
        public const uint CertificateGroupType_TrustList_RemoveCertificate_InputArguments = 13630;

        /// <remarks />
        public const uint CertificateGroupType_CertificateTypes = 13631;

        /// <remarks />
        public const uint CertificateGroupType_GetRejectedList_OutputArguments = 23527;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_EventId = 19451;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_EventType = 19452;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_SourceNode = 19453;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_SourceName = 19454;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Time = 19455;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ReceiveTime = 19456;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Message = 19458;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Severity = 19459;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ConditionClassId = 19460;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ConditionClassName = 19461;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ConditionName = 19464;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_BranchId = 19465;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Retain = 19466;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_EnabledState = 19467;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_EnabledState_Id = 19468;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Quality = 19476;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Quality_SourceTimestamp = 19477;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_LastSeverity = 19478;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp = 19479;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Comment = 19480;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Comment_SourceTimestamp = 19481;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ClientUserId = 19482;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_AddComment_InputArguments = 19486;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_AckedState = 19487;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_AckedState_Id = 19488;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ConfirmedState_Id = 19497;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Acknowledge_InputArguments = 19506;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Confirm_InputArguments = 19508;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ActiveState = 19509;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ActiveState_Id = 19510;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_InputNode = 19518;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_SuppressedState_Id = 19520;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_OutOfServiceState_Id = 19529;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_CurrentState = 19538;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id = 19539;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id = 19544;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime = 20096;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20098;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 24979;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 24981;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 24983;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_SuppressedOrShelved = 20101;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_SilenceState_Id = 20109;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_LatchedState_Id = 20122;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Suppress2_InputArguments = 24519;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Unsuppress2_InputArguments = 24521;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_RemoveFromService2_InputArguments = 24523;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_PlaceInService2_InputArguments = 24525;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Reset2_InputArguments = 24527;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_GetGroupMemberships_OutputArguments = 25177;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_NormalState = 20138;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_ExpirationDate = 20139;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_CertificateType = 20141;

        /// <remarks />
        public const uint CertificateGroupType_CertificateExpired_Certificate = 20142;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_EventId = 20144;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_EventType = 20145;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_SourceNode = 20146;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_SourceName = 20147;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Time = 20148;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ReceiveTime = 20149;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Message = 20151;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Severity = 20152;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionClassId = 20153;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionClassName = 20154;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionName = 20157;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_BranchId = 20158;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Retain = 20159;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_EnabledState = 20160;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_EnabledState_Id = 20161;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Quality = 20169;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp = 20170;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_LastSeverity = 20171;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20172;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Comment = 20173;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp = 20174;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ClientUserId = 20175;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments = 20179;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_AckedState = 20180;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_AckedState_Id = 20181;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id = 20190;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments = 20199;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments = 20201;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ActiveState = 20202;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ActiveState_Id = 20203;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_InputNode = 20211;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_SuppressedState_Id = 20213;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id = 20222;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState = 20231;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20232;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20237;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime = 20244;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20246;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 24987;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 24989;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 24991;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved = 20249;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_SilenceState_Id = 20257;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_LatchedState_Id = 20270;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Suppress2_InputArguments = 24529;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Unsuppress2_InputArguments = 24531;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_RemoveFromService2_InputArguments = 24533;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_PlaceInService2_InputArguments = 24535;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_Reset2_InputArguments = 24537;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25178;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_NormalState = 20286;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_TrustListId = 20287;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_LastUpdateTime = 20288;

        /// <remarks />
        public const uint CertificateGroupType_TrustListOutOfDate_UpdateFrequency = 20289;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size = 13816;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable = 13817;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable = 13818;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount = 13819;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments = 13822;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments = 13823;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments = 13825;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments = 13827;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments = 13828;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments = 13830;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments = 13832;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments = 13833;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments = 13835;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime = 13836;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments = 13838;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments = 13839;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments = 13841;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments = 13842;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments = 13844;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments = 13846;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes = 13847;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments = 23530;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId = 20292;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType = 20293;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode = 20294;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName = 20295;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time = 20296;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime = 20297;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message = 20299;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity = 20300;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId = 20301;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName = 20302;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName = 20305;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId = 20306;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain = 20307;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState = 20308;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id = 20309;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality = 20317;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp = 20318;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity = 20319;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp = 20320;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment = 20321;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp = 20322;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId = 20323;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments = 20327;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState = 20328;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id = 20329;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id = 20338;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments = 20347;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments = 20349;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState = 20350;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id = 20351;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode = 20359;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id = 20361;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id = 20370;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState = 20379;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id = 20380;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id = 20385;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime = 20392;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20394;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 24995;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 24997;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 24999;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved = 20397;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id = 20405;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id = 20420;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments = 24539;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments = 24541;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments = 24543;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments = 24545;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments = 24547;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25179;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState = 20436;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate = 20437;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType = 20439;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate = 20440;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId = 20442;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType = 20443;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode = 20444;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName = 20445;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time = 20446;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime = 20447;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message = 20449;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity = 20450;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId = 20451;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName = 20452;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName = 20455;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId = 20456;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain = 20457;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState = 20458;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id = 20459;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality = 20467;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp = 20468;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity = 20469;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20470;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment = 20471;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp = 20472;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId = 20473;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments = 20477;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState = 20478;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id = 20479;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id = 20488;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments = 20497;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments = 20499;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState = 20500;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id = 20501;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode = 20509;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id = 20511;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id = 20520;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState = 20529;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20530;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20535;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 20542;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20544;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25003;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25005;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25007;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved = 20547;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id = 20555;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id = 20568;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments = 24549;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24551;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24553;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24555;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments = 24557;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25180;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState = 20584;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId = 20585;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime = 20586;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency = 20587;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size = 13850;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable = 13851;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable = 13852;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount = 13853;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments = 13856;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments = 13857;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments = 13859;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments = 13861;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments = 13862;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments = 13864;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments = 13866;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments = 13867;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments = 13869;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime = 13870;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments = 13872;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments = 13873;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments = 13875;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments = 13876;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments = 13878;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments = 13880;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes = 13881;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments = 23532;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId = 20590;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType = 20591;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode = 20592;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName = 20593;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time = 20594;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime = 20595;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message = 20597;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity = 20598;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId = 20599;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName = 20600;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName = 20603;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId = 20604;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain = 20605;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState = 20606;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id = 20607;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality = 20615;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp = 20616;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity = 20617;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp = 20618;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment = 20619;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp = 20620;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId = 20621;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments = 20625;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState = 20626;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id = 20627;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id = 20636;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments = 20645;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments = 20647;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState = 20648;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id = 20649;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode = 20657;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id = 20659;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id = 20668;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState = 20677;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id = 20678;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id = 20683;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime = 20690;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20692;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25011;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25013;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25015;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved = 20695;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id = 20703;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id = 20716;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments = 24559;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments = 24561;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments = 24563;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments = 24565;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments = 24567;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25181;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState = 20732;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate = 20733;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType = 20735;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate = 20736;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId = 20738;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType = 20739;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode = 20740;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName = 20741;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time = 20742;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime = 20743;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message = 20745;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity = 20746;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId = 20747;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName = 20748;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName = 20751;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId = 20752;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain = 20753;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState = 20754;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id = 20755;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality = 20763;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp = 20764;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity = 20765;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20766;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment = 20767;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp = 20768;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId = 20769;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments = 20773;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState = 20774;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id = 20775;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id = 20784;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments = 20793;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments = 20795;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState = 20796;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id = 20797;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode = 20805;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id = 20807;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id = 20816;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState = 20825;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20826;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20831;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 20838;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20840;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25019;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25021;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25023;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved = 20843;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id = 20851;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id = 20864;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments = 24569;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24571;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24573;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24575;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments = 24577;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25182;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState = 20880;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId = 20881;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime = 20882;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency = 20883;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size = 13884;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable = 13885;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable = 13886;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount = 13887;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments = 13890;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments = 13891;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments = 13893;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments = 13895;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments = 13896;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments = 13898;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments = 13900;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments = 13901;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments = 13903;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime = 13904;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments = 13906;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments = 13907;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments = 13909;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments = 13910;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments = 13912;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments = 13914;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes = 13915;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList_OutputArguments = 23534;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId = 20886;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType = 20887;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode = 20888;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName = 20889;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time = 20890;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime = 20891;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message = 20893;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity = 20894;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId = 20895;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName = 20896;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName = 20899;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId = 20900;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain = 20901;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState = 20902;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id = 20903;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality = 20911;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp = 20912;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity = 20913;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp = 20914;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment = 20915;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp = 20916;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId = 20917;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments = 20921;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState = 20922;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id = 20923;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id = 20932;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments = 20941;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments = 20943;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState = 20944;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id = 20945;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode = 20953;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id = 20955;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id = 20964;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState = 20973;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id = 20974;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id = 20979;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime = 20986;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20988;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25027;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25029;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25031;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved = 20991;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id = 21008;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id = 21215;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments = 24579;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments = 24581;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments = 24583;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments = 24585;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments = 24587;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25183;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState = 21231;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate = 21232;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType = 21234;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate = 21235;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId = 21237;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType = 21238;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode = 21239;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName = 21240;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time = 21241;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime = 21242;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message = 21244;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity = 21245;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId = 21246;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName = 21247;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName = 21250;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId = 21251;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain = 21252;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState = 21253;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id = 21254;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality = 21262;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp = 21263;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity = 21264;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 21265;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment = 21266;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp = 21267;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId = 21268;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments = 21272;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState = 21273;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id = 21274;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id = 21283;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments = 21292;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments = 21294;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState = 21295;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id = 21296;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode = 21304;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id = 21306;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id = 21315;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState = 21324;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 21325;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 21330;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 21337;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 21339;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25035;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25037;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25039;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved = 21342;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id = 21350;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id = 21363;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments = 24589;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24591;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24593;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24595;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments = 24597;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25184;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState = 21379;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId = 21380;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime = 21381;

        /// <remarks />
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency = 21382;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size = 13918;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable = 13919;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable = 13920;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount = 13921;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments = 13924;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments = 13925;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments = 13927;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments = 13929;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments = 13930;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments = 13932;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments = 13934;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments = 13935;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments = 13937;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime = 13938;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments = 13940;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments = 13941;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments = 13943;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments = 13944;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments = 13946;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments = 13948;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes = 13949;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList_OutputArguments = 23536;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId = 21385;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType = 21386;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode = 21387;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName = 21388;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time = 21389;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime = 21390;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message = 21392;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity = 21393;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId = 21394;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName = 21395;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName = 21398;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId = 21399;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain = 21400;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState = 21401;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id = 21402;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality = 21410;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp = 21411;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity = 21412;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp = 21413;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment = 21414;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp = 21415;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId = 21416;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments = 21420;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState = 21421;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id = 21422;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id = 21431;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments = 21440;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments = 21442;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState = 21443;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id = 21444;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode = 21452;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id = 21454;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id = 21463;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState = 21472;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id = 21473;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id = 21478;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime = 21485;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 21487;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25043;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25045;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25047;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved = 21490;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id = 21498;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id = 21511;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2_InputArguments = 24599;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2_InputArguments = 24601;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2_InputArguments = 24603;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2_InputArguments = 24605;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2_InputArguments = 24607;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships_OutputArguments = 25185;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState = 21527;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate = 21528;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType = 21530;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate = 21531;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId = 21533;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType = 21534;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode = 21535;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName = 21536;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time = 21537;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime = 21538;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message = 21540;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity = 21541;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId = 21542;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName = 21543;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName = 21546;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId = 21547;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain = 21548;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState = 21549;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id = 21550;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality = 21558;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp = 21559;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity = 21560;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp = 21561;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment = 21562;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp = 21563;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId = 21564;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments = 21568;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState = 21569;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id = 21570;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id = 21579;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments = 21588;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments = 21590;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState = 21591;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id = 21592;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode = 21600;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id = 21602;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id = 21611;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState = 21620;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id = 21621;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id = 21626;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime = 21633;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 21635;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25051;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25053;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25055;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved = 21638;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id = 21646;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id = 21659;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2_InputArguments = 24609;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2_InputArguments = 24611;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2_InputArguments = 24613;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2_InputArguments = 24615;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2_InputArguments = 24617;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25186;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState = 21675;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId = 21676;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime = 21677;

        /// <remarks />
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency = 21678;

        /// <remarks />
        public const uint TrustListUpdatedAuditEventType_TrustListId = 32281;

        /// <remarks />
        public const uint TransactionDiagnosticsType_StartTime = 32287;

        /// <remarks />
        public const uint TransactionDiagnosticsType_EndTime = 32288;

        /// <remarks />
        public const uint TransactionDiagnosticsType_Result = 32289;

        /// <remarks />
        public const uint TransactionDiagnosticsType_AffectedTrustLists = 32290;

        /// <remarks />
        public const uint TransactionDiagnosticsType_AffectedCertificateGroups = 32291;

        /// <remarks />
        public const uint TransactionDiagnosticsType_Errors = 32292;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size = 13953;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable = 13954;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable = 13955;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount = 13956;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments = 13959;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments = 13960;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments = 13962;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments = 13964;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments = 13965;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments = 13967;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments = 13969;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments = 13970;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments = 13972;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime = 13973;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments = 13975;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments = 13976;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments = 13978;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments = 13979;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments = 13981;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments = 13983;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes = 13984;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments = 23545;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId = 21681;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType = 21682;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode = 21683;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName = 21684;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time = 21685;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime = 21686;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message = 21688;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity = 21689;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId = 21690;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName = 21691;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName = 21694;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId = 21695;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain = 21696;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState = 21697;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id = 21698;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality = 21706;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp = 21707;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity = 21708;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp = 21709;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment = 21710;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp = 21711;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId = 21712;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments = 21716;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState = 21717;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id = 21718;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id = 21727;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments = 21736;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments = 21738;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState = 21739;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id = 21740;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode = 21748;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id = 21750;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id = 21759;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState = 21768;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id = 21769;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id = 21774;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime = 21781;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 21783;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25059;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25061;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25063;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved = 21786;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id = 21794;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id = 21807;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments = 24619;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments = 24621;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments = 24623;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments = 24625;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments = 24627;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25187;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState = 21823;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate = 21824;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType = 21826;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate = 21827;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId = 21829;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType = 21830;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode = 21831;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName = 21832;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time = 21833;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime = 21834;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message = 21836;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity = 21837;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId = 21838;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName = 21839;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName = 21842;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId = 21843;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain = 21844;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState = 21845;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id = 21846;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality = 21854;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp = 21855;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity = 21856;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 21857;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment = 21858;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp = 21859;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId = 21860;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments = 21864;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState = 21865;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id = 21866;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id = 21875;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments = 21884;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments = 21886;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState = 21887;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id = 21888;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode = 21896;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id = 21898;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id = 21907;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState = 21916;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 21917;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 21922;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 21929;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 21931;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25067;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25069;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25071;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved = 21934;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id = 21942;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id = 21955;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments = 24629;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24631;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24633;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24635;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments = 24637;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25188;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState = 21971;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId = 21972;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime = 21973;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency = 21974;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size = 13987;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable = 13988;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable = 13989;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount = 13990;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments = 13993;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments = 13994;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments = 13996;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments = 13998;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments = 13999;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments = 14001;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments = 14003;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments = 14004;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments = 14006;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime = 14007;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments = 14009;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments = 14010;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments = 14012;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments = 14013;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments = 14015;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments = 14017;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes = 14018;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments = 23547;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId = 21977;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType = 21978;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode = 21979;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName = 21980;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time = 21981;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime = 21982;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message = 21984;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity = 21985;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId = 21986;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName = 21987;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName = 21990;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId = 21991;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain = 21992;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState = 21993;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id = 21994;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality = 22002;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp = 22003;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity = 22004;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp = 22005;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment = 22006;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp = 22007;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId = 22008;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments = 22012;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState = 22013;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id = 22014;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id = 22023;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments = 22032;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments = 22034;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState = 22035;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id = 22036;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode = 22044;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id = 22046;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id = 22055;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState = 22064;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id = 22065;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id = 22070;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime = 22077;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 22079;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25075;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25077;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25079;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved = 22082;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id = 22090;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id = 22103;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments = 24639;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments = 24641;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments = 24643;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments = 24645;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments = 24647;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25189;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState = 22119;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate = 22120;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType = 22122;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate = 22123;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId = 22125;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType = 22126;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode = 22127;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName = 22128;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time = 22129;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime = 22130;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message = 22132;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity = 22133;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId = 22134;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName = 22135;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName = 22138;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId = 22139;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain = 22140;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState = 22141;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id = 22142;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality = 22150;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp = 22151;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity = 22152;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 22153;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment = 22154;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp = 22155;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId = 22156;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments = 22160;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState = 22161;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id = 22162;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id = 22171;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments = 22180;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments = 22182;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState = 22183;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id = 22184;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode = 22192;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id = 22194;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id = 22203;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState = 22212;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 22213;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 22218;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 22225;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 22227;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25083;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25085;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25087;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved = 22230;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id = 22238;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id = 22251;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments = 24649;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24651;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24653;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24655;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments = 24657;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25190;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState = 22267;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId = 22268;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime = 22269;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency = 22270;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size = 14021;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable = 14022;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable = 14023;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount = 14024;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments = 14027;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments = 14028;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments = 14030;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments = 14032;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments = 14033;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments = 14035;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments = 14037;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments = 14038;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments = 14040;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime = 14041;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments = 14043;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments = 14044;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments = 14046;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments = 14047;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments = 14049;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments = 14051;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes = 14052;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments = 23549;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId = 22273;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType = 22274;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode = 22275;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName = 22276;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time = 22277;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime = 22278;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message = 22280;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity = 22281;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId = 22282;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName = 22283;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName = 22286;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId = 22287;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain = 22288;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState = 22289;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id = 22290;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality = 22298;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp = 22299;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity = 22300;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp = 22301;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment = 22302;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp = 22303;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId = 22304;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments = 22308;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState = 22309;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id = 22310;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id = 22319;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments = 22328;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments = 22330;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState = 22331;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id = 22332;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode = 22340;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id = 22342;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id = 22351;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState = 22360;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id = 22361;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id = 22366;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime = 22373;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 22375;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25091;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25093;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25095;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved = 22378;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id = 22386;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id = 22399;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments = 24659;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments = 24661;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments = 24663;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments = 24665;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments = 24667;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25191;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState = 22415;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate = 22416;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType = 22418;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate = 22419;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId = 22421;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType = 22422;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode = 22423;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName = 22424;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time = 22425;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime = 22426;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message = 22428;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity = 22429;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId = 22430;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName = 22431;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName = 22434;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId = 22435;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain = 22436;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState = 22437;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id = 22438;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality = 22446;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp = 22447;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity = 22448;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 22449;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment = 22450;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp = 22451;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId = 22452;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments = 22456;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState = 22457;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id = 22458;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id = 22467;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments = 22476;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments = 22478;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState = 22479;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id = 22480;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode = 22488;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id = 22490;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id = 22499;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState = 22508;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 22509;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 22514;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 22521;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 22523;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25099;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25101;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25103;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved = 22526;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id = 22534;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id = 22547;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments = 24669;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24671;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24673;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24675;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments = 24677;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25192;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState = 22563;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId = 22564;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime = 22565;

        /// <remarks />
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency = 22566;

        /// <remarks />
        public const uint ServerConfigurationType_ApplicationUri = 25696;

        /// <remarks />
        public const uint ServerConfigurationType_ProductUri = 25724;

        /// <remarks />
        public const uint ServerConfigurationType_ApplicationType = 25697;

        /// <remarks />
        public const uint ServerConfigurationType_ServerCapabilities = 12708;

        /// <remarks />
        public const uint ServerConfigurationType_SupportedPrivateKeyFormats = 12583;

        /// <remarks />
        public const uint ServerConfigurationType_MaxTrustListSize = 12584;

        /// <remarks />
        public const uint ServerConfigurationType_MulticastDnsEnabled = 12585;

        /// <remarks />
        public const uint ServerConfigurationType_HasSecureElement = 23593;

        /// <remarks />
        public const uint ServerConfigurationType_UpdateCertificate_InputArguments = 12617;

        /// <remarks />
        public const uint ServerConfigurationType_UpdateCertificate_OutputArguments = 12618;

        /// <remarks />
        public const uint ServerConfigurationType_GetCertificates_InputArguments = 32297;

        /// <remarks />
        public const uint ServerConfigurationType_GetCertificates_OutputArguments = 32298;

        /// <remarks />
        public const uint ServerConfigurationType_CreateSigningRequest_InputArguments = 12732;

        /// <remarks />
        public const uint ServerConfigurationType_CreateSigningRequest_OutputArguments = 12733;

        /// <remarks />
        public const uint ServerConfigurationType_GetRejectedList_OutputArguments = 12776;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_StartTime = 32300;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_EndTime = 32301;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_Result = 32302;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_AffectedTrustLists = 32303;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_AffectedCertificateGroups = 32304;

        /// <remarks />
        public const uint ServerConfigurationType_TransactionDiagnostics_Errors = 32305;

        /// <remarks />
        public const uint CertificateUpdatedAuditEventType_CertificateGroup = 13735;

        /// <remarks />
        public const uint CertificateUpdatedAuditEventType_CertificateType = 13736;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size = 12643;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable = 14157;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable = 14158;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount = 12646;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments = 12648;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments = 12649;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments = 12651;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments = 12653;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments = 12654;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments = 12656;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments = 12658;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments = 12659;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments = 12661;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime = 12662;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments = 12664;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments = 12665;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments = 14160;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments = 12667;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments = 12669;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments = 12671;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes = 14161;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments = 23551;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId = 22569;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType = 22570;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode = 22571;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName = 22572;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time = 22573;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime = 22574;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message = 22576;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity = 22577;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId = 22578;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName = 22579;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName = 22582;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId = 22583;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain = 22584;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState = 22585;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id = 22586;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality = 22594;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp = 22595;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity = 22596;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp = 22597;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment = 22598;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp = 22599;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId = 22600;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments = 22604;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState = 22605;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id = 22606;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id = 22615;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments = 22624;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments = 22626;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState = 22627;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id = 22628;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode = 22636;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id = 22638;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id = 22647;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState = 22656;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id = 22657;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id = 22662;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime = 22669;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 22671;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25107;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25109;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25111;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved = 22674;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id = 22682;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id = 22695;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments = 24679;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments = 24681;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments = 24683;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments = 24685;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments = 24687;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25193;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState = 22711;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate = 22712;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType = 22714;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate = 22715;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId = 22717;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType = 22718;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode = 22719;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName = 22720;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time = 22721;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime = 22722;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message = 22724;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity = 22725;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId = 22726;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName = 22727;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName = 22730;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId = 22731;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain = 22732;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState = 22733;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id = 22734;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality = 22742;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp = 22743;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity = 22744;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 22745;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment = 22746;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp = 22747;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId = 22748;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments = 22752;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState = 22753;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id = 22754;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id = 22763;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments = 22772;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments = 22774;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState = 22775;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id = 22776;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode = 22784;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id = 22786;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id = 22795;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState = 22804;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 22805;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 22810;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 22817;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 22819;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25115;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25117;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25119;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved = 22822;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id = 22830;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id = 22843;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments = 24689;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24691;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24693;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24695;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments = 24697;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25194;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState = 22859;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId = 22860;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime = 22861;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency = 22862;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size = 14090;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable = 14091;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable = 14092;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount = 14093;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments = 14096;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments = 14097;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments = 14099;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments = 14101;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments = 14102;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments = 14104;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments = 14106;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments = 14107;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments = 14109;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime = 14110;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments = 14112;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments = 14113;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments = 14115;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments = 14116;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments = 14118;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments = 14120;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes = 14121;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments = 23553;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId = 22865;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType = 22866;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode = 22867;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName = 22868;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time = 22869;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime = 22870;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message = 22872;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity = 22873;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId = 22874;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName = 22875;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName = 22878;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId = 22879;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain = 22880;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState = 22881;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id = 22882;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality = 22890;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp = 22891;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity = 22892;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp = 22893;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment = 22894;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp = 22895;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId = 22896;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments = 22900;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState = 22901;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id = 22902;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id = 22911;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments = 22920;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments = 22922;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState = 22923;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id = 22924;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode = 22932;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id = 22934;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id = 22943;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState = 22952;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id = 22953;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id = 22958;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime = 22965;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 22967;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25123;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25125;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25127;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved = 22970;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id = 22978;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id = 22991;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments = 24699;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments = 24701;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments = 24703;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments = 24705;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments = 24707;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25195;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState = 23007;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate = 23008;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType = 23010;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate = 23011;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId = 23013;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType = 23014;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode = 23015;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName = 23016;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time = 23017;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime = 23018;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message = 23020;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity = 23021;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId = 23022;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName = 23023;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName = 23026;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId = 23027;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain = 23028;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState = 23029;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id = 23030;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality = 23038;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp = 23039;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity = 23040;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 23041;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment = 23042;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp = 23043;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId = 23044;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments = 23048;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState = 23049;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id = 23050;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id = 23059;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments = 23068;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments = 23070;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState = 23071;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id = 23072;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode = 23080;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id = 23082;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id = 23091;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState = 23100;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 23101;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 23106;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 23113;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 23115;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25131;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25133;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25135;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved = 23118;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id = 23126;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id = 23139;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments = 24709;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24711;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24713;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24715;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments = 24717;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25196;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState = 23155;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId = 23156;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime = 23157;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency = 23158;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size = 14124;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable = 14125;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable = 14126;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount = 14127;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments = 14130;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments = 14131;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments = 14133;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments = 14135;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments = 14136;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments = 14138;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments = 14140;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments = 14141;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments = 14143;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime = 14144;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments = 14146;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments = 14147;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments = 14149;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments = 14150;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments = 14152;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments = 14154;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes = 14155;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments = 23555;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId = 23161;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType = 23162;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode = 23163;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName = 23164;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time = 23165;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime = 23166;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message = 23168;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity = 23169;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId = 23170;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName = 23171;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName = 23174;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId = 23175;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain = 23176;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState = 23177;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id = 23178;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality = 23186;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp = 23187;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity = 23188;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp = 23189;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment = 23190;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp = 23191;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId = 23192;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments = 23196;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState = 23197;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id = 23198;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id = 23207;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments = 23216;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments = 23218;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState = 23219;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id = 23220;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode = 23228;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id = 23230;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id = 23239;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState = 23248;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id = 23249;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id = 23254;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime = 23261;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 23263;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments = 25139;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments = 25141;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments = 25143;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved = 23266;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id = 23274;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id = 23287;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments = 24719;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments = 24721;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments = 24723;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments = 24725;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments = 24727;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments = 25197;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState = 23303;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate = 23304;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType = 23306;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate = 23307;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId = 23309;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType = 23310;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode = 23311;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName = 23312;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time = 23313;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime = 23314;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message = 23316;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity = 23317;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId = 23318;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName = 23319;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName = 23322;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId = 23323;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain = 23324;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState = 23325;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id = 23326;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality = 23334;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp = 23335;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity = 23336;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 23337;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment = 23338;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp = 23339;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId = 23340;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments = 23344;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState = 23345;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id = 23346;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id = 23355;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments = 23364;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments = 23366;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState = 23367;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id = 23368;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode = 23376;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id = 23378;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id = 23387;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState = 23396;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 23397;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 23402;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 23409;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 23411;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments = 25147;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments = 25149;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments = 25151;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved = 23414;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id = 23422;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id = 23435;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments = 24729;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments = 24731;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments = 24733;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments = 24735;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments = 24737;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments = 25198;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState = 23451;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId = 23452;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime = 23453;

        /// <remarks />
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency = 23454;

        /// <remarks />
        public const uint ServerConfiguration_ApplicationUri = 25706;

        /// <remarks />
        public const uint ServerConfiguration_ProductUri = 25725;

        /// <remarks />
        public const uint ServerConfiguration_ApplicationType = 25707;

        /// <remarks />
        public const uint ServerConfiguration_ServerCapabilities = 12710;

        /// <remarks />
        public const uint ServerConfiguration_SupportedPrivateKeyFormats = 12639;

        /// <remarks />
        public const uint ServerConfiguration_MaxTrustListSize = 12640;

        /// <remarks />
        public const uint ServerConfiguration_MulticastDnsEnabled = 12641;

        /// <remarks />
        public const uint ServerConfiguration_HasSecureElement = 23597;

        /// <remarks />
        public const uint ServerConfiguration_UpdateCertificate_InputArguments = 13738;

        /// <remarks />
        public const uint ServerConfiguration_UpdateCertificate_OutputArguments = 13739;

        /// <remarks />
        public const uint ServerConfiguration_GetCertificates_InputArguments = 32334;

        /// <remarks />
        public const uint ServerConfiguration_GetCertificates_OutputArguments = 32335;

        /// <remarks />
        public const uint ServerConfiguration_CreateSigningRequest_InputArguments = 12738;

        /// <remarks />
        public const uint ServerConfiguration_CreateSigningRequest_OutputArguments = 12739;

        /// <remarks />
        public const uint ServerConfiguration_GetRejectedList_OutputArguments = 12778;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_StartTime = 32337;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_EndTime = 32338;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_Result = 32339;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_AffectedTrustLists = 32340;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_AffectedCertificateGroups = 32341;

        /// <remarks />
        public const uint ServerConfiguration_TransactionDiagnostics_Errors = 32342;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ResourceUri = 17512;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ProfileUri = 17513;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_InputArguments = 17517;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_OutputArguments = 17518;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential_InputArguments = 17520;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_CreateCredential_InputArguments = 17523;

        /// <remarks />
        public const uint KeyCredentialConfigurationFolderType_CreateCredential_OutputArguments = 17524;

        /// <remarks />
        public const uint KeyCredentialConfiguration_ServiceName_Placeholder_ResourceUri = 18157;

        /// <remarks />
        public const uint KeyCredentialConfiguration_ServiceName_Placeholder_ProfileUri = 18164;

        /// <remarks />
        public const uint KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_InputArguments = 17526;

        /// <remarks />
        public const uint KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_OutputArguments = 17527;

        /// <remarks />
        public const uint KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential_InputArguments = 18162;

        /// <remarks />
        public const uint KeyCredentialConfiguration_CreateCredential_InputArguments = 17529;

        /// <remarks />
        public const uint KeyCredentialConfiguration_CreateCredential_OutputArguments = 17530;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_ResourceUri = 18069;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_ProfileUri = 18165;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_EndpointUrls = 18004;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_ServiceStatus = 18005;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_GetEncryptingKey_InputArguments = 17535;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_GetEncryptingKey_OutputArguments = 17536;

        /// <remarks />
        public const uint KeyCredentialConfigurationType_UpdateCredential_InputArguments = 18007;

        /// <remarks />
        public const uint KeyCredentialAuditEventType_ResourceUri = 18028;

        /// <remarks />
        public const uint KeyCredentialDeletedAuditEventType_ResourceUri = 18064;

        /// <remarks />
        public const uint AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_ServiceUri = 23558;

        /// <remarks />
        public const uint AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_ServiceCertificate = 23559;

        /// <remarks />
        public const uint AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_IssuerEndpointUrl = 23560;

        /// <remarks />
        public const uint AuthorizationServiceConfigurationType_ServiceUri = 18072;

        /// <remarks />
        public const uint AuthorizationServiceConfigurationType_ServiceCertificate = 17860;

        /// <remarks />
        public const uint AuthorizationServiceConfigurationType_IssuerEndpointUrl = 18073;

        /// <remarks />
        public const uint AggregateConfigurationType_TreatUncertainAsBad = 11188;

        /// <remarks />
        public const uint AggregateConfigurationType_PercentDataBad = 11189;

        /// <remarks />
        public const uint AggregateConfigurationType_PercentDataGood = 11190;

        /// <remarks />
        public const uint AggregateConfigurationType_UseSlopedExtrapolation = 11191;

        /// <remarks />
        public const uint PubSubState_EnumStrings = 14648;

        /// <remarks />
        public const uint DataSetFieldFlags_OptionSetValues = 15577;

        /// <remarks />
        public const uint DataSetFieldContentMask_OptionSetValues = 15584;

        /// <remarks />
        public const uint OverrideValueHandling_EnumStrings = 15875;

        /// <remarks />
        public const uint DataSetOrderingType_EnumStrings = 15641;

        /// <remarks />
        public const uint UadpNetworkMessageContentMask_OptionSetValues = 15643;

        /// <remarks />
        public const uint UadpDataSetMessageContentMask_OptionSetValues = 15647;

        /// <remarks />
        public const uint JsonNetworkMessageContentMask_OptionSetValues = 15655;

        /// <remarks />
        public const uint JsonDataSetMessageContentMask_OptionSetValues = 15659;

        /// <remarks />
        public const uint BrokerTransportQualityOfService_EnumStrings = 15009;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityKeys_InputArguments = 15908;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityKeys_OutputArguments = 15909;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityGroup_InputArguments = 15911;

        /// <remarks />
        public const uint PubSubKeyServiceType_GetSecurityGroup_OutputArguments = 15912;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments = 15915;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments = 15916;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments = 15918;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments = 25272;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments = 25273;

        /// <remarks />
        public const uint PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments = 25275;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments = 25279;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments = 25280;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments = 25282;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments = 25284;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments = 25285;

        /// <remarks />
        public const uint PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments = 25287;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments = 15455;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments = 15456;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments = 15458;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments = 25294;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments = 25295;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments = 25297;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris = 25298;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId = 15460;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime = 15010;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri = 15011;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount = 15012;

        /// <remarks />
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount = 15043;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroup_InputArguments = 15462;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroup_OutputArguments = 15463;

        /// <remarks />
        public const uint SecurityGroupFolderType_RemoveSecurityGroup_InputArguments = 15465;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments = 25313;

        /// <remarks />
        public const uint SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments = 25314;

        /// <remarks />
        public const uint SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments = 25316;

        /// <remarks />
        public const uint SecurityGroupFolderType_SupportedSecurityPolicyUris = 25317;

        /// <remarks />
        public const uint SecurityGroupType_SecurityGroupId = 15472;

        /// <remarks />
        public const uint SecurityGroupType_KeyLifetime = 15046;

        /// <remarks />
        public const uint SecurityGroupType_SecurityPolicyUri = 15047;

        /// <remarks />
        public const uint SecurityGroupType_MaxFutureKeyCount = 15048;

        /// <remarks />
        public const uint SecurityGroupType_MaxPastKeyCount = 15056;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId = 25627;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime = 25628;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri = 25629;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount = 25630;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount = 25631;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_ApplicationUri = 25634;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_EndpointUrl = 25635;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_SecurityPolicyUri = 25340;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_UserTokenType = 25636;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_RequestedKeyCount = 25637;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_RetryInterval = 25638;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_LastPushExecutionTime = 25639;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_LastPushErrorTime = 25640;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments = 25642;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments = 25643;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments = 25645;

        /// <remarks />
        public const uint PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments = 25646;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments = 25349;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments = 25350;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments = 25352;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments = 25354;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments = 25355;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments = 25357;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri = 25648;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl = 25649;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri = 25361;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType = 25650;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount = 25651;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval = 25652;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime = 25653;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime = 25654;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments = 25656;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments = 25657;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments = 25659;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments = 25660;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments = 25367;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments = 25368;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments = 25370;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments = 25372;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments = 25373;

        /// <remarks />
        public const uint PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments = 25375;

        /// <remarks />
        public const uint PublishSubscribeType_GetSecurityKeys_InputArguments = 15213;

        /// <remarks />
        public const uint PublishSubscribeType_GetSecurityKeys_OutputArguments = 15214;

        /// <remarks />
        public const uint PublishSubscribeType_GetSecurityGroup_InputArguments = 15432;

        /// <remarks />
        public const uint PublishSubscribeType_GetSecurityGroup_OutputArguments = 15433;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments = 15436;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments = 15437;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments = 15439;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments = 25387;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments = 25388;

        /// <remarks />
        public const uint PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments = 25390;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments = 25394;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments = 25395;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments = 25397;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments = 25399;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments = 25400;

        /// <remarks />
        public const uint PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments = 25402;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_PublisherId = 14418;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri = 17292;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections = 17706;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties = 17478;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface = 15533;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections = 17503;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Status_State = 14420;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel = 18668;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation = 18669;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active = 18670;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification = 18671;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 18672;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError = 18674;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active = 18675;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification = 18676;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 18677;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError = 18680;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError = 18682;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active = 18683;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification = 18684;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 18685;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 18687;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 18688;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 18689;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 18690;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 18692;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 18693;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 18694;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 18695;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 18697;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 18698;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 18699;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 18700;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent = 18702;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 18703;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 18704;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 18705;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 18707;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 18708;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 18709;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 18710;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress = 18713;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel = 18714;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments = 16558;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments = 16559;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments = 16561;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments = 16571;

        /// <remarks />
        public const uint PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments = 14425;

        /// <remarks />
        public const uint PublishSubscribeType_SetSecurityKeys_InputArguments = 17297;

        /// <remarks />
        public const uint PublishSubscribeType_AddConnection_InputArguments = 16599;

        /// <remarks />
        public const uint PublishSubscribeType_AddConnection_OutputArguments = 16600;

        /// <remarks />
        public const uint PublishSubscribeType_RemoveConnection_InputArguments = 14433;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments = 14436;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments = 14437;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments = 14439;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments = 14440;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments = 16611;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments = 16638;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments = 16640;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments = 16641;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments = 14442;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments = 16678;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments = 16679;

        /// <remarks />
        public const uint PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments = 16681;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments = 24005;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments = 24006;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments = 24008;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments = 23638;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments = 23639;

        /// <remarks />
        public const uint PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments = 23641;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Size = 25404;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Writable = 25405;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_UserWritable = 25406;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_OpenCount = 25407;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Open_InputArguments = 25412;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Open_OutputArguments = 25413;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Close_InputArguments = 25415;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Read_InputArguments = 25417;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Read_OutputArguments = 25418;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_Write_InputArguments = 25420;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments = 25422;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments = 25423;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments = 25425;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments = 25427;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments = 25428;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments = 25430;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments = 25431;

        /// <remarks />
        public const uint PublishSubscribeType_Status_State = 15845;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_DiagnosticsLevel = 18716;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalInformation = 18717;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalInformation_Active = 18718;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalInformation_Classification = 18719;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel = 18720;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalError = 18722;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalError_Active = 18723;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalError_Classification = 18724;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel = 18725;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_SubError = 18728;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateError = 18730;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateError_Active = 18731;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateError_Classification = 18732;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel = 18733;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod = 18735;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active = 18736;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification = 18737;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 18738;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent = 18740;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active = 18741;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification = 18742;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 18743;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError = 18745;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active = 18746;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification = 18747;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 18748;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StatePausedByParent = 18750;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active = 18751;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification = 18752;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 18753;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod = 18755;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active = 18756;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification = 18757;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 18758;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters = 18761;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 18762;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders = 18763;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 18764;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters = 18765;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 18766;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders = 18767;

        /// <remarks />
        public const uint PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 18768;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxPubSubConnections = 23643;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxWriterGroups = 23644;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxReaderGroups = 23645;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxDataSetWriters = 23646;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxDataSetReaders = 23647;

        /// <remarks />
        public const uint PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet = 23648;

        /// <remarks />
        public const uint PublishSubscribeType_DataSetClasses_DataSetName_Placeholder = 24009;

        /// <remarks />
        public const uint PublishSubscribeType_SupportedTransportProfiles = 17479;

        /// <remarks />
        public const uint PublishSubscribeType_DefaultDatagramPublisherId = 25432;

        /// <remarks />
        public const uint PublishSubscribeType_ConfigurationVersion = 25433;

        /// <remarks />
        public const uint PublishSubscribeType_DefaultSecurityKeyServices = 32396;

        /// <remarks />
        public const uint PublishSubscribeType_ConfigurationProperties = 32397;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityKeys_InputArguments = 15216;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityKeys_OutputArguments = 15217;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityGroup_InputArguments = 15441;

        /// <remarks />
        public const uint PublishSubscribe_GetSecurityGroup_OutputArguments = 15442;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments = 15445;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments = 15446;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments = 15448;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments = 25435;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments = 25436;

        /// <remarks />
        public const uint PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments = 25438;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments = 25442;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments = 25443;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments = 25445;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments = 25447;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments = 25448;

        /// <remarks />
        public const uint PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments = 25450;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_PublisherId = 15791;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri = 15792;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections = 15848;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties = 17480;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface = 15863;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections = 17506;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Status_State = 15892;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel = 15938;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation = 15939;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active = 15989;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification = 15994;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 16013;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError = 16059;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active = 16060;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification = 16061;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 16074;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError = 16101;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError = 16103;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active = 16122;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification = 16123;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 16124;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 16283;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 16322;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 16523;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 17300;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 17304;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 17305;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 17320;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 17335;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 17337;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 17338;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 17339;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 17340;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent = 17342;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 17343;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 17344;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 17345;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 17347;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 17348;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 17349;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 17350;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress = 17353;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel = 17354;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments = 17357;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments = 17358;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments = 17360;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments = 17361;

        /// <remarks />
        public const uint PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments = 17363;

        /// <remarks />
        public const uint PublishSubscribe_SetSecurityKeys_InputArguments = 17365;

        /// <remarks />
        public const uint PublishSubscribe_AddConnection_InputArguments = 17367;

        /// <remarks />
        public const uint PublishSubscribe_AddConnection_OutputArguments = 17368;

        /// <remarks />
        public const uint PublishSubscribe_RemoveConnection_InputArguments = 17370;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments = 17373;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments = 17374;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments = 17376;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments = 17377;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments = 17379;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments = 17380;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments = 17382;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments = 17383;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments = 17385;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments = 17401;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments = 17402;

        /// <remarks />
        public const uint PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments = 17404;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments = 24011;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments = 24012;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments = 24014;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments = 23674;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments = 23675;

        /// <remarks />
        public const uint PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments = 23677;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Size = 25452;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Writable = 25453;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_UserWritable = 25454;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_OpenCount = 25455;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Open_InputArguments = 25460;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Open_OutputArguments = 25461;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Close_InputArguments = 25463;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Read_InputArguments = 25465;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Read_OutputArguments = 25466;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_Write_InputArguments = 25468;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments = 25470;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments = 25471;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments = 25473;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments = 25475;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments = 25476;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments = 25478;

        /// <remarks />
        public const uint PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments = 25479;

        /// <remarks />
        public const uint PublishSubscribe_Status_State = 17406;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_DiagnosticsLevel = 17410;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalInformation = 17411;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalInformation_Active = 17412;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalInformation_Classification = 17413;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel = 17414;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalError = 17416;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalError_Active = 17417;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalError_Classification = 17418;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel = 17419;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_SubError = 17422;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateError = 17424;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateError_Active = 17425;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateError_Classification = 17426;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel = 17429;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod = 17431;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active = 17432;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification = 17433;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 17434;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByParent = 17436;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active = 17437;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification = 17438;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 17439;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalFromError = 17441;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active = 17442;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification = 17443;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 17444;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StatePausedByParent = 17446;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active = 17447;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification = 17448;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 17449;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod = 17451;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active = 17452;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification = 17453;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 17454;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters = 17458;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 17459;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders = 17460;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 17461;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters = 17462;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 17463;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders = 17464;

        /// <remarks />
        public const uint PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 17466;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxPubSubConnections = 23679;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxWriterGroups = 23680;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxReaderGroups = 23681;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxDataSetWriters = 23682;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxDataSetReaders = 23683;

        /// <remarks />
        public const uint PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet = 23684;

        /// <remarks />
        public const uint PublishSubscribe_SupportedTransportProfiles = 17481;

        /// <remarks />
        public const uint PublishSubscribe_DefaultDatagramPublisherId = 25480;

        /// <remarks />
        public const uint PublishSubscribe_ConfigurationVersion = 25481;

        /// <remarks />
        public const uint PublishSubscribe_DefaultSecurityKeyServices = 32403;

        /// <remarks />
        public const uint PublishSubscribe_ConfigurationProperties = 32404;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityKeys_InputArguments = 32407;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityKeys_OutputArguments = 32408;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityGroup_InputArguments = 32410;

        /// <remarks />
        public const uint DataSetClasses_GetSecurityGroup_OutputArguments = 32411;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_AddSecurityGroup_InputArguments = 32414;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_AddSecurityGroup_OutputArguments = 32415;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_RemoveSecurityGroup_InputArguments = 32417;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_AddSecurityGroupFolder_InputArguments = 32419;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_AddSecurityGroupFolder_OutputArguments = 32420;

        /// <remarks />
        public const uint DataSetClasses_SecurityGroups_RemoveSecurityGroupFolder_InputArguments = 32422;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_AddPushTarget_InputArguments = 32426;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_AddPushTarget_OutputArguments = 32427;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_RemovePushTarget_InputArguments = 32429;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_AddPushTargetFolder_InputArguments = 32431;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_AddPushTargetFolder_OutputArguments = 32432;

        /// <remarks />
        public const uint DataSetClasses_KeyPushTargets_RemovePushTargetFolder_InputArguments = 32434;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_PublisherId = 32436;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_TransportProfileUri = 32437;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_TransportProfileUri_Selections = 32438;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_ConnectionProperties = 32441;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Address_NetworkInterface = 32443;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Address_NetworkInterface_Selections = 32444;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Status_State = 32449;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel = 32453;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation = 32454;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active = 32455;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification = 32456;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 32457;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError = 32459;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_Active = 32460;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_Classification = 32461;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 32462;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_SubError = 32465;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError = 32467;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active = 32468;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification = 32469;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 32470;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 32472;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 32473;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 32474;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 32475;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 32477;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 32478;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 32479;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 32480;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 32482;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 32483;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 32484;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 32485;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent = 32487;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 32488;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 32489;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 32490;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 32492;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 32493;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 32494;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 32495;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress = 32498;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel = 32499;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_AddWriterGroup_InputArguments = 32501;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_AddWriterGroup_OutputArguments = 32502;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_AddReaderGroup_InputArguments = 32504;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_AddReaderGroup_OutputArguments = 32505;

        /// <remarks />
        public const uint DataSetClasses_ConnectionName_Placeholder_RemoveGroup_InputArguments = 32507;

        /// <remarks />
        public const uint DataSetClasses_SetSecurityKeys_InputArguments = 32509;

        /// <remarks />
        public const uint DataSetClasses_AddConnection_InputArguments = 32511;

        /// <remarks />
        public const uint DataSetClasses_AddConnection_OutputArguments = 32512;

        /// <remarks />
        public const uint DataSetClasses_RemoveConnection_InputArguments = 32514;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedDataItems_InputArguments = 32517;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedDataItems_OutputArguments = 32518;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedEvents_InputArguments = 32520;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedEvents_OutputArguments = 32521;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments = 32523;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments = 32524;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate_InputArguments = 32526;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments = 32527;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_RemovePublishedDataSet_InputArguments = 32529;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddDataSetFolder_InputArguments = 32531;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_AddDataSetFolder_OutputArguments = 32532;

        /// <remarks />
        public const uint DataSetClasses_PublishedDataSets_RemoveDataSetFolder_InputArguments = 32534;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_AddSubscribedDataSet_InputArguments = 32537;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_AddSubscribedDataSet_OutputArguments = 32538;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments = 32540;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_AddDataSetFolder_InputArguments = 32542;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_AddDataSetFolder_OutputArguments = 32543;

        /// <remarks />
        public const uint DataSetClasses_SubscribedDataSets_RemoveDataSetFolder_InputArguments = 32545;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Size = 32547;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Writable = 32548;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_UserWritable = 32549;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_OpenCount = 32550;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Open_InputArguments = 32555;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Open_OutputArguments = 32556;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Close_InputArguments = 32558;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Read_InputArguments = 32560;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Read_OutputArguments = 32561;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_Write_InputArguments = 32563;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_GetPosition_InputArguments = 32565;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_GetPosition_OutputArguments = 32566;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_SetPosition_InputArguments = 32568;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_ReserveIds_InputArguments = 32570;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_ReserveIds_OutputArguments = 32571;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_CloseAndUpdate_InputArguments = 32573;

        /// <remarks />
        public const uint DataSetClasses_PubSubConfiguration_CloseAndUpdate_OutputArguments = 32574;

        /// <remarks />
        public const uint DataSetClasses_Status_State = 32576;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_DiagnosticsLevel = 32580;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalInformation = 32581;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalInformation_Active = 32582;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalInformation_Classification = 32583;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalInformation_DiagnosticsLevel = 32584;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalError = 32586;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalError_Active = 32587;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalError_Classification = 32588;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_TotalError_DiagnosticsLevel = 32589;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_SubError = 32592;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateError = 32594;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateError_Active = 32595;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateError_Classification = 32596;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateError_DiagnosticsLevel = 32597;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByMethod = 32599;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_Active = 32600;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_Classification = 32601;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 32602;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByParent = 32604;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByParent_Active = 32605;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByParent_Classification = 32606;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 32607;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalFromError = 32609;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalFromError_Active = 32610;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalFromError_Classification = 32611;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 32612;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StatePausedByParent = 32614;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StatePausedByParent_Active = 32615;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StatePausedByParent_Classification = 32616;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 32617;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateDisabledByMethod = 32619;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_Active = 32620;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_Classification = 32621;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 32622;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetWriters = 32625;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 32626;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetReaders = 32627;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 32628;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_OperationalDataSetWriters = 32629;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 32630;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_OperationalDataSetReaders = 32631;

        /// <remarks />
        public const uint DataSetClasses_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 32632;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxPubSubConnections = 32634;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxWriterGroups = 32635;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxReaderGroups = 32636;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxDataSetWriters = 32637;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxDataSetReaders = 32638;

        /// <remarks />
        public const uint DataSetClasses_PubSubCapablities_MaxFieldsPerDataSet = 32656;

        /// <remarks />
        public const uint DataSetClasses_SupportedTransportProfiles = 32646;

        /// <remarks />
        public const uint DataSetClasses_DefaultDatagramPublisherId = 32647;

        /// <remarks />
        public const uint DataSetClasses_ConfigurationVersion = 32648;

        /// <remarks />
        public const uint PubSubConfigurationType_Open_InputArguments = 25491;

        /// <remarks />
        public const uint PubSubConfigurationType_Open_OutputArguments = 25492;

        /// <remarks />
        public const uint PubSubConfigurationType_Close_InputArguments = 25494;

        /// <remarks />
        public const uint PubSubConfigurationType_Read_InputArguments = 25496;

        /// <remarks />
        public const uint PubSubConfigurationType_Read_OutputArguments = 25497;

        /// <remarks />
        public const uint PubSubConfigurationType_Write_InputArguments = 25499;

        /// <remarks />
        public const uint PubSubConfigurationType_GetPosition_InputArguments = 25501;

        /// <remarks />
        public const uint PubSubConfigurationType_GetPosition_OutputArguments = 25502;

        /// <remarks />
        public const uint PubSubConfigurationType_SetPosition_InputArguments = 25504;

        /// <remarks />
        public const uint PubSubConfigurationType_ReserveIds_InputArguments = 25506;

        /// <remarks />
        public const uint PubSubConfigurationType_ReserveIds_OutputArguments = 25507;

        /// <remarks />
        public const uint PubSubConfigurationType_CloseAndUpdate_InputArguments = 25509;

        /// <remarks />
        public const uint PubSubConfigurationType_CloseAndUpdate_OutputArguments = 25510;

        /// <remarks />
        public const uint PubSubConfigurationRefMask_OptionSetValues = 25518;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId = 16720;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask = 16721;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties = 17482;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Status_State = 15224;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel = 18872;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation = 18873;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active = 18874;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification = 18875;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 18876;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError = 18878;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active = 18879;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification = 18880;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 18881;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError = 18884;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError = 18886;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active = 18887;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification = 18888;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 18889;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 18891;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 18892;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 18893;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 18894;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 18896;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 18897;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 18898;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 18899;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 18901;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 18902;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 18903;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 18904;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent = 18906;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 18907;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 18908;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 18909;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 18911;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 18912;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 18913;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 18914;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages = 18917;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active = 18918;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification = 18919;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 18920;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 18923;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 18925;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 18927;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 18929;

        /// <remarks />
        public const uint PublishedDataSetType_ConfigurationVersion = 14519;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetMetaData = 15229;

        /// <remarks />
        public const uint PublishedDataSetType_DataSetClassId = 16759;

        /// <remarks />
        public const uint PublishedDataSetType_CyclicDataSet = 25521;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments = 15483;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments = 15484;

        /// <remarks />
        public const uint PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments = 15486;

        /// <remarks />
        public const uint ExtensionFieldsType_ExtensionFieldName_Placeholder = 15490;

        /// <remarks />
        public const uint ExtensionFieldsType_AddExtensionField_InputArguments = 15492;

        /// <remarks />
        public const uint ExtensionFieldsType_AddExtensionField_OutputArguments = 15493;

        /// <remarks />
        public const uint ExtensionFieldsType_RemoveExtensionField_InputArguments = 15495;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId = 16760;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask = 16761;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties = 17483;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State = 15232;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel = 18931;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation = 18932;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active = 18933;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification = 18934;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 18935;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError = 18937;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active = 18938;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification = 18939;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 18940;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError = 18943;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError = 18945;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active = 18946;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification = 18947;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 18948;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 18950;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 18951;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 18952;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 18953;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 18955;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 18956;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 18957;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 18958;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 18960;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 18961;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 18962;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 18963;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent = 18965;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 18966;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 18967;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 18968;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 18970;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 18971;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 18972;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 18973;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages = 18976;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active = 18977;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification = 18978;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 18979;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 18982;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 18984;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 18986;

        /// <remarks />
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 18988;

        /// <remarks />
        public const uint PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments = 15505;

        /// <remarks />
        public const uint PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments = 15506;

        /// <remarks />
        public const uint PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments = 15508;

        /// <remarks />
        public const uint PublishedDataItemsType_PublishedData = 14548;

        /// <remarks />
        public const uint PublishedDataItemsType_AddVariables_InputArguments = 14556;

        /// <remarks />
        public const uint PublishedDataItemsType_AddVariables_OutputArguments = 14557;

        /// <remarks />
        public const uint PublishedDataItemsType_RemoveVariables_InputArguments = 14559;

        /// <remarks />
        public const uint PublishedDataItemsType_RemoveVariables_OutputArguments = 14560;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId = 16801;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask = 16802;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties = 17484;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Status_State = 15240;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel = 18990;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation = 18991;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active = 18992;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification = 18993;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 18994;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError = 18996;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active = 18997;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification = 18998;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 18999;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError = 19002;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError = 19004;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active = 19005;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification = 19006;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 19007;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 19009;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 19010;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 19011;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19012;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 19014;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 19015;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 19016;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19017;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 19019;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 19020;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 19021;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19022;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent = 19024;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 19025;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 19026;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19027;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 19029;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 19030;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 19031;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19032;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages = 19035;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active = 19036;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification = 19037;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 19038;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 19041;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 19043;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 19045;

        /// <remarks />
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 19047;

        /// <remarks />
        public const uint PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments = 15513;

        /// <remarks />
        public const uint PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments = 15514;

        /// <remarks />
        public const uint PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments = 15516;

        /// <remarks />
        public const uint PublishedEventsType_PubSubEventNotifier = 14586;

        /// <remarks />
        public const uint PublishedEventsType_SelectedFields = 14587;

        /// <remarks />
        public const uint PublishedEventsType_Filter = 14588;

        /// <remarks />
        public const uint PublishedEventsType_ModifyFieldSelection_InputArguments = 15053;

        /// <remarks />
        public const uint PublishedEventsType_ModifyFieldSelection_OutputArguments = 15517;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_InputArguments = 14480;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_OutputArguments = 14481;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_InputArguments = 14483;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_OutputArguments = 14484;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_InputArguments = 16843;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_OutputArguments = 16853;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_InputArguments = 16882;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_OutputArguments = 16883;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet_InputArguments = 14486;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_InputArguments = 16894;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments = 16922;

        /// <remarks />
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments = 16924;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ConfigurationVersion = 14489;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_DataSetMetaData = 15221;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_InputArguments = 15475;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_OutputArguments = 15476;

        /// <remarks />
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField_InputArguments = 15478;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItems_InputArguments = 14494;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItems_OutputArguments = 14495;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEvents_InputArguments = 14497;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEvents_OutputArguments = 14498;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItemsTemplate_InputArguments = 16958;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedDataItemsTemplate_OutputArguments = 16959;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEventsTemplate_InputArguments = 16961;

        /// <remarks />
        public const uint DataSetFolderType_AddPublishedEventsTemplate_OutputArguments = 16971;

        /// <remarks />
        public const uint DataSetFolderType_RemovePublishedDataSet_InputArguments = 14500;

        /// <remarks />
        public const uint DataSetFolderType_AddDataSetFolder_InputArguments = 16995;

        /// <remarks />
        public const uint DataSetFolderType_AddDataSetFolder_OutputArguments = 16996;

        /// <remarks />
        public const uint DataSetFolderType_RemoveDataSetFolder_InputArguments = 17007;

        /// <remarks />
        public const uint PubSubConnectionType_PublisherId = 14595;

        /// <remarks />
        public const uint PubSubConnectionType_TransportProfileUri = 17306;

        /// <remarks />
        public const uint PubSubConnectionType_TransportProfileUri_Selections = 17710;

        /// <remarks />
        public const uint PubSubConnectionType_ConnectionProperties = 17485;

        /// <remarks />
        public const uint PubSubConnectionType_Address_NetworkInterface = 17202;

        /// <remarks />
        public const uint PubSubConnectionType_Address_NetworkInterface_Selections = 17576;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode = 17311;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize = 17204;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties = 17486;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Status_State = 17315;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId = 17214;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval = 17318;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime = 17319;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Priority = 17321;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds = 17322;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri = 17558;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel = 19108;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation = 19109;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active = 19110;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification = 19111;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 19112;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError = 19114;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active = 19115;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification = 19116;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 19117;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError = 19120;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError = 19122;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active = 19123;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification = 19124;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 19125;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 19127;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 19128;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 19129;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19130;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 19132;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 19133;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 19134;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19135;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 19137;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 19138;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 19139;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19140;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent = 19142;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 19143;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 19144;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19145;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 19147;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 19148;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 19149;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19150;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages = 19153;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active = 19154;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification = 19155;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel = 19156;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions = 19158;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active = 19159;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification = 19160;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel = 19161;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors = 19163;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active = 19164;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification = 19165;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel = 19166;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters = 19168;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 19169;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters = 19170;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 19171;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel = 19173;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 19175;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments = 17294;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments = 17301;

        /// <remarks />
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments = 17324;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode = 17326;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize = 17302;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties = 17487;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Status_State = 17330;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel = 19177;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation = 19178;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active = 19179;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification = 19180;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 19181;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError = 19183;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active = 19184;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification = 19185;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 19186;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError = 19189;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError = 19191;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active = 19192;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification = 19193;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 19194;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 19196;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 19197;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 19198;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19199;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 19201;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 19202;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 19203;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19204;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 19206;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 19207;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 19208;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19209;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent = 19211;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 19212;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 19213;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19214;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 19216;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 19217;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 19218;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19219;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages = 19222;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active = 19223;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification = 19224;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel = 19225;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active = 19228;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification = 19229;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel = 19230;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active = 19233;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification = 19234;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel = 19235;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders = 19237;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 19238;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders = 19239;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 19240;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments = 17399;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments = 17400;

        /// <remarks />
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments = 17334;

        /// <remarks />
        public const uint PubSubConnectionType_Status_State = 14601;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_DiagnosticsLevel = 19242;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalInformation = 19243;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalInformation_Active = 19244;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalInformation_Classification = 19245;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel = 19246;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalError = 19248;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalError_Active = 19249;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalError_Classification = 19250;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel = 19251;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_SubError = 19254;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateError = 19256;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateError_Active = 19257;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateError_Classification = 19258;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel = 19259;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod = 19261;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active = 19262;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification = 19263;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19264;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent = 19266;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active = 19267;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification = 19268;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19269;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError = 19271;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active = 19272;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification = 19273;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19274;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StatePausedByParent = 19276;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active = 19277;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification = 19278;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19279;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod = 19281;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active = 19282;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification = 19283;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19284;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress = 19287;

        /// <remarks />
        public const uint PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel = 19288;

        /// <remarks />
        public const uint PubSubConnectionType_AddWriterGroup_InputArguments = 17428;

        /// <remarks />
        public const uint PubSubConnectionType_AddWriterGroup_OutputArguments = 17456;

        /// <remarks />
        public const uint PubSubConnectionType_AddReaderGroup_InputArguments = 17507;

        /// <remarks />
        public const uint PubSubConnectionType_AddReaderGroup_OutputArguments = 17508;

        /// <remarks />
        public const uint PubSubConnectionType_RemoveGroup_InputArguments = 14226;

        /// <remarks />
        public const uint PubSubGroupType_SecurityMode = 15926;

        /// <remarks />
        public const uint PubSubGroupType_SecurityGroupId = 15927;

        /// <remarks />
        public const uint PubSubGroupType_SecurityKeyServices = 15928;

        /// <remarks />
        public const uint PubSubGroupType_MaxNetworkMessageSize = 17724;

        /// <remarks />
        public const uint PubSubGroupType_GroupProperties = 17488;

        /// <remarks />
        public const uint PubSubGroupType_Status_State = 15266;

        /// <remarks />
        public const uint WriterGroupType_Status_State = 17731;

        /// <remarks />
        public const uint WriterGroupType_WriterGroupId = 17736;

        /// <remarks />
        public const uint WriterGroupType_PublishingInterval = 17737;

        /// <remarks />
        public const uint WriterGroupType_KeepAliveTime = 17738;

        /// <remarks />
        public const uint WriterGroupType_Priority = 17739;

        /// <remarks />
        public const uint WriterGroupType_LocaleIds = 17740;

        /// <remarks />
        public const uint WriterGroupType_HeaderLayoutUri = 17559;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId = 17744;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask = 17745;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties = 17490;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Status_State = 17750;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel = 17754;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation = 17755;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active = 17756;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification = 17757;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 17758;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError = 17760;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active = 17761;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification = 17762;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 17763;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError = 17766;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError = 17768;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active = 17769;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification = 17770;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 17771;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 17773;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 17774;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 17775;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 17776;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 17778;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 17779;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 17780;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 17781;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 17783;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 17784;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 17785;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 17786;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent = 17788;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 17789;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 17790;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 17791;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 17793;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 17794;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 17795;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 17796;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages = 17799;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active = 17800;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification = 17801;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 17802;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 17805;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 17807;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 17809;

        /// <remarks />
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 17811;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_DiagnosticsLevel = 17813;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalInformation = 17814;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalInformation_Active = 17815;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalInformation_Classification = 17816;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel = 17817;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalError = 17819;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalError_Active = 17820;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalError_Classification = 17821;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel = 17822;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_SubError = 17825;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateError = 17827;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateError_Active = 17828;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateError_Classification = 17829;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel = 17830;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByMethod = 17832;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active = 17833;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification = 17834;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 17835;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByParent = 17837;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active = 17838;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification = 17839;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 17840;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalFromError = 17842;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active = 17843;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification = 17844;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 17845;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StatePausedByParent = 17847;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active = 17848;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification = 17849;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 17850;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateDisabledByMethod = 17853;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active = 17854;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification = 17855;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 17856;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_SentNetworkMessages = 17859;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active = 17864;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification = 17871;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel = 17872;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_FailedTransmissions = 17874;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active = 17878;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification = 17885;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel = 17892;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_EncryptionErrors = 17900;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active = 17901;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification = 17902;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel = 17903;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters = 17913;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 17920;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters = 17927;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 17934;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel = 17948;

        /// <remarks />
        public const uint WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 17962;

        /// <remarks />
        public const uint WriterGroupType_AddDataSetWriter_InputArguments = 17976;

        /// <remarks />
        public const uint WriterGroupType_AddDataSetWriter_OutputArguments = 17987;

        /// <remarks />
        public const uint WriterGroupType_RemoveDataSetWriter_InputArguments = 17993;

        /// <remarks />
        public const uint ReaderGroupType_Status_State = 18068;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_PublisherId = 18077;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId = 18078;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId = 18079;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData = 18080;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask = 18081;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout = 18082;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount = 17560;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri = 17562;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties = 17492;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Status_State = 18089;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel = 18093;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation = 18094;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active = 18095;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification = 18096;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel = 18097;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError = 18099;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active = 18100;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification = 18101;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel = 18102;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError = 18105;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError = 18107;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active = 18108;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification = 18109;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel = 18110;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod = 18112;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active = 18113;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification = 18114;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 18115;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent = 18117;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active = 18118;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification = 18119;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 18120;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError = 18122;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active = 18123;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification = 18124;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 18125;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent = 18127;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active = 18128;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification = 18129;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 18130;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod = 18132;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active = 18133;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification = 18134;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 18135;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages = 18138;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active = 18139;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification = 18140;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 18141;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active = 18144;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification = 18145;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel = 18146;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 18149;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 18151;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 18153;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 18158;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel = 21003;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 21005;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments = 21010;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments = 21011;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments = 21013;

        /// <remarks />
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments = 21014;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_DiagnosticsLevel = 21016;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalInformation = 21017;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalInformation_Active = 21018;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalInformation_Classification = 21019;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel = 21020;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalError = 21022;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalError_Active = 21023;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalError_Classification = 21024;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel = 21025;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_SubError = 21028;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateError = 21030;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateError_Active = 21031;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateError_Classification = 21032;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel = 21033;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod = 21035;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active = 21036;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification = 21037;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 21038;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByParent = 21040;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active = 21041;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification = 21042;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 21043;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalFromError = 21045;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active = 21046;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification = 21047;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 21048;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StatePausedByParent = 21050;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active = 21051;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification = 21052;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 21053;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod = 21055;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active = 21056;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification = 21057;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 21058;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages = 21061;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active = 21062;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification = 21063;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel = 21064;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active = 21067;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification = 21068;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel = 21069;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active = 21072;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification = 21073;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel = 21074;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders = 21076;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 21077;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders = 21078;

        /// <remarks />
        public const uint ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 21079;

        /// <remarks />
        public const uint ReaderGroupType_AddDataSetReader_InputArguments = 21083;

        /// <remarks />
        public const uint ReaderGroupType_AddDataSetReader_OutputArguments = 21084;

        /// <remarks />
        public const uint ReaderGroupType_RemoveDataSetReader_InputArguments = 21086;

        /// <remarks />
        public const uint DataSetWriterType_DataSetWriterId = 21092;

        /// <remarks />
        public const uint DataSetWriterType_DataSetFieldContentMask = 21093;

        /// <remarks />
        public const uint DataSetWriterType_KeyFrameCount = 21094;

        /// <remarks />
        public const uint DataSetWriterType_DataSetWriterProperties = 17493;

        /// <remarks />
        public const uint DataSetWriterType_Status_State = 15300;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_DiagnosticsLevel = 19551;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalInformation = 19552;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalInformation_Active = 19553;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalInformation_Classification = 19554;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalInformation_DiagnosticsLevel = 19555;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalError = 19557;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalError_Active = 19558;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalError_Classification = 19559;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_TotalError_DiagnosticsLevel = 19560;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_SubError = 19563;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateError = 19565;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateError_Active = 19566;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateError_Classification = 19567;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateError_DiagnosticsLevel = 19568;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod = 19570;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Active = 19571;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Classification = 19572;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19573;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByParent = 19575;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Active = 19576;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Classification = 19577;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19578;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalFromError = 19580;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Active = 19581;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Classification = 19582;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19583;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StatePausedByParent = 19585;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Active = 19586;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Classification = 19587;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19588;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod = 19590;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Active = 19591;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Classification = 19592;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19593;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages = 19596;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Active = 19597;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Classification = 19598;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 19599;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 19602;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 19604;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 19606;

        /// <remarks />
        public const uint DataSetWriterType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 19608;

        /// <remarks />
        public const uint DataSetReaderType_PublisherId = 21097;

        /// <remarks />
        public const uint DataSetReaderType_WriterGroupId = 21098;

        /// <remarks />
        public const uint DataSetReaderType_DataSetWriterId = 21099;

        /// <remarks />
        public const uint DataSetReaderType_DataSetMetaData = 21100;

        /// <remarks />
        public const uint DataSetReaderType_DataSetFieldContentMask = 21101;

        /// <remarks />
        public const uint DataSetReaderType_MessageReceiveTimeout = 21102;

        /// <remarks />
        public const uint DataSetReaderType_KeyFrameCount = 17563;

        /// <remarks />
        public const uint DataSetReaderType_HeaderLayoutUri = 17564;

        /// <remarks />
        public const uint DataSetReaderType_SecurityMode = 15932;

        /// <remarks />
        public const uint DataSetReaderType_SecurityGroupId = 15933;

        /// <remarks />
        public const uint DataSetReaderType_SecurityKeyServices = 15934;

        /// <remarks />
        public const uint DataSetReaderType_DataSetReaderProperties = 17494;

        /// <remarks />
        public const uint DataSetReaderType_Status_State = 15308;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_DiagnosticsLevel = 19610;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalInformation = 19611;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalInformation_Active = 19612;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalInformation_Classification = 19613;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalInformation_DiagnosticsLevel = 19614;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalError = 19616;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalError_Active = 19617;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalError_Classification = 19618;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_TotalError_DiagnosticsLevel = 19619;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_SubError = 19622;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateError = 19624;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateError_Active = 19625;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateError_Classification = 19626;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateError_DiagnosticsLevel = 19627;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod = 19629;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Active = 19630;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Classification = 19631;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel = 19632;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByParent = 19634;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Active = 19635;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Classification = 19636;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel = 19637;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalFromError = 19639;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Active = 19640;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Classification = 19641;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel = 19642;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StatePausedByParent = 19644;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Active = 19645;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Classification = 19646;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel = 19647;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod = 19649;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Active = 19650;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Classification = 19651;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel = 19652;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages = 19655;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Active = 19656;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Classification = 19657;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel = 19658;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Active = 19661;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Classification = 19662;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel = 19663;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 19666;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel = 19668;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel = 19670;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel = 19672;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel = 19674;

        /// <remarks />
        public const uint DataSetReaderType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 19676;

        /// <remarks />
        public const uint DataSetReaderType_CreateTargetVariables_InputArguments = 17387;

        /// <remarks />
        public const uint DataSetReaderType_CreateTargetVariables_OutputArguments = 17388;

        /// <remarks />
        public const uint DataSetReaderType_CreateDataSetMirror_InputArguments = 17390;

        /// <remarks />
        public const uint DataSetReaderType_CreateDataSetMirror_OutputArguments = 17391;

        /// <remarks />
        public const uint TargetVariablesType_TargetVariables = 15114;

        /// <remarks />
        public const uint TargetVariablesType_AddTargetVariables_InputArguments = 15116;

        /// <remarks />
        public const uint TargetVariablesType_AddTargetVariables_OutputArguments = 15117;

        /// <remarks />
        public const uint TargetVariablesType_RemoveTargetVariables_InputArguments = 15119;

        /// <remarks />
        public const uint TargetVariablesType_RemoveTargetVariables_OutputArguments = 15120;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet_InputArguments = 23798;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet_OutputArguments = 23799;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet_InputArguments = 23801;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder_InputArguments = 23803;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments = 23804;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments = 23806;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_DataSetMetaData = 23809;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_IsConnected = 23810;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddSubscribedDataSet_InputArguments = 23812;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddSubscribedDataSet_OutputArguments = 23813;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_RemoveSubscribedDataSet_InputArguments = 23815;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddDataSetFolder_InputArguments = 23817;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_AddDataSetFolder_OutputArguments = 23818;

        /// <remarks />
        public const uint SubscribedDataSetFolderType_RemoveDataSetFolder_InputArguments = 23820;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetType_DataSetMetaData = 23830;

        /// <remarks />
        public const uint StandaloneSubscribedDataSetType_IsConnected = 23831;

        /// <remarks />
        public const uint PubSubStatusType_State = 14644;

        /// <remarks />
        public const uint PubSubDiagnosticsType_DiagnosticsLevel = 19678;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalInformation = 19679;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalInformation_Active = 19680;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalInformation_Classification = 19681;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel = 19682;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalError = 19684;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalError_Active = 19685;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalError_Classification = 19686;

        /// <remarks />
        public const uint PubSubDiagnosticsType_TotalError_DiagnosticsLevel = 19687;

        /// <remarks />
        public const uint PubSubDiagnosticsType_SubError = 19690;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateError = 19692;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateError_Active = 19693;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateError_Classification = 19694;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel = 19695;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByMethod = 19697;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active = 19698;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification = 19699;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19700;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByParent = 19702;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByParent_Active = 19703;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification = 19704;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel = 19705;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalFromError = 19707;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalFromError_Active = 19708;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification = 19709;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel = 19710;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StatePausedByParent = 19712;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StatePausedByParent_Active = 19713;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StatePausedByParent_Classification = 19714;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel = 19715;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateDisabledByMethod = 19717;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active = 19718;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification = 19719;

        /// <remarks />
        public const uint PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel = 19720;

        /// <remarks />
        public const uint DiagnosticsLevel_EnumStrings = 19724;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterType_Active = 19726;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterType_Classification = 19727;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterType_DiagnosticsLevel = 19728;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterType_TimeFirstChange = 19729;

        /// <remarks />
        public const uint PubSubDiagnosticsCounterClassification_EnumStrings = 19731;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalInformation_Active = 19735;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalInformation_Classification = 19736;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalInformation_DiagnosticsLevel = 19737;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalError_Active = 19740;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalError_Classification = 19741;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_TotalError_DiagnosticsLevel = 19742;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateError = 19747;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateError_Active = 19748;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateError_Classification = 19749;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateError_DiagnosticsLevel = 19750;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByMethod = 19752;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Active = 19753;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Classification = 19754;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19755;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByParent = 19757;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Active = 19758;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Classification = 19759;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalByParent_DiagnosticsLevel = 19760;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalFromError = 19762;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Active = 19763;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Classification = 19764;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateOperationalFromError_DiagnosticsLevel = 19765;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StatePausedByParent = 19767;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StatePausedByParent_Active = 19768;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StatePausedByParent_Classification = 19769;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StatePausedByParent_DiagnosticsLevel = 19770;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateDisabledByMethod = 19772;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Active = 19773;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Classification = 19774;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_DiagnosticsLevel = 19775;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters = 19778;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 19779;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders = 19780;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 19781;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters = 19782;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 19783;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders = 19784;

        /// <remarks />
        public const uint PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 19785;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalInformation_Active = 19789;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalInformation_Classification = 19790;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalInformation_DiagnosticsLevel = 19791;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalError_Active = 19794;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalError_Classification = 19795;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_TotalError_DiagnosticsLevel = 19796;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateError = 19801;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateError_Active = 19802;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateError_Classification = 19803;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateError_DiagnosticsLevel = 19804;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod = 19806;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Active = 19807;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Classification = 19808;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19809;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent = 19811;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Active = 19812;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Classification = 19813;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_DiagnosticsLevel = 19814;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError = 19816;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Active = 19817;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Classification = 19818;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_DiagnosticsLevel = 19819;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StatePausedByParent = 19821;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Active = 19822;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Classification = 19823;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_DiagnosticsLevel = 19824;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod = 19826;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Active = 19827;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Classification = 19828;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_DiagnosticsLevel = 19829;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress = 19832;

        /// <remarks />
        public const uint PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel = 19833;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalInformation_Active = 19837;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalInformation_Classification = 19838;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalInformation_DiagnosticsLevel = 19839;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalError_Active = 19842;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalError_Classification = 19843;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_TotalError_DiagnosticsLevel = 19844;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateError = 19849;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateError_Active = 19850;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification = 19851;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel = 19852;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod = 19854;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active = 19855;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification = 19856;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19857;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent = 19859;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active = 19860;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification = 19861;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel = 19862;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError = 19864;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active = 19865;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification = 19866;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel = 19867;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent = 19869;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active = 19870;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification = 19871;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel = 19872;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod = 19874;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active = 19875;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification = 19876;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel = 19877;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages = 19880;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active = 19881;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification = 19882;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel = 19883;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions = 19885;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active = 19886;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification = 19887;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel = 19888;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors = 19890;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active = 19891;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification = 19892;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel = 19893;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters = 19895;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel = 19896;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters = 19897;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel = 19898;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID = 19899;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel = 19900;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID = 19901;

        /// <remarks />
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 19902;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalInformation_Active = 19906;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalInformation_Classification = 19907;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalInformation_DiagnosticsLevel = 19908;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalError_Active = 19911;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalError_Classification = 19912;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_TotalError_DiagnosticsLevel = 19913;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateError = 19918;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateError_Active = 19919;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification = 19920;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel = 19921;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod = 19923;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active = 19924;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification = 19925;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19926;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent = 19928;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active = 19929;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification = 19930;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel = 19931;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError = 19933;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active = 19934;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification = 19935;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel = 19936;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent = 19938;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active = 19939;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification = 19940;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel = 19941;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod = 19943;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active = 19944;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification = 19945;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel = 19946;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages = 19949;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active = 19950;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification = 19951;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel = 19952;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages = 19954;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active = 19955;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification = 19956;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel = 19957;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors = 19959;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active = 19960;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification = 19961;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel = 19962;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders = 19964;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel = 19965;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders = 19966;

        /// <remarks />
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel = 19967;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalInformation_Active = 19971;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalInformation_Classification = 19972;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalInformation_DiagnosticsLevel = 19973;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalError_Active = 19976;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalError_Classification = 19977;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_TotalError_DiagnosticsLevel = 19978;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateError = 19983;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active = 19984;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification = 19985;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel = 19986;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod = 19988;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active = 19989;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification = 19990;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel = 19991;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent = 19993;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active = 19994;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification = 19995;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel = 19996;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError = 19998;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active = 19999;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification = 20000;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel = 20001;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent = 20003;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active = 20004;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification = 20005;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel = 20006;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod = 20008;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active = 20009;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification = 20010;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel = 20011;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages = 20014;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active = 20015;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification = 20016;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel = 20017;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber = 20019;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 20020;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode = 20021;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel = 20022;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion = 20023;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel = 20024;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion = 20025;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel = 20026;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalInformation_Active = 20030;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalInformation_Classification = 20031;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalInformation_DiagnosticsLevel = 20032;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalError_Active = 20035;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalError_Classification = 20036;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_TotalError_DiagnosticsLevel = 20037;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateError = 20042;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active = 20043;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification = 20044;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel = 20045;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod = 20047;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active = 20048;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification = 20049;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel = 20050;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent = 20052;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active = 20053;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification = 20054;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel = 20055;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError = 20057;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active = 20058;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification = 20059;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel = 20060;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent = 20062;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active = 20063;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification = 20064;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel = 20065;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod = 20067;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active = 20068;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification = 20069;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel = 20070;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages = 20073;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active = 20074;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification = 20075;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel = 20076;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors = 20078;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active = 20079;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification = 20080;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel = 20081;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber = 20083;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel = 20084;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode = 20085;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel = 20086;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion = 20087;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel = 20088;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion = 20089;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel = 20090;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID = 20091;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel = 20092;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID = 20093;

        /// <remarks />
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel = 20094;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxPubSubConnections = 23833;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxWriterGroups = 23834;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxReaderGroups = 23835;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxDataSetWriters = 23836;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxDataSetReaders = 23837;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxFieldsPerDataSet = 23838;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxDataSetWritersPerGroup = 32651;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram = 32652;

        /// <remarks />
        public const uint PubSubCapabilitiesType_MaxNetworkMessageSizeBroker = 32653;

        /// <remarks />
        public const uint PubSubCapabilitiesType_SupportSecurityKeyPull = 32654;

        /// <remarks />
        public const uint PubSubCapabilitiesType_SupportSecurityKeyPush = 32655;

        /// <remarks />
        public const uint PubSubStatusEventType_ConnectionId = 15545;

        /// <remarks />
        public const uint PubSubStatusEventType_GroupId = 15546;

        /// <remarks />
        public const uint PubSubStatusEventType_State = 15547;

        /// <remarks />
        public const uint PubSubTransportLimitsExceedEventType_Actual = 15561;

        /// <remarks />
        public const uint PubSubTransportLimitsExceedEventType_Maximum = 15562;

        /// <remarks />
        public const uint PubSubCommunicationFailureEventType_Error = 15576;

        /// <remarks />
        public const uint UadpWriterGroupMessageType_GroupVersion = 21106;

        /// <remarks />
        public const uint UadpWriterGroupMessageType_DataSetOrdering = 21107;

        /// <remarks />
        public const uint UadpWriterGroupMessageType_NetworkMessageContentMask = 21108;

        /// <remarks />
        public const uint UadpWriterGroupMessageType_SamplingOffset = 21109;

        /// <remarks />
        public const uint UadpWriterGroupMessageType_PublishingOffset = 21110;

        /// <remarks />
        public const uint UadpDataSetWriterMessageType_DataSetMessageContentMask = 21112;

        /// <remarks />
        public const uint UadpDataSetWriterMessageType_ConfiguredSize = 21113;

        /// <remarks />
        public const uint UadpDataSetWriterMessageType_NetworkMessageNumber = 21114;

        /// <remarks />
        public const uint UadpDataSetWriterMessageType_DataSetOffset = 21115;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_GroupVersion = 21117;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_NetworkMessageNumber = 21119;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_DataSetOffset = 17477;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_DataSetClassId = 21120;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_NetworkMessageContentMask = 21121;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_DataSetMessageContentMask = 21122;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_PublishingInterval = 21123;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_ProcessingOffset = 21124;

        /// <remarks />
        public const uint UadpDataSetReaderMessageType_ReceiveOffset = 21125;

        /// <remarks />
        public const uint JsonWriterGroupMessageType_NetworkMessageContentMask = 21127;

        /// <remarks />
        public const uint JsonDataSetWriterMessageType_DataSetMessageContentMask = 21129;

        /// <remarks />
        public const uint JsonDataSetReaderMessageType_NetworkMessageContentMask = 21131;

        /// <remarks />
        public const uint JsonDataSetReaderMessageType_DataSetMessageContentMask = 21132;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface = 15154;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections = 17579;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DiscoveryAnnounceRate = 23839;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DiscoveryMaxMessageSize = 23840;

        /// <remarks />
        public const uint DatagramConnectionTransportType_QosCategory = 25525;

        /// <remarks />
        public const uint DatagramConnectionTransportType_DatagramQos = 25526;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_MessageRepeatCount = 21134;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_MessageRepeatDelay = 21135;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_Address_NetworkInterface = 23843;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_Address_NetworkInterface_Selections = 23844;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_QosCategory = 25527;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_DatagramQos = 23847;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_DiscoveryAnnounceRate = 23848;

        /// <remarks />
        public const uint DatagramWriterGroupTransportType_Topic = 23849;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_Address_NetworkInterface = 24018;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections = 24019;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_QosCategory = 25528;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_DatagramQos = 24022;

        /// <remarks />
        public const uint DatagramDataSetReaderTransportType_Topic = 24023;

        /// <remarks />
        public const uint BrokerConnectionTransportType_ResourceUri = 15156;

        /// <remarks />
        public const uint BrokerConnectionTransportType_AuthenticationProfileUri = 15178;

        /// <remarks />
        public const uint BrokerWriterGroupTransportType_QueueName = 21137;

        /// <remarks />
        public const uint BrokerWriterGroupTransportType_ResourceUri = 15246;

        /// <remarks />
        public const uint BrokerWriterGroupTransportType_AuthenticationProfileUri = 15247;

        /// <remarks />
        public const uint BrokerWriterGroupTransportType_RequestedDeliveryGuarantee = 15249;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_QueueName = 21139;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_MetaDataQueueName = 21140;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_ResourceUri = 15250;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_AuthenticationProfileUri = 15251;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_RequestedDeliveryGuarantee = 15330;

        /// <remarks />
        public const uint BrokerDataSetWriterTransportType_MetaDataUpdateTime = 21141;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType_QueueName = 21143;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType_ResourceUri = 15334;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType_AuthenticationProfileUri = 15419;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType_RequestedDeliveryGuarantee = 15420;

        /// <remarks />
        public const uint BrokerDataSetReaderTransportType_MetaDataQueueName = 21144;

        /// <remarks />
        public const uint NetworkAddressType_NetworkInterface = 21146;

        /// <remarks />
        public const uint NetworkAddressType_NetworkInterface_Selections = 17582;

        /// <remarks />
        public const uint NetworkAddressUrlType_NetworkInterface_Selections = 17585;

        /// <remarks />
        public const uint NetworkAddressUrlType_