% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dm_k.r
\name{find_dm_k}
\alias{find_dm_k}
\title{Find a suitable k}
\usage{
find_dm_k(n, min_k = 100L, small = 1000L, big = 10000L)
}
\arguments{
\item{n}{Number of possible neighbors (nrow(dataset) - 1)}

\item{min_k}{Minimum number of neighbors. Will be chosen for \eqn{n \ge big}}

\item{small}{Number of neighbors considered small. If/where \eqn{n \le small}, n itself will be returned.}

\item{big}{Number of neighbors considered big. If/where \eqn{n \ge big}, \code{min_k} will be returned.}
}
\value{
A vector of the same length as \code{n} that contains suitable \code{k} values for the respective \code{n}
}
\description{
The \code{k} parameter for the k nearest neighbors used in \link{DiffusionMap} should be as big as possible while
still being computationally feasible. This function approximates it depending on the size of the dataset \code{n}.
}
\examples{
curve(find_dm_k(n),     0, 13000, xname = 'n')
curve(find_dm_k(n) / n, 0, 13000, xname = 'n')
}
