% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab_corr.R
\name{phi}
\alias{phi}
\alias{cramers_v}
\alias{tschuprows_t}
\alias{cohens_w}
\alias{fei}
\alias{pearsons_c}
\title{\eqn{\phi} and Other Contingency Tables Correlations}
\usage{
phi(x, y = NULL, adjust = TRUE, ci = 0.95, alternative = "greater", ...)

cramers_v(x, y = NULL, adjust = TRUE, ci = 0.95, alternative = "greater", ...)

tschuprows_t(
  x,
  y = NULL,
  adjust = TRUE,
  ci = 0.95,
  alternative = "greater",
  ...
)

cohens_w(
  x,
  y = NULL,
  p = rep(1, length(x)),
  ci = 0.95,
  alternative = "greater",
  ...
)

fei(x, p = rep(1, length(x)), ci = 0.95, alternative = "greater", ...)

pearsons_c(
  x,
  y = NULL,
  p = rep(1, length(x)),
  ci = 0.95,
  alternative = "greater",
  ...
)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{adjust}{Should the effect size be corrected for small-sample bias?
Defaults to \code{TRUE}; Advisable for small samples and large tables.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"greater"} (default) or \code{"less"}
(one-sided CI), or \code{"two.sided"} (default, two-sided CI). Partial matching
is allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in
\link{effectsize_CIs}.}

\item{...}{Ignored.}

\item{p}{a vector of probabilities of the same length as \code{x}.
    An error is given if any entry of \code{p} is negative.}
}
\value{
A data frame with the effect size (\code{Cramers_v}, \code{phi} (possibly with
the suffix \verb{_adjusted}), \code{Cohens_w}, \code{Fei}) and its CIs (\code{CI_low} and
\code{CI_high}).
}
\description{
Compute phi (\eqn{\phi}), Cramer's \emph{V}, Tschuprow's \emph{T}, Cohen's \emph{w},
\ifelse{latex}{\eqn{Fei}}{פ (Fei)}, Pearson's contingency coefficient for
contingency tables or goodness-of-fit. Pair with any reported
\code{\link[stats:chisq.test]{stats::chisq.test()}}.
}
\details{
phi (\eqn{\phi}), Cramer's \emph{V}, Tschuprow's \emph{T}, Cohen's \emph{w}, and Pearson's
\emph{C} are effect sizes for tests of independence in 2D contingency tables. For
2-by-2 tables, phi, Cramer's \emph{V}, Tschuprow's \emph{T}, and Cohen's \emph{w} are
identical, and are equal to the simple correlation between two dichotomous
variables, ranging between  0 (no dependence) and 1 (perfect dependence).
\cr\cr
For larger tables, Cramer's \emph{V}, Tschuprow's \emph{T} or Pearson's \emph{C} should be
used, as they are bounded between 0-1. (Cohen's \emph{w} can also be used, but
since it is not bounded at 1 (can be larger) its interpretation is more
difficult.) For square table, Cramer's \emph{V} and Tschuprow's \emph{T} give the same
results, but for non-square tables Tschuprow's \emph{T} is more conservative:
while \emph{V} will be 1 if either columns are fully dependent on rows (for each
column, there is only one non-0 cell) \emph{or} rows are fully dependent on
columns, \emph{T} will only be 1 if both are true.
\cr \cr
For goodness-of-fit in 1D tables Cohen's \emph{W}, \ifelse{latex}{\eqn{Fei}}{פ (Fei)}
or Pearson's \emph{C} can be used. Cohen's \emph{w} has no upper bound (can be
arbitrarily large, depending on the expected distribution). \emph{Fei} is an
adjusted Cohen's \emph{w}, accounting for the expected distribution, making it
bounded between 0-1 (Ben-Shachar et al, 2023). Pearson's \emph{C} is also bounded
between 0-1.
\cr \cr
To summarize, for correlation-like effect sizes, we recommend:
\itemize{
\item For a 2x2 table, use \code{phi()}
\item For larger tables, use \code{cramers_v()}
\item For goodness-of-fit, use \code{fei()}
}
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{

## 2-by-2 tables
## -------------
data("RCT_table")
RCT_table # note groups are COLUMNS

phi(RCT_table)
pearsons_c(RCT_table)



## Larger tables
## -------------
data("Music_preferences")
Music_preferences

cramers_v(Music_preferences)

cohens_w(Music_preferences)

pearsons_c(Music_preferences)



## Goodness of fit
## ---------------
data("Smoking_FASD")
Smoking_FASD

fei(Smoking_FASD)

cohens_w(Smoking_FASD)

pearsons_c(Smoking_FASD)

# Use custom expected values:
fei(Smoking_FASD, p = c(0.015, 0.010, 0.975))

cohens_w(Smoking_FASD, p = c(0.015, 0.010, 0.975))

pearsons_c(Smoking_FASD, p = c(0.015, 0.010, 0.975))

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Ben-Shachar, M.S., Patil, I., Thériault, R., Wiernik, B.M., Lüdecke, D.
(2023). Phi, Fei, Fo, Fum: Effect Sizes for Categorical Data That Use the
Chi‑Squared Statistic. Mathematics, 11, 1982. \doi{10.3390/math11091982}
\item Johnston, J. E., Berry, K. J., & Mielke Jr, P. W. (2006). Measures of
effect size for chi-squared and likelihood-ratio goodness-of-fit tests.
Perceptual and motor skills, 103(2), 412-414.
\item Rosenberg, M. S. (2010). A generalized formula for converting chi-square
tests to effect sizes for meta-analysis. PloS one, 5(4), e10059.
}
}
\seealso{
\code{\link[=chisq_to_phi]{chisq_to_phi()}} for details regarding estimation and CIs.

Other effect sizes for contingency table: 
\code{\link{cohens_g}()},
\code{\link{oddsratio}()}
}
\concept{effect sizes for contingency table}
