/*
 * DZcomm : a serial port API.
 * file : dzucfg.h
 *
 * Configuration defines for use on Unix platforms.
 * 
 * See readme.txt for copyright information.
 */



#ifndef DZUCFG_H
#define DZUCFG_H

#include <fcntl.h>
#include <unistd.h>

/* Describe this platform.  */
#define DZCOMM_PLATFORM_STR  "Unix"

#define DZCOMM_UNIX
#define DZCOMM_CONSOLE_OK

#define DZCOMM_EXTRA_HEADER "dzcomm/dzunix.h"
#define DZCOMM_INTERNAL_HEADER "dzcomm/dintunix.h"

#ifndef O_BINARY
# define O_BINARY  0
# define O_TEXT    0
#endif

#include <math.h>
#ifdef __sgi__
/* SGI defines these macros in <math.h>.  */
# undef fsin
# undef fcos
# undef ftan
# undef fasin
# undef facos
# undef fatan
# undef fatan2
# undef fsqrt
#endif

/* Include configuration generated by configure script.  */
#include "dzunixac.h"

/* Provide implementations of missing functions.  */
#ifndef HAVE_STRICMP
#define DZCOMM_NO_STRICMP
#endif

#ifndef HAVE_STRLWR
#define DZCOMM_NO_STRLWR
#endif

#ifndef HAVE_STRUPR
#define DZCOMM_NO_STRUPR
#endif

#ifndef HAVE_MEMCMP
#define DZCOMM_NO_MEMCMP
#endif

#ifndef HAVE_FINDFIRST
#define DZCOMM_NO_FINDFIRST
#endif

#endif /* ifndef DZUCFG_H */
