#pragma once
#include "../Listing.h"
#include "../Output.h"

namespace code {
	namespace arm64 {
		STORM_PKG(core.asm.arm64);

		// Output a listing to an Output object.
		void output(Listing *src, Output *to);


		/**
		 * Custom updater for offset references.
		 */
		class ArmOffsetUpdater : public OffsetReference {
			STORM_CLASS;
		public:
			ArmOffsetUpdater(OffsetRef src, Content *inside, void *code, Nat codeOffset, Nat type);

			// Notification of a new location.
			virtual void moved(Offset newAddr);

			// Types of references:
			enum {
				tImm,
				tLoadStore,
				tLea,
			};

		private:
			// Code segment to update.
			UNKNOWN(PTR_GC) void *code;

			// Offset in 'code' to update.
			Nat codeOffset;

			// Type of reference.
			Nat type;
		};


	}
}
