.TH XScreenSaver 1 "17-Jun-99" "X Version 11"
.SH NAME
vidwhacker \- grab images and apply random filters to them
.SH SYNOPSIS
.B vidwhacker
[\-\-display \fIhost:display.screen\fP] [\-\-root]
[\-\-window\-id \fInumber\fP][\-\-verbose]
[\-\-stdin] [\-\-stdout] [\-\-delay seconds]
[-directory \fIdirectory\fP]
[\-\-fps]
.SH DESCRIPTION
Distorts an image using a random series of filters: edge detection,
subtracting the image from a rotated version of itself, etc.

Selection of random image files is done by running the
.BR xscreensaver\-getimage\-file (MANSUFFIX)
program.  Capture of video frames (if requested) is done by running the
.BR xscreensaver\-getimage\-video (MANSUFFIX)
program.
.SH OPTIONS
.I vidwhacker
accepts the following options:
.TP 8
.B \-\-root
Draw on the root window.  This is the default.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-verbose
Print diagnostics.
.TP 8
.B \-\-stdin
Instead of grabbing an image from disk or video, read an image
to manipulate from stdin.  This image must be in
.BR ppm (5)
format.  The program will still perform repeated random image 
transformations, but it will always use this one image as its starting point.
.TP 8
.B \-\-delay \fIseconds\fP
How long to sleep between images.  Default 5 seconds (the actual
elapsed time is significantly longer, due to processing time.)
.TP 8
.B \-\-stdout
Instead of displaying the image on a window or on the root, write the new
image on stdout, and exit.
.TP 8
.B \-\-directory \fIdirectory\fP
Use this directory instead of the \fBimageDirectory\fP specified in 
the \fI~/.xscreensaver\fP file.
.TP 8
.B \-\-fps
Display the current frame rate and CPU load.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH BUGS
It is poorly named; originally it worked only on grabbed video frames,
before being expanded to work on any image.

It requires the various PBM tools, e.g.,
.BR ppmrelief (1).
Though still available, the "pbmplus" suite has largely fallen out of
favor these days, so it would be nice if someone were to port this script
to make use of ImageMagick's
.BR convert (1)
instead.  That would also probably make it faster.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xscreensaver\-getimage (MANSUFFIX),
.BR xscreensaver\-getimage\-file (MANSUFFIX),
.BR xscreensaver\-getimage\-video (MANSUFFIX),
.BR ppmtogif (1),
.BR convert (1)
.SH COPYRIGHT
Copyright \(co 1998-2001 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 18-Jan-98.
