#!/bin/bash
test -d ../data || (echo "must be called from kit data directory!"; exit 1)
rpm -q R-base 2>&1 >/dev/null|| (echo "R-base rpm not installed!"; exit 1)

echo "rebuilding directory structure ..."
rm -rf ../src
mkdir -p ../src/usr/opt/RGS650/bin
mkdir -p ../src/usr/opt/RGS650/shlib
mkdir -p ../src/usr/opt/RGS650/lib
mkdir -p ../src/usr/opt/RGS650/doc
mkdir -p ../src/usr/opt/RGS650/info
mkdir -p ../src/usr/opt/RGS650/man/man1

echo "copying base R installation ..."
cp -rpd /usr/local/lib/R ../src/usr/opt/RGS650/lib/

echo "modifying start scripts ..."
cat /usr/local/bin/R | \
  sed -e "s#/usr/local/lib/R#/usr/opt/RGS650/lib/R#g" > \
  ../src/usr/opt/RGS650/bin/R.orig
chmod 755 ../src/usr/opt/RGS650/bin/R.orig

cat <<!EOF! >../src/usr/opt/RGS650/bin/R
#!/bin/sh

# R call wrapper, prepends LD_LIBRARY_PATH for libncurses and libreadline:
LD_LIBRARY_PATH=/usr/opt/RGS650/shlib:$LD_LIBRARY_PATH
export $LD_LIBRARY_PATH

# now source the original R call script
. /usr/opt/RGS650/bin/R.orig

!EOF!
chmod 755 ../src/usr/opt/RGS650/bin/R

echo "copying man pages ..."
for i in `rpm -ql R-base| grep -v /usr/local/lib/R| grep man1`; do
  cp $i ../src/usr/opt/RGS650/man/man1
done

echo "copying info pages ..."
for i in `rpm -ql R-base| grep -v /usr/local/lib/R| grep info`; do
  cp $i ../src/usr/opt/RGS650/info/
done

echo "copying postscript documentation ..."
for i in `rpm -ql R-base| grep -v /usr/local/lib/R| grep doc`; do
  cp $i ../src/usr/opt/RGS650/doc/
done

echo "copying extra scripts ..."
for i in /usr/local/bin/Rd2txt \
         /usr/local/bin/Rdconv \
         /usr/local/bin/Rdindex \
         /usr/local/bin/Sd2Rd ; do
  cat $i | \
    sed -e s"#/usr/local/bin/perl#/usr/bin/perl#g" > \
      ../src/usr/opt/RGS650/bin/`basename $i`
done

echo "copying shared libraries ..."
for i in `rpm -ql readline|grep libreadline\*.so`; do
  cp $i ../src/usr/opt/RGS650/shlib
done

for i in `rpm -ql ncurses|grep libncurses\*.so`; do
  cp $i ../src/usr/opt/RGS650/shlib
done

echo "modifying perl scripts ..."
cd ../src/usr/opt/RGS650/lib/R
for i in `find . -type f -exec grep -l /usr/local/bin/perl {} \;`; do
  mv $i $i.bak
  cat $i.bak | \
    sed -e "s#/usr/local/bin/perl#/usr/bin/perl#g" > $i
  rm -f $i.bak
done

echo "Done."

exit 0

